/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.util.CancelFlag;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgnitePlanner;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public final class PlanningContext
implements Context {
    private final Context parentCtx;
    private final String qry;
    private final Object[] parameters;
    private final CancelFlag cancelFlag = new CancelFlag(new AtomicBoolean());
    private Function<RuleSet, RuleSet> rulesFilter;
    private IgnitePlanner planner;
    private final long startTs;
    private final long plannerTimeout;

    private PlanningContext(Context parentCtx, String qry, Object[] parameters, long plannerTimeout) {
        this.qry = qry;
        this.parameters = parameters;
        this.parentCtx = parentCtx;
        this.startTs = U.currentTimeMillis();
        this.plannerTimeout = plannerTimeout;
    }

    public String query() {
        return this.qry;
    }

    public Object[] parameters() {
        return this.parameters;
    }

    public SqlConformance conformance() {
        return this.config().getParserConfig().conformance();
    }

    public String schemaName() {
        return this.schema().getName();
    }

    public long startTs() {
        return this.startTs;
    }

    public long plannerTimeout() {
        return this.plannerTimeout;
    }

    public SchemaPlus schema() {
        return this.config().getDefaultSchema();
    }

    public IgnitePlanner planner() {
        if (this.planner == null) {
            this.planner = new IgnitePlanner(this);
        }
        return this.planner;
    }

    public IgniteTypeFactory typeFactory() {
        return this.unwrap(BaseQueryContext.class).typeFactory();
    }

    public SqlOperatorTable opTable() {
        return this.unwrap(BaseQueryContext.class).opTable();
    }

    public CalciteCatalogReader catalogReader() {
        return this.unwrap(BaseQueryContext.class).catalogReader();
    }

    public RelOptCluster cluster() {
        return this.planner().cluster();
    }

    public <C> C unwrap(Class<C> aCls) {
        if (aCls == this.getClass()) {
            return aCls.cast(this);
        }
        if (aCls == CancelFlag.class) {
            return aCls.cast(this.cancelFlag);
        }
        return (C)this.parentCtx.unwrap(aCls);
    }

    public static Builder builder() {
        return new Builder();
    }

    public RuleSet rules(RuleSet set) {
        return this.rulesFilter != null ? this.rulesFilter.apply(set) : set;
    }

    public void rulesFilter(Function<RuleSet, RuleSet> rulesFilter) {
        this.rulesFilter = rulesFilter;
    }

    public FrameworkConfig config() {
        return this.unwrap(BaseQueryContext.class).config();
    }

    public RexBuilder rexBuilder() {
        return this.unwrap(BaseQueryContext.class).rexBuilder();
    }

    public static class Builder {
        private Context parentCtx = Contexts.empty();
        private String qry;
        private Object[] parameters;
        private long plannerTimeout;

        public Builder parentContext(@NotNull Context parentCtx) {
            this.parentCtx = parentCtx;
            return this;
        }

        public Builder query(@NotNull String qry) {
            this.qry = qry;
            return this;
        }

        public Builder parameters(Object ... parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder plannerTimeout(long plannerTimeout) {
            this.plannerTimeout = plannerTimeout;
            return this;
        }

        public PlanningContext build() {
            return new PlanningContext(this.parentCtx, this.qry, this.parameters, this.plannerTimeout);
        }
    }
}

