/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.query.calcite.message.CalciteMessageFactory;
import org.apache.ignite.internal.processors.query.calcite.message.ExecutionContextAware;
import org.apache.ignite.internal.processors.query.calcite.message.MarshalableMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MarshallingContext;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.processors.query.calcite.message.ValueMessage;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class QueryBatchMessage
implements MarshalableMessage,
ExecutionContextAware {
    private UUID qryId;
    private long fragmentId;
    private long exchangeId;
    private int batchId;
    private boolean last;
    @GridDirectTransient
    private List<Object> rows;
    @GridDirectCollection(value=ValueMessage.class)
    private List<ValueMessage> mRows;

    public QueryBatchMessage() {
    }

    public QueryBatchMessage(UUID qryId, long fragmentId, long exchangeId, int batchId, boolean last, List<Object> rows) {
        this.qryId = qryId;
        this.fragmentId = fragmentId;
        this.exchangeId = exchangeId;
        this.batchId = batchId;
        this.last = last;
        this.rows = rows;
    }

    @Override
    public UUID queryId() {
        return this.qryId;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    public long exchangeId() {
        return this.exchangeId;
    }

    public int batchId() {
        return this.batchId;
    }

    public boolean last() {
        return this.last;
    }

    public List<Object> rows() {
        return this.rows;
    }

    @Override
    public void prepareMarshal(MarshallingContext ctx) throws IgniteCheckedException {
        if (this.mRows != null || this.rows == null) {
            return;
        }
        this.mRows = new ArrayList<ValueMessage>(this.rows.size());
        for (Object row : this.rows) {
            ValueMessage mRow = CalciteMessageFactory.asMessage(row);
            assert (mRow != null);
            mRow.prepareMarshal(ctx);
            this.mRows.add(mRow);
        }
    }

    @Override
    public void prepareUnmarshal(MarshallingContext ctx) throws IgniteCheckedException {
        if (this.rows != null || this.mRows == null) {
            return;
        }
        this.rows = new ArrayList<Object>(this.mRows.size());
        for (ValueMessage mRow : this.mRows) {
            assert (mRow != null);
            mRow.prepareUnmarshal(ctx);
            this.rows.add(mRow.value());
        }
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("batchId", this.batchId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeLong("exchangeId", this.exchangeId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("fragmentId", this.fragmentId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeBoolean("last", this.last)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeCollection("mRows", this.mRows, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeUuid("queryId", this.qryId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.batchId = reader.readInt("batchId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.exchangeId = reader.readLong("exchangeId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.fragmentId = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.last = reader.readBoolean("last");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.mRows = (List)reader.readCollection("mRows", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.qryId = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryBatchMessage.class);
    }

    @Override
    public MessageType type() {
        return MessageType.QUERY_BATCH_MESSAGE;
    }

    public byte fieldsCount() {
        return 6;
    }
}

