/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;
import org.apache.ignite.internal.util.GridBoundedPriorityQueue;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class SortNode<Row>
extends AbstractNode<Row>
implements SingleNode<Row>,
Downstream<Row> {
    private int requested;
    private int waiting;
    private boolean inLoop;
    private final PriorityQueue<Row> rows;
    private final int limit;
    private List<Row> reversed;

    public SortNode(ExecutionContext<Row> ctx, RelDataType rowType, Comparator<Row> comp, @Nullable Supplier<Integer> offset, @Nullable Supplier<Integer> fetch) {
        super(ctx, rowType);
        assert (fetch == null || fetch.get() >= 0);
        assert (offset == null || offset.get() >= 0);
        int n = fetch == null ? -1 : (this.limit = fetch.get() + (offset == null ? 0 : offset.get()));
        this.rows = this.limit < 0 ? new PriorityQueue<Row>(comp) : new GridBoundedPriorityQueue(this.limit, comp == null ? Comparator.reverseOrder() : comp.reversed());
    }

    public SortNode(ExecutionContext<Row> ctx, RelDataType rowType, Comparator<Row> comp) {
        this(ctx, rowType, comp, null, null);
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.rows.clear();
        if (this.reversed != null) {
            this.reversed.clear();
        }
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        assert (this.waiting <= 0);
        this.checkState();
        this.requested = rowsCnt;
        if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.source().request(this.waiting);
        } else if (!this.inLoop) {
            this.context().execute(this::flush, this::onError);
        }
    }

    @Override
    public void push(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        assert (this.reversed == null || this.reversed.isEmpty());
        this.checkState();
        --this.waiting;
        this.rows.add(row);
        if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.source().request(this.waiting);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.flush();
    }

    private void flush() throws Exception {
        if (this.isClosed()) {
            return;
        }
        assert (this.waiting == -1);
        int processed = 0;
        this.inLoop = true;
        try {
            if (this.limit > 0 && !this.rows.isEmpty()) {
                if (this.reversed == null) {
                    this.reversed = new ArrayList<Row>(this.rows.size());
                }
                while (!this.rows.isEmpty()) {
                    this.reversed.add(this.rows.poll());
                    if (++processed < IN_BUFFER_SIZE) continue;
                    this.context().execute(this::flush, this::onError);
                    return;
                }
                processed = 0;
            }
            while (this.requested > 0 && (this.reversed == null ? !this.rows.isEmpty() : !this.reversed.isEmpty())) {
                this.checkState();
                --this.requested;
                this.downstream().push(this.reversed == null ? this.rows.poll() : this.reversed.remove(this.reversed.size() - 1));
                if (++processed < IN_BUFFER_SIZE || this.requested <= 0) continue;
                this.context().execute(this::flush, this::onError);
                return;
            }
            if (this.reversed == null ? this.rows.isEmpty() : this.reversed.isEmpty()) {
                if (this.requested > 0) {
                    this.downstream().end();
                }
                this.requested = 0;
            }
        }
        finally {
            this.inLoop = false;
        }
    }
}

