/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionCancelledException;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class AbstractNode<Row>
implements Node<Row> {
    protected static final int IN_BUFFER_SIZE = IgniteSystemProperties.getInteger((String)"IGNITE_CALCITE_EXEC_IN_BUFFER_SIZE", (int)512);
    protected static final int MODIFY_BATCH_SIZE = IgniteSystemProperties.getInteger((String)"IGNITE_CALCITE_EXEC_MODIFY_BATCH_SIZE", (int)100);
    protected static final int IO_BATCH_SIZE = IgniteSystemProperties.getInteger((String)"IGNITE_CALCITE_EXEC_IO_BATCH_SIZE", (int)256);
    protected static final int IO_BATCH_CNT = IgniteSystemProperties.getInteger((String)"IGNITE_CALCITE_EXEC_IO_BATCH_CNT", (int)4);
    private volatile Thread thread;
    private ExecutionContext<Row> ctx;
    private RelDataType rowType;
    private Downstream<Row> downstream;
    private boolean closed;
    private List<Node<Row>> sources;

    protected AbstractNode(ExecutionContext<Row> ctx, RelDataType rowType) {
        this.ctx = ctx;
        this.rowType = rowType;
    }

    @Override
    public ExecutionContext<Row> context() {
        return this.ctx;
    }

    protected void context(ExecutionContext<Row> ctx) {
        this.ctx = ctx;
    }

    @Override
    public RelDataType rowType() {
        return this.rowType;
    }

    protected void rowType(RelDataType rowType) {
        this.rowType = rowType;
    }

    @Override
    public void register(List<Node<Row>> sources) {
        this.sources = sources;
        for (int i = 0; i < sources.size(); ++i) {
            sources.get(i).onRegister(this.requestDownstream(i));
        }
    }

    @Override
    public List<Node<Row>> sources() {
        return this.sources;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.closeInternal();
        if (!F.isEmpty(this.sources())) {
            this.sources().forEach(IgniteUtils::closeQuiet);
        }
    }

    @Override
    public void rewind() {
        this.rewindInternal();
        if (!F.isEmpty(this.sources())) {
            this.sources().forEach(Node::rewind);
        }
    }

    @Override
    public void onRegister(Downstream<Row> downstream) {
        this.downstream = downstream;
    }

    public void onError(Throwable e) {
        if (e instanceof ExecutionCancelledException) {
            U.warn((IgniteLogger)this.context().logger(), (Object)"Execution is cancelled.", (Throwable)e);
        } else {
            this.onErrorInternal(e);
        }
    }

    protected void closeInternal() {
        this.closed = true;
    }

    protected abstract void rewindInternal();

    protected void onErrorInternal(Throwable e) {
        Downstream<Row> downstream = this.downstream();
        assert (downstream != null);
        try {
            downstream.onError(e);
        }
        finally {
            U.closeQuiet((AutoCloseable)this);
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void checkState() throws Exception {
        if (this.context().isCancelled()) {
            throw new ExecutionCancelledException();
        }
        if (Thread.interrupted()) {
            throw new IgniteInterruptedCheckedException("Thread was interrupted.");
        }
        if (!U.assertionsEnabled()) {
            return;
        }
        if (this.thread == null) {
            this.thread = Thread.currentThread();
        } else assert (this.thread == Thread.currentThread());
    }

    protected abstract Downstream<Row> requestDownstream(int var1);

    @Override
    public Downstream<Row> downstream() {
        return this.downstream;
    }
}

