/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp.agg;

import java.util.Arrays;
import org.apache.ignite.internal.util.typedef.X;

public class GroupKey {
    public static final GroupKey EMPTY_GRP_KEY = new GroupKey(X.EMPTY_OBJECT_ARRAY);
    private final Object[] fields;

    public GroupKey(Object[] fields) {
        this.fields = fields;
    }

    public Object field(int idx) {
        return this.fields[idx];
    }

    public int fieldsCount() {
        return this.fields.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupKey groupKey = (GroupKey)o;
        return Arrays.equals(this.fields, groupKey.fields);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }

    public static Builder builder(int rowLen) {
        return new Builder(rowLen);
    }

    public static class Builder {
        private final Object[] fields;
        private int idx;

        private Builder(int rowLen) {
            this.fields = new Object[rowLen];
        }

        public Builder add(Object val) {
            if (this.idx == this.fields.length) {
                throw new IndexOutOfBoundsException();
            }
            this.fields[this.idx++] = val;
            return this;
        }

        public GroupKey build() {
            assert (this.idx == this.fields.length);
            return new GroupKey(this.fields);
        }
    }
}

