/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.processors.query.calcite.exec.AbstractIndexScan;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RuntimeIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndex;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class RuntimeSortedIndex<Row>
implements RuntimeIndex<Row>,
TreeIndex<Row> {
    protected final ExecutionContext<Row> ectx;
    protected final Comparator<Row> comp;
    private final RelCollation collation;
    private final ArrayList<Row> rows = new ArrayList();

    public RuntimeSortedIndex(ExecutionContext<Row> ectx, RelCollation collation, Comparator<Row> comp) {
        this.ectx = ectx;
        this.comp = comp;
        assert (Objects.nonNull(collation));
        this.collation = collation;
    }

    @Override
    public void push(Row r) {
        assert (this.rows.isEmpty() || this.comp.compare(r, this.rows.get(this.rows.size() - 1)) >= 0) : "Not sorted input";
        this.rows.add(r);
    }

    @Override
    public void close() {
        this.rows.clear();
    }

    @Override
    public GridCursor<Row> find(Row lower, Row upper, IndexQueryContext qctx) {
        assert (qctx == null);
        int firstCol = (Integer)F.first((List)this.collation.getKeys());
        Object lowerBound = lower == null ? null : this.ectx.rowHandler().get(firstCol, lower);
        Object upperBound = upper == null ? null : this.ectx.rowHandler().get(firstCol, upper);
        Object lowerRow = lowerBound == null ? null : (Object)lower;
        Object upperRow = upperBound == null ? null : (Object)upper;
        return new Cursor(this.rows, lowerRow, upperRow);
    }

    public Iterable<Row> scan(ExecutionContext<Row> ectx, RelDataType rowType, Predicate<Row> filter, Supplier<Row> lowerBound, Supplier<Row> upperBound) {
        return new IndexScan(rowType, this, filter, lowerBound, upperBound);
    }

    private class IndexScan
    extends AbstractIndexScan<Row, Row> {
        IndexScan(RelDataType rowType, TreeIndex<Row> idx, Predicate<Row> filter, Supplier<Row> lowerBound, Supplier<Row> upperBound) {
            super(RuntimeSortedIndex.this.ectx, rowType, idx, filter, lowerBound, upperBound, null);
        }

        @Override
        protected Row row2indexRow(Row bound) {
            return bound;
        }

        @Override
        protected Row indexRow2Row(Row row) {
            return row;
        }

        @Override
        protected IndexQueryContext indexQueryContext() {
            return null;
        }
    }

    private class Cursor
    implements GridCursor<Row> {
        private final List<Row> rows;
        private final Row upper;
        private Row row;
        private int idx;

        Cursor(@Nullable List<Row> rows, @Nullable Row lower, Row upper) {
            this.rows = rows;
            this.upper = upper;
            this.idx = lower == null ? 0 : this.lowerBound(rows, lower);
        }

        private int lowerBound(List<Row> rows, Row bound) {
            int low = 0;
            int high = rows.size() - 1;
            int idx = -1;
            while (low <= high) {
                int mid = (high - low) / 2 + low;
                int compRes = RuntimeSortedIndex.this.comp.compare(rows.get(mid), bound);
                if (compRes > 0) {
                    high = mid - 1;
                    continue;
                }
                if (compRes == 0) {
                    idx = mid;
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            return idx == -1 ? low : idx;
        }

        public boolean next() {
            if (this.idx == this.rows.size() || this.upper != null && RuntimeSortedIndex.this.comp.compare(this.upper, this.rows.get(this.idx)) < 0) {
                return false;
            }
            this.row = this.rows.get(this.idx++);
            return true;
        }

        public Row get() {
            return this.row;
        }
    }
}

