/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyTypeSettings;
import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.IndexSearchRowImpl;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndex;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKeyFactory;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtTopologyFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.query.calcite.exec.AbstractIndexScan;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilterImpl;
import org.jetbrains.annotations.Nullable;

public class IndexScan<Row>
extends AbstractIndexScan<Row, IndexRow> {
    private final GridKernalContext kctx;
    private final GridCacheContext<?, ?> cctx;
    private final CacheTableDescriptor desc;
    private final RowHandler.RowFactory<Row> factory;
    private final AffinityTopologyVersion topVer;
    private final int[] parts;
    private final MvccSnapshot mvccSnapshot;
    private volatile List<GridDhtLocalPartition> reserved;
    private final ImmutableBitSet requiredColumns;
    private final InlineIndex idx;
    private final ImmutableIntList idxFieldMapping;
    private final Type[] fieldsStoreTypes;

    public IndexScan(ExecutionContext<Row> ectx, CacheTableDescriptor desc, InlineIndex idx, ImmutableIntList idxFieldMapping, int[] parts, Predicate<Row> filters, Supplier<Row> lowerBound, Supplier<Row> upperBound, Function<Row, Row> rowTransformer, @Nullable ImmutableBitSet requiredColumns) {
        super(ectx, desc.rowType(ectx.getTypeFactory(), requiredColumns), new TreeIndexWrapper(idx), filters, lowerBound, upperBound, rowTransformer);
        this.desc = desc;
        this.idx = idx;
        this.cctx = desc.cacheContext();
        this.kctx = this.cctx.kernalContext();
        this.factory = ectx.rowHandler().factory(ectx.getTypeFactory(), this.rowType);
        this.topVer = ectx.topologyVersion();
        this.parts = parts;
        this.mvccSnapshot = ectx.mvccSnapshot();
        this.requiredColumns = requiredColumns;
        this.idxFieldMapping = idxFieldMapping;
        RelDataType srcRowType = desc.rowType(ectx.getTypeFactory(), null);
        IgniteTypeFactory typeFactory = ectx.getTypeFactory();
        this.fieldsStoreTypes = new Type[srcRowType.getFieldCount()];
        for (int i = 0; i < srcRowType.getFieldCount(); ++i) {
            this.fieldsStoreTypes[i] = typeFactory.getResultClass(((RelDataTypeField)srcRowType.getFieldList().get(i)).getType());
        }
    }

    @Override
    public synchronized Iterator<Row> iterator() {
        this.reserve();
        try {
            return super.iterator();
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
    }

    @Override
    protected IndexRow row2indexRow(Row bound) {
        if (bound == null) {
            return null;
        }
        InlineIndexRowHandler idxRowHnd = this.idx.segment(0).rowHandler();
        RowHandler<Row> rowHnd = this.ectx.rowHandler();
        IndexKey[] keys = new IndexKey[idxRowHnd.indexKeyDefinitions().size()];
        assert (keys.length >= this.idxFieldMapping.size()) : "Unexpected index keys [keys.length=" + keys.length + ", idxFieldMapping.size()=" + this.idxFieldMapping.size() + ']';
        boolean nullSearchRow = true;
        for (int i = 0; i < this.idxFieldMapping.size(); ++i) {
            int fieldIdx = this.idxFieldMapping.getInt(i);
            Object key = rowHnd.get(fieldIdx, bound);
            if (key == this.ectx.unspecifiedValue()) continue;
            key = TypeUtils.fromInternal(this.ectx, key, this.fieldsStoreTypes[fieldIdx]);
            keys[i] = IndexKeyFactory.wrap((Object)key, (IndexKeyType)((IndexKeyDefinition)idxRowHnd.indexKeyDefinitions().get(i)).idxType(), (CacheObjectValueContext)this.cctx.cacheObjectContext(), (IndexKeyTypeSettings)idxRowHnd.indexKeyTypeSettings());
            nullSearchRow = false;
        }
        return nullSearchRow ? null : new IndexSearchRowImpl(keys, idxRowHnd);
    }

    @Override
    protected Row indexRow2Row(IndexRow row) throws IgniteCheckedException {
        return this.desc.toRow(this.ectx, row.cacheDataRow(), this.factory, this.requiredColumns);
    }

    @Override
    public void close() {
        this.release();
    }

    private synchronized void reserve() {
        List<GridDhtLocalPartition> toReserve;
        if (this.reserved != null) {
            return;
        }
        GridDhtPartitionTopology top = this.cctx.topology();
        top.readLock();
        GridDhtTopologyFuture topFut = top.topologyVersionFuture();
        boolean done = topFut.isDone();
        if (!done || topFut.topologyVersion().compareTo(this.topVer) < 0 || this.cctx.shared().exchange().lastAffinityChangedTopologyVersion(topFut.initialVersion()).compareTo(this.topVer) > 0) {
            top.readUnlock();
            throw new ClusterTopologyException("Topology was changed. Please retry on stable topology.");
        }
        if (this.cctx.isReplicated()) {
            int partsCnt = this.cctx.affinity().partitions();
            toReserve = new ArrayList<GridDhtLocalPartition>(partsCnt);
            for (int i = 0; i < partsCnt; ++i) {
                toReserve.add(top.localPartition(i));
            }
        } else if (this.cctx.isPartitioned()) {
            assert (this.parts != null);
            toReserve = new ArrayList<GridDhtLocalPartition>(this.parts.length);
            for (int i = 0; i < this.parts.length; ++i) {
                toReserve.add(top.localPartition(this.parts[i]));
            }
        } else {
            toReserve = Collections.emptyList();
        }
        this.reserved = new ArrayList<GridDhtLocalPartition>(toReserve.size());
        try {
            for (GridDhtLocalPartition part : toReserve) {
                if (part == null || !part.reserve()) {
                    throw new ClusterTopologyException("Failed to reserve partition for query execution. Retry on stable topology.");
                }
                if (part.state() != GridDhtPartitionState.OWNING) {
                    part.release();
                    throw new ClusterTopologyException("Failed to reserve partition for query execution. Retry on stable topology.");
                }
                this.reserved.add(part);
            }
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
        finally {
            top.readUnlock();
        }
    }

    private synchronized void release() {
        if (this.reserved == null) {
            return;
        }
        for (GridDhtLocalPartition part : this.reserved) {
            part.release();
        }
        this.reserved = null;
    }

    @Override
    protected IndexQueryContext indexQueryContext() {
        IndexingQueryFilterImpl filter = new IndexingQueryFilterImpl(this.kctx, this.topVer, this.parts);
        return new IndexQueryContext((IndexingQueryFilter)filter, null, this.mvccSnapshot);
    }

    private static class TreeIndexWrapper
    implements TreeIndex<IndexRow> {
        private final InlineIndex idx;

        private TreeIndexWrapper(InlineIndex idx) {
            this.idx = idx;
        }

        @Override
        public GridCursor<IndexRow> find(IndexRow lower, IndexRow upper, IndexQueryContext qctx) {
            try {
                return this.idx.find(lower, upper, true, true, qctx);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Failed to find index rows", (Throwable)e);
            }
        }
    }
}

