/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.query.calcite.exec.QueryTaskExecutor;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.ExpressionFactory;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.ExpressionFactoryImpl;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentDescription;
import org.apache.ignite.internal.processors.query.calcite.prepare.AbstractQueryContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseDataContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.lang.RunnableX;
import org.jetbrains.annotations.NotNull;

public class ExecutionContext<Row>
extends AbstractQueryContext
implements DataContext {
    private static final Object UNSPECIFIED_VALUE = new Object();
    private final UUID qryId;
    private final UUID locNodeId;
    private final UUID originatingNodeId;
    private final AffinityTopologyVersion topVer;
    private final FragmentDescription fragmentDesc;
    private final Map<String, Object> params;
    private final QueryTaskExecutor executor;
    private final RowHandler<Row> handler;
    private final ExpressionFactory<Row> expressionFactory;
    private final AtomicBoolean cancelFlag = new AtomicBoolean();
    private final BaseDataContext baseDataContext;
    private Object[] correlations = new Object[16];

    public ExecutionContext(BaseQueryContext qctx, QueryTaskExecutor executor, UUID qryId, UUID locNodeId, UUID originatingNodeId, AffinityTopologyVersion topVer, FragmentDescription fragmentDesc, RowHandler<Row> handler, Map<String, Object> params) {
        super(qctx);
        this.executor = executor;
        this.qryId = qryId;
        this.locNodeId = locNodeId;
        this.originatingNodeId = originatingNodeId;
        this.topVer = topVer;
        this.fragmentDesc = fragmentDesc;
        this.handler = handler;
        this.params = params;
        this.baseDataContext = new BaseDataContext(qctx.typeFactory());
        this.expressionFactory = new ExpressionFactoryImpl(this, qctx.typeFactory(), qctx.config().getParserConfig().conformance(), qctx.rexBuilder());
    }

    public UUID queryId() {
        return this.qryId;
    }

    public long fragmentId() {
        return this.fragmentDesc.fragmentId();
    }

    public ColocationGroup target() {
        return this.fragmentDesc.target();
    }

    public List<UUID> remotes(long exchangeId) {
        return this.fragmentDesc.remotes().get(exchangeId);
    }

    public ColocationGroup group(long sourceId) {
        return this.fragmentDesc.mapping().findGroup(sourceId);
    }

    public boolean keepBinary() {
        return true;
    }

    public MvccSnapshot mvccSnapshot() {
        return null;
    }

    public RowHandler<Row> rowHandler() {
        return this.handler;
    }

    public ExpressionFactory<Row> expressionFactory() {
        return this.expressionFactory;
    }

    public UUID localNodeId() {
        return this.locNodeId;
    }

    public UUID originatingNodeId() {
        return this.originatingNodeId;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public IgniteLogger logger() {
        return this.unwrap(BaseQueryContext.class).logger();
    }

    public SchemaPlus getRootSchema() {
        return this.baseDataContext.getRootSchema();
    }

    public IgniteTypeFactory getTypeFactory() {
        return this.baseDataContext.getTypeFactory();
    }

    public QueryProvider getQueryProvider() {
        return this.baseDataContext.getQueryProvider();
    }

    public Object get(String name) {
        if (DataContext.Variable.CANCEL_FLAG.camelName.equals(name)) {
            return this.cancelFlag;
        }
        if (name.startsWith("?")) {
            return TypeUtils.toInternal(this, this.params.get(name));
        }
        return this.baseDataContext.get(name);
    }

    public Object getParameter(String name, Type storageType) {
        assert (name.startsWith("?")) : name;
        return TypeUtils.toInternal(this, this.params.get(name), storageType);
    }

    @NotNull
    public Object getCorrelated(int id) {
        Commons.checkRange(this.correlations, id);
        return this.correlations[id];
    }

    public void setCorrelated(@NotNull Object value, int id) {
        this.correlations = Commons.ensureCapacity(this.correlations, id + 1);
        this.correlations[id] = value;
    }

    public void execute(RunnableX task, Consumer<Throwable> onError) {
        if (this.isCancelled()) {
            return;
        }
        this.executor.execute(this.qryId, this.fragmentId(), () -> {
            try {
                if (!this.isCancelled()) {
                    task.run();
                }
            }
            catch (Throwable e) {
                onError.accept(e);
                throw new IgniteException("Unexpected exception", e);
            }
        });
    }

    public boolean cancel() {
        return !this.cancelFlag.get() && this.cancelFlag.compareAndSet(false, true);
    }

    public boolean isCancelled() {
        return this.cancelFlag.get();
    }

    public Object unspecifiedValue() {
        return UNSPECIFIED_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionContext context = (ExecutionContext)o;
        return this.qryId.equals(context.qryId) && this.fragmentDesc.fragmentId() == context.fragmentDesc.fragmentId();
    }

    public int hashCode() {
        return Objects.hash(this.qryId, this.fragmentDesc.fragmentId());
    }
}

