/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cache.query.index.sorted.inline.IndexQueryContext;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndex;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;

public abstract class AbstractIndexScan<Row, IdxRow>
implements Iterable<Row>,
AutoCloseable {
    private final TreeIndex<IdxRow> idx;
    private final Predicate<Row> filters;
    private final Supplier<Row> lowerBound;
    private final Supplier<Row> upperBound;
    private final Function<Row, Row> rowTransformer;
    protected final ExecutionContext<Row> ectx;
    protected final RelDataType rowType;

    protected AbstractIndexScan(ExecutionContext<Row> ectx, RelDataType rowType, TreeIndex<IdxRow> idx, Predicate<Row> filters, Supplier<Row> lowerBound, Supplier<Row> upperBound, Function<Row, Row> rowTransformer) {
        this.ectx = ectx;
        this.rowType = rowType;
        this.idx = idx;
        this.filters = filters;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.rowTransformer = rowTransformer;
    }

    @Override
    public synchronized Iterator<Row> iterator() {
        Object lower = this.lowerBound == null ? null : (Object)this.row2indexRow(this.lowerBound.get());
        Object upper = this.upperBound == null ? null : (Object)this.row2indexRow(this.upperBound.get());
        return new IteratorImpl(this.idx.find(lower, upper, this.indexQueryContext()));
    }

    protected abstract IdxRow row2indexRow(Row var1);

    protected abstract Row indexRow2Row(IdxRow var1) throws IgniteCheckedException;

    protected abstract IndexQueryContext indexQueryContext();

    @Override
    public void close() {
    }

    private class IteratorImpl
    extends GridIteratorAdapter<Row> {
        private final GridCursor<IdxRow> cursor;
        private Row next;

        private IteratorImpl(GridCursor<IdxRow> cursor) {
            this.cursor = cursor;
        }

        public boolean hasNextX() throws IgniteCheckedException {
            this.advance();
            return this.next != null;
        }

        public Row nextX() throws IgniteCheckedException {
            this.advance();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object res = this.next;
            this.next = null;
            return res;
        }

        public void removeX() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }

        private void advance() throws IgniteCheckedException {
            assert (this.cursor != null);
            if (this.next != null) {
                return;
            }
            while (this.next == null && this.cursor.next()) {
                Object idxRow = this.cursor.get();
                Object r = AbstractIndexScan.this.indexRow2Row(idxRow);
                if (AbstractIndexScan.this.filters != null && !AbstractIndexScan.this.filters.test(r)) continue;
                if (AbstractIndexScan.this.rowTransformer != null) {
                    r = AbstractIndexScan.this.rowTransformer.apply(r);
                }
                this.next = r;
            }
        }
    }
}

