/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.UUID;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;

public class ScanQueryView {
    private final UUID nodeId;
    private final long qryId;
    private final boolean canceled;
    private final GridCacheQueryManager.ScanQueryIterator iter;

    public <K, V> ScanQueryView(UUID nodeId, long qryId, boolean canceled, IgniteSpiCloseableIterator<IgniteBiTuple<K, V>> iter) {
        this.nodeId = nodeId;
        this.qryId = qryId;
        this.canceled = canceled;
        this.iter = (GridCacheQueryManager.ScanQueryIterator)iter;
    }

    @Order
    public UUID originNodeId() {
        return this.nodeId;
    }

    @Order(value=1)
    public long queryId() {
        return this.qryId;
    }

    public boolean canceled() {
        return this.canceled;
    }

    @Order(value=2)
    public String cacheName() {
        return this.iter.cacheContext().name();
    }

    @Order(value=3)
    public int cacheId() {
        return this.iter.cacheContext().cacheId();
    }

    @Order(value=4)
    public int cacheGroupId() {
        return this.iter.cacheContext().groupId();
    }

    @Order(value=5)
    public String cacheGroupName() {
        return this.iter.cacheContext().group().cacheOrGroupName();
    }

    @Order(value=6)
    public long startTime() {
        return this.iter.startTime();
    }

    @Order(value=7)
    public long duration() {
        return U.currentTimeMillis() - this.iter.startTime();
    }

    public String filter() {
        IgniteBiPredicate filter = this.iter.filter();
        return filter == null ? null : IgniteUtils.toStringSafe(filter);
    }

    public int partition() {
        GridDhtLocalPartition part = this.iter.localPartition();
        if (part == null) {
            return -1;
        }
        return part.id();
    }

    public boolean local() {
        return this.iter.local();
    }

    public String transformer() {
        IgniteClosure trans = this.iter.transformer();
        return trans == null ? null : IgniteUtils.toStringSafe(trans);
    }

    public String topology() {
        return IgniteUtils.toStringSafe(this.iter.topVer());
    }

    public boolean keepBinary() {
        return this.iter.keepBinary();
    }

    public UUID subjectId() {
        return this.iter.subjectId();
    }

    public String taskName() {
        return this.iter.taskName();
    }

    public int pageSize() {
        return this.iter.pageSize();
    }
}

