/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.cache.configuration.Factory;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.eviction.AbstractEvictionPolicyFactory;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxyImpl;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.event.VisorGridEvent;
import org.apache.ignite.internal.visor.event.VisorGridEventsLost;
import org.apache.ignite.internal.visor.file.VisorFileBlock;
import org.apache.ignite.internal.visor.log.VisorLogFile;
import org.apache.ignite.internal.visor.util.VisorEventMapper;
import org.apache.ignite.internal.visor.util.VisorMimeTypes;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.eventstorage.NoopEventStorageSpi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisorTaskUtils {
    private static final String DFLT_EMPTY_NAME = "<default>";
    private static final int EVENTS_LOST_THROTTLE = 10;
    private static final int EVENTS_COLLECT_TIME_WINDOW = 600000;
    private static final byte[] EMPTY_FILE_BUF = new byte[0];
    public static final int LOG_FILES_COUNT_LIMIT = 5000;
    public static final int NOTHING_TO_REBALANCE = -1;
    public static final int REBALANCE_NOT_AVAILABLE = -2;
    public static final double MINIMAL_REBALANCE = 0.01;
    public static final int REBALANCE_COMPLETE = 1;
    private static final int DFLT_BUFFER_SIZE = 4096;
    public static final int[] VISOR_TASK_EVTS = new int[]{44, 45, 46, 48, 43, 47, 50, 20, 21, 22, 23};
    public static final int[] VISOR_NON_TASK_EVTS = new int[]{32, 35};
    public static final int[] VISOR_ALL_EVTS = VisorTaskUtils.concat(VISOR_TASK_EVTS, VISOR_NON_TASK_EVTS);
    public static final int MAX_FOLDER_DEPTH = 4;
    private static final Comparator<VisorLogFile> LAST_MODIFIED = new Comparator<VisorLogFile>(){

        @Override
        public int compare(VisorLogFile f1, VisorLogFile f2) {
            return Long.compare(f2.getLastModified(), f1.getLastModified());
        }
    };
    private static final Comparator<Event> EVTS_ORDER_COMPARATOR = new Comparator<Event>(){

        @Override
        public int compare(Event o1, Event o2) {
            return Long.compare(o1.localOrder(), o2.localOrder());
        }
    };
    public static final VisorEventMapper EVT_MAPPER = new VisorEventMapper();
    private static final String[] TEXT_MIME_TYPE = new String[]{"text/plain", "application/xml", "text/html", "x-sh"};

    public static String escapeName(@Nullable Object name) {
        return name == null ? DFLT_EMPTY_NAME : name.toString();
    }

    public static String unescapeName(String name) {
        assert (name != null);
        return DFLT_EMPTY_NAME.equals(name) ? null : name;
    }

    public static int[] concat(int[] ... arrays) {
        assert (arrays != null);
        assert (arrays.length > 1);
        int len = 0;
        for (int[] a : arrays) {
            len += a.length;
        }
        int[] r = Arrays.copyOf(arrays[0], len);
        int shift = 0;
        for (int i = 1; i < arrays.length; ++i) {
            System.arraycopy(arrays[i], 0, r, shift += arrays[i - 1].length, arrays[i].length);
        }
        return r;
    }

    @Nullable
    public static Object compactObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Enum) {
            return obj.toString();
        }
        if (obj instanceof String || obj instanceof Boolean || obj instanceof Number) {
            return obj;
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            Object[] res = new Object[col.size()];
            int i = 0;
            for (Object elm : col) {
                res[i++] = VisorTaskUtils.compactObject(elm);
            }
            return res;
        }
        if (obj.getClass().isArray()) {
            Class<?> arrType = obj.getClass().getComponentType();
            if (arrType.isPrimitive()) {
                if (obj instanceof boolean[]) {
                    return Arrays.toString((boolean[])obj);
                }
                if (obj instanceof byte[]) {
                    return Arrays.toString((byte[])obj);
                }
                if (obj instanceof short[]) {
                    return Arrays.toString((short[])obj);
                }
                if (obj instanceof int[]) {
                    return Arrays.toString((int[])obj);
                }
                if (obj instanceof long[]) {
                    return Arrays.toString((long[])obj);
                }
                if (obj instanceof float[]) {
                    return Arrays.toString((float[])obj);
                }
                if (obj instanceof double[]) {
                    return Arrays.toString((double[])obj);
                }
            }
            Object[] arr = (Object[])obj;
            int iMax = arr.length - 1;
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i <= iMax; ++i) {
                sb.append(VisorTaskUtils.compactObject(arr[i]));
                if (i == iMax) continue;
                sb.append(", ");
            }
            sb.append(']');
            return sb.toString();
        }
        return U.compact(obj.getClass().getName());
    }

    @Nullable
    public static String compactClass(Class cls) {
        if (cls == null) {
            return null;
        }
        return U.compact(cls.getName());
    }

    @Nullable
    public static String compactClass(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        return VisorTaskUtils.compactClass(obj.getClass());
    }

    @Nullable
    public static List<String> compactClasses(Class<?>[] clss) {
        if (clss == null) {
            return null;
        }
        int len = clss.length;
        ArrayList<String> res = new ArrayList<String>(len);
        for (Class<?> cls : clss) {
            res.add(U.compact(cls.getName()));
        }
        return res;
    }

    @Nullable
    public static String compactArray(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        String sep = ", ";
        StringBuilder sb = new StringBuilder();
        for (Object s : arr) {
            sb.append(s).append(sep);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - sep.length());
        }
        return U.compact(sb.toString());
    }

    @Nullable
    public static String compactIterable(Iterable col) {
        if (col == null || !col.iterator().hasNext()) {
            return null;
        }
        String sep = ", ";
        StringBuilder sb = new StringBuilder();
        for (Object s : col) {
            sb.append(s).append(sep);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - sep.length());
        }
        return U.compact(sb.toString());
    }

    public static Integer intValue(String propName, Integer dflt) {
        String sysProp = System.getProperty(propName);
        return sysProp != null && !sysProp.isEmpty() ? Integer.getInteger(sysProp) : dflt;
    }

    public static boolean boolValue(String propName, boolean dflt) {
        String sysProp = System.getProperty(propName);
        return sysProp != null && !sysProp.isEmpty() ? Boolean.getBoolean(sysProp) : dflt;
    }

    public static <K, V> V getOrElse(Map<K, V> map, K key, V ifNull) {
        assert (map != null);
        V res = map.get(key);
        return res != null ? res : ifNull;
    }

    public static boolean checkExplicitTaskMonitoring(Ignite ignite) {
        int[] evts = ignite.configuration().getIncludeEventTypes();
        if (F.isEmpty(evts)) {
            return false;
        }
        for (int evt : VISOR_TASK_EVTS) {
            if (F.contains(evts, evt)) continue;
            return false;
        }
        return true;
    }

    public static Collection<VisorGridEvent> collectEvents(Ignite ignite, String evtOrderKey, String evtThrottleCntrKey, boolean all, IgniteClosure<Event, VisorGridEvent> evtMapper) {
        int[] evtTypes;
        int[] nArray = evtTypes = all ? VISOR_ALL_EVTS : VISOR_NON_TASK_EVTS;
        if (evtOrderKey.startsWith("CONSOLE_")) {
            evtTypes = VisorTaskUtils.concat(evtTypes, EventType.EVTS_DISCOVERY);
        }
        return VisorTaskUtils.collectEvents(ignite, evtOrderKey, evtThrottleCntrKey, evtTypes, evtMapper);
    }

    public static List<VisorGridEvent> collectEvents(Ignite ignite, String evtOrderKey, String evtThrottleCntrKey, int[] evtTypes, IgniteClosure<Event, VisorGridEvent> evtMapper) {
        List<Event> evts;
        assert (ignite != null);
        assert (evtTypes != null && evtTypes.length > 0);
        ConcurrentMap<String, Long> nl = ignite.cluster().nodeLocalMap();
        final long lastOrder = VisorTaskUtils.getOrElse(nl, evtOrderKey, -1L);
        long throttle = VisorTaskUtils.getOrElse(nl, evtThrottleCntrKey, 0L);
        final long notOlderThan = System.currentTimeMillis() - 600000L;
        final AtomicBoolean lastFound = new AtomicBoolean(lastOrder < 0L);
        IgnitePredicate<Event> p = new IgnitePredicate<Event>(){
            private static final long serialVersionUID = 0L;

            @Override
            public boolean apply(Event e) {
                if (!lastFound.get() && lastOrder == e.localOrder()) {
                    lastFound.set(true);
                }
                return e.localOrder() > lastOrder && e.timestamp() > notOlderThan;
            }
        };
        Collection<Event> collection = evts = ignite.configuration().getEventStorageSpi() instanceof NoopEventStorageSpi ? Collections.emptyList() : ignite.events().localQuery(p, evtTypes);
        if (!evts.isEmpty()) {
            Event maxEvt = Collections.max(evts, EVTS_ORDER_COMPARATOR);
            nl.put(evtOrderKey, maxEvt.localOrder());
        }
        if (!lastFound.get()) {
            nl.put(evtThrottleCntrKey, throttle == 0L ? 10L : throttle - 1L);
        }
        boolean lost = !lastFound.get() && throttle == 0L;
        ArrayList<VisorGridEvent> res = new ArrayList<VisorGridEvent>(evts.size() + (lost ? 1 : 0));
        if (lost) {
            res.add(new VisorGridEventsLost(ignite.cluster().localNode().id()));
        }
        for (Event e : evts) {
            VisorGridEvent visorEvt = evtMapper.apply(e);
            if (visorEvt == null) continue;
            res.add(visorEvt);
        }
        return res;
    }

    public static File resolveIgnitePath(String path) throws IOException {
        File folder = U.resolveIgnitePath(path);
        if (folder == null) {
            return null;
        }
        if (!folder.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).startsWith(Paths.get(U.getIgniteHome(), new String[0]))) {
            return null;
        }
        return folder;
    }

    public static File resolveSymbolicLink(File file) throws IOException {
        Path path = file.toPath();
        return Files.isSymbolicLink(path) ? Files.readSymbolicLink(path).toFile() : file;
    }

    public static List<VisorLogFile> fileTree(File file, int maxDepth, @Nullable FileFilter filter) throws IOException {
        if ((file = VisorTaskUtils.resolveSymbolicLink(file)).isDirectory()) {
            File[] files;
            File[] fileArray = files = filter == null ? file.listFiles() : file.listFiles(filter);
            if (files == null) {
                return Collections.emptyList();
            }
            ArrayList<VisorLogFile> res = new ArrayList<VisorLogFile>(files.length);
            for (File f : files) {
                if (f.isFile() && f.length() > 0L) {
                    res.add(new VisorLogFile(f));
                    continue;
                }
                if (maxDepth <= 1) continue;
                res.addAll(VisorTaskUtils.fileTree(f, maxDepth - 1, filter));
            }
            return res;
        }
        return new ArrayList<VisorLogFile>(F.asList(new VisorLogFile(file)));
    }

    public static List<VisorLogFile> matchedFiles(File file, final String ptrn) throws IOException {
        List<VisorLogFile> files = VisorTaskUtils.fileTree(file, 4, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isHidden() && (f.isDirectory() || f.isFile() && f.getName().matches(ptrn));
            }
        });
        Collections.sort(files, LAST_MODIFIED);
        return files;
    }

    public static boolean textFile(File f, boolean emptyOk) {
        if (f.length() == 0L) {
            return emptyOk;
        }
        String detected = VisorMimeTypes.getContentType(f);
        for (String mime : TEXT_MIME_TYPE) {
            if (!mime.equals(detected)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Charset decode(File f) throws IOException {
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        String[] firstCharsets = new String[]{Charset.defaultCharset().name(), "US-ASCII", "UTF-8", "UTF-16BE", "UTF-16LE"};
        LinkedHashSet<Charset> orderedCharsets = U.newLinkedHashSet(charsets.size());
        for (String c : firstCharsets) {
            if (!charsets.containsKey(c)) continue;
            orderedCharsets.add((Charset)charsets.get(c));
        }
        orderedCharsets.addAll(charsets.values());
        Throwable throwable = null;
        try (RandomAccessFile raf = new RandomAccessFile(f, "r");){
            FileChannel ch = raf.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(4096);
            ch.read(buf);
            buf.flip();
            for (Charset charset : orderedCharsets) {
                CharsetDecoder decoder = charset.newDecoder();
                decoder.reset();
                try {
                    decoder.decode(buf);
                    Charset charset2 = charset;
                    return charset2;
                }
                catch (CharacterCodingException characterCodingException) {
                    try {
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        return Charset.defaultCharset();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisorFileBlock readBlock(File file, long off, int blockSz, long lastModified) throws IOException {
        long pos;
        long fLastModified;
        long fSz;
        RandomAccessFile raf;
        block5: {
            VisorFileBlock visorFileBlock;
            raf = null;
            try {
                fSz = file.length();
                fLastModified = file.lastModified();
                long l = pos = off >= 0L ? off : Math.max(fSz - (long)blockSz, 0L);
                if (fLastModified == lastModified && fSz != 0L && pos >= fSz) {
                    throw new IOException("Trying to read file block with wrong offset: " + pos + " while file size: " + fSz);
                }
                if (fSz != 0L) break block5;
                visorFileBlock = new VisorFileBlock(file.getPath(), pos, fLastModified, 0L, false, EMPTY_FILE_BUF);
            }
            catch (Throwable throwable) {
                U.close(raf, null);
                throw throwable;
            }
            U.close(raf, null);
            return visorFileBlock;
        }
        int toRead = Math.min(blockSz, (int)(fSz - pos));
        raf = new RandomAccessFile(file, "r");
        raf.seek(pos);
        byte[] buf = new byte[toRead];
        int cntRead = raf.read(buf, 0, toRead);
        if (cntRead != toRead) {
            throw new IOException("Count of requested and actually read bytes does not match [cntRead=" + cntRead + ", toRead=" + toRead + ']');
        }
        boolean zipped = buf.length > 512;
        VisorFileBlock visorFileBlock = new VisorFileBlock(file.getPath(), pos, fSz, fLastModified, zipped, zipped ? VisorTaskUtils.zipBytes(buf) : buf);
        U.close(raf, null);
        return visorFileBlock;
    }

    public static Integer evictionPolicyMaxSize(@Nullable Factory plc) {
        if (plc instanceof AbstractEvictionPolicyFactory) {
            return ((AbstractEvictionPolicyFactory)plc).getMaxSize();
        }
        return null;
    }

    private static String formatDuration(long ms) {
        long min;
        long hh;
        assert (ms >= 0L);
        if (ms == 0L) {
            return "< 1 ms";
        }
        SB sb = new SB();
        long dd = ms / 1440000L;
        if (dd > 0L) {
            sb.a(dd).a(dd == 1L ? " day " : " days ");
        }
        if ((hh = (ms %= 1440000L) / 60000L) > 0L) {
            sb.a(hh).a(hh == 1L ? " hour " : " hours ");
        }
        if ((min = ms / 60000L) > 0L) {
            sb.a(min).a(min == 1L ? " min " : " mins ");
        }
        if ((ms %= 60000L) > 0L) {
            sb.a(ms).a(" ms ");
        }
        return sb.toString().trim();
    }

    private static void log0(@Nullable IgniteLogger log, long time, String msg) {
        if (log != null) {
            if (log.isDebugEnabled()) {
                log.debug(msg);
            } else {
                log.warning(msg);
            }
        } else {
            X.println(String.format("[%s][%s]%s", IgniteUtils.DEBUG_DATE_FMT.format(Instant.ofEpochMilli(time)), Thread.currentThread().getName(), msg), new Object[0]);
        }
    }

    public static void logStart(@Nullable IgniteLogger log, Class<?> clazz, long start) {
        VisorTaskUtils.log0(log, start, "[" + clazz.getSimpleName() + "]: STARTED");
    }

    public static void logFinish(@Nullable IgniteLogger log, Class<?> clazz, long start) {
        long end = System.currentTimeMillis();
        VisorTaskUtils.log0(log, end, String.format("[%s]: FINISHED, duration: %s", clazz.getSimpleName(), VisorTaskUtils.formatDuration(end - start)));
    }

    public static void logMapped(@Nullable IgniteLogger log, Class<?> clazz, Collection<ClusterNode> nodes) {
        VisorTaskUtils.log0(log, System.currentTimeMillis(), String.format("[%s]: MAPPED: %s", clazz.getSimpleName(), U.toShortString(nodes)));
    }

    public static long log(@Nullable IgniteLogger log, String msg, Class<?> clazz, long start) {
        long end = System.currentTimeMillis();
        VisorTaskUtils.log0(log, end, String.format("[%s]: %s, duration: %s", clazz.getSimpleName(), msg, VisorTaskUtils.formatDuration(end - start)));
        return end;
    }

    public static void log(@Nullable IgniteLogger log, String msg) {
        VisorTaskUtils.log0(log, System.currentTimeMillis(), " " + msg);
    }

    public static boolean reachableByPing(InetAddress addr, int reachTimeout) {
        try {
            if (addr.isReachable(reachTimeout)) {
                return true;
            }
            String cmd = String.format("ping -%s 1 %s", U.isWindows() ? "n" : "c", addr.getHostAddress());
            Process myProc = Runtime.getRuntime().exec(cmd);
            myProc.waitFor();
            return myProc.exitValue() == 0;
        }
        catch (IOException ignore) {
            return false;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static List<Process> startLocalNode(@Nullable IgniteLogger log, String cfgPath, int nodesToStart, boolean quite, Map<String, String> envVars) throws IOException {
        String quitePar = quite ? "" : "-v";
        String cmdFile = new File("bin", U.isWindows() ? "ignite.bat" : "ignite.sh").getPath();
        File cmdFilePath = U.resolveIgnitePath(cmdFile);
        if (cmdFilePath == null || !cmdFilePath.exists()) {
            throw new FileNotFoundException(String.format("File not found: %s", cmdFile));
        }
        File nodesCfgPath = U.resolveIgnitePath(cfgPath);
        if (nodesCfgPath == null || !nodesCfgPath.exists()) {
            throw new FileNotFoundException(String.format("File not found: %s", cfgPath));
        }
        String nodeCfg = nodesCfgPath.getCanonicalPath();
        VisorTaskUtils.log(log, String.format("Starting %s local %s with '%s' config", nodesToStart, nodesToStart > 1 ? "nodes" : "node", nodeCfg));
        ArrayList<Process> run = new ArrayList<Process>();
        try {
            String igniteCmd = cmdFilePath.getCanonicalPath();
            for (int i = 0; i < nodesToStart; ++i) {
                if (U.isMacOs()) {
                    HashMap<String, String> macEnv = new HashMap<String, String>(System.getenv());
                    if (envVars != null) {
                        for (Map.Entry<String, String> ent : envVars.entrySet()) {
                            if (macEnv.containsKey(ent.getKey())) {
                                String old = (String)macEnv.get(ent.getKey());
                                if (old == null || old.isEmpty()) {
                                    macEnv.put(ent.getKey(), ent.getValue());
                                    continue;
                                }
                                macEnv.put(ent.getKey(), old + ':' + ent.getValue());
                                continue;
                            }
                            macEnv.put(ent.getKey(), ent.getValue());
                        }
                    }
                    StringBuilder envs = new StringBuilder();
                    for (Map.Entry entry : macEnv.entrySet()) {
                        String val = (String)entry.getValue();
                        if (val.indexOf(59) >= 0 || val.indexOf(39) >= 0) continue;
                        envs.append(String.format("export %s='%s'; ", entry.getKey(), val.replace('\n', ' ').replace("'", "'")));
                    }
                    run.add(VisorTaskUtils.openInConsole(envs.toString(), igniteCmd, quitePar, nodeCfg));
                    continue;
                }
                run.add(VisorTaskUtils.openInConsole(null, envVars, igniteCmd, quitePar, nodeCfg));
            }
            return run;
        }
        catch (Exception e) {
            for (Process proc : run) {
                proc.destroy();
            }
            throw e;
        }
    }

    public static Process openInConsole(String ... args) throws IOException {
        return VisorTaskUtils.openInConsole(null, args);
    }

    public static Process openInConsole(@Nullable File workFolder, String ... args) throws IOException {
        return VisorTaskUtils.openInConsole(workFolder, null, args);
    }

    public static Process openInConsole(@Nullable File workFolder, Map<String, String> envVars, String ... args) throws IOException {
        String[] commands = args;
        String cmd = F.concat(Arrays.asList(args), " ");
        if (U.isWindows()) {
            commands = F.asArray("cmd", "/c", String.format("start %s", cmd));
        }
        if (U.isMacOs()) {
            commands = F.asArray("osascript", "-e", String.format("tell application \"Terminal\" to do script \"%s\"", cmd));
        }
        if (U.isUnix()) {
            commands = F.asArray("xterm", "-sl", "1024", "-geometry", "200x50", "-e", cmd);
        }
        ProcessBuilder pb = new ProcessBuilder(commands);
        if (workFolder != null) {
            pb.directory(workFolder);
        }
        if (envVars != null) {
            String sep = U.isWindows() ? ";" : ":";
            Map<String, String> goalVars = pb.environment();
            for (Map.Entry<String, String> var : envVars.entrySet()) {
                String envVar = goalVars.get(var.getKey());
                envVar = envVar == null || envVar.isEmpty() ? var.getValue() : envVar + sep + var.getValue();
                goalVars.put(var.getKey(), envVar);
            }
        }
        return pb.start();
    }

    public static byte[] zipBytes(byte[] input) throws IOException {
        return VisorTaskUtils.zipBytes(input, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] zipBytes(byte[] input, int initBufSize) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(initBufSize);
        try (ZipOutputStream zos = new ZipOutputStream(bos);){
            try {
                ZipEntry entry = new ZipEntry("");
                entry.setSize(input.length);
                zos.putNextEntry(entry);
                zos.write(input);
            }
            finally {
                zos.closeEntry();
            }
        }
        return bos.toByteArray();
    }

    public static boolean joinTimedOut(String msg) {
        return msg != null && msg.startsWith("Join process timed out.");
    }

    public static Collection<String> sortAddresses(Collection<String> addrs) {
        if (F.isEmpty(addrs)) {
            return Collections.emptyList();
        }
        int sz = addrs.size();
        ArrayList<SortableAddress> sorted = new ArrayList<SortableAddress>(sz);
        for (String addr : addrs) {
            sorted.add(new SortableAddress(addr));
        }
        Collections.sort(sorted);
        ArrayList<String> res = new ArrayList<String>(sz);
        for (SortableAddress sa : sorted) {
            res.add(sa.address());
        }
        return res;
    }

    public static Collection<String> splitAddresses(String s) {
        if (F.isEmpty(s)) {
            return Collections.emptyList();
        }
        String[] addrs = s.split(",");
        for (int i = 0; i < addrs.length; ++i) {
            addrs[i] = addrs[i].trim();
        }
        return Arrays.asList(addrs);
    }

    public static boolean isProxyCache(IgniteEx ignite, String cacheName) {
        ClusterNode locNode;
        GridDiscoveryManager discovery = ignite.context().discovery();
        return !discovery.cacheAffinityNode(locNode = ignite.localNode(), cacheName) && !discovery.cacheNearNode(locNode, cacheName);
    }

    public static boolean isRestartingCache(IgniteEx ignite, String cacheName) {
        IgniteCacheProxy proxy = ignite.context().cache().jcache(cacheName);
        return proxy instanceof IgniteCacheProxyImpl && ((IgniteCacheProxyImpl)proxy).isRestarting();
    }

    public static class SortableAddress
    implements Comparable<SortableAddress> {
        private int type;
        private BigDecimal bits;
        private String addr;

        public SortableAddress(String addr) {
            this.addr = addr;
            if (addr.indexOf(58) > 0) {
                this.type = 4;
            } else {
                try {
                    InetAddress inetAddr = InetAddress.getByName(addr);
                    this.type = inetAddr.isLoopbackAddress() ? 3 : (inetAddr.isSiteLocalAddress() ? 2 : 1);
                }
                catch (UnknownHostException ignored) {
                    this.type = 5;
                }
            }
            this.bits = BigDecimal.valueOf(0L);
            try {
                String[] octets = addr.contains(".") ? addr.split(".") : addr.split(":");
                int len = octets.length;
                for (int i = 0; i < len; ++i) {
                    long oct = F.isEmpty(octets[i]) ? 0L : Long.valueOf(octets[i]);
                    long pow = Double.valueOf(Math.pow(256.0, octets.length - 1 - i)).longValue();
                    this.bits = this.bits.add(BigDecimal.valueOf(oct * pow));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public int compareTo(@NotNull SortableAddress o) {
            return this.type == o.type ? this.bits.compareTo(o.bits) : Integer.compare(this.type, o.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortableAddress other = (SortableAddress)o;
            return this.addr != null ? this.addr.equals(other.addr) : other.addr == null;
        }

        public int hashCode() {
            return this.addr != null ? this.addr.hashCode() : 0;
        }

        public String address() {
            return this.addr;
        }
    }
}

