/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.file;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorFileBlock
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String path;
    private long off;
    private long size;
    private long lastModified;
    private boolean zipped;
    private byte[] data;

    public VisorFileBlock() {
    }

    public VisorFileBlock(String path, long off, long size, long lastModified, boolean zipped, byte[] data) {
        this.path = path;
        this.off = off;
        this.size = size;
        this.lastModified = lastModified;
        this.zipped = zipped;
        this.data = data;
    }

    public String getPath() {
        return this.path;
    }

    public long getOffset() {
        return this.off;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean isZipped() {
        return this.zipped;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.path);
        out.writeLong(this.off);
        out.writeLong(this.size);
        out.writeLong(this.lastModified);
        out.writeBoolean(this.zipped);
        U.writeByteArray(out, this.data);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = U.readString(in);
        this.off = in.readLong();
        this.size = in.readLong();
        this.lastModified = in.readLong();
        this.zipped = in.readBoolean();
        this.data = U.readByteArray(in);
    }

    public String toString() {
        return S.toString(VisorFileBlock.class, this);
    }
}

