/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.configuration.Factory;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorCacheEvictionConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String plc;
    private Integer plcMaxSize;
    private String filter;

    public VisorCacheEvictionConfiguration() {
    }

    public VisorCacheEvictionConfiguration(CacheConfiguration ccfg) {
        Factory evictionPlc = ccfg.getEvictionPolicyFactory();
        this.plc = VisorTaskUtils.compactClass(evictionPlc);
        this.plcMaxSize = VisorTaskUtils.evictionPolicyMaxSize(evictionPlc);
        this.filter = VisorTaskUtils.compactClass(ccfg.getEvictionFilter());
    }

    @Nullable
    public String getPolicy() {
        return this.plc;
    }

    @Nullable
    public Integer getPolicyMaxSize() {
        return this.plcMaxSize;
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.plc);
        out.writeObject(this.plcMaxSize);
        U.writeString(out, this.filter);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.plc = U.readString(in);
        this.plcMaxSize = (Integer)in.readObject();
        this.filter = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorCacheEvictionConfiguration.class, this);
    }
}

