/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.gridify;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import org.apache.ignite.compute.gridify.GridifyInput;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public final class GridifyUtils {
    public static final int UNKNOWN_SIZE = -1;
    private static final Class<?>[] ALLOWED_MTD_RETURN_TYPES = new Class[]{Iterable.class, Iterator.class, Enumeration.class, Collection.class, Set.class, List.class, Queue.class, CharSequence.class};
    private static final Class<?>[] ALLOWED_MTD_PARAM_TYPES = new Class[]{Iterable.class, Iterator.class, Enumeration.class, Collection.class, Set.class, List.class, Queue.class, CharSequence.class};

    private GridifyUtils() {
    }

    public static int getLength(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return -1;
    }

    public static Iterator<?> getIterator(final Object obj) {
        assert (obj != null);
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        if (obj instanceof Enumeration) {
            final Enumeration enumeration = (Enumeration)obj;
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return enumeration.nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not implemented.");
                }
            };
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof CharSequence) {
            final CharSequence cSeq = (CharSequence)obj;
            return new Iterator<Object>(){
                private int idx;

                @Override
                public boolean hasNext() {
                    return this.idx < cSeq.length();
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ++this.idx;
                    return Character.valueOf(cSeq.charAt(this.idx - 1));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not implemented.");
                }
            };
        }
        if (obj.getClass().isArray()) {
            return new Iterator<Object>(){
                private int idx;

                @Override
                public boolean hasNext() {
                    return this.idx < Array.getLength(obj);
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ++this.idx;
                    return Array.get(obj, this.idx - 1);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not implemented.");
                }
            };
        }
        throw new IllegalArgumentException("Unknown parameter type: " + obj.getClass().getName());
    }

    public static boolean isMethodReturnTypeValid(Class<?> cls) {
        for (Class<?> mtdReturnType : ALLOWED_MTD_RETURN_TYPES) {
            if (!mtdReturnType.equals(cls)) continue;
            return true;
        }
        return cls.isArray();
    }

    public static boolean isMethodParameterTypeAllowed(Class<?> cls) {
        for (Class<?> mtdReturnType : ALLOWED_MTD_PARAM_TYPES) {
            if (!mtdReturnType.equals(cls)) continue;
            return true;
        }
        if (cls.isArray()) {
            return true;
        }
        int mod = cls.getModifiers();
        if (!Modifier.isInterface(mod) && !Modifier.isAbstract(mod) && Collection.class.isAssignableFrom(cls)) {
            Constructor<?>[] ctors;
            for (Constructor<?> ctor : ctors = cls.getConstructors()) {
                try {
                    if (ctor.getParameterTypes().length == 0 && ctor.newInstance(new Object[0]) != null) {
                        return true;
                    }
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean isMethodParameterTypeAnnotated(Annotation[] anns) {
        if (anns != null && anns.length > 0) {
            for (Annotation ann : anns) {
                if (!ann.annotationType().equals(GridifyInput.class)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> getAllowedMethodReturnTypes() {
        ArrayList<String> types = new ArrayList<String>(ALLOWED_MTD_RETURN_TYPES.length + 1);
        for (Class<?> type : ALLOWED_MTD_RETURN_TYPES) {
            types.add(type.getName());
        }
        types.add("Java Array");
        return types;
    }

    public static Collection<String> getAllowedMethodParameterTypes() {
        ArrayList<String> types = new ArrayList<String>(ALLOWED_MTD_PARAM_TYPES.length + 1);
        for (Class<?> type : ALLOWED_MTD_PARAM_TYPES) {
            types.add(type.getName());
        }
        types.add("Java Array");
        return Collections.unmodifiableCollection(types);
    }

    @Nullable
    public static Collection parameterToCollection(Object arg) {
        if (arg instanceof Collection) {
            return (Collection)arg;
        }
        if (arg instanceof Iterator) {
            ArrayList res = new ArrayList();
            Iterator iter = (Iterator)arg;
            while (iter.hasNext()) {
                res.add(iter.next());
            }
            return res;
        }
        if (arg instanceof Iterable) {
            ArrayList res = new ArrayList();
            for (Object o : (Iterable)arg) {
                res.add(o);
            }
            return res;
        }
        if (arg instanceof Enumeration) {
            ArrayList res = new ArrayList();
            Enumeration elements = (Enumeration)arg;
            while (elements.hasMoreElements()) {
                res.add(elements.nextElement());
            }
            return res;
        }
        if (F.isArray(arg)) {
            ArrayList<Object> res = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(arg); ++i) {
                res.add(Array.get(arg, i));
            }
            return res;
        }
        if (arg instanceof CharSequence) {
            CharSequence elements = (CharSequence)arg;
            ArrayList<Character> res = new ArrayList<Character>(elements.length());
            for (int i = 0; i < elements.length(); ++i) {
                res.add(Character.valueOf(elements.charAt(i)));
            }
            return res;
        }
        return null;
    }

    @Nullable
    public static Object collectionToParameter(Class<?> paramCls, Collection data) {
        if (Collection.class.equals(paramCls)) {
            return data;
        }
        if (Iterable.class.equals(paramCls)) {
            return data;
        }
        if (Iterator.class.equals(paramCls)) {
            return new IteratorAdapter(data);
        }
        if (Enumeration.class.equals(paramCls)) {
            return new EnumerationAdapter(data);
        }
        if (Set.class.equals(paramCls)) {
            return new HashSet(data);
        }
        if (List.class.equals(paramCls)) {
            return new LinkedList(data);
        }
        if (Queue.class.equals(paramCls)) {
            return new LinkedList(data);
        }
        if (CharSequence.class.equals(paramCls)) {
            SB sb = new SB();
            for (Object obj : data) {
                assert (obj instanceof Character);
                sb.a(obj);
            }
            return sb;
        }
        if (paramCls.isArray()) {
            Class<?> componentType = paramCls.getComponentType();
            Object arr = Array.newInstance(componentType, data.size());
            int i = 0;
            for (Object element : data) {
                Array.set(arr, i, element);
                ++i;
            }
            return arr;
        }
        if (Collection.class.isAssignableFrom(paramCls)) {
            try {
                Collection col = (Collection)paramCls.newInstance();
                for (Object dataObj : data) {
                    col.add(dataObj);
                }
                return col;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class IteratorAdapter<T>
    implements Iterator<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private Collection<T> col;
        private transient Iterator<T> iter;

        IteratorAdapter(Collection<T> col) {
            this.col = col;
            this.iter = col.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            this.iter = this.col.iterator();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }
    }

    private static class EnumerationAdapter<T>
    implements Enumeration<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private Collection<T> col;
        private transient Iterator<T> iter;

        private EnumerationAdapter(Collection<T> col) {
            this.col = col;
            this.iter = col.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iter.next();
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            this.iter = this.col.iterator();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
        }
    }
}

