/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.pool.MetricsAwareExecutorService;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.internal.util.worker.GridWorkerListener;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.thread.IgniteThread;
import org.jetbrains.annotations.NotNull;

public class StripedExecutor
implements ExecutorService,
MetricsAwareExecutorService {
    public static final int DFLT_DATA_STREAMING_EXECUTOR_SERVICE_TASKS_STEALING_THRESHOLD = 4;
    private final Stripe[] stripes;
    private final long threshold;
    private final IgniteLogger log;
    @GridToStringExclude
    private volatile HistogramMetricImpl execTime;

    public StripedExecutor(int cnt, String igniteInstanceName, String poolName, IgniteLogger log, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr, long failureDetectionTimeout) {
        this(cnt, igniteInstanceName, poolName, log, errHnd, false, gridWorkerLsnr, failureDetectionTimeout);
    }

    public StripedExecutor(int cnt, String igniteInstanceName, String poolName, IgniteLogger log, IgniteInClosure<Throwable> errHnd, boolean stealTasks, GridWorkerListener gridWorkerLsnr, long failureDetectionTimeout) {
        A.ensure(cnt > 0, "cnt > 0");
        boolean success = false;
        this.stripes = new Stripe[cnt];
        this.threshold = failureDetectionTimeout;
        this.execTime = new HistogramMetricImpl("TaskExecutionTime", "Tasks execution times as histogram (milliseconds).", PoolProcessor.TASK_EXEC_TIME_HISTOGRAM_BUCKETS);
        this.log = log;
        try {
            int i;
            for (i = 0; i < cnt; ++i) {
                this.stripes[i] = stealTasks ? new StripeConcurrentQueue(igniteInstanceName, poolName, i, log, this.stripes, errHnd, gridWorkerLsnr, this.execTime) : new StripeConcurrentQueue(igniteInstanceName, poolName, i, log, errHnd, gridWorkerLsnr, this.execTime);
            }
            for (i = 0; i < cnt; ++i) {
                this.stripes[i].start();
            }
            success = true;
        }
        catch (Error | RuntimeException e) {
            U.error(log, "Failed to initialize striped pool.", e);
            throw e;
        }
        finally {
            if (!success) {
                for (Stripe stripe : this.stripes) {
                    U.cancel(stripe);
                }
                for (Stripe stripe : this.stripes) {
                    U.join(stripe, log);
                }
            }
        }
    }

    public boolean detectStarvation() {
        boolean starvationDetected = false;
        for (Stripe stripe : this.stripes) {
            boolean active = stripe.active;
            long lastStartedTs = stripe.lastStartedTs;
            if (!active || lastStartedTs + this.threshold >= U.currentTimeMillis()) continue;
            starvationDetected = true;
            boolean deadlockPresent = U.deadlockPresent();
            GridStringBuilder sb = new GridStringBuilder();
            sb.a(">>> Possible starvation in striped pool.").a(U.nl()).a("    Thread name: ").a(stripe.thread.getName()).a(U.nl()).a("    Queue: ").a(stripe.queueToString()).a(U.nl()).a("    Deadlock: ").a(deadlockPresent).a(U.nl()).a("    Completed: ").a(stripe.completedCnt).a(U.nl());
            U.printStackTrace(stripe.thread.getId(), sb);
            String msg = sb.toString();
            U.warn(this.log, msg);
        }
        return starvationDetected;
    }

    public int stripesCount() {
        return this.stripes.length;
    }

    public Stripe[] stripes() {
        return this.stripes;
    }

    public void execute(int idx, Runnable cmd) {
        if (idx == -1) {
            this.execute(cmd);
        } else {
            assert (idx >= 0) : idx;
            this.stripes[idx % this.stripes.length].execute(cmd);
        }
    }

    @Override
    public void shutdown() {
        this.signalStop();
    }

    @Override
    public void execute(@NotNull Runnable cmd) {
        this.stripes[ThreadLocalRandom.current().nextInt(this.stripes.length)].execute(cmd);
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.signalStop();
        return Collections.emptyList();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        this.awaitStop();
        return true;
    }

    @Override
    public boolean isShutdown() {
        for (Stripe stripe : this.stripes) {
            if (stripe == null || !stripe.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTerminated() {
        for (Stripe stripe : this.stripes) {
            if (stripe.thread.getState() == Thread.State.TERMINATED) continue;
            return false;
        }
        return true;
    }

    public void stop() {
        this.signalStop();
        this.awaitStop();
    }

    private void signalStop() {
        for (Stripe stripe : this.stripes) {
            U.cancel(stripe);
        }
    }

    private void awaitStop() {
        for (Stripe stripe : this.stripes) {
            U.join(stripe, this.log);
        }
    }

    public int queueSize() {
        int size = 0;
        for (Stripe stripe : this.stripes) {
            size += stripe.queueSize();
        }
        return size;
    }

    public int queueStripeSize(int idx) {
        A.ensure(idx >= 0, "Stripe index should be non-negative: " + idx);
        return this.stripes[idx % this.stripes.length].queueSize();
    }

    public long completedTasks() {
        long cnt = 0L;
        for (Stripe stripe : this.stripes) {
            cnt += stripe.completedCnt;
        }
        return cnt;
    }

    public long[] stripesCompletedTasks() {
        long[] res = new long[this.stripesCount()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.stripes[i].completedCnt;
        }
        return res;
    }

    public boolean[] stripesActiveStatuses() {
        boolean[] res = new boolean[this.stripesCount()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.stripes[i].active;
        }
        return res;
    }

    public int activeStripesCount() {
        int res = 0;
        for (boolean status : this.stripesActiveStatuses()) {
            if (!status) continue;
            ++res;
        }
        return res;
    }

    public int[] stripesQueueSizes() {
        int[] res = new int[this.stripesCount()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.stripes[i].queueSize();
        }
        return res;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T res) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public void awaitComplete(int ... stripes) throws InterruptedException {
        CountDownLatch awaitLatch;
        if (stripes.length == 0) {
            awaitLatch = new CountDownLatch(this.stripesCount());
            IntStream.range(0, this.stripesCount()).forEach(idx -> this.execute(idx, awaitLatch::countDown));
        } else {
            awaitLatch = new CountDownLatch(stripes.length);
            for (int idx2 : stripes) {
                this.execute(idx2, awaitLatch::countDown);
            }
        }
        while (!awaitLatch.await(60L, TimeUnit.SECONDS)) {
            U.log(this.log, "Await stripes executor complete tasks, awaitLatch=" + awaitLatch.getCount() + ", stripes=" + (stripes.length == 0 ? Arrays.toString(IntStream.range(0, this.stripesCount()).toArray()) : Arrays.toString(stripes)) + ", queueSize=" + Arrays.toString(this.stripesQueueSizes()) + ", activeStatus=" + Arrays.toString(this.stripesActiveStatuses()));
        }
    }

    @Override
    public void registerMetrics(MetricRegistry mreg) {
        mreg.register("StripesCount", this::stripesCount, "Stripes count.");
        mreg.register("Shutdown", this::isShutdown, "True if this executor has been shut down.");
        mreg.register("Terminated", this::isTerminated, "True if all tasks have completed following shut down.");
        mreg.register("DetectStarvation", this::detectStarvation, "True if possible starvation in striped pool is detected.");
        mreg.register("TotalQueueSize", this::queueSize, "Total queue size of all stripes.");
        mreg.register("TotalCompletedTasksCount", this::completedTasks, "Completed tasks count of all stripes.");
        mreg.register("StripesCompletedTasksCounts", this::stripesCompletedTasks, long[].class, "Number of completed tasks per stripe.");
        mreg.register("ActiveCount", this::activeStripesCount, "Number of active tasks of all stripes.");
        mreg.register("StripesActiveStatuses", this::stripesActiveStatuses, boolean[].class, "Number of active tasks per stripe.");
        mreg.register("StripesQueueSizes", this::stripesQueueSizes, int[].class, "Size of queue per stripe.");
        HistogramMetricImpl execTime0 = this.execTime;
        this.execTime = new HistogramMetricImpl(MetricUtils.metricName(mreg.name(), "TaskExecutionTime"), execTime0);
        mreg.register(this.execTime);
        for (Stripe stripe : this.stripes) {
            stripe.execTime = this.execTime;
        }
    }

    public String toString() {
        return S.toString(StripedExecutor.class, this);
    }

    private static class StripeConcurrentQueue
    extends Stripe {
        private static final int IGNITE_TASKS_STEALING_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_DATA_STREAMING_EXECUTOR_SERVICE_TASKS_STEALING_THRESHOLD", 4);
        private final Queue<Runnable> queue;
        @GridToStringExclude
        private final Stripe[] others;
        private volatile boolean parked;

        StripeConcurrentQueue(String igniteInstanceName, String poolName, int idx, IgniteLogger log, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr, HistogramMetricImpl execTime) {
            this(igniteInstanceName, poolName, idx, log, null, errHnd, gridWorkerLsnr, execTime);
        }

        StripeConcurrentQueue(String igniteInstanceName, String poolName, int idx, IgniteLogger log, Stripe[] others, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr, HistogramMetricImpl execTime) {
            super(igniteInstanceName, poolName, idx, log, errHnd, gridWorkerLsnr, execTime);
            this.others = others;
            this.queue = others == null ? new ConcurrentLinkedQueue() : new ConcurrentLinkedDeque();
        }

        @Override
        Runnable take() throws InterruptedException {
            Runnable r;
            for (int i = 0; i < 2048; ++i) {
                r = this.queue.poll();
                if (r == null) continue;
                return r;
            }
            this.parked = true;
            try {
                do {
                    if ((r = this.queue.poll()) != null) {
                        Runnable i = r;
                        return i;
                    }
                    if (this.others != null) {
                        int init;
                        int len = this.others.length;
                        int cur = init = ThreadLocalRandom.current().nextInt(len);
                        do {
                            Deque queue;
                            if (cur == this.idx || (queue = (Deque)((StripeConcurrentQueue)this.others[cur]).queue).size() <= IGNITE_TASKS_STEALING_THRESHOLD || (r = (Runnable)queue.pollLast()) == null) continue;
                            Runnable runnable = r;
                            return runnable;
                        } while ((cur = (cur + 1) % len) != init);
                    }
                    LockSupport.park();
                } while (!Thread.interrupted());
                throw new InterruptedException();
            }
            finally {
                this.parked = false;
            }
        }

        @Override
        void execute(Runnable cmd) {
            this.queue.add(cmd);
            if (this.parked) {
                LockSupport.unpark(this.thread);
            }
            if (this.others != null && this.queueSize() > IGNITE_TASKS_STEALING_THRESHOLD) {
                for (Stripe other : this.others) {
                    if (!((StripeConcurrentQueue)other).parked) continue;
                    LockSupport.unpark(other.thread);
                }
            }
        }

        @Override
        String queueToString() {
            return String.valueOf(this.queue);
        }

        @Override
        public Queue<Runnable> queue() {
            return this.queue;
        }

        @Override
        int queueSize() {
            return this.queue.size();
        }

        @Override
        public String toString() {
            return S.toString(StripeConcurrentQueue.class, this, super.toString());
        }
    }

    public static abstract class Stripe
    extends GridWorker {
        private final String igniteInstanceName;
        protected final int idx;
        private final IgniteLogger log;
        private volatile long completedCnt;
        private volatile boolean active;
        private volatile long lastStartedTs;
        protected Thread thread;
        private final IgniteInClosure<Throwable> errHnd;
        private volatile HistogramMetricImpl execTime;

        public Stripe(String igniteInstanceName, String poolName, int idx, IgniteLogger log, IgniteInClosure<Throwable> errHnd, GridWorkerListener gridWorkerLsnr, HistogramMetricImpl execTime) {
            super(igniteInstanceName, poolName + "-stripe-" + idx, log, gridWorkerLsnr);
            this.igniteInstanceName = igniteInstanceName;
            this.idx = idx;
            this.log = log;
            this.errHnd = errHnd;
            this.execTime = execTime;
        }

        void start() {
            this.thread = new IgniteThread(this.igniteInstanceName, this.name(), this, -1, this.idx, -1);
            this.thread.start();
        }

        @Override
        public void body() {
            while (!this.isCancelled()) {
                try {
                    Runnable cmd;
                    this.blockingSectionBegin();
                    try {
                        cmd = this.take();
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                    if (cmd != null) {
                        this.active = true;
                        this.lastStartedTs = U.currentTimeMillis();
                        this.updateHeartbeat();
                        try {
                            cmd.run();
                        }
                        finally {
                            this.active = false;
                            ++this.completedCnt;
                            this.execTime.value(U.currentTimeMillis() - this.lastStartedTs);
                        }
                    }
                    this.onIdle();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Throwable e) {
                    this.errHnd.apply(e);
                    U.error(this.log, "Failed to execute runnable.", e);
                }
            }
            if (!this.isCancelled) {
                this.errHnd.apply(new IllegalStateException("Thread " + Thread.currentThread().getName() + " is terminated unexpectedly"));
            }
        }

        abstract void execute(Runnable var1);

        abstract Runnable take() throws InterruptedException;

        abstract int queueSize();

        abstract String queueToString();

        public abstract Queue<Runnable> queue();

        public int index() {
            return this.idx;
        }

        @Override
        public String toString() {
            return S.toString(Stripe.class, this);
        }
    }
}

