/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.internal.A;

public class BasicRateLimiter {
    private final long startTime = System.nanoTime();
    private final Object mux = new Object();
    private double stableIntervalMicros;
    private long nextFreeTicketMicros;
    private volatile boolean unlimited;

    public BasicRateLimiter(double permitsPerSecond) {
        this.setRate(permitsPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRate(double permitsPerSecond) {
        A.ensure(permitsPerSecond >= 0.0, "Requested permits (" + permitsPerSecond + ") must be non-negative.");
        this.unlimited = permitsPerSecond == 0.0;
        if (this.unlimited) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            this.resync();
            this.stableIntervalMicros = (double)TimeUnit.SECONDS.toMicros(1L) / permitsPerSecond;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRate() {
        if (this.unlimited) {
            return 0.0;
        }
        Object object = this.mux;
        synchronized (object) {
            return (double)TimeUnit.SECONDS.toMicros(1L) / this.stableIntervalMicros;
        }
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public void acquire(long permits) throws IgniteInterruptedCheckedException {
        if (this.unlimited) {
            return;
        }
        long microsToWait = this.reserve(permits);
        try {
            TimeUnit.MICROSECONDS.sleep(microsToWait);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedCheckedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long reserve(long permits) {
        A.ensure(permits > 0L, "Requested permits (" + permits + ") must be positive");
        Object object = this.mux;
        synchronized (object) {
            long nowMicros = this.resync();
            long momentAvailable = this.nextFreeTicketMicros;
            this.nextFreeTicketMicros = momentAvailable + (long)((double)permits * this.stableIntervalMicros);
            return Math.max(momentAvailable - nowMicros, 0L);
        }
    }

    private long resync() {
        long passed = TimeUnit.MICROSECONDS.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
        if (passed > this.nextFreeTicketMicros) {
            this.nextFreeTicketMicros = passed;
        }
        return passed;
    }
}

