/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.pool;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.ExecutorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.StripedExecutorMXBeanAdapter;
import org.apache.ignite.internal.ThreadPoolMXBeanAdapter;
import org.apache.ignite.internal.managers.IgniteMBeansManager;
import org.apache.ignite.internal.managers.communication.GridIoPolicy;
import org.apache.ignite.internal.managers.systemview.walker.StripedExecutorTaskViewWalker;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.plugin.IgnitePluginProcessor;
import org.apache.ignite.internal.processors.pool.MetricsAwareExecutorService;
import org.apache.ignite.internal.processors.security.thread.SecurityAwareIoPool;
import org.apache.ignite.internal.processors.security.thread.SecurityAwareStripedExecutor;
import org.apache.ignite.internal.processors.security.thread.SecurityAwareStripedThreadPoolExecutor;
import org.apache.ignite.internal.processors.security.thread.SecurityAwareThreadPoolExecutor;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorkerListener;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.mxbean.StripedExecutorMXBean;
import org.apache.ignite.mxbean.ThreadPoolMXBean;
import org.apache.ignite.plugin.extensions.communication.IoPool;
import org.apache.ignite.spi.systemview.view.StripedExecutorTaskView;
import org.apache.ignite.thread.IgniteStripedThreadPoolExecutor;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.apache.ignite.thread.SameThreadExecutor;
import org.jetbrains.annotations.Nullable;

public class PoolProcessor
extends GridProcessorAdapter {
    public static final String ACTIVE_COUNT_DESC = "Approximate number of threads that are actively executing tasks.";
    public static final String COMPLETED_TASK_DESC = "Approximate total number of tasks that have completed execution.";
    public static final String CORE_SIZE_DESC = "The core number of threads.";
    public static final String LARGEST_SIZE_DESC = "Largest number of threads that have ever simultaneously been in the pool.";
    public static final String MAX_SIZE_DESC = "The maximum allowed number of threads.";
    public static final String POOL_SIZE_DESC = "Current number of threads in the pool.";
    public static final String TASK_COUNT_DESC = "Approximate total number of tasks that have been scheduled for execution.";
    public static final String QUEUE_SIZE_DESC = "Current size of the execution queue.";
    public static final String KEEP_ALIVE_TIME_DESC = "Thread keep-alive time, which is the amount of time which threads in excess of the core pool size may remain idle before being terminated.";
    public static final String IS_SHUTDOWN_DESC = "True if this executor has been shut down.";
    public static final String IS_TERMINATED_DESC = "True if all tasks have completed following shut down.";
    public static final String IS_TERMINATING_DESC = "True if terminating but not yet terminated.";
    public static final String REJ_HND_DESC = "Class name of current rejection handler.";
    public static final String THRD_FACTORY_DESC = "Class name of thread factory used to create new threads.";
    public static final String TASK_EXEC_TIME = "TaskExecutionTime";
    public static final String TASK_EXEC_TIME_DESC = "Tasks execution times as histogram (milliseconds).";
    public static final String STREAM_POOL_QUEUE_VIEW = MetricUtils.metricName("datastream", "threadpool", "queue");
    public static final String STREAM_POOL_QUEUE_VIEW_DESC = "Datastream thread pool task queue";
    public static final String SYS_POOL_QUEUE_VIEW = MetricUtils.metricName("striped", "threadpool", "queue");
    public static final String SYS_POOL_QUEUE_VIEW_DESC = "Striped thread pool task queue";
    public static final String THREAD_POOLS = "threadPools";
    public static final long[] TASK_EXEC_TIME_HISTOGRAM_BUCKETS = new long[]{100L, 1000L, 10000L, 30000L, 60000L};
    @GridToStringExclude
    private ThreadPoolExecutor execSvc;
    @GridToStringExclude
    private ThreadPoolExecutor svcExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor sysExecSvc;
    @GridToStringExclude
    private StripedExecutor stripedExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor mgmtExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor p2pExecSvc;
    @GridToStringExclude
    private StripedExecutor dataStreamerExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor restExecSvc;
    private ThreadPoolExecutor utilityCacheExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor affExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor idxExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor buildIdxExecSvc;
    @GridToStringExclude
    private IgniteStripedThreadPoolExecutor callbackExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor qryExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor schemaExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor rebalanceExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor snpExecSvc;
    @GridToStringExclude
    private ExecutorService thinClientExec;
    @GridToStringExclude
    private IgniteStripedThreadPoolExecutor rebalanceStripedExecSvc;
    @GridToStringExclude
    private ThreadPoolExecutor reencryptExecSvc;
    private final IoPool[] extPools = new IoPool[128];
    private Map<String, ThreadPoolExecutor> customExecs;

    public PoolProcessor(GridKernalContext ctx) {
        super(ctx);
        IoPool[] executorExtensions;
        IgnitePluginProcessor plugins = ctx.plugins();
        if (plugins != null && (executorExtensions = (IoPool[])ctx.plugins().extensions(IoPool.class)) != null) {
            for (IoPool ex : executorExtensions) {
                byte id = ex.id();
                if (id < 0) {
                    throw new IgniteException("Failed to register IO executor pool because its ID is negative: " + id);
                }
                if (GridIoPolicy.isReservedGridIoPolicy(id)) {
                    throw new IgniteException("Failed to register IO executor pool because its ID in in the reserved range: " + id);
                }
                if (this.extPools[id] != null) {
                    throw new IgniteException("Failed to register IO executor pool because its ID as already used: " + id);
                }
                this.extPools[id] = ctx.security().enabled() ? new SecurityAwareIoPool(ctx.security(), ex) : ex;
            }
        }
    }

    @Override
    public void start() throws IgniteCheckedException {
        super.start();
        IgniteConfiguration cfg = this.ctx.config();
        Thread.UncaughtExceptionHandler oomeHnd = this.ctx.uncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler excHnd = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                PoolProcessor.this.ctx.failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
            }
        };
        PoolProcessor.validateThreadPoolSize(cfg.getPublicThreadPoolSize(), "public");
        this.execSvc = this.createExecutorService("pub", cfg.getIgniteInstanceName(), cfg.getPublicThreadPoolSize(), cfg.getPublicThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)0, oomeHnd);
        this.execSvc.allowCoreThreadTimeOut(true);
        PoolProcessor.validateThreadPoolSize(cfg.getServiceThreadPoolSize(), "service");
        this.svcExecSvc = this.createExecutorService("svc", cfg.getIgniteInstanceName(), cfg.getServiceThreadPoolSize(), cfg.getServiceThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)11, oomeHnd);
        this.svcExecSvc.allowCoreThreadTimeOut(true);
        PoolProcessor.validateThreadPoolSize(cfg.getSystemThreadPoolSize(), "system");
        this.sysExecSvc = this.createExecutorService("sys", cfg.getIgniteInstanceName(), cfg.getSystemThreadPoolSize(), cfg.getSystemThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)2, oomeHnd);
        this.sysExecSvc.allowCoreThreadTimeOut(true);
        PoolProcessor.validateThreadPoolSize(cfg.getStripedPoolSize(), "stripedPool");
        WorkersRegistry workerRegistry = this.ctx.workersRegistry();
        this.stripedExecSvc = this.createStripedExecutor(cfg.getStripedPoolSize(), cfg.getIgniteInstanceName(), "sys", this.log, new IgniteInClosure<Throwable>(){

            @Override
            public void apply(Throwable t) {
                PoolProcessor.this.ctx.failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, t));
            }
        }, false, workerRegistry, cfg.getFailureDetectionTimeout());
        PoolProcessor.validateThreadPoolSize(cfg.getManagementThreadPoolSize(), "management");
        this.mgmtExecSvc = this.createExecutorService("mgmt", cfg.getIgniteInstanceName(), cfg.getManagementThreadPoolSize(), cfg.getManagementThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)3, oomeHnd);
        this.mgmtExecSvc.allowCoreThreadTimeOut(true);
        PoolProcessor.validateThreadPoolSize(cfg.getPeerClassLoadingThreadPoolSize(), "peer class loading");
        this.p2pExecSvc = this.createExecutorService("p2p", cfg.getIgniteInstanceName(), cfg.getPeerClassLoadingThreadPoolSize(), cfg.getPeerClassLoadingThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)1, oomeHnd);
        this.p2pExecSvc.allowCoreThreadTimeOut(true);
        this.dataStreamerExecSvc = this.createStripedExecutor(cfg.getDataStreamerThreadPoolSize(), cfg.getIgniteInstanceName(), "data-streamer", this.log, new IgniteInClosure<Throwable>(){

            @Override
            public void apply(Throwable t) {
                PoolProcessor.this.ctx.failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, t));
            }
        }, true, workerRegistry, cfg.getFailureDetectionTimeout());
        PoolProcessor.validateThreadPoolSize(cfg.getAsyncCallbackPoolSize(), "async callback");
        this.callbackExecSvc = new IgniteStripedThreadPoolExecutor(cfg.getAsyncCallbackPoolSize(), cfg.getIgniteInstanceName(), "callback", oomeHnd, false, 0L);
        if (cfg.getConnectorConfiguration() != null) {
            PoolProcessor.validateThreadPoolSize(cfg.getConnectorConfiguration().getThreadPoolSize(), "connector");
            this.restExecSvc = this.createExecutorService("rest", cfg.getIgniteInstanceName(), cfg.getConnectorConfiguration().getThreadPoolSize(), cfg.getConnectorConfiguration().getThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)-1, oomeHnd);
            this.restExecSvc.allowCoreThreadTimeOut(true);
        }
        PoolProcessor.validateThreadPoolSize(cfg.getUtilityCacheThreadPoolSize(), "utility cache");
        this.utilityCacheExecSvc = this.createExecutorService("utility", cfg.getIgniteInstanceName(), cfg.getUtilityCacheThreadPoolSize(), cfg.getUtilityCacheThreadPoolSize(), cfg.getUtilityCacheKeepAliveTime(), new LinkedBlockingQueue<Runnable>(), (byte)5, oomeHnd);
        this.utilityCacheExecSvc.allowCoreThreadTimeOut(true);
        this.affExecSvc = this.createExecutorService("aff", cfg.getIgniteInstanceName(), 1, 1, 60000L, new LinkedBlockingQueue<Runnable>(), (byte)4, oomeHnd);
        this.affExecSvc.allowCoreThreadTimeOut(true);
        if (IgniteComponentType.INDEXING.inClassPath()) {
            int cpus = Runtime.getRuntime().availableProcessors();
            this.idxExecSvc = this.createExecutorService("idx", cfg.getIgniteInstanceName(), cpus, cpus * 2, 3000L, new LinkedBlockingQueue<Runnable>(1000), (byte)7, oomeHnd);
            int buildIdxThreadPoolSize = cfg.getBuildIndexThreadPoolSize();
            PoolProcessor.validateThreadPoolSize(buildIdxThreadPoolSize, "build-idx");
            this.buildIdxExecSvc = this.createExecutorService("build-idx-runner", cfg.getIgniteInstanceName(), buildIdxThreadPoolSize, buildIdxThreadPoolSize, 60000L, new LinkedBlockingQueue<Runnable>(), (byte)-1, oomeHnd);
            this.buildIdxExecSvc.allowCoreThreadTimeOut(true);
        }
        PoolProcessor.validateThreadPoolSize(cfg.getQueryThreadPoolSize(), "query");
        this.qryExecSvc = this.createExecutorService("query", cfg.getIgniteInstanceName(), cfg.getQueryThreadPoolSize(), cfg.getQueryThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)10, oomeHnd);
        this.qryExecSvc.allowCoreThreadTimeOut(true);
        this.schemaExecSvc = this.createExecutorService("schema", cfg.getIgniteInstanceName(), 2, 2, 60000L, new LinkedBlockingQueue<Runnable>(), (byte)12, oomeHnd);
        this.schemaExecSvc.allowCoreThreadTimeOut(true);
        PoolProcessor.validateThreadPoolSize(cfg.getRebalanceThreadPoolSize(), "rebalance");
        this.rebalanceExecSvc = this.createExecutorService("rebalance", cfg.getIgniteInstanceName(), cfg.getRebalanceThreadPoolSize(), cfg.getRebalanceThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)-1, excHnd);
        this.rebalanceExecSvc.allowCoreThreadTimeOut(true);
        if (CU.isPersistenceEnabled(this.ctx.config())) {
            this.snpExecSvc = this.createExecutorService("snapshot-runner", cfg.getIgniteInstanceName(), cfg.getSnapshotThreadPoolSize(), cfg.getSnapshotThreadPoolSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)-1, excHnd);
            this.snpExecSvc.allowCoreThreadTimeOut(true);
            this.reencryptExecSvc = this.createExecutorService("reencrypt", this.ctx.igniteInstanceName(), 1, 1, 60000L, new LinkedBlockingQueue<Runnable>(), (byte)-1, oomeHnd);
            this.reencryptExecSvc.allowCoreThreadTimeOut(true);
        }
        if (cfg.getClientConnectorConfiguration() != null) {
            this.thinClientExec = new IgniteThreadPoolExecutor("client-connector", cfg.getIgniteInstanceName(), cfg.getClientConnectorConfiguration().getThreadPoolSize(), cfg.getClientConnectorConfiguration().getThreadPoolSize(), 0L, new LinkedBlockingQueue<Runnable>(), -1, oomeHnd);
        }
        this.rebalanceStripedExecSvc = this.createStripedThreadPoolExecutor(cfg.getRebalanceThreadPoolSize(), cfg.getIgniteInstanceName(), "rebalance-striped", excHnd, true, 60000L);
        if (!F.isEmpty(cfg.getExecutorConfiguration())) {
            PoolProcessor.validateCustomExecutorsConfiguration(cfg.getExecutorConfiguration());
            this.customExecs = new HashMap<String, ThreadPoolExecutor>();
            for (ExecutorConfiguration execCfg : cfg.getExecutorConfiguration()) {
                IgniteThreadPoolExecutor exec = this.createExecutorService(execCfg.getName(), cfg.getIgniteInstanceName(), execCfg.getSize(), execCfg.getSize(), 60000L, new LinkedBlockingQueue<Runnable>(), (byte)-1, oomeHnd);
                this.customExecs.put(execCfg.getName(), exec);
            }
        }
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        Arrays.fill(this.extPools, null);
        this.stopExecutors(this.log);
    }

    public void registerMetrics() {
        this.monitorExecutor("GridUtilityCacheExecutor", this.utilityCacheExecSvc);
        this.monitorExecutor("GridExecutionExecutor", this.execSvc);
        this.monitorExecutor("GridServicesExecutor", this.svcExecSvc);
        this.monitorExecutor("GridSystemExecutor", this.sysExecSvc);
        this.monitorExecutor("GridClassLoadingExecutor", this.p2pExecSvc);
        this.monitorExecutor("GridManagementExecutor", this.mgmtExecSvc);
        this.monitorExecutor("GridAffinityExecutor", this.affExecSvc);
        this.monitorExecutor("GridCallbackExecutor", this.callbackExecSvc);
        this.monitorExecutor("GridQueryExecutor", this.qryExecSvc);
        this.monitorExecutor("GridSchemaExecutor", this.schemaExecSvc);
        this.monitorExecutor("GridRebalanceExecutor", this.rebalanceExecSvc);
        this.monitorExecutor("GridRebalanceStripedExecutor", this.rebalanceStripedExecSvc);
        this.monitorExecutor("GridDataStreamExecutor", this.dataStreamerExecSvc);
        this.monitorExecutor("StripedExecutor", this.stripedExecSvc);
        if (this.idxExecSvc != null) {
            this.monitorExecutor("GridIndexingExecutor", this.idxExecSvc);
        }
        if (this.ctx.config().getConnectorConfiguration() != null) {
            this.monitorExecutor("GridRestExecutor", this.restExecSvc);
        }
        if (this.snpExecSvc != null) {
            this.monitorExecutor("GridSnapshotExecutor", this.snpExecSvc);
        }
        if (this.thinClientExec != null) {
            this.monitorExecutor("GridThinClientExecutor", this.thinClientExec);
        }
        if (this.reencryptExecSvc != null) {
            this.monitorExecutor("GridReencryptionExecutor", this.reencryptExecSvc);
        }
        if (this.customExecs != null) {
            for (Map.Entry<String, ThreadPoolExecutor> entry : this.customExecs.entrySet()) {
                this.monitorExecutor(entry.getKey(), entry.getValue());
            }
        }
        this.ctx.systemView().registerInnerCollectionView(SYS_POOL_QUEUE_VIEW, SYS_POOL_QUEUE_VIEW_DESC, new StripedExecutorTaskViewWalker(), Arrays.asList(this.stripedExecSvc.stripes()), StripedExecutor.Stripe::queue, StripedExecutorTaskView::new);
        this.ctx.systemView().registerInnerCollectionView(STREAM_POOL_QUEUE_VIEW, STREAM_POOL_QUEUE_VIEW_DESC, new StripedExecutorTaskViewWalker(), Arrays.asList(this.dataStreamerExecSvc.stripes()), StripedExecutor.Stripe::queue, StripedExecutorTaskView::new);
    }

    public Executor poolForPolicy(byte plc) throws IgniteCheckedException {
        switch (plc) {
            case 1: {
                return this.getPeerClassLoadingExecutorService();
            }
            case 2: {
                return this.getSystemExecutorService();
            }
            case 0: {
                return this.getExecutorService();
            }
            case 3: {
                return this.getManagementExecutorService();
            }
            case 4: {
                return this.getAffinityExecutorService();
            }
            case 7: {
                assert (this.getIndexingExecutorService() != null) : "Indexing pool is not configured.";
                return this.getIndexingExecutorService();
            }
            case 5: {
                assert (this.utilityCachePool() != null) : "Utility cache pool is not configured.";
                return this.utilityCachePool();
            }
            case 11: {
                assert (this.getServiceExecutorService() != null) : "Service pool is not configured.";
                return this.getServiceExecutorService();
            }
            case 9: {
                assert (this.getDataStreamerExecutorService() != null) : "Data streamer pool is not configured.";
                return this.getDataStreamerExecutorService();
            }
            case 10: {
                assert (this.getQueryExecutorService() != null) : "Query pool is not configured.";
                return this.getQueryExecutorService();
            }
            case 12: {
                assert (this.getSchemaExecutorService() != null) : "Query pool is not configured.";
                return this.getSchemaExecutorService();
            }
            case 13: {
                return SameThreadExecutor.INSTANCE;
            }
        }
        if (plc < 0) {
            throw new IgniteCheckedException("Policy cannot be negative: " + plc);
        }
        if (GridIoPolicy.isReservedGridIoPolicy(plc)) {
            throw new IgniteCheckedException("Policy is reserved for internal usage (range 0-31): " + plc);
        }
        IoPool pool = this.extPools[plc];
        if (pool == null) {
            throw new IgniteCheckedException("No pool is registered for policy: " + plc);
        }
        assert (plc == pool.id());
        Executor res = pool.executor();
        if (res == null) {
            throw new IgniteCheckedException("Thread pool for policy is null: " + plc);
        }
        return res;
    }

    @Nullable
    public Executor customExecutor(String name) {
        assert (name != null);
        Executor exec = null;
        if (this.customExecs != null) {
            exec = this.customExecs.get(name);
        }
        return exec;
    }

    public ExecutorService utilityCachePool() {
        return this.utilityCacheExecSvc;
    }

    public IgniteStripedThreadPoolExecutor asyncCallbackPool() {
        return this.callbackExecSvc;
    }

    public ExecutorService getExecutorService() {
        return this.execSvc;
    }

    public ExecutorService getServiceExecutorService() {
        return this.svcExecSvc;
    }

    public ExecutorService getSystemExecutorService() {
        return this.sysExecSvc;
    }

    public StripedExecutor getStripedExecutorService() {
        return this.stripedExecSvc;
    }

    public ExecutorService getManagementExecutorService() {
        return this.mgmtExecSvc;
    }

    public ExecutorService getPeerClassLoadingExecutorService() {
        return this.p2pExecSvc;
    }

    public StripedExecutor getDataStreamerExecutorService() {
        return this.dataStreamerExecSvc;
    }

    public ExecutorService getRestExecutorService() {
        return this.restExecSvc;
    }

    public ExecutorService getAffinityExecutorService() {
        return this.affExecSvc;
    }

    @Nullable
    public ExecutorService getIndexingExecutorService() {
        return this.idxExecSvc;
    }

    public ExecutorService getQueryExecutorService() {
        return this.qryExecSvc;
    }

    @Nullable
    public Map<String, ? extends ExecutorService> customExecutors() {
        return this.customExecs == null ? null : Collections.unmodifiableMap(this.customExecs);
    }

    public ExecutorService getSchemaExecutorService() {
        return this.schemaExecSvc;
    }

    public ExecutorService getRebalanceExecutorService() {
        return this.rebalanceExecSvc;
    }

    public ExecutorService getSnapshotExecutorService() {
        return this.snpExecSvc;
    }

    public ExecutorService getThinClientExecutorService() {
        return this.thinClientExec;
    }

    public IgniteStripedThreadPoolExecutor getStripedRebalanceExecutorService() {
        return this.rebalanceStripedExecSvc;
    }

    public ExecutorService buildIndexExecutorService() {
        return this.buildIdxExecSvc;
    }

    public ExecutorService getReencryptionExecutorService() {
        return this.reencryptExecSvc;
    }

    private void monitorExecutor(String name, ExecutorService execSvc) {
        if (!(execSvc instanceof MetricsAwareExecutorService)) {
            throw new UnsupportedOperationException("Executor '" + name + "' does not implement '" + MetricsAwareExecutorService.class.getSimpleName() + "'.");
        }
        ((MetricsAwareExecutorService)((Object)execSvc)).registerMetrics(this.ctx.metric().registry(MetricUtils.metricName(THREAD_POOLS, name)));
    }

    public void registerMxBeans(IgniteMBeansManager mbMgr) throws IgniteCheckedException {
        this.registerExecutorMBean(mbMgr, "GridUtilityCacheExecutor", this.utilityCacheExecSvc);
        this.registerExecutorMBean(mbMgr, "GridExecutionExecutor", this.execSvc);
        this.registerExecutorMBean(mbMgr, "GridServicesExecutor", this.svcExecSvc);
        this.registerExecutorMBean(mbMgr, "GridSystemExecutor", this.sysExecSvc);
        this.registerExecutorMBean(mbMgr, "GridClassLoadingExecutor", this.p2pExecSvc);
        this.registerExecutorMBean(mbMgr, "GridManagementExecutor", this.mgmtExecSvc);
        this.registerExecutorMBean(mbMgr, "GridAffinityExecutor", this.affExecSvc);
        this.registerExecutorMBean(mbMgr, "GridCallbackExecutor", this.callbackExecSvc);
        this.registerExecutorMBean(mbMgr, "GridQueryExecutor", this.qryExecSvc);
        this.registerExecutorMBean(mbMgr, "GridSchemaExecutor", this.schemaExecSvc);
        this.registerExecutorMBean(mbMgr, "GridRebalanceExecutor", this.rebalanceExecSvc);
        this.registerExecutorMBean(mbMgr, "GridRebalanceStripedExecutor", this.rebalanceStripedExecSvc);
        this.registerStripedExecutorMBean(mbMgr, "GridDataStreamExecutor", this.dataStreamerExecSvc);
        if (this.idxExecSvc != null) {
            this.registerExecutorMBean(mbMgr, "GridIndexingExecutor", this.idxExecSvc);
        }
        if (this.ctx.config().getConnectorConfiguration() != null) {
            this.registerExecutorMBean(mbMgr, "GridRestExecutor", this.restExecSvc);
        }
        if (this.stripedExecSvc != null) {
            this.registerStripedExecutorMBean(mbMgr, "StripedExecutor", this.stripedExecSvc);
        }
        if (this.snpExecSvc != null) {
            this.registerExecutorMBean(mbMgr, "GridSnapshotExecutor", this.snpExecSvc);
        }
        if (this.thinClientExec != null) {
            this.registerExecutorMBean(mbMgr, "GridThinClientExecutor", this.thinClientExec);
        }
        if (this.customExecs != null) {
            for (Map.Entry<String, ThreadPoolExecutor> entry : this.customExecs.entrySet()) {
                this.registerExecutorMBean(mbMgr, entry.getKey(), entry.getValue());
            }
        }
    }

    private void registerExecutorMBean(IgniteMBeansManager mgr, String name, ExecutorService exec) throws IgniteCheckedException {
        mgr.registerMBean("Thread Pools", name, new ThreadPoolMXBeanAdapter(exec), ThreadPoolMXBean.class);
    }

    private void registerStripedExecutorMBean(IgniteMBeansManager mgr, String name, StripedExecutor exec) throws IgniteCheckedException {
        mgr.registerMBean("Thread Pools", name, new StripedExecutorMXBeanAdapter(exec), StripedExecutorMXBean.class);
    }

    private void stopExecutors(IgniteLogger log) {
        boolean interrupted = Thread.interrupted();
        try {
            this.stopExecutors0(log);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void stopExecutors0(IgniteLogger log) {
        assert (log != null);
        U.shutdownNow(this.getClass(), this.snpExecSvc, log);
        this.snpExecSvc = null;
        U.shutdownNow(this.getClass(), this.execSvc, log);
        this.execSvc = null;
        U.shutdownNow(this.getClass(), this.svcExecSvc, log);
        this.svcExecSvc = null;
        U.shutdownNow(this.getClass(), this.sysExecSvc, log);
        this.sysExecSvc = null;
        U.shutdownNow(this.getClass(), this.qryExecSvc, log);
        this.qryExecSvc = null;
        U.shutdownNow(this.getClass(), this.schemaExecSvc, log);
        this.schemaExecSvc = null;
        U.shutdownNow(this.getClass(), this.rebalanceExecSvc, log);
        this.rebalanceExecSvc = null;
        U.shutdownNow(this.getClass(), this.rebalanceStripedExecSvc, log);
        this.rebalanceStripedExecSvc = null;
        U.shutdownNow(this.getClass(), this.stripedExecSvc, log);
        this.stripedExecSvc = null;
        U.shutdownNow(this.getClass(), this.mgmtExecSvc, log);
        this.mgmtExecSvc = null;
        U.shutdownNow(this.getClass(), this.p2pExecSvc, log);
        this.p2pExecSvc = null;
        U.shutdownNow(this.getClass(), this.dataStreamerExecSvc, log);
        this.dataStreamerExecSvc = null;
        if (this.restExecSvc != null) {
            U.shutdownNow(this.getClass(), this.restExecSvc, log);
        }
        this.restExecSvc = null;
        U.shutdownNow(this.getClass(), this.utilityCacheExecSvc, log);
        this.utilityCacheExecSvc = null;
        U.shutdownNow(this.getClass(), this.affExecSvc, log);
        this.affExecSvc = null;
        U.shutdownNow(this.getClass(), this.idxExecSvc, log);
        this.idxExecSvc = null;
        U.shutdownNow(this.getClass(), this.buildIdxExecSvc, log);
        this.buildIdxExecSvc = null;
        U.shutdownNow(this.getClass(), this.callbackExecSvc, log);
        this.callbackExecSvc = null;
        if (this.thinClientExec != null) {
            U.shutdownNow(this.getClass(), this.thinClientExec, log);
        }
        this.thinClientExec = null;
        U.shutdownNow(this.getClass(), this.reencryptExecSvc, log);
        this.reencryptExecSvc = null;
        if (!F.isEmpty(this.customExecs)) {
            for (ThreadPoolExecutor exec : this.customExecs.values()) {
                U.shutdownNow(this.getClass(), exec, log);
            }
            this.customExecs = null;
        }
    }

    private static void validateThreadPoolSize(int poolSize, String poolName) throws IgniteCheckedException {
        if (poolSize <= 0) {
            throw new IgniteCheckedException("Invalid " + poolName + " thread pool size (must be greater than 0), actual value: " + poolSize);
        }
    }

    private static void validateCustomExecutorsConfiguration(ExecutorConfiguration[] cfgs) throws IgniteCheckedException {
        if (cfgs == null) {
            return;
        }
        HashSet<String> names = new HashSet<String>(cfgs.length);
        for (ExecutorConfiguration cfg : cfgs) {
            if (F.isEmpty(cfg.getName())) {
                throw new IgniteCheckedException("Custom executor name cannot be null or empty.");
            }
            if (!names.add(cfg.getName())) {
                throw new IgniteCheckedException("Duplicate custom executor name: " + cfg.getName());
            }
            if (cfg.getSize() > 0) continue;
            throw new IgniteCheckedException("Custom executor size must be positive [name=" + cfg.getName() + ", size=" + cfg.getSize() + ']');
        }
    }

    private IgniteStripedThreadPoolExecutor createStripedThreadPoolExecutor(int concurrentLvl, String igniteInstanceName, String threadNamePrefix, Thread.UncaughtExceptionHandler eHnd, boolean allowCoreThreadTimeOut, long keepAliveTime) {
        return this.ctx.security().enabled() ? new SecurityAwareStripedThreadPoolExecutor(this.ctx.security(), concurrentLvl, igniteInstanceName, threadNamePrefix, eHnd, allowCoreThreadTimeOut, keepAliveTime) : new IgniteStripedThreadPoolExecutor(concurrentLvl, igniteInstanceName, threadNamePrefix, eHnd, allowCoreThreadTimeOut, keepAliveTime);
    }

    private StripedExecutor createStripedExecutor(int cnt, String igniteInstanceName, String poolName, IgniteLogger log, IgniteInClosure<Throwable> errHnd, boolean stealTasks, GridWorkerListener gridWorkerLsnr, long failureDetectionTimeout) {
        return this.ctx.security().enabled() ? new SecurityAwareStripedExecutor(this.ctx.security(), cnt, igniteInstanceName, poolName, log, errHnd, stealTasks, gridWorkerLsnr, failureDetectionTimeout) : new StripedExecutor(cnt, igniteInstanceName, poolName, log, errHnd, stealTasks, gridWorkerLsnr, failureDetectionTimeout);
    }

    private IgniteThreadPoolExecutor createExecutorService(String threadNamePrefix, String igniteInstanceName, int corePoolSize, int maxPoolSize, long keepAliveTime, BlockingQueue<Runnable> workQ, byte plc, Thread.UncaughtExceptionHandler eHnd) {
        return this.ctx.security().enabled() ? new SecurityAwareThreadPoolExecutor(this.ctx.security(), threadNamePrefix, igniteInstanceName, corePoolSize, maxPoolSize, keepAliveTime, workQ, plc, eHnd) : new IgniteThreadPoolExecutor(threadNamePrefix, igniteInstanceName, corePoolSize, maxPoolSize, keepAliveTime, workQ, plc, eHnd);
    }
}

