/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteBinary;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteServices;
import org.apache.ignite.internal.IgniteServicesImpl;
import org.apache.ignite.internal.binary.BinaryArray;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.cluster.ClusterGroupAdapter;
import org.apache.ignite.internal.processors.platform.PlatformNativeException;
import org.apache.ignite.internal.processors.platform.client.ClientBitmaskFeature;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientObjectResponse;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.services.PlatformService;
import org.apache.ignite.internal.processors.platform.services.PlatformServices;
import org.apache.ignite.internal.processors.service.GridServiceProxy;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceDescriptor;

public class ClientServiceInvokeRequest
extends ClientRequest {
    private static final byte FLAG_KEEP_BINARY_MASK = 1;
    private static final byte FLAG_PARAMETER_TYPES_MASK = 2;
    private static final Map<MethodDescriptor, Method> methodsCache = new ConcurrentHashMap<MethodDescriptor, Method>();
    private final String name;
    private final byte flags;
    private final long timeout;
    private final Collection<UUID> nodeIds;
    private final String methodName;
    private final int[] paramTypeIds;
    private final Object[] args;
    private final BinaryRawReaderEx reader;
    private final Map<String, Object> callAttrs;

    public ClientServiceInvokeRequest(BinaryReaderExImpl reader, ClientProtocolContext protocolCtx) {
        super(reader);
        this.name = reader.readString();
        this.flags = reader.readByte();
        this.timeout = reader.readLong();
        int cnt = reader.readInt();
        this.nodeIds = new ArrayList<UUID>(cnt);
        for (int i = 0; i < cnt; ++i) {
            this.nodeIds.add(new UUID(reader.readLong(), reader.readLong()));
        }
        this.methodName = reader.readString();
        int argCnt = reader.readInt();
        this.paramTypeIds = this.hasParameterTypes() ? new int[argCnt] : null;
        this.args = new Object[argCnt];
        this.reader = reader;
        int argsStartPos = reader.in().position();
        for (int i = 0; i < argCnt; ++i) {
            if (this.paramTypeIds != null) {
                this.paramTypeIds[i] = reader.readInt();
            }
            this.args[i] = reader.readObjectDetached();
        }
        this.callAttrs = protocolCtx.isFeatureSupported(ClientBitmaskFeature.SERVICE_INVOKE_CALLCTX) ? reader.readMap() : null;
        reader.in().position(argsStartPos);
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        if (F.isEmpty(this.name)) {
            throw new IgniteException("Service name can't be empty");
        }
        if (F.isEmpty(this.methodName)) {
            throw new IgniteException("Method name can't be empty");
        }
        ServiceDescriptor desc = ClientServiceInvokeRequest.findServiceDescriptor(ctx, this.name);
        Class<? extends Service> svcCls = desc.serviceClass();
        ClusterGroupAdapter grp = ctx.kernalContext().cluster().get();
        grp = (ClusterGroupAdapter)(this.nodeIds.isEmpty() ? grp.forServers() : grp.forNodeIds(this.nodeIds));
        IgniteServices services = grp.services();
        try {
            Object res;
            if (PlatformService.class.isAssignableFrom(svcCls)) {
                PlatformService proxy = ((IgniteServicesImpl)services).serviceProxy(this.name, PlatformService.class, false, this.timeout, true);
                res = proxy.invokeMethod(this.methodName, this.keepBinary(), false, this.args, this.callAttrs);
            } else {
                if (!this.keepBinary() && this.args.length > 0) {
                    for (int i = 0; i < this.args.length; ++i) {
                        if (this.paramTypeIds != null) {
                            this.reader.readInt();
                        }
                        this.args[i] = this.reader.readObject();
                    }
                }
                GridServiceProxy<Service> proxy = new GridServiceProxy<Service>(grp, this.name, Service.class, false, this.timeout, ctx.kernalContext(), null, true);
                Method method = this.resolveMethod(ctx, svcCls);
                if (!BinaryArray.useBinaryArrays()) {
                    PlatformServices.convertArrayArgs(this.args, method);
                }
                res = proxy.invokeMethod(method, this.args, this.callAttrs);
            }
            return new ClientObjectResponse(this.requestId(), res);
        }
        catch (PlatformNativeException e) {
            ctx.kernalContext().log(this.getClass()).error("Failed to invoke platform service", e);
            throw new IgniteException("Failed to invoke platform service, see server logs for details");
        }
        catch (Throwable e) {
            throw new IgniteException(e);
        }
    }

    private boolean keepBinary() {
        return (this.flags & 1) != 0;
    }

    private boolean hasParameterTypes() {
        return (this.flags & 2) != 0;
    }

    public static ServiceDescriptor findServiceDescriptor(ClientConnectionContext ctx, String name) {
        for (ServiceDescriptor desc : ctx.kernalContext().service().serviceDescriptors()) {
            if (!name.equals(desc.name())) continue;
            return desc;
        }
        throw new IgniteException("Service not found: " + name);
    }

    private Method resolveMethod(ClientConnectionContext ctx, Class<?> cls) throws ReflectiveOperationException {
        if (this.paramTypeIds != null) {
            MethodDescriptor desc = new MethodDescriptor(cls, this.methodName, this.paramTypeIds);
            Method method = methodsCache.get(desc);
            if (method != null) {
                return method;
            }
            IgniteBinary binary = ctx.kernalContext().grid().binary();
            for (Method method0 : cls.getMethods()) {
                if (!this.methodName.equals(method0.getName())) continue;
                MethodDescriptor desc0 = MethodDescriptor.forMethod(binary, method0);
                methodsCache.putIfAbsent(desc0, method0);
                if (!desc0.equals(desc)) continue;
                return method0;
            }
            throw new NoSuchMethodException("Method not found: " + desc);
        }
        return PlatformServices.getMethod(cls, this.methodName, this.args);
    }

    private static class MethodDescriptor {
        private final Class<?> cls;
        private final String methodName;
        private final int[] paramTypeIds;
        private final int hash;

        private MethodDescriptor(Class<?> cls, String methodName, int[] paramTypeIds) {
            assert (cls != null);
            assert (methodName != null);
            assert (paramTypeIds != null);
            this.cls = cls;
            this.methodName = methodName;
            this.paramTypeIds = paramTypeIds;
            this.hash = 31 * (31 * cls.hashCode() + methodName.hashCode()) + Arrays.hashCode(paramTypeIds);
        }

        private static MethodDescriptor forMethod(IgniteBinary binary, Method method) {
            Class<?>[] paramTypes = method.getParameterTypes();
            int[] paramTypeIds = new int[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypeIds[i] = binary.typeId(paramTypes[i].getName());
            }
            return new MethodDescriptor(method.getDeclaringClass(), method.getName(), paramTypeIds);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodDescriptor that = (MethodDescriptor)o;
            return this.cls.equals(that.cls) && this.methodName.equals(that.methodName) && Arrays.equals(this.paramTypeIds, that.paramTypeIds);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return S.toString(MethodDescriptor.class, this, "paramTypeIds", (Object)this.paramTypeIds);
        }
    }
}

