/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.Storable;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CompactablePageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDataPageIO<T extends Storable>
extends PageIO
implements CompactablePageIO {
    private static final int SHOW_ITEM = 1;
    private static final int SHOW_PAYLOAD_LEN = 2;
    private static final int SHOW_LINK = 4;
    private static final int FREE_LIST_PAGE_ID_OFF = 40;
    private static final int FREE_SPACE_OFF = 48;
    private static final int DIRECT_CNT_OFF = 50;
    private static final int INDIRECT_CNT_OFF = 51;
    private static final int FIRST_ENTRY_OFF = 52;
    public static final int ITEMS_OFF = 54;
    private static final int ITEM_SIZE = 2;
    private static final int PAYLOAD_LEN_SIZE = 2;
    private static final int LINK_SIZE = 8;
    private static final int FRAGMENTED_FLAG = 32768;
    public static final int MIN_DATA_PAGE_OVERHEAD = 66;

    protected AbstractDataPageIO(int type, int ver) {
        super(type, ver);
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setEmptyPage(pageAddr, pageSize);
        this.setFreeListPageId(pageAddr, 0L);
    }

    private void setEmptyPage(long pageAddr, int pageSize) {
        this.setDirectCount(pageAddr, 0);
        this.setIndirectCount(pageAddr, 0);
        this.setFirstEntryOffset(pageAddr, pageSize, pageSize);
        this.setRealFreeSpace(pageAddr, pageSize - 54, pageSize);
    }

    public void setFreeListPageId(long pageAddr, long freeListPageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 40, freeListPageId);
    }

    public long getFreeListPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 40);
    }

    private int getPageEntrySize(long pageAddr, int dataOff, int show) {
        int payloadLen = PageUtils.getShort(pageAddr, dataOff) & 0xFFFF;
        if ((payloadLen & 0x8000) != 0) {
            payloadLen &= 0xFFFF7FFF;
        } else {
            show &= 0xFFFFFFFB;
        }
        return this.getPageEntrySize(payloadLen, show);
    }

    private int getPageEntrySize(int payloadLen, int show) {
        assert (payloadLen > 0) : payloadLen;
        int res = payloadLen;
        if ((show & 4) != 0) {
            res += 8;
        }
        if ((show & 1) != 0) {
            res += 2;
        }
        if ((show & 2) != 0) {
            res += 2;
        }
        return res;
    }

    private void setFirstEntryOffset(long pageAddr, int dataOff, int pageSize) {
        assert (dataOff >= 56 && dataOff <= pageSize) : dataOff;
        this.assertPageType(pageAddr);
        PageUtils.putShort(pageAddr, 52, (short)dataOff);
    }

    private int getFirstEntryOffset(long pageAddr) {
        return PageUtils.getShort(pageAddr, 52) & 0xFFFF;
    }

    private void setRealFreeSpace(long pageAddr, int freeSpace, int pageSize) {
        assert (freeSpace == this.actualFreeSpace(pageAddr, pageSize)) : freeSpace + " != " + this.actualFreeSpace(pageAddr, pageSize);
        this.assertPageType(pageAddr);
        PageUtils.putShort(pageAddr, 48, (short)freeSpace);
    }

    public int getFreeSpace(long pageAddr) {
        if (this.getFreeItemSlots(pageAddr) == 0) {
            return 0;
        }
        int freeSpace = this.getRealFreeSpace(pageAddr);
        return (freeSpace -= 12) < 0 ? 0 : freeSpace;
    }

    public boolean isEmpty(long pageAddr) {
        return this.getDirectCount(pageAddr) == 0;
    }

    public int getRealFreeSpace(long pageAddr) {
        return PageUtils.getShort(pageAddr, 48);
    }

    private void setDirectCount(long pageAddr, int cnt) {
        assert (this.checkCount(cnt)) : cnt;
        this.assertPageType(pageAddr);
        PageUtils.putByte(pageAddr, 50, (byte)cnt);
    }

    public int getDirectCount(long pageAddr) {
        return PageUtils.getByte(pageAddr, 50) & 0xFF;
    }

    public int getRowsCount(long pageAddr) {
        return this.getDirectCount(pageAddr);
    }

    public <U> List<U> forAllItems(long pageAddr, CC<U> c) throws IgniteCheckedException {
        this.assertPageType(pageAddr);
        long pageId = AbstractDataPageIO.getPageId(pageAddr);
        int cnt = this.getDirectCount(pageAddr);
        ArrayList<U> res = new ArrayList<U>(cnt);
        for (int i = 0; i < cnt; ++i) {
            long link = PageIdUtils.link(pageId, i);
            res.add(c.apply(link));
        }
        return res;
    }

    private void setIndirectCount(long pageAddr, int cnt) {
        assert (this.checkCount(cnt)) : cnt;
        PageUtils.putByte(pageAddr, 51, (byte)cnt);
    }

    protected boolean checkIndex(int idx) {
        return idx >= 0 && idx < 255;
    }

    private boolean checkCount(int cnt) {
        return cnt >= 0 && cnt <= 255;
    }

    private int getIndirectCount(long pageAddr) {
        return PageUtils.getByte(pageAddr, 51) & 0xFF;
    }

    private int getFreeItemSlots(long pageAddr) {
        return 255 - this.getDirectCount(pageAddr);
    }

    private int findIndirectItemIndex(long pageAddr, int itemId, int directCnt, int indirectCnt) {
        int low = directCnt;
        int high = directCnt + indirectCnt - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = Integer.compare(this.itemId(this.getItem(pageAddr, mid)), itemId);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        throw new IllegalStateException("Item not found: " + itemId);
    }

    private String printPageLayout(long pageAddr, int pageSize) {
        SB b = new SB();
        this.printPageLayout(pageAddr, pageSize, b);
        return b.toString();
    }

    protected void printPageLayout(long pageAddr, int pageSize, GridStringBuilder b) {
        int directCnt = this.getDirectCount(pageAddr);
        int indirectCnt = this.getIndirectCount(pageAddr);
        int free = this.getRealFreeSpace(pageAddr);
        boolean valid = directCnt >= indirectCnt;
        b.appendHex(PageIO.getPageId(pageAddr)).a(" [");
        int entriesSize = 0;
        for (int i = 0; i < directCnt; ++i) {
            short item;
            if (i != 0) {
                b.a(", ");
            }
            if ((item = this.getItem(pageAddr, i)) < 54 || item >= pageSize) {
                valid = false;
            }
            entriesSize += this.getPageEntrySize(pageAddr, item, 6);
            b.a(item);
        }
        b.a("][");
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i = directCnt; i < directCnt + indirectCnt; ++i) {
            if (i != directCnt) {
                b.a(", ");
            }
            short item = this.getItem(pageAddr, i);
            int itemId = this.itemId(item);
            int directIdx = this.directItemIndex(item);
            if (!set.add(directIdx) || !set.add(itemId)) {
                valid = false;
            }
            assert (this.indirectItem(itemId, directIdx) == item);
            if (itemId < directCnt || directIdx < 0 || directIdx >= directCnt) {
                valid = false;
            }
            if (i > directCnt && this.itemId(this.getItem(pageAddr, i - 1)) >= itemId) {
                valid = false;
            }
            b.a(itemId).a('^').a(directIdx);
        }
        b.a("][free=").a(free);
        int actualFree = pageSize - 54 - (entriesSize + (directCnt + indirectCnt) * 2);
        if (free != actualFree) {
            b.a(", actualFree=").a(actualFree);
            valid = false;
        } else {
            b.a("]");
        }
        assert (valid) : b.toString();
    }

    protected int getDataOffset(long pageAddr, int itemId, int pageSize) {
        assert (this.checkIndex(itemId)) : itemId;
        int directCnt = this.getDirectCount(pageAddr);
        assert (directCnt > 0) : "itemId=" + itemId + ", directCnt=" + directCnt + ", page=" + this.printPageLayout(pageAddr, pageSize);
        if (itemId >= directCnt) {
            int indirectCnt = this.getIndirectCount(pageAddr);
            assert (indirectCnt > 0) : "itemId=" + itemId + ", directCnt=" + directCnt + ", indirectCnt=" + indirectCnt + ", page=" + this.printPageLayout(pageAddr, pageSize);
            int indirectItemIdx = this.findIndirectItemIndex(pageAddr, itemId, directCnt, indirectCnt);
            assert (indirectItemIdx >= directCnt) : indirectItemIdx + " " + directCnt;
            assert (indirectItemIdx < directCnt + indirectCnt) : indirectItemIdx + " " + directCnt + " " + indirectCnt;
            itemId = this.directItemIndex(this.getItem(pageAddr, indirectItemIdx));
            assert (itemId >= 0 && itemId < directCnt) : itemId + " " + directCnt + " " + indirectCnt;
        }
        return this.directItemToOffset(this.getItem(pageAddr, itemId));
    }

    private long getNextFragmentLink(long pageAddr, int dataOff) {
        assert (this.isFragmented(pageAddr, dataOff));
        return PageUtils.getLong(pageAddr, dataOff + 2);
    }

    protected boolean isFragmented(long pageAddr, int dataOff) {
        return (PageUtils.getShort(pageAddr, dataOff) & 0x8000) != 0;
    }

    public DataPagePayload readPayload(long pageAddr, int itemId, int pageSize) {
        int dataOff = this.getDataOffset(pageAddr, itemId, pageSize);
        boolean fragmented = this.isFragmented(pageAddr, dataOff);
        long nextLink = fragmented ? this.getNextFragmentLink(pageAddr, dataOff) : 0L;
        int payloadSize = this.getPageEntrySize(pageAddr, dataOff, 0);
        return new DataPagePayload(dataOff + 2 + (fragmented ? 8 : 0), payloadSize, nextLink);
    }

    public int getPayloadOffset(long pageAddr, int itemId, int pageSize, int reqLen) {
        int dataOff = this.getDataOffset(pageAddr, itemId, pageSize);
        int payloadSize = this.getPageEntrySize(pageAddr, dataOff, 0);
        assert (payloadSize >= reqLen) : payloadSize;
        return dataOff + 2 + (this.isFragmented(pageAddr, dataOff) ? 8 : 0);
    }

    private short getItem(long pageAddr, int idx) {
        return PageUtils.getShort(pageAddr, this.itemOffset(idx));
    }

    private void setItem(long pageAddr, int idx, short item) {
        this.assertPageType(pageAddr);
        PageUtils.putShort(pageAddr, this.itemOffset(idx), item);
    }

    private int itemOffset(int idx) {
        assert (this.checkIndex(idx)) : idx;
        return 54 + idx * 2;
    }

    private int directItemToOffset(short directItem) {
        return directItem & 0xFFFF;
    }

    private short directItemFromOffset(int dataOff) {
        assert (dataOff >= 56 && dataOff < Short.MAX_VALUE) : dataOff;
        return (short)dataOff;
    }

    private int directItemIndex(short indirectItem) {
        return indirectItem & 0xFF;
    }

    private int itemId(short indirectItem) {
        return (indirectItem & 0xFFFF) >>> 8;
    }

    private short indirectItem(int itemId, int directItemIdx) {
        assert (this.checkIndex(itemId)) : itemId;
        assert (this.checkIndex(directItemIdx)) : directItemIdx;
        return (short)(itemId << 8 | directItemIdx);
    }

    private boolean moveLastItem(long pageAddr, int freeDirectIdx, int directCnt, int indirectCnt) {
        int lastIndirectId = this.findIndirectIndexForLastDirect(pageAddr, directCnt, indirectCnt);
        int lastItemId = directCnt - 1;
        assert (lastItemId != freeDirectIdx);
        short indirectItem = this.indirectItem(lastItemId, freeDirectIdx);
        assert (this.itemId(indirectItem) == lastItemId && this.directItemIndex(indirectItem) == freeDirectIdx);
        this.setItem(pageAddr, freeDirectIdx, this.getItem(pageAddr, lastItemId));
        this.setItem(pageAddr, lastItemId, indirectItem);
        assert (this.getItem(pageAddr, lastItemId) == indirectItem);
        if (lastIndirectId != -1) {
            this.setItem(pageAddr, lastIndirectId, this.indirectItem(this.itemId(this.getItem(pageAddr, lastIndirectId)), freeDirectIdx));
            return true;
        }
        return false;
    }

    private int findIndirectIndexForLastDirect(long pageAddr, int directCnt, int indirectCnt) {
        int lastDirectId = directCnt - 1;
        int end = directCnt + indirectCnt;
        for (int i = directCnt; i < end; ++i) {
            short item = this.getItem(pageAddr, i);
            if (this.directItemIndex(item) != lastDirectId) continue;
            return i;
        }
        return -1;
    }

    public boolean updateRow(long pageAddr, int itemId, int pageSize, @Nullable byte[] payload, @Nullable T row, int rowSize) throws IgniteCheckedException {
        assert (this.checkIndex(itemId)) : itemId;
        assert (row != null ^ payload != null);
        this.assertPageType(pageAddr);
        int dataOff = this.getDataOffset(pageAddr, itemId, pageSize);
        if (this.isFragmented(pageAddr, dataOff)) {
            return false;
        }
        if (row != null) {
            this.writeRowData(pageAddr, dataOff, rowSize, row, false);
        } else {
            this.writeRowData(pageAddr, dataOff, payload);
        }
        return true;
    }

    public long removeRow(long pageAddr, int itemId, int pageSize) throws IgniteCheckedException {
        int indirectCnt;
        assert (this.checkIndex(itemId)) : itemId;
        this.assertPageType(pageAddr);
        int dataOff = this.getDataOffset(pageAddr, itemId, pageSize);
        long nextLink = this.isFragmented(pageAddr, dataOff) ? this.getNextFragmentLink(pageAddr, dataOff) : 0L;
        int directCnt = this.getDirectCount(pageAddr);
        int curIndirectCnt = indirectCnt = this.getIndirectCount(pageAddr);
        assert (directCnt > 0) : directCnt;
        if (directCnt == 1) {
            assert (indirectCnt == 0 && itemId == 0 || indirectCnt == 1 && itemId == this.itemId(this.getItem(pageAddr, 1))) : itemId;
            this.setEmptyPage(pageAddr, pageSize);
        } else {
            int rmvEntrySize = this.getPageEntrySize(pageAddr, dataOff, 6);
            int indirectId = 0;
            if (itemId >= directCnt) {
                assert (indirectCnt > 0);
                indirectId = this.findIndirectItemIndex(pageAddr, itemId, directCnt, indirectCnt);
                assert (indirectId >= directCnt);
                itemId = this.directItemIndex(this.getItem(pageAddr, indirectId));
                assert (itemId < directCnt);
            }
            boolean dropLast = true;
            if (itemId + 1 < directCnt) {
                dropLast = this.moveLastItem(pageAddr, itemId, directCnt, indirectCnt);
            }
            if (indirectId == 0) {
                if (dropLast) {
                    this.moveItems(pageAddr, directCnt, indirectCnt, -1, pageSize);
                } else {
                    ++curIndirectCnt;
                }
            } else {
                if (dropLast) {
                    this.moveItems(pageAddr, directCnt, indirectId - directCnt, -1, pageSize);
                }
                this.moveItems(pageAddr, indirectId + 1, directCnt + indirectCnt - indirectId - 1, dropLast ? -2 : -1, pageSize);
                if (dropLast) {
                    --curIndirectCnt;
                }
            }
            this.setIndirectCount(pageAddr, curIndirectCnt);
            this.setDirectCount(pageAddr, directCnt - 1);
            assert (this.getIndirectCount(pageAddr) <= this.getDirectCount(pageAddr));
            this.setRealFreeSpace(pageAddr, this.getRealFreeSpace(pageAddr) + rmvEntrySize + 2 * (directCnt - this.getDirectCount(pageAddr) + indirectCnt - this.getIndirectCount(pageAddr)), pageSize);
        }
        return nextLink;
    }

    private void moveItems(long pageAddr, int idx, int cnt, int step, int pageSize) {
        assert (cnt >= 0) : cnt;
        if (cnt != 0) {
            this.moveBytes(pageAddr, this.itemOffset(idx), cnt * 2, step * 2, pageSize);
        }
    }

    private boolean isEnoughSpace(int newEntryFullSize, int firstEntryOff, int directCnt, int indirectCnt) {
        return 54 + 2 * (directCnt + indirectCnt) <= firstEntryOff - newEntryFullSize;
    }

    public void addRow(long pageId, long pageAddr, T row, int rowSize, int pageSize) throws IgniteCheckedException {
        assert (rowSize <= this.getFreeSpace(pageAddr)) : "can't call addRow if not enough space for the whole row";
        this.assertPageType(pageAddr);
        int fullEntrySize = this.getPageEntrySize(rowSize, 3);
        int directCnt = this.getDirectCount(pageAddr);
        int indirectCnt = this.getIndirectCount(pageAddr);
        int dataOff = this.getDataOffsetForWrite(pageAddr, fullEntrySize, directCnt, indirectCnt, pageSize);
        this.writeRowData(pageAddr, dataOff, rowSize, row, true);
        int itemId = this.addItem(pageAddr, fullEntrySize, directCnt, indirectCnt, dataOff, pageSize);
        this.setLinkByPageId(row, pageId, itemId);
    }

    public int addRow(long pageAddr, byte[] payload, int pageSize) throws IgniteCheckedException {
        assert (payload.length <= this.getFreeSpace(pageAddr)) : "can't call addRow if not enough space for the whole row";
        this.assertPageType(pageAddr);
        int fullEntrySize = this.getPageEntrySize(payload.length, 3);
        int directCnt = this.getDirectCount(pageAddr);
        int indirectCnt = this.getIndirectCount(pageAddr);
        int dataOff = this.getDataOffsetForWrite(pageAddr, fullEntrySize, directCnt, indirectCnt, pageSize);
        this.writeRowData(pageAddr, dataOff, payload);
        return this.addItem(pageAddr, fullEntrySize, directCnt, indirectCnt, dataOff, pageSize);
    }

    private int compactIfNeed(long pageAddr, int entryFullSize, int directCnt, int indirectCnt, int dataOff, int pageSize) {
        this.assertPageType(pageAddr);
        if (!this.isEnoughSpace(entryFullSize, dataOff, directCnt, indirectCnt)) {
            dataOff = this.compactDataEntries(pageAddr, directCnt, pageSize);
            assert (this.isEnoughSpace(entryFullSize, dataOff, directCnt, indirectCnt));
        }
        return dataOff;
    }

    private int addItem(long pageAddr, int fullEntrySize, int directCnt, int indirectCnt, int dataOff, int pageSize) {
        this.setFirstEntryOffset(pageAddr, dataOff, pageSize);
        int itemId = this.insertItem(pageAddr, dataOff, directCnt, indirectCnt, pageSize);
        assert (this.checkIndex(itemId)) : itemId;
        assert (this.getIndirectCount(pageAddr) <= this.getDirectCount(pageAddr));
        this.setRealFreeSpace(pageAddr, this.getRealFreeSpace(pageAddr) - fullEntrySize + (this.getIndirectCount(pageAddr) != indirectCnt ? 2 : 0), pageSize);
        return itemId;
    }

    private int getDataOffsetForWrite(long pageAddr, int fullEntrySize, int directCnt, int indirectCnt, int pageSize) {
        int dataOff = this.getFirstEntryOffset(pageAddr);
        dataOff = this.compactIfNeed(pageAddr, fullEntrySize, directCnt, indirectCnt, dataOff, pageSize);
        return dataOff -= fullEntrySize - 2;
    }

    public int addRowFragment(PageMemory pageMem, long pageId, long pageAddr, T row, int written, int rowSize, int pageSize) throws IgniteCheckedException {
        this.assertPageType(pageAddr);
        return this.addRowFragment(pageMem, pageId, pageAddr, written, rowSize, row.link(), row, null, pageSize);
    }

    public void addRowFragment(long pageId, long pageAddr, byte[] payload, long lastLink, int pageSize) throws IgniteCheckedException {
        this.assertPageType(pageAddr);
        this.addRowFragment(null, pageId, pageAddr, 0, 0, lastLink, null, payload, pageSize);
    }

    private int addRowFragment(PageMemory pageMem, long pageId, long pageAddr, int written, int rowSize, long lastLink, T row, byte[] payload, int pageSize) throws IgniteCheckedException {
        int payloadSize;
        assert (payload == null ^ row == null);
        int directCnt = this.getDirectCount(pageAddr);
        int indirectCnt = this.getIndirectCount(pageAddr);
        int n = payloadSize = payload != null ? payload.length : Math.min(rowSize - written, this.getFreeSpace(pageAddr));
        if (row != null) {
            int remain = rowSize - written - payloadSize;
            int hdrSize = row.headerSize();
            if (remain > 0 && remain < hdrSize) {
                payloadSize -= hdrSize - remain;
            }
        }
        int fullEntrySize = this.getPageEntrySize(payloadSize, 7);
        int dataOff = this.getDataOffsetForWrite(pageAddr, fullEntrySize, directCnt, indirectCnt, pageSize);
        if (payload == null) {
            ByteBuffer buf = pageMem.pageBuffer(pageAddr);
            buf.position(dataOff);
            short p = (short)(payloadSize | 0x8000);
            buf.putShort(p);
            buf.putLong(lastLink);
            int rowOff = rowSize - written - payloadSize;
            this.writeFragmentData(row, buf, rowOff, payloadSize);
        } else {
            PageUtils.putShort(pageAddr, dataOff, (short)(payloadSize | 0x8000));
            PageUtils.putLong(pageAddr, dataOff + 2, lastLink);
            PageUtils.putBytes(pageAddr, dataOff + 10, payload);
        }
        int itemId = this.addItem(pageAddr, fullEntrySize, directCnt, indirectCnt, dataOff, pageSize);
        if (row != null) {
            this.setLinkByPageId(row, pageId, itemId);
        }
        return payloadSize;
    }

    private void setLinkByPageId(T row, long pageId, int itemId) {
        row.link(PageIdUtils.link(pageId, itemId));
    }

    protected abstract void writeFragmentData(T var1, ByteBuffer var2, int var3, int var4) throws IgniteCheckedException;

    private int insertItem(long pageAddr, int dataOff, int directCnt, int indirectCnt, int pageSize) {
        short item;
        if (indirectCnt > 0 && this.itemId(item = this.getItem(pageAddr, directCnt)) == directCnt) {
            int directItemIdx = this.directItemIndex(item);
            this.setItem(pageAddr, directCnt, this.getItem(pageAddr, directItemIdx));
            this.setItem(pageAddr, directItemIdx, this.directItemFromOffset(dataOff));
            this.setDirectCount(pageAddr, directCnt + 1);
            this.setIndirectCount(pageAddr, indirectCnt - 1);
            return directItemIdx;
        }
        this.moveItems(pageAddr, directCnt, indirectCnt, 1, pageSize);
        this.setItem(pageAddr, directCnt, this.directItemFromOffset(dataOff));
        this.setDirectCount(pageAddr, directCnt + 1);
        assert (this.getDirectCount(pageAddr) == directCnt + 1);
        return directCnt;
    }

    @Override
    public void compactPage(ByteBuffer page, ByteBuffer out, int pageSize) {
        this.assertPageType(page);
        this.copyPage(page, out, pageSize);
        long pageAddr = GridUnsafe.bufferAddress(out);
        int freeSpace = this.getRealFreeSpace(pageAddr);
        if (freeSpace == 0) {
            return;
        }
        int directCnt = this.getDirectCount(pageAddr);
        if (directCnt != 0) {
            int firstOff = this.getFirstEntryOffset(pageAddr);
            if (firstOff - freeSpace != this.getHeaderSizeWithItems(pageAddr, directCnt)) {
                firstOff = this.compactDataEntries(pageAddr, directCnt, pageSize);
                this.setFirstEntryOffset(pageAddr, firstOff, pageSize);
            }
            this.moveBytes(pageAddr, firstOff, pageSize - firstOff, -freeSpace, pageSize);
        }
        out.limit(pageSize - freeSpace);
    }

    @Override
    public void restorePage(ByteBuffer page, int pageSize) {
        int firstOff;
        int cnt;
        assert (page.isDirect());
        assert (page.position() == 0);
        assert (page.limit() <= pageSize);
        this.assertPageType(page);
        long pageAddr = GridUnsafe.bufferAddress(page);
        int freeSpace = this.getRealFreeSpace(pageAddr);
        if (freeSpace != 0 && (cnt = pageSize - (firstOff = this.getFirstEntryOffset(pageAddr))) != 0) {
            int off = page.limit() - cnt;
            assert (off > 40) : off;
            assert (cnt > 0) : cnt;
            this.moveBytes(pageAddr, off, cnt, freeSpace, pageSize);
        }
        page.limit(pageSize);
    }

    private int compactDataEntries(long pageAddr, int directCnt, int pageSize) {
        assert (this.checkCount(directCnt)) : directCnt;
        int[] offs = new int[directCnt];
        for (int i = 0; i < directCnt; ++i) {
            int off = this.directItemToOffset(this.getItem(pageAddr, i));
            offs[i] = off << 8 | i;
        }
        Arrays.sort(offs);
        int prevOff = pageSize;
        int start = directCnt - 1;
        int curOff = offs[start] >>> 8;
        int curEntrySize = this.getPageEntrySize(pageAddr, curOff, 6);
        for (int i = start; i >= 0; --i) {
            assert (curOff < prevOff) : curOff;
            int delta = prevOff - (curOff + curEntrySize);
            int off = curOff;
            int entrySize = curEntrySize;
            if (delta != 0) {
                assert (delta > 0) : delta;
                int itemId = offs[i] & 0xFF;
                this.setItem(pageAddr, itemId, this.directItemFromOffset(curOff + delta));
                for (int j = i - 1; j >= 0; --j) {
                    int offNext = offs[j] >>> 8;
                    int nextSize = this.getPageEntrySize(pageAddr, offNext, 6);
                    if (offNext + nextSize == off) {
                        --i;
                        off = offNext;
                        entrySize += nextSize;
                    } else {
                        curOff = offNext;
                        curEntrySize = nextSize;
                        break;
                    }
                    itemId = offs[j] & 0xFF;
                    this.setItem(pageAddr, itemId, this.directItemFromOffset(offNext + delta));
                }
                this.moveBytes(pageAddr, off, entrySize, delta, pageSize);
                off += delta;
            } else if (i > 0) {
                curOff = offs[i - 1] >>> 8;
                curEntrySize = this.getPageEntrySize(pageAddr, curOff, 6);
            }
            prevOff = off;
        }
        return prevOff;
    }

    private int actualFreeSpace(long pageAddr, int pageSize) {
        int directCnt = this.getDirectCount(pageAddr);
        int entriesSize = 0;
        for (int i = 0; i < directCnt; ++i) {
            int off = this.directItemToOffset(this.getItem(pageAddr, i));
            int entrySize = this.getPageEntrySize(pageAddr, off, 6);
            entriesSize += entrySize;
        }
        return pageSize - entriesSize - this.getHeaderSizeWithItems(pageAddr, directCnt);
    }

    private int getHeaderSizeWithItems(long pageAddr, int directCnt) {
        return 54 + (directCnt + this.getIndirectCount(pageAddr)) * 2;
    }

    private void moveBytes(long addr, int off, int cnt, int step, int pageSize) {
        assert (cnt >= 0) : cnt;
        assert (step != 0) : step;
        assert (off + step >= 0);
        assert (off + step + cnt <= pageSize) : "[off=" + off + ", step=" + step + ", cnt=" + cnt + ", cap=" + pageSize + ']';
        PageHandler.copyMemory(addr, (long)off, addr, (long)(off + step), (long)cnt);
    }

    protected abstract void writeRowData(long var1, int var3, int var4, T var5, boolean var6) throws IgniteCheckedException;

    protected void writeRowData(long pageAddr, int dataOff, byte[] payload) {
        this.assertPageType(pageAddr);
        PageUtils.putShort(pageAddr, dataOff, (short)payload.length);
        PageUtils.putBytes(pageAddr, dataOff += 2, payload);
    }

    public static interface CC<T> {
        public T apply(long var1) throws IgniteCheckedException;
    }
}

