/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.mxbean.SnapshotMXBean;

public class SnapshotMXBeanImpl
implements SnapshotMXBean {
    private final IgniteSnapshotManager mgr;

    public SnapshotMXBeanImpl(GridKernalContext ctx) {
        this.mgr = ctx.cache().context().snapshotMgr();
    }

    @Override
    public void createSnapshot(String snpName) {
        IgniteFuture<Void> fut = this.mgr.createSnapshot(snpName);
        if (fut.isDone()) {
            fut.get();
        }
    }

    @Override
    public void cancelSnapshot(String snpName) {
        this.mgr.cancelSnapshot(snpName).get();
    }

    @Override
    public void restoreSnapshot(String name, String grpNames) {
        Set grpNamesSet = F.isEmpty(grpNames) ? null : Arrays.stream(grpNames.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        IgniteFuture<Void> fut = this.mgr.restoreSnapshot(name, grpNamesSet);
        if (fut.isDone()) {
            fut.get();
        }
    }

    @Override
    public void cancelSnapshotRestore(String name) {
        this.mgr.cancelSnapshotRestore(name).get();
    }
}

