/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

abstract class AbstractSnapshotMessage
implements Message {
    private String reqId;

    protected AbstractSnapshotMessage() {
    }

    protected AbstractSnapshotMessage(String reqId) {
        assert (U.alphanumericUnderscore(reqId)) : reqId;
        this.reqId = reqId;
    }

    public String requestId() {
        return this.reqId;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        if (writer.state() == 0) {
            if (!writer.writeString("reqId", this.reqId)) {
                return false;
            }
            writer.incrementState();
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (reader.state() == 0) {
            this.reqId = reader.readString("reqId");
            if (!reader.isLastRead()) {
                return false;
            }
            reader.incrementState();
        }
        return reader.afterMessageRead(AbstractSnapshotMessage.class);
    }

    @Override
    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(AbstractSnapshotMessage.class, this);
    }
}

