/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local.atomic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheInvokeEntry;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheLazyEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.CachePartialUpdateCheckedException;
import org.apache.ignite.internal.processors.cache.CacheStorePartialUpdateException;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCachePreloader;
import org.apache.ignite.internal.processors.cache.GridCachePreloaderAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.LockedEntriesInfo;
import org.apache.ignite.internal.processors.cache.local.GridLocalCache;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.resource.GridResourceIoc;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.C1;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CX1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridLocalAtomicCache<K, V>
extends GridLocalCache<K, V> {
    private static final long serialVersionUID = 0L;
    private GridCachePreloader preldr;
    private final LockedEntriesInfo lockedEntriesInfo = new LockedEntriesInfo();

    public GridLocalAtomicCache() {
    }

    public GridLocalAtomicCache(GridCacheContext<K, V> ctx) {
        super(ctx);
        this.preldr = new GridCachePreloaderAdapter(ctx.group());
    }

    @Override
    protected void checkJta() throws IgniteCheckedException {
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public GridCachePreloader preloader() {
        return this.preldr;
    }

    @Override
    protected V getAndPut0(K key, V val, @Nullable CacheEntryPredicate filter) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return (V)this.updateAllInternal(GridCacheOperation.UPDATE, Collections.singleton(key), Collections.singleton(val), null, this.expiryPerCall(), true, false, filter, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    protected boolean put0(K key, V val, CacheEntryPredicate filter) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        Boolean res = (Boolean)this.updateAllInternal(GridCacheOperation.UPDATE, Collections.singleton(key), Collections.singleton(val), null, this.expiryPerCall(), false, false, filter, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
        assert (res != null);
        return res;
    }

    @Override
    public IgniteInternalFuture<V> getAndPutAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.updateAllAsync0(F0.asMap(key, val), null, null, true, false, filter);
    }

    @Override
    public IgniteInternalFuture<Boolean> putAsync0(K key, V val, @Nullable CacheEntryPredicate filter) {
        return this.updateAllAsync0(F0.asMap(key, val), null, null, false, false, filter);
    }

    @Override
    protected void putAll0(Map<? extends K, ? extends V> m) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        this.updateAllInternal(GridCacheOperation.UPDATE, m.keySet(), m.values(), null, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public IgniteInternalFuture<?> putAllAsync0(Map<? extends K, ? extends V> m) {
        return this.updateAllAsync0(m, null, null, false, false, null).chain(RET2NULL);
    }

    @Override
    protected V getAndRemove0(K key) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        return (V)this.updateAllInternal(GridCacheOperation.DELETE, Collections.singleton(key), null, null, this.expiryPerCall(), true, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public IgniteInternalFuture<V> getAndRemoveAsync0(K key) {
        return this.removeAllAsync0(Collections.singletonList(key), true, false, null);
    }

    @Override
    public void removeAll0(Collection<? extends K> keys) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        this.updateAllInternal(GridCacheOperation.DELETE, keys, null, null, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
    }

    @Override
    public IgniteInternalFuture<Object> removeAllAsync0(Collection<? extends K> keys) {
        return this.removeAllAsync0(keys, false, false, null).chain(RET2NULL);
    }

    @Override
    public boolean remove0(K key, CacheEntryPredicate filter) throws IgniteCheckedException {
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        Boolean rmv = (Boolean)this.updateAllInternal(GridCacheOperation.DELETE, Collections.singleton(key), null, null, this.expiryPerCall(), false, false, filter, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
        assert (rmv != null);
        return rmv;
    }

    @Override
    public IgniteInternalFuture<Boolean> removeAsync0(K key, @Nullable CacheEntryPredicate filter) {
        return this.removeAllAsync0(Collections.singletonList(key), false, false, filter);
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        return this.ctx.closures().callLocalSafe(new GridPlainCallable<Void>(){

            @Override
            public Void call() throws Exception {
                GridLocalAtomicCache.this.removeAll();
                return null;
            }
        });
    }

    @Override
    protected V get(K key, String taskName, boolean deserializeBinary, boolean needVer) throws IgniteCheckedException {
        Map<K, V> m = this.getAllInternal(Collections.singleton(key), this.ctx.readThrough(), taskName, deserializeBinary, false, needVer);
        assert (m.isEmpty() || m.size() == 1) : m.size();
        return F.firstValue(m);
    }

    @Override
    public final Map<K, V> getAll(Collection<? extends K> keys, boolean deserializeBinary, boolean needVer, boolean recovery, ReadRepairStrategy readRepairStrategy) throws IgniteCheckedException {
        A.notNull(keys, "keys");
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        return this.getAllInternal(keys, this.ctx.readThrough(), taskName, deserializeBinary, false, needVer);
    }

    @Override
    public IgniteInternalFuture<Map<K, V>> getAllAsync(final @Nullable Collection<? extends K> keys, boolean forcePrimary, boolean skipTx, final String taskName, final boolean deserializeBinary, boolean recovery, ReadRepairStrategy readRepairStrategy, final boolean skipVals, final boolean needVer) {
        A.notNull(keys, "keys");
        final boolean storeEnabled = this.ctx.readThrough();
        return this.asyncOp(new GridPlainCallable<Map<K, V>>(){

            @Override
            public Map<K, V> call() throws Exception {
                return GridLocalAtomicCache.this.getAllInternal(keys, storeEnabled, taskName, deserializeBinary, skipVals, needVer);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> getAllInternal(@Nullable Collection<? extends K> keys, boolean storeEnabled, String taskName, boolean deserializeBinary, boolean skipVals, boolean needVer) throws IgniteCheckedException {
        this.ctx.checkSecurity(SecurityPermission.CACHE_READ);
        if (F.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        HashMap vals = U.newHashMap(keys.size());
        this.warnIfUnordered(keys, GridCacheAdapter.BulkOperation.GET);
        IgniteCacheExpiryPolicy expiry = this.expiryPolicy(opCtx != null ? opCtx.expiry() : null);
        boolean success = true;
        boolean readNoEntry = this.ctx.readNoEntry(expiry, false);
        boolean evt = !skipVals;
        this.ctx.shared().database().checkpointReadLock();
        try {
            for (K key : keys) {
                if (key == null) {
                    throw new NullPointerException("Null key.");
                }
                KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
                boolean skipEntry = readNoEntry;
                if (readNoEntry) {
                    CacheDataRow row = this.ctx.offheap().read(this.ctx, cacheKey);
                    if (row != null) {
                        long expireTime = row.expireTime();
                        if (expireTime == 0L || expireTime > U.currentTimeMillis()) {
                            this.ctx.addResult(vals, cacheKey, row.value(), skipVals, false, deserializeBinary, true, null, row.version(), 0L, 0L, needVer, null);
                            if (this.ctx.statisticsEnabled() && !skipVals) {
                                this.metrics0().onRead(true);
                            }
                            if (evt) {
                                this.ctx.events().readEvent(cacheKey, null, null, row.value(), taskName, !deserializeBinary);
                            }
                        } else {
                            skipEntry = false;
                        }
                    } else {
                        success = false;
                    }
                }
                if (!skipEntry) {
                    GridCacheEntryEx entry = null;
                    do {
                        try {
                            entry = this.entryEx(cacheKey);
                            if (entry == null) break;
                            if (needVer) {
                                EntryGetResult res = entry.innerGetVersioned(null, null, false, evt, null, taskName, expiry, !deserializeBinary, null);
                                if (res != null) {
                                    this.ctx.addResult(vals, cacheKey, res, skipVals, false, deserializeBinary, true, needVer);
                                    break;
                                }
                                success = false;
                                break;
                            }
                            CacheObject v = entry.innerGet(null, null, false, true, evt, null, taskName, expiry, !deserializeBinary);
                            if (v != null) {
                                this.ctx.addResult(vals, cacheKey, v, skipVals, false, deserializeBinary, true, null, 0L, 0L, null);
                                break;
                            }
                            success = false;
                            break;
                        }
                        catch (GridCacheEntryRemovedException gridCacheEntryRemovedException) {
                        }
                        finally {
                            if (entry != null) {
                                entry.touch();
                            }
                        }
                    } while (success || !storeEnabled);
                }
                if (success || storeEnabled || !this.ctx.statisticsEnabled() || skipVals) continue;
                this.metrics0().onRead(false);
            }
        }
        finally {
            this.ctx.shared().database().checkpointReadUnlock();
        }
        if (success || !storeEnabled) {
            return vals;
        }
        return this.getAllAsync(keys, null, opCtx == null || !opCtx.skipStore(), false, taskName, deserializeBinary, opCtx != null && opCtx.recovery(), null, false, expiry, skipVals, needVer).get();
    }

    @Override
    public <T> EntryProcessorResult<T> invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        return this.invokeAsync(key, entryProcessor, args).get();
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, Object ... args) throws IgniteCheckedException {
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        this.warnIfUnordered(keys, GridCacheAdapter.BulkOperation.INVOKE);
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor>(){

            @Override
            public EntryProcessor apply(K k) {
                return entryProcessor;
            }
        }, new IgnitePredicate[0]);
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        Map entryProcessorRes = (Map)this.updateAllInternal(GridCacheOperation.TRANSFORM, invokeMap.keySet(), invokeMap.values(), args, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), keepBinary);
        if (statsEnabled) {
            this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
        }
        return entryProcessorRes;
    }

    @Override
    public <T> IgniteInternalFuture<EntryProcessorResult<T>> invokeAsync(K key, EntryProcessor<K, V, T> entryProcessor, Object ... args) throws EntryProcessorException {
        A.notNull(key, "key", entryProcessor, "entryProcessor");
        final boolean statsEnabled = this.ctx.statisticsEnabled();
        final long start = statsEnabled ? System.nanoTime() : 0L;
        Map<K, EntryProcessor<K, V, T>> invokeMap = Collections.singletonMap(key, entryProcessor);
        IgniteInternalFuture fut = this.updateAllAsync0(null, invokeMap, args, false, false, null);
        return fut.chain(new CX1<IgniteInternalFuture<Map<K, EntryProcessorResult<T>>>, EntryProcessorResult<T>>(){

            @Override
            public EntryProcessorResult<T> applyx(IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> fut) throws IgniteCheckedException {
                Map resMap = fut.get();
                if (statsEnabled) {
                    GridLocalAtomicCache.this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
                }
                if (resMap != null) {
                    assert (resMap.isEmpty() || resMap.size() == 1) : resMap.size();
                    return resMap.isEmpty() ? new CacheInvokeResult() : resMap.values().iterator().next();
                }
                return new CacheInvokeResult();
            }
        });
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Set<? extends K> keys, final EntryProcessor<K, V, T> entryProcessor, Object ... args) {
        A.notNull(keys, "keys", entryProcessor, "entryProcessor");
        this.warnIfUnordered(keys, GridCacheAdapter.BulkOperation.INVOKE);
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        Map invokeMap = F.viewAsMap(keys, new C1<K, EntryProcessor>(){

            @Override
            public EntryProcessor apply(K k) {
                return entryProcessor;
            }
        }, new IgnitePredicate[0]);
        IgniteInternalFuture fut = this.updateAllAsync0(null, invokeMap, args, true, false, null);
        if (statsEnabled) {
            fut.listen(new GridCacheAdapter.InvokeAllTimeStatClosure(this.metrics0(), start));
        }
        return fut;
    }

    @Override
    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) throws IgniteCheckedException {
        A.notNull(map, "map");
        this.warnIfUnordered(map, GridCacheAdapter.BulkOperation.INVOKE);
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        Map entryProcessorResult = (Map)this.updateAllInternal(GridCacheOperation.TRANSFORM, map.keySet(), map.values(), args, this.expiryPerCall(), false, false, null, this.ctx.writeThrough(), this.ctx.readThrough(), opCtx != null && opCtx.isKeepBinary());
        if (statsEnabled) {
            this.metrics0().addInvokeTimeNanos(System.nanoTime() - start);
        }
        return entryProcessorResult;
    }

    @Override
    public <T> IgniteInternalFuture<Map<K, EntryProcessorResult<T>>> invokeAllAsync(Map<? extends K, ? extends EntryProcessor<K, V, T>> map, Object ... args) {
        A.notNull(map, "map");
        this.warnIfUnordered(map, GridCacheAdapter.BulkOperation.INVOKE);
        boolean statsEnabled = this.ctx.statisticsEnabled();
        long start = statsEnabled ? System.nanoTime() : 0L;
        IgniteInternalFuture fut = this.updateAllAsync0(null, map, args, true, false, null);
        if (statsEnabled) {
            fut.listen(new GridCacheAdapter.InvokeAllTimeStatClosure(this.metrics0(), start));
        }
        return fut;
    }

    private IgniteInternalFuture updateAllAsync0(@Nullable Map<? extends K, ? extends V> map, @Nullable Map<? extends K, ? extends EntryProcessor> invokeMap, final @Nullable Object[] invokeArgs, final boolean retval, final boolean rawRetval, final @Nullable CacheEntryPredicate filter) {
        Set<K> keys;
        GridCacheOperation op;
        GridCacheOperation gridCacheOperation = op = invokeMap != null ? GridCacheOperation.TRANSFORM : GridCacheOperation.UPDATE;
        Set<Object> set = map != null ? map.keySet() : (keys = invokeMap != null ? invokeMap.keySet() : null);
        final Collection<? extends V> vals = map != null ? map.values() : (invokeMap != null ? invokeMap.values() : null);
        final boolean writeThrough = this.ctx.writeThrough();
        final boolean readThrough = this.ctx.readThrough();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final ExpiryPolicy expiry = this.expiryPerCall();
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        return this.asyncOp(new GridPlainCallable<Object>(){

            @Override
            public Object call() throws Exception {
                return GridLocalAtomicCache.this.updateAllInternal(op, keys, vals, invokeArgs, expiry, retval, rawRetval, filter, writeThrough, readThrough, keepBinary);
            }
        });
    }

    private IgniteInternalFuture removeAllAsync0(final @Nullable Collection<? extends K> keys, final boolean retval, final boolean rawRetval, final @Nullable CacheEntryPredicate filter) {
        final boolean writeThrough = this.ctx.writeThrough();
        final boolean readThrough = this.ctx.readThrough();
        final ExpiryPolicy expiryPlc = this.expiryPerCall();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        final boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
        return this.asyncOp(new GridPlainCallable<Object>(){

            @Override
            public Object call() throws Exception {
                return GridLocalAtomicCache.this.updateAllInternal(GridCacheOperation.DELETE, keys, null, null, expiryPlc, retval, rawRetval, filter, writeThrough, readThrough, keepBinary);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object updateAllInternal(GridCacheOperation op, Collection<? extends K> keys, @Nullable Iterable<?> vals, @Nullable Object[] invokeArgs, @Nullable ExpiryPolicy expiryPlc, boolean retval, boolean rawRetval, CacheEntryPredicate filter, boolean writeThrough, boolean readThrough, boolean keepBinary) throws IgniteCheckedException {
        Object ret;
        if (op == GridCacheOperation.DELETE) {
            this.ctx.checkSecurity(SecurityPermission.CACHE_REMOVE);
        } else {
            this.ctx.checkSecurity(SecurityPermission.CACHE_PUT);
        }
        String taskName = this.ctx.kernalContext().job().currentTaskName();
        GridCacheVersion ver = this.nextVersion();
        CacheEntryPredicate[] filters = CU.filterArray(filter);
        IgniteBiTuple res = null;
        CachePartialUpdateCheckedException err = null;
        this.ctx.shared().database().checkpointReadLock();
        try {
            this.ctx.shared().database().ensureFreeSpace(this.ctx.dataRegion());
            if (writeThrough && keys.size() > 1) {
                Map<? extends K, EntryProcessorResult> map = this.updateWithBatch(op, keys, vals, invokeArgs, expiryPlc, ver, filters, keepBinary, taskName);
                return map;
            }
            Iterator<?> valsIter = vals != null ? vals.iterator() : null;
            boolean intercept = this.ctx.config().getInterceptor() != null;
            block11: for (K key : keys) {
                CacheObject val;
                if (key == null) {
                    throw new NullPointerException("Null key.");
                }
                CacheObject cacheObject = val = valsIter != null ? (CacheObject)valsIter.next() : null;
                if (val == null && op != GridCacheOperation.DELETE) {
                    throw new NullPointerException("Null value.");
                }
                KeyCacheObject cacheKey = this.ctx.toCacheKeyObject(key);
                if (op == GridCacheOperation.UPDATE) {
                    val = this.ctx.toCacheObject(val);
                    this.ctx.validateKeyAndValue(cacheKey, val);
                } else if (op == GridCacheOperation.TRANSFORM) {
                    this.ctx.kernalContext().resource().inject((Object)val, GridResourceIoc.AnnotationSet.ENTRY_PROCESSOR, this.ctx.name());
                }
                while (true) {
                    GridCacheEntryEx entry = null;
                    try {
                        entry = this.entryEx(cacheKey);
                        GridTuple3<Boolean, Object, EntryProcessorResult<Object>> t = entry.innerUpdateLocal(ver, val == null ? GridCacheOperation.DELETE : op, val, invokeArgs, writeThrough, readThrough, retval, keepBinary, expiryPlc, true, true, filters, intercept, taskName, false);
                        if (op == GridCacheOperation.TRANSFORM) {
                            Map<K, EntryProcessorResult<Object>> computedMap;
                            if (t.get3() == null) continue block11;
                            if (res == null) {
                                computedMap = U.newHashMap(keys.size());
                                res = new IgniteBiTuple(true, computedMap);
                            } else {
                                computedMap = (Map)res.get2();
                            }
                            computedMap.put(key, t.get3());
                            continue block11;
                        }
                        if (res != null) continue block11;
                        res = new T2<Boolean, Object>(t.get1(), t.get2());
                        continue block11;
                    }
                    catch (GridCacheEntryRemovedException ignored) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Got removed entry while updating (will retry): " + key);
                        }
                        entry = null;
                        continue;
                    }
                    catch (IgniteCheckedException e) {
                        if (err == null) {
                            err = GridLocalAtomicCache.partialUpdateException();
                        }
                        err.add(F.asList(key), e);
                        U.error(this.log, "Failed to update key : " + key, e);
                        continue block11;
                    }
                    finally {
                        if (entry == null) continue;
                        entry.touch();
                        continue;
                    }
                    break;
                }
            }
        }
        finally {
            this.ctx.shared().database().checkpointReadUnlock();
        }
        if (err != null) {
            throw err;
        }
        Object object = res == null ? null : (rawRetval ? new GridCacheReturn(this.ctx, true, keepBinary, U.deploymentClassLoader(this.ctx.kernalContext(), U.contextDeploymentClassLoaderId(this.ctx.kernalContext())), res.get2(), (Boolean)res.get1()) : (ret = retval || op == GridCacheOperation.TRANSFORM ? res.get2() : res.get1()));
        if (op == GridCacheOperation.TRANSFORM && ret == null) {
            ret = Collections.emptyMap();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, EntryProcessorResult> updateWithBatch(GridCacheOperation op, Collection<? extends K> keys, @Nullable Iterable<?> vals, @Nullable Object[] invokeArgs, @Nullable ExpiryPolicy expiryPlc, GridCacheVersion ver, @Nullable CacheEntryPredicate[] filter, boolean keepBinary, String taskName) throws IgniteCheckedException {
        List<GridCacheEntryEx> locked = this.lockEntries(keys);
        try {
            int size = locked.size();
            LinkedHashMap<KeyCacheObject, CacheObject> putMap = null;
            ArrayList<KeyCacheObject> rmvKeys = null;
            ArrayList<CacheObject> writeVals = null;
            HashMap invokeResMap = op == GridCacheOperation.TRANSFORM ? U.newHashMap(size) : null;
            ArrayList<GridCacheEntryEx> filtered = new ArrayList<GridCacheEntryEx>(size);
            CachePartialUpdateCheckedException err = null;
            Iterator<?> valsIter = vals != null ? vals.iterator() : null;
            boolean intercept = this.ctx.config().getInterceptor() != null;
            for (int i = 0; i < size; ++i) {
                Object val;
                GridCacheEntryEx entry = locked.get(i);
                Object v = val = valsIter != null ? (Object)valsIter.next() : null;
                if (val == null && op != GridCacheOperation.DELETE) {
                    throw new NullPointerException("Null value.");
                }
                try {
                    CacheObject old;
                    block45: {
                        try {
                            if (!this.ctx.isAllLocked(entry, filter)) {
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Entry did not pass the filter (will skip write) [entry=" + entry + ", filter=" + Arrays.toString(filter) + ']');
                            }
                            break block45;
                        }
                        catch (IgniteCheckedException e) {
                            if (err == null) {
                                err = GridLocalAtomicCache.partialUpdateException();
                            }
                            err.add(F.asList(entry.key()), e);
                        }
                        continue;
                    }
                    if (op == GridCacheOperation.TRANSFORM) {
                        CacheObject updated;
                        this.ctx.kernalContext().resource().inject(val, GridResourceIoc.AnnotationSet.ENTRY_PROCESSOR, this.ctx.name());
                        EntryProcessor entryProcessor = (EntryProcessor)val;
                        old = entry.innerGet(null, null, true, true, true, entryProcessor, taskName, null, keepBinary);
                        Object oldVal = null;
                        CacheInvokeEntry invokeEntry = new CacheInvokeEntry(entry.key(), old, entry.version(), keepBinary, entry);
                        Object updatedVal = null;
                        CacheInvokeResult invokeRes = null;
                        boolean validation = false;
                        IgniteThread.onEntryProcessorEntered(false);
                        try {
                            Object computed = entryProcessor.process(invokeEntry, invokeArgs);
                            updatedVal = this.ctx.unwrapTemporary(invokeEntry.getValue());
                            updated = this.ctx.toCacheObject(updatedVal);
                            if (computed != null) {
                                invokeRes = CacheInvokeResult.fromResult(this.ctx.unwrapTemporary(computed));
                            }
                            if (invokeEntry.modified() && updated != null) {
                                validation = true;
                                this.ctx.validateKeyAndValue(entry.key(), updated);
                            } else if (this.ctx.statisticsEnabled() && !invokeEntry.modified()) {
                                this.ctx.cache().metrics0().onReadOnlyInvoke(old != null);
                            }
                        }
                        catch (Exception e) {
                            invokeRes = CacheInvokeResult.fromError(e);
                            updated = old;
                            if (validation) {
                                invokeResMap.put(entry.key().value(this.ctx.cacheObjectContext(), false), invokeRes);
                                continue;
                            }
                        }
                        finally {
                            IgniteThread.onEntryProcessorLeft();
                        }
                        if (invokeRes != null) {
                            invokeResMap.put(entry.key().value(this.ctx.cacheObjectContext(), false), invokeRes);
                        }
                        if (updated == null) {
                            IgniteBiTuple<Boolean, Object> interceptorRes;
                            if (intercept && this.ctx.cancelRemove(interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry(this.ctx, entry.key(), invokeEntry.key(), old, oldVal, keepBinary)))) continue;
                            if (putMap != null) {
                                err = this.updatePartialBatch(filtered, ver, writeVals, putMap, null, expiryPlc, keepBinary, err, taskName, true);
                                putMap = null;
                                writeVals = null;
                                filtered = new ArrayList();
                            }
                            if (rmvKeys == null) {
                                rmvKeys = new ArrayList(size);
                            }
                            rmvKeys.add(entry.key());
                        } else {
                            if (intercept) {
                                Object interceptorVal = this.ctx.config().getInterceptor().onBeforePut(new CacheLazyEntry(this.ctx, entry.key(), invokeEntry.getKey(), old, oldVal, keepBinary), updatedVal);
                                if (interceptorVal == null) continue;
                                updated = this.ctx.toCacheObject(this.ctx.unwrapTemporary(interceptorVal));
                            }
                            if (rmvKeys != null) {
                                err = this.updatePartialBatch(filtered, ver, null, null, rmvKeys, expiryPlc, keepBinary, err, taskName, true);
                                rmvKeys = null;
                                filtered = new ArrayList();
                            }
                            if (putMap == null) {
                                putMap = new LinkedHashMap(size, 1.0f);
                                writeVals = new ArrayList(size);
                            }
                            putMap.put(entry.key(), updated);
                            writeVals.add(updated);
                        }
                    } else if (op == GridCacheOperation.UPDATE) {
                        CacheObject cacheVal = this.ctx.toCacheObject(val);
                        if (intercept) {
                            old = entry.innerGet(null, null, this.ctx.loadPreviousValue(), true, true, null, taskName, null, keepBinary);
                            Object interceptorVal = this.ctx.config().getInterceptor().onBeforePut(new CacheLazyEntry(this.ctx, entry.key(), old, keepBinary), (CacheObject)val);
                            if (interceptorVal == null) continue;
                            cacheVal = this.ctx.toCacheObject(this.ctx.unwrapTemporary(interceptorVal));
                        }
                        this.ctx.validateKeyAndValue(entry.key(), cacheVal);
                        if (putMap == null) {
                            putMap = new LinkedHashMap<KeyCacheObject, CacheObject>(size, 1.0f);
                            writeVals = new ArrayList<CacheObject>(size);
                        }
                        putMap.put(entry.key(), cacheVal);
                        writeVals.add(cacheVal);
                    } else {
                        assert (op == GridCacheOperation.DELETE);
                        if (intercept) {
                            CacheObject old2 = entry.innerGet(null, null, this.ctx.loadPreviousValue(), true, true, null, taskName, null, keepBinary);
                            IgniteBiTuple<Boolean, CacheObject> interceptorRes = this.ctx.config().getInterceptor().onBeforeRemove(new CacheLazyEntry(this.ctx, entry.key(), old2, keepBinary));
                            if (this.ctx.cancelRemove(interceptorRes)) continue;
                        }
                        if (rmvKeys == null) {
                            rmvKeys = new ArrayList<KeyCacheObject>(size);
                        }
                        rmvKeys.add(entry.key());
                    }
                    filtered.add(entry);
                    continue;
                }
                catch (IgniteCheckedException e) {
                    if (err == null) {
                        err = GridLocalAtomicCache.partialUpdateException();
                    }
                    err.add(F.asList(entry.key()), e);
                    continue;
                }
                catch (GridCacheEntryRemovedException ignore) {
                    assert (false) : "Entry cannot become obsolete while holding lock.";
                    continue;
                }
            }
            if (putMap != null || rmvKeys != null) {
                err = this.updatePartialBatch(filtered, ver, writeVals, putMap, rmvKeys, expiryPlc, keepBinary, err, taskName, op == GridCacheOperation.TRANSFORM);
            } else assert (filtered.isEmpty());
            if (err != null) {
                throw err;
            }
            HashMap hashMap = invokeResMap;
            return hashMap;
        }
        finally {
            this.unlockEntries(locked);
        }
    }

    @Nullable
    private CachePartialUpdateCheckedException updatePartialBatch(List<GridCacheEntryEx> entries, final GridCacheVersion ver, @Nullable List<CacheObject> writeVals, @Nullable Map<KeyCacheObject, CacheObject> putMap, @Nullable Collection<KeyCacheObject> rmvKeys, @Nullable ExpiryPolicy expiryPlc, boolean keepBinary, @Nullable CachePartialUpdateCheckedException err, String taskName, boolean transformed) {
        GridCacheOperation op;
        CacheStorePartialUpdateException storeErr;
        block18: {
            assert (putMap == null ^ rmvKeys == null);
            storeErr = null;
            try {
                if (putMap != null) {
                    try {
                        Map<KeyCacheObject, IgniteBiTuple<? extends CacheObject, GridCacheVersion>> view = F.viewReadOnly(putMap, new C1<CacheObject, IgniteBiTuple<? extends CacheObject, GridCacheVersion>>(){

                            @Override
                            public IgniteBiTuple<? extends CacheObject, GridCacheVersion> apply(CacheObject val) {
                                return F.t(val, ver);
                            }
                        }, new IgnitePredicate[0]);
                        this.ctx.store().putAll(null, view);
                    }
                    catch (CacheStorePartialUpdateException e) {
                        storeErr = e;
                    }
                    op = GridCacheOperation.UPDATE;
                    break block18;
                }
                try {
                    this.ctx.store().removeAll(null, rmvKeys);
                }
                catch (CacheStorePartialUpdateException e) {
                    storeErr = e;
                }
                op = GridCacheOperation.DELETE;
            }
            catch (IgniteCheckedException e) {
                if (err == null) {
                    err = GridLocalAtomicCache.partialUpdateException();
                }
                err.add(putMap != null ? putMap.keySet() : rmvKeys, e);
                return err;
            }
        }
        boolean intercept = this.ctx.config().getInterceptor() != null;
        for (int i = 0; i < entries.size(); ++i) {
            GridCacheEntryEx entry = entries.get(i);
            assert (entry.lockedByCurrentThread());
            if (entry.obsolete() || storeErr != null && storeErr.failedKeys().contains(entry.key().value(this.ctx.cacheObjectContext(), false))) continue;
            try {
                CacheObject writeVal;
                CacheObject cacheObject = writeVal = op == GridCacheOperation.UPDATE ? writeVals.get(i) : null;
                assert (writeVal != null || op == GridCacheOperation.DELETE) : "null write value found.";
                GridTuple3<Boolean, Object, EntryProcessorResult<Object>> t = entry.innerUpdateLocal(ver, op, writeVal, null, false, false, false, keepBinary, expiryPlc, true, true, null, false, taskName, transformed);
                if (!intercept) continue;
                if (op == GridCacheOperation.UPDATE) {
                    this.ctx.config().getInterceptor().onAfterPut(new CacheLazyEntry(this.ctx, entry.key(), writeVal, keepBinary));
                    continue;
                }
                this.ctx.config().getInterceptor().onAfterRemove(new CacheLazyEntry(this.ctx, entry.key(), t.get2(), keepBinary));
                continue;
            }
            catch (GridCacheEntryRemovedException ignore) {
                assert (false) : "Entry cannot become obsolete while holding lock.";
                continue;
            }
            catch (IgniteCheckedException e) {
                if (err == null) {
                    err = GridLocalAtomicCache.partialUpdateException();
                }
                err.add(Collections.singleton(entry.key()), e);
            }
        }
        return err;
    }

    private List<GridCacheEntryEx> lockEntries(Collection<? extends K> keys) {
        boolean nullKeys;
        GridCacheEntryEx[] locked;
        block5: {
            locked = new GridCacheEntryEx[keys.size()];
            nullKeys = false;
            do {
                int i = 0;
                for (K key : keys) {
                    if (key == null) {
                        nullKeys = true;
                        break;
                    }
                    GridCacheEntryEx entry = this.entryEx(this.ctx.toCacheKeyObject(key));
                    locked[i++] = entry;
                }
                if (nullKeys) break block5;
            } while (!this.lockedEntriesInfo.tryLockEntries(locked));
            return Arrays.asList(locked);
        }
        assert (nullKeys);
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        for (GridCacheEntryEx entry : locked) {
            if (entry == null) continue;
            entry.touch();
        }
        throw new NullPointerException("Null key.");
    }

    private void unlockEntries(Iterable<GridCacheEntryEx> locked) {
        for (GridCacheEntryEx entry : locked) {
            entry.unlockEntry();
        }
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        for (GridCacheEntryEx entry : locked) {
            entry.touch();
        }
    }

    private static CachePartialUpdateCheckedException partialUpdateException() {
        return new CachePartialUpdateCheckedException("Failed to update keys (retry update if possible).");
    }

    @Override
    public IgniteInternalFuture<Boolean> txLockAsync(Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx tx, boolean isRead, boolean retval, TransactionIsolation isolation, boolean invalidate, long createTtl, long accessTtl) {
        return new GridFinishedFuture<Boolean>(new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)"));
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(@Nullable Collection<? extends K> keys, long timeout) {
        return new GridFinishedFuture<Boolean>(new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)"));
    }

    @Override
    public void unlockAll(@Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        throw new UnsupportedOperationException("Locks are not supported for CacheAtomicityMode.ATOMIC mode (use CacheAtomicityMode.TRANSACTIONAL instead)");
    }

    @Nullable
    private ExpiryPolicy expiryPerCall() {
        ExpiryPolicy expiry;
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        ExpiryPolicy expiryPolicy = expiry = opCtx != null ? opCtx.expiry() : null;
        if (expiry == null) {
            expiry = this.ctx.expiry();
        }
        return expiry;
    }

    private IgniteInternalFuture asyncOp(Callable<?> op) {
        IgniteInternalFuture fail = this.asyncOpAcquire(false);
        if (fail != null) {
            return fail;
        }
        IgniteInternalFuture<?> f = this.ctx.closures().callLocalSafe(op);
        f.listen(new CI1<IgniteInternalFuture<?>>(){

            @Override
            public void apply(IgniteInternalFuture<?> f) {
                GridLocalAtomicCache.this.asyncOpRelease(false);
            }
        });
        return f;
    }

    @Override
    public void onDeferredDelete(GridCacheEntryEx entry, GridCacheVersion ver) {
        assert (false) : "Should not be called";
    }
}

