/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.ReadRepairStrategy;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.GridNearReadRepairAbstractFuture;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.distributed.near.consistency.IgniteIrreparableConsistencyViolationException;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionState;

public class GridNearReadRepairFuture
extends GridNearReadRepairAbstractFuture {
    public GridNearReadRepairFuture(AffinityTopologyVersion topVer, GridCacheContext ctx, Collection<KeyCacheObject> keys, ReadRepairStrategy strategy, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, IgniteInternalTx tx) {
        this(topVer, ctx, keys, strategy, readThrough, taskName, deserializeBinary, recovery, expiryPlc, tx, (GridNearReadRepairFuture)null);
    }

    private GridNearReadRepairFuture(AffinityTopologyVersion topVer, GridCacheContext ctx, Collection<KeyCacheObject> keys, ReadRepairStrategy strategy, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, IgniteInternalTx tx, GridNearReadRepairFuture remappedFut) {
        super(topVer, ctx, keys, strategy, readThrough, taskName, deserializeBinary, recovery, expiryPlc, tx, remappedFut);
        assert (ctx.transactional()) : "Atomic cache should not be recovered using this future";
    }

    @Override
    protected GridNearReadRepairAbstractFuture remapFuture(AffinityTopologyVersion topVer) {
        throw new UnsupportedOperationException("Method should never be called.");
    }

    @Override
    protected void reduce() {
        assert (this.strategy != null);
        try {
            this.check();
            this.onDone(Collections.emptyMap());
        }
        catch (IgniteConsistencyViolationException e) {
            try {
                Map<KeyCacheObject, EntryGetResult> fixedMap;
                if (this.strategy == ReadRepairStrategy.LWW) {
                    fixedMap = this.fixWithLww(e.keys());
                } else if (this.strategy == ReadRepairStrategy.PRIMARY) {
                    fixedMap = this.fixWithPrimary(e.keys());
                } else if (this.strategy == ReadRepairStrategy.RELATIVE_MAJORITY) {
                    fixedMap = this.fixWithMajority(e.keys());
                } else if (this.strategy == ReadRepairStrategy.REMOVE) {
                    fixedMap = this.fixWithRemove(e.keys());
                } else {
                    if (this.strategy == ReadRepairStrategy.CHECK_ONLY) {
                        throw new IgniteIrreparableConsistencyViolationException(null, this.ctx.unwrapBinariesIfNeeded(e.keys(), !this.deserializeBinary));
                    }
                    throw new UnsupportedOperationException("Unsupported strategy: " + (Object)((Object)this.strategy));
                }
                if (!fixedMap.isEmpty()) {
                    this.tx.finishFuture().listen(future -> {
                        TransactionState state = this.tx.state();
                        if (state == TransactionState.COMMITTED) {
                            this.recordConsistencyViolation(fixedMap.keySet(), fixedMap, this.strategy);
                        }
                    });
                }
                this.onDone(fixedMap);
            }
            catch (IgniteIrreparableConsistencyViolationException ie) {
                this.recordConsistencyViolation(e.keys(), null, this.strategy);
                this.onDone(ie);
            }
            catch (IgniteCheckedException ce) {
                this.onDone(ce);
            }
        }
        catch (IgniteCheckedException e) {
            this.onDone(e);
        }
    }

    public Map<KeyCacheObject, EntryGetResult> fixWithLww(Set<KeyCacheObject> inconsistentKeys) throws IgniteCheckedException {
        HashMap<KeyCacheObject, EntryGetResult> newestMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        HashMap<KeyCacheObject, EntryGetResult> fixedMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        HashSet<KeyCacheObject> irreparableSet = new HashSet<KeyCacheObject>();
        for (GridPartitionedGetFuture fut : this.futs.values()) {
            for (KeyCacheObject key : inconsistentKeys) {
                if (!fut.keys().contains(key)) continue;
                EntryGetResult candidateRes = (EntryGetResult)((Map)fut.result()).get(key);
                boolean hasNewest = newestMap.containsKey(key);
                if (!hasNewest) {
                    newestMap.put(key, candidateRes);
                    continue;
                }
                EntryGetResult newestRes = (EntryGetResult)newestMap.get(key);
                if (candidateRes != null) {
                    byte[] newestBytes;
                    if (newestRes == null) {
                        if (hasNewest) {
                            irreparableSet.add(key);
                            continue;
                        }
                        newestMap.put(key, candidateRes);
                        fixedMap.put(key, candidateRes);
                        continue;
                    }
                    int compareRes = candidateRes.version().compareTo(newestRes.version());
                    if (compareRes > 0) {
                        newestMap.put(key, candidateRes);
                        fixedMap.put(key, candidateRes);
                        continue;
                    }
                    if (compareRes < 0) {
                        fixedMap.put(key, newestRes);
                        continue;
                    }
                    if (compareRes != 0) continue;
                    CacheObject candidateVal = (CacheObject)candidateRes.value();
                    CacheObject newestVal = (CacheObject)newestRes.value();
                    byte[] candidateBytes = candidateVal.valueBytes(this.ctx.cacheObjectContext());
                    if (Arrays.equals(candidateBytes, newestBytes = newestVal.valueBytes(this.ctx.cacheObjectContext()))) continue;
                    irreparableSet.add(key);
                    continue;
                }
                if (newestRes == null) continue;
                irreparableSet.add(key);
            }
        }
        assert (!fixedMap.containsValue(null)) : "null should never be considered as a fix";
        if (!irreparableSet.isEmpty()) {
            this.throwIrreparable(inconsistentKeys, irreparableSet);
        }
        return fixedMap;
    }

    public Map<KeyCacheObject, EntryGetResult> fixWithPrimary(Collection<KeyCacheObject> inconsistentKeys) {
        HashMap<KeyCacheObject, EntryGetResult> fixedMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        for (GridPartitionedGetFuture fut : this.futs.values()) {
            for (KeyCacheObject key : inconsistentKeys) {
                if (!fut.keys().contains(key) || !((ClusterNode)this.primaries.get(key)).equals(fut.affNode())) continue;
                fixedMap.put(key, (EntryGetResult)((Map)fut.result()).get(key));
            }
        }
        return fixedMap;
    }

    public Map<KeyCacheObject, EntryGetResult> fixWithRemove(Collection<KeyCacheObject> inconsistentKeys) {
        HashMap<KeyCacheObject, EntryGetResult> fixedMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        for (KeyCacheObject key : inconsistentKeys) {
            fixedMap.put(key, null);
        }
        return fixedMap;
    }

    public Map<KeyCacheObject, EntryGetResult> fixWithMajority(Collection<KeyCacheObject> inconsistentKeys) throws IgniteCheckedException {
        HashSet<KeyCacheObject> irreparableSet = new HashSet<KeyCacheObject>(inconsistentKeys.size());
        HashMap<KeyCacheObject, EntryGetResult> fixedMap = new HashMap<KeyCacheObject, EntryGetResult>(inconsistentKeys.size());
        block0: for (KeyCacheObject key : inconsistentKeys) {
            HashMap<T2, T2> cntMap = new HashMap<T2, T2>();
            for (GridPartitionedGetFuture fut : this.futs.values()) {
                GridCacheVersion ver;
                GridNearReadRepairAbstractFuture.ByteArrayWrapper wrapped;
                if (!fut.keys().contains(key)) continue;
                EntryGetResult res = (EntryGetResult)((Map)fut.result()).get(key);
                if (res != null) {
                    CacheObject val = (CacheObject)res.value();
                    wrapped = new GridNearReadRepairAbstractFuture.ByteArrayWrapper(val.valueBytes(this.ctx.cacheObjectContext()));
                    ver = res.version();
                } else {
                    wrapped = new GridNearReadRepairAbstractFuture.ByteArrayWrapper(null);
                    ver = null;
                }
                T2<GridNearReadRepairAbstractFuture.ByteArrayWrapper, Object> keyVer = new T2<GridNearReadRepairAbstractFuture.ByteArrayWrapper, Object>(wrapped, ver);
                cntMap.putIfAbsent(keyVer, new T2<EntryGetResult, Integer>(res, 0));
                cntMap.compute(keyVer, (kv, ri) -> new T2(ri.getKey(), (Integer)ri.getValue() + 1));
            }
            int[] sorted = cntMap.values().stream().map(IgniteBiTuple::getValue).sorted(Comparator.reverseOrder()).mapToInt(v -> v).toArray();
            int max = sorted[0];
            assert (max > 0);
            if (sorted.length > 1 && sorted[1] == max) {
                irreparableSet.add(key);
                continue;
            }
            for (Map.Entry count : cntMap.entrySet()) {
                if (!((Integer)((T2)count.getValue()).getValue()).equals(max)) continue;
                fixedMap.put(key, (EntryGetResult)((T2)count.getValue()).getKey());
                continue block0;
            }
        }
        if (!irreparableSet.isEmpty()) {
            this.throwIrreparable(inconsistentKeys, irreparableSet);
        }
        return fixedMap;
    }

    private void throwIrreparable(Collection<KeyCacheObject> inconsistentKeys, Set<KeyCacheObject> irreparableSet) throws IgniteIrreparableConsistencyViolationException {
        HashSet<KeyCacheObject> repairableKeys = new HashSet<KeyCacheObject>(inconsistentKeys);
        repairableKeys.removeAll(irreparableSet);
        throw new IgniteIrreparableConsistencyViolationException(this.ctx.unwrapBinariesIfNeeded(repairableKeys, !this.deserializeBinary), this.ctx.unwrapBinariesIfNeeded(irreparableSet, !this.deserializeBinary));
    }
}

