/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheEntry;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridDhtAtomicUpdateRequest;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GridDhtAtomicUpdateFuture
extends GridDhtAtomicAbstractUpdateFuture {
    private int updateCntr;

    GridDhtAtomicUpdateFuture(GridCacheContext cctx, GridCacheVersion writeVer, GridNearAtomicAbstractUpdateRequest updateReq) {
        super(cctx, writeVer, updateReq);
        this.mappings = U.newHashMap(updateReq.size());
    }

    @Override
    protected boolean sendAllToDht() {
        return this.updateCntr == this.updateReq.size();
    }

    @Override
    protected void addDhtKey(KeyCacheObject key, List<ClusterNode> dhtNodes) {
        assert (this.updateCntr < this.updateReq.size());
        ++this.updateCntr;
    }

    @Override
    protected void addNearKey(KeyCacheObject key, GridDhtCacheEntry.ReaderId[] readers) {
    }

    @Override
    protected GridDhtAtomicAbstractUpdateRequest createRequest(UUID nodeId, long futId, GridCacheVersion writeVer, CacheWriteSynchronizationMode syncMode, @NotNull AffinityTopologyVersion topVer, long ttl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer) {
        return new GridDhtAtomicUpdateRequest(this.cctx.cacheId(), nodeId, futId, writeVer, syncMode, topVer, this.updateReq.taskNameHash(), null, this.cctx.deploymentEnabled(), this.updateReq.keepBinary(), this.updateReq.skipStore(), false);
    }

    @Override
    public String toString() {
        return S.toString(GridDhtAtomicUpdateFuture.class, this, "super", (Object)super.toString());
    }
}

