/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheExistsException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.GridCachePluginContext;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.managers.encryption.GridEncryptionManager;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.managers.systemview.walker.CacheGroupViewWalker;
import org.apache.ignite.internal.managers.systemview.walker.CacheViewWalker;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheClientReconnectDiscoveryData;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.processors.cache.CacheConfigurationSplitter;
import org.apache.ignite.internal.processors.cache.CacheData;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupData;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheJoinNodeDiscoveryData;
import org.apache.ignite.internal.processors.cache.CacheNodeCommonDiscoveryData;
import org.apache.ignite.internal.processors.cache.ClientCacheChangeDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.ClusterCachesReconnectResult;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeBatch;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeFailureMessage;
import org.apache.ignite.internal.processors.cache.DynamicCacheChangeRequest;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.GridCacheAttributes;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.LocalJoinCachesContext;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.distributed.dht.IgniteClusterReadOnlyException;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateFinishMessage;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.query.QuerySchema;
import org.apache.ignite.internal.processors.query.QuerySchemaPatch;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.CachePluginProvider;
import org.apache.ignite.plugin.PluginProvider;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.systemview.view.CacheGroupView;
import org.apache.ignite.spi.systemview.view.CacheView;
import org.jetbrains.annotations.Nullable;

public class ClusterCachesInfo {
    public static final String CACHES_VIEW = "caches";
    public static final String CACHES_VIEW_DESC = "Caches";
    public static final String CACHE_GRPS_VIEW = "cacheGroups";
    public static final String CACHE_GRPS_VIEW_DESC = "Cache groups";
    private static final IgniteUuid NULL_OBJECT = new IgniteUuid();
    private static final IgniteProductVersion V_MERGE_CONFIG_SINCE = IgniteProductVersion.fromString("2.5.0");
    private final GridKernalContext ctx;
    private final ConcurrentNavigableMap<AffinityTopologyVersion, Map<Integer, CacheGroupDescriptor>> markedForDeletionCacheGrps = new ConcurrentSkipListMap<AffinityTopologyVersion, Map<Integer, CacheGroupDescriptor>>();
    private final ConcurrentMap<String, DynamicCacheDescriptor> registeredCaches = new ConcurrentHashMap<String, DynamicCacheDescriptor>();
    private final ConcurrentMap<Integer, DynamicCacheDescriptor> registeredCachesById = new ConcurrentHashMap<Integer, DynamicCacheDescriptor>();
    private final ConcurrentMap<Integer, CacheGroupDescriptor> registeredCacheGrps = new ConcurrentHashMap<Integer, CacheGroupDescriptor>();
    private final ConcurrentMap<String, DynamicCacheDescriptor> registeredTemplates = new ConcurrentHashMap<String, DynamicCacheDescriptor>();
    private final ConcurrentHashMap<String, IgniteUuid> restartingCaches = new ConcurrentHashMap();
    private final IgniteLogger log;
    private CachesOnDisconnect cachesOnDisconnect;
    private CacheJoinNodeDiscoveryData joinDiscoData;
    private GridData gridData;
    private LocalJoinCachesContext locJoinCachesCtx;
    private Map<String, T2<CacheConfiguration, NearCacheConfiguration>> locCfgsForActivation = Collections.emptyMap();
    private Map<UUID, CacheClientReconnectDiscoveryData> clientReconnectReqs;
    private boolean joinOnTransition;
    private final AtomicBoolean alreadyFiltered = new AtomicBoolean();

    public ClusterCachesInfo(GridKernalContext ctx) {
        this.ctx = ctx;
        ctx.systemView().registerView(CACHES_VIEW, CACHES_VIEW_DESC, new CacheViewWalker(), this.registeredCaches.values(), desc -> new CacheView((DynamicCacheDescriptor)desc, ctx));
        ctx.systemView().registerView(CACHE_GRPS_VIEW, CACHE_GRPS_VIEW_DESC, new CacheGroupViewWalker(), this.registeredCacheGrps.values(), CacheGroupView::new);
        this.log = ctx.log(this.getClass());
    }

    public void filterDynamicCacheDescriptors(Set<String> localCachesOnStart) {
        if (this.ctx.isDaemon()) {
            return;
        }
        if (!this.alreadyFiltered.compareAndSet(false, true)) {
            return;
        }
        this.filterRegisteredCachesAndCacheGroups(localCachesOnStart);
        List<T2<DynamicCacheDescriptor, NearCacheConfiguration>> locJoinStartCaches = this.locJoinCachesCtx.caches();
        this.filterLocalJoinStartCaches(locJoinStartCaches);
        List<DynamicCacheDescriptor> initCaches = this.locJoinCachesCtx.initCaches();
        this.filterInitCaches(initCaches);
        this.locJoinCachesCtx = new LocalJoinCachesContext(locJoinStartCaches, initCaches, this.registeredCacheGrps, this.registeredCaches);
    }

    private void filterRegisteredCachesAndCacheGroups(Set<String> locCaches) {
        Iterator cachesIter = this.registeredCaches.entrySet().iterator();
        while (cachesIter.hasNext()) {
            Map.Entry e = cachesIter.next();
            if (locCaches.contains(e.getKey())) continue;
            cachesIter.remove();
            this.registeredCachesById.remove(e.getValue());
            this.ctx.discovery().removeCacheFilter((String)e.getKey());
        }
        Iterator grpsIter = this.registeredCacheGrps.entrySet().iterator();
        while (grpsIter.hasNext()) {
            Map.Entry e = grpsIter.next();
            boolean removeGrp = true;
            for (DynamicCacheDescriptor cacheDescr : this.registeredCaches.values()) {
                if (cacheDescr.groupId() != ((Integer)e.getKey()).intValue()) continue;
                removeGrp = false;
                break;
            }
            if (!removeGrp) continue;
            grpsIter.remove();
            this.ctx.discovery().removeCacheGroup((CacheGroupDescriptor)e.getValue());
        }
    }

    private void filterLocalJoinStartCaches(List<T2<DynamicCacheDescriptor, NearCacheConfiguration>> locJoinStartCaches) {
        locJoinStartCaches.removeIf(next -> !this.registeredCaches.containsKey(((DynamicCacheDescriptor)next.getKey()).cacheName()));
    }

    private void filterInitCaches(List<DynamicCacheDescriptor> initCaches) {
        initCaches.removeIf(desc -> !this.registeredCaches.containsKey(desc.cacheName()));
    }

    public void onStart(CacheJoinNodeDiscoveryData joinDiscoData) throws IgniteCheckedException {
        this.joinDiscoData = joinDiscoData;
        HashMap grpCfgs = new HashMap();
        for (CacheJoinNodeDiscoveryData.CacheInfo info : joinDiscoData.caches().values()) {
            if (info.cacheData().config().getGroupName() == null) continue;
            CacheConfiguration ccfg = (CacheConfiguration)((Object)grpCfgs.get(info.cacheData().config().getGroupName()));
            if (ccfg == null) {
                grpCfgs.put(info.cacheData().config().getGroupName(), info.cacheData().config());
                continue;
            }
            this.validateCacheGroupConfiguration(ccfg, info.cacheData().config());
        }
        String conflictErr = this.processJoiningNode(joinDiscoData, this.ctx.localNodeId(), true);
        if (conflictErr != null) {
            throw new IgniteCheckedException("Failed to start configured cache. " + conflictErr);
        }
    }

    public void onKernalStart(boolean checkConsistency) throws IgniteCheckedException {
        if (this.gridData != null && this.gridData.conflictErr != null) {
            throw new IgniteCheckedException(this.gridData.conflictErr);
        }
        if (this.gridData != null && this.gridData.joinDiscoData != null) {
            CacheJoinNodeDiscoveryData joinDiscoData = this.gridData.joinDiscoData;
            for (CacheJoinNodeDiscoveryData.CacheInfo locCacheInfo : joinDiscoData.caches().values()) {
                CacheConfiguration<?, ?> locCfg = locCacheInfo.cacheData().config();
                CacheData cacheData = this.gridData.gridData.caches().get(locCfg.getName());
                if (cacheData != null) {
                    if (!F.eq(cacheData.sql(), locCacheInfo.sql())) {
                        throw new IgniteCheckedException("Cache configuration mismatch (local cache was created via " + (locCacheInfo.sql() ? "CREATE TABLE" : "Ignite API") + ", while remote cache was created via " + (cacheData.sql() ? "CREATE TABLE" : "Ignite API") + "): " + locCacheInfo.cacheData().config().getName());
                    }
                    if (checkConsistency) {
                        this.checkCache(locCacheInfo, cacheData, cacheData.receivedFrom());
                        ClusterNode rmt = this.ctx.discovery().node(cacheData.receivedFrom());
                        if (rmt == null) {
                            for (ClusterNode node : this.ctx.discovery().localJoin().discoCache().serverNodes()) {
                                if (node.isLocal() || !this.ctx.discovery().cacheAffinityNode(node, locCfg.getName())) continue;
                                rmt = node;
                                break;
                            }
                        }
                        if (rmt != null) {
                            for (PluginProvider p : this.ctx.plugins().allProviders()) {
                                GridCachePluginContext pluginCtx;
                                CachePluginProvider provider = p.createCacheProvider(pluginCtx = new GridCachePluginContext(this.ctx, locCfg));
                                if (provider == null) continue;
                                provider.validateRemote(locCfg, cacheData.cacheConfiguration(), rmt);
                            }
                        }
                    }
                }
                if (!checkConsistency) continue;
                this.validateStartCacheConfiguration(locCfg);
            }
        }
        this.gridData = null;
    }

    private void checkCache(CacheJoinNodeDiscoveryData.CacheInfo locInfo, CacheData rmtData, UUID rmt) throws IgniteCheckedException {
        GridCacheAttributes rmtAttr = new GridCacheAttributes(rmtData.cacheConfiguration(), rmtData.cacheConfigurationEnrichment());
        GridCacheAttributes locAttr = new GridCacheAttributes(locInfo.cacheData().config(), locInfo.cacheData().cacheConfigurationEnrichment());
        CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "cacheMode", "Cache mode", (Object)locAttr.cacheMode(), (Object)rmtAttr.cacheMode(), true);
        CU.checkAttributeMismatch(this.log, rmtAttr.groupName(), rmt, "groupName", "Cache group name", locAttr.groupName(), rmtAttr.groupName(), true);
        if (rmtAttr.cacheMode() != CacheMode.LOCAL) {
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "interceptor", "Cache Interceptor", locAttr.interceptorClassName(), rmtAttr.interceptorClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "atomicityMode", "Cache atomicity mode", (Object)locAttr.atomicityMode(), (Object)rmtAttr.atomicityMode(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "cachePreloadMode", "Cache preload mode", (Object)locAttr.cacheRebalanceMode(), (Object)rmtAttr.cacheRebalanceMode(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "topologyValidator", "Cache topology validator", locAttr.topologyValidatorClassName(), rmtAttr.topologyValidatorClassName(), true);
            ClusterNode rmtNode = this.ctx.discovery().node(rmt);
            if (CU.affinityNode(this.ctx.discovery().localNode(), locInfo.cacheData().config().getNodeFilter()) && rmtNode != null && CU.affinityNode(rmtNode, rmtData.cacheConfiguration().getNodeFilter())) {
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "storeFactory", "Store factory", locAttr.storeFactoryClassName(), rmtAttr.storeFactoryClassName(), true);
            }
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "cacheAffinity", "Cache affinity", locAttr.cacheAffinityClassName(), rmtAttr.cacheAffinityClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "cacheAffinityMapper", "Cache affinity mapper", locAttr.cacheAffinityMapperClassName(), rmtAttr.cacheAffinityMapperClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "affinityPartitionsCount", "Affinity partitions count", locAttr.affinityPartitionsCount(), rmtAttr.affinityPartitionsCount(), true);
            CU.validateKeyConfigiration(rmtAttr.groupName(), rmtAttr.cacheName(), rmt, rmtAttr.configuration().getKeyConfiguration(), locAttr.configuration().getKeyConfiguration(), this.log, true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "evictionFilter", "Eviction filter", locAttr.evictionFilterClassName(), rmtAttr.evictionFilterClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "evictionPolicy", "Eviction policy", locAttr.evictionPolicyClassName(), rmtAttr.evictionPolicyClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "evictionPolicyFactory", "Eviction policy factory", locAttr.evictionPolicyFactoryClassName(), rmtAttr.evictionPolicyFactoryClassName(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "transactionManagerLookup", "Transaction manager lookup", locAttr.transactionManagerLookupClassName(), rmtAttr.transactionManagerLookupClassName(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "defaultLockTimeout", "Default lock timeout", locAttr.defaultLockTimeout(), rmtAttr.defaultLockTimeout(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "preloadBatchSize", "Preload batch size", locAttr.rebalanceBatchSize(), rmtAttr.rebalanceBatchSize(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "rebalanceDelay", "Rebalance delay", locAttr.rebalanceDelay(), rmtAttr.rebalanceDelay(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "rebalanceBatchesPrefetchCount", "Rebalance batches prefetch count", locAttr.rebalanceBatchesPrefetchCount(), rmtAttr.rebalanceBatchesPrefetchCount(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "rebalanceOrder", "Rebalance order", locAttr.rebalanceOrder(), rmtAttr.rebalanceOrder(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "rebalanceThrottle", "Rebalance throttle", locAttr.rebalanceThrottle(), rmtAttr.rebalanceThrottle(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "rebalanceTimeout", "Rebalance timeout", locAttr.rebalanceTimeout(), rmtAttr.rebalanceTimeout(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeSynchronizationMode", "Write synchronization mode", (Object)locAttr.writeSynchronization(), (Object)rmtAttr.writeSynchronization(), true);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindBatchSize", "Write behind batch size", locAttr.writeBehindBatchSize(), rmtAttr.writeBehindBatchSize(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindCoalescing", "Write behind coalescing", locAttr.writeBehindCoalescing(), rmtAttr.writeBehindCoalescing(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindEnabled", "Write behind enabled", locAttr.writeBehindEnabled(), rmtAttr.writeBehindEnabled(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindFlushFrequency", "Write behind flush frequency", locAttr.writeBehindFlushFrequency(), rmtAttr.writeBehindFlushFrequency(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindFlushSize", "Write behind flush size", locAttr.writeBehindFlushSize(), rmtAttr.writeBehindFlushSize(), false);
            CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "writeBehindFlushThreadCount", "Write behind flush thread count", locAttr.writeBehindFlushThreadCount(), rmtAttr.writeBehindFlushThreadCount(), false);
            if (locAttr.cacheMode() == CacheMode.PARTITIONED) {
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "nearEvictionPolicy", "Near eviction policy", locAttr.nearEvictionPolicyClassName(), rmtAttr.nearEvictionPolicyClassName(), false);
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "nearEvictionPolicyFactory", "Near eviction policy factory", locAttr.nearEvictionPolicyFactoryClassName(), rmtAttr.nearEvictionPolicyFactoryClassName(), false);
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "affinityIncludeNeighbors", "Affinity include neighbors", locAttr.affinityIncludeNeighbors(), rmtAttr.affinityIncludeNeighbors(), true);
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "affinityKeyBackups", "Affinity key backups", locAttr.affinityKeyBackups(), rmtAttr.affinityKeyBackups(), true);
                CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "qryParallelism", "Query parallelism", locAttr.qryParallelism(), rmtAttr.qryParallelism(), true);
            }
        }
        CU.checkAttributeMismatch(this.log, rmtAttr.cacheName(), rmt, "isEncryptionEnabled", "Cache encrypted", locAttr.isEncryptionEnabled(), rmtAttr.isEncryptionEnabled(), true);
    }

    public void onClientCacheChange(ClientCacheChangeDiscoveryMessage msg, ClusterNode node) {
        Set<Integer> closedCaches;
        Map<Integer, Boolean> startedCaches = msg.startedCaches();
        if (startedCaches != null) {
            block0: for (Map.Entry<Integer, Boolean> e : startedCaches.entrySet()) {
                for (DynamicCacheDescriptor desc : this.registeredCaches.values()) {
                    if (!e.getKey().equals(desc.cacheId())) continue;
                    this.ctx.discovery().addClientNode(desc.cacheName(), node.id(), e.getValue());
                    continue block0;
                }
            }
        }
        if ((closedCaches = msg.closedCaches()) != null) {
            block2: for (Integer cacheId : closedCaches) {
                for (DynamicCacheDescriptor desc : this.registeredCaches.values()) {
                    if (!cacheId.equals(desc.cacheId())) continue;
                    this.ctx.discovery().onClientCacheClose(desc.cacheName(), node.id());
                    continue block2;
                }
            }
        }
    }

    public void onCacheChangeRequested(DynamicCacheChangeFailureMessage failMsg, AffinityTopologyVersion topVer) {
        ExchangeActions exchangeActions = new ExchangeActions();
        ArrayList<DynamicCacheChangeRequest> requests = new ArrayList<DynamicCacheChangeRequest>(failMsg.cacheNames().size());
        for (String cacheName : failMsg.cacheNames()) {
            DynamicCacheDescriptor cacheDescr = (DynamicCacheDescriptor)this.registeredCaches.get(cacheName);
            assert (cacheDescr != null) : "Dynamic cache descriptor is missing [cacheName=" + cacheName + "]";
            requests.add(DynamicCacheChangeRequest.stopRequest(this.ctx, cacheName, cacheDescr.sql(), true));
        }
        this.processCacheChangeRequests(exchangeActions, requests, topVer, false);
        failMsg.exchangeActions(exchangeActions);
    }

    public boolean onCacheChangeRequested(DynamicCacheChangeBatch batch, AffinityTopologyVersion topVer) {
        DiscoveryDataClusterState state = this.ctx.state().clusterState();
        if (state.active() && !state.transition()) {
            HashSet<IgniteUuid> restartIds = new HashSet<IgniteUuid>(F.viewReadOnly(batch.requests(), DynamicCacheChangeRequest::restartId, req -> req.start() && req.restartId() != null));
            assert (restartIds.size() <= 1) : batch.requests();
            Set<UUID> nodes = this.ctx.cache().context().snapshotMgr().cacheStartRequiredAliveNodes(F.first(restartIds));
            for (UUID nodeId : nodes) {
                ClusterNode node = this.ctx.discovery().node(nodeId);
                if (node != null && CU.baselineNode(node, state) && this.ctx.discovery().alive(node)) continue;
                ClusterTopologyCheckedException err = new ClusterTopologyCheckedException("Required node has left the cluster [nodeId=" + nodeId + ']');
                for (DynamicCacheChangeRequest req2 : batch.requests()) {
                    this.ctx.cache().completeCacheStartFuture(req2, false, err);
                }
                return false;
            }
            ExchangeActions exchangeActions = new ExchangeActions();
            CacheChangeProcessResult res = this.processCacheChangeRequests(exchangeActions, batch.requests(), topVer, false);
            if (res.needExchange) {
                assert (!exchangeActions.empty()) : exchangeActions;
                batch.exchangeActions(exchangeActions);
                if (!nodes.isEmpty()) {
                    exchangeActions.cacheStartRequiredAliveNodes(nodes);
                }
            }
            return res.needExchange;
        }
        IgniteCheckedException err = new IgniteCheckedException("Failed to start/stop cache, cluster state change is in progress.");
        for (DynamicCacheChangeRequest req3 : batch.requests()) {
            if (req3.template()) {
                this.ctx.cache().completeTemplateAddFuture(req3.startCacheConfiguration().getName(), req3.deploymentId());
                continue;
            }
            this.ctx.cache().completeCacheStartFuture(req3, false, err);
        }
        return false;
    }

    private CacheChangeProcessResult processCacheChangeRequests(ExchangeActions exchangeActions, Collection<DynamicCacheChangeRequest> reqs, AffinityTopologyVersion topVer, boolean persistedCfgs) {
        CacheChangeProcessResult res = new CacheChangeProcessResult();
        final ArrayList<T2<DynamicCacheChangeRequest, AffinityTopologyVersion>> reqsToComplete = new ArrayList<T2<DynamicCacheChangeRequest, AffinityTopologyVersion>>();
        for (DynamicCacheChangeRequest req : reqs) {
            this.processCacheChangeRequest0(req, exchangeActions, topVer, persistedCfgs, res, reqsToComplete);
        }
        if (!F.isEmpty(res.addedDescs)) {
            AffinityTopologyVersion startTopVer = res.needExchange ? topVer.nextMinorVersion() : topVer;
            for (DynamicCacheDescriptor desc : res.addedDescs) {
                assert (desc.template() || res.needExchange);
                desc.startTopologyVersion(startTopVer);
            }
        }
        if (!F.isEmpty(reqsToComplete)) {
            this.ctx.closure().callLocalSafe(new GridPlainCallable<Void>(){

                @Override
                public Void call() {
                    for (T2 t : reqsToComplete) {
                        IgniteInternalFuture<AffinityTopologyVersion> fut;
                        final DynamicCacheChangeRequest req = (DynamicCacheChangeRequest)t.get1();
                        AffinityTopologyVersion waitTopVer = (AffinityTopologyVersion)t.get2();
                        IgniteInternalFuture<AffinityTopologyVersion> igniteInternalFuture = fut = waitTopVer != null ? ClusterCachesInfo.this.ctx.cache().context().exchange().affinityReadyFuture(waitTopVer) : null;
                        if (fut == null || fut.isDone()) {
                            ClusterCachesInfo.this.ctx.cache().completeCacheStartFuture(req, false, null);
                            continue;
                        }
                        fut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

                            @Override
                            public void apply(IgniteInternalFuture<?> fut) {
                                ClusterCachesInfo.this.ctx.cache().completeCacheStartFuture(req, false, null);
                            }
                        });
                    }
                    return null;
                }
            });
        }
        return res;
    }

    private void processCacheChangeRequest0(DynamicCacheChangeRequest req, ExchangeActions exchangeActions, AffinityTopologyVersion topVer, boolean persistedCfgs, CacheChangeProcessResult res, List<T2<DynamicCacheChangeRequest, AffinityTopologyVersion>> reqsToComplete) {
        String cacheName = req.cacheName();
        if (req.template()) {
            this.processTemplateAddRequest(persistedCfgs, res, req);
            return;
        }
        assert (!req.clientStartOnly()) : req;
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(cacheName);
        boolean needExchange = false;
        boolean clientCacheStart = false;
        AffinityTopologyVersion waitTopVer = null;
        if (req.start()) {
            boolean proceedFuther = true;
            if (this.restartingCaches.containsKey(cacheName) && (req.restartId() == null && this.restartingCaches.get(cacheName) != NULL_OBJECT || req.restartId() != null && !req.restartId().equals(this.restartingCaches.get(cacheName)))) {
                if (req.failIfExists()) {
                    this.ctx.cache().completeCacheStartFuture(req, false, (Throwable)((Object)new CacheExistsException("Failed to start cache (a cache is restarting): " + cacheName)));
                }
                proceedFuther = false;
            }
            if (proceedFuther) {
                if (desc == null) {
                    if (!this.processStartNewCacheRequest(exchangeActions, topVer, persistedCfgs, res, req, cacheName)) {
                        return;
                    }
                    needExchange = true;
                } else {
                    clientCacheStart = this.processStartAlreadyStartedCacheRequest(topVer, persistedCfgs, req, cacheName, desc);
                    if (!clientCacheStart) {
                        if (desc.clientCacheStartVersion() != null) {
                            waitTopVer = desc.clientCacheStartVersion();
                        } else {
                            AffinityTopologyVersion nodeStartVer = new AffinityTopologyVersion(this.ctx.discovery().localNode().order(), 0);
                            waitTopVer = desc.startTopologyVersion() != null ? desc.startTopologyVersion() : desc.receivedFromStartVersion();
                            if (waitTopVer == null || nodeStartVer.compareTo(waitTopVer) > 0) {
                                waitTopVer = nodeStartVer;
                            }
                        }
                    }
                }
            }
        } else if (req.resetLostPartitions()) {
            if (desc != null) {
                needExchange = true;
                exchangeActions.addCacheToResetLostPartitions(req, desc);
            }
        } else if (req.stop()) {
            if (desc != null) {
                if (req.sql() && !desc.sql()) {
                    this.ctx.cache().completeCacheStartFuture(req, false, new IgniteCheckedException("Only cache created with CREATE TABLE may be removed with DROP TABLE [cacheName=" + cacheName + ']'));
                    return;
                }
                if (!this.processStopCacheRequest(exchangeActions, req, res, cacheName, desc, topVer.nextMinorVersion())) {
                    return;
                }
                needExchange = true;
            }
        } else assert (false) : req;
        if (!needExchange) {
            if (!clientCacheStart && this.ctx.localNodeId().equals(req.initiatingNodeId())) {
                reqsToComplete.add(new T2<DynamicCacheChangeRequest, Object>(req, waitTopVer));
            }
        } else {
            res.needExchange = true;
        }
    }

    private boolean processStopCacheRequest(ExchangeActions exchangeActions, DynamicCacheChangeRequest req, CacheChangeProcessResult res, String cacheName, DynamicCacheDescriptor desc, AffinityTopologyVersion topVer) {
        if (this.ctx.cache().context().snapshotMgr().isSnapshotCreating()) {
            IgniteCheckedException err = new IgniteCheckedException("Operation rejected due to the snapshot operation in progress.");
            U.warn(this.log, err);
            res.errs.add(err);
            this.ctx.cache().completeCacheStartFuture(req, false, err);
            return false;
        }
        DynamicCacheDescriptor old = (DynamicCacheDescriptor)this.registeredCaches.remove(cacheName);
        assert (old != null && old == desc) : "Dynamic cache map was concurrently modified [req=" + req + ']';
        this.registeredCachesById.remove(old.cacheId());
        if (req.restart()) {
            IgniteUuid restartId = req.restartId();
            this.restartingCaches.put(cacheName, restartId == null ? NULL_OBJECT : restartId);
        }
        this.ctx.discovery().removeCacheFilter(cacheName);
        exchangeActions.addCacheToStop(req, desc);
        CacheGroupDescriptor grpDesc = (CacheGroupDescriptor)this.registeredCacheGrps.get(desc.groupId());
        assert (grpDesc != null && grpDesc.groupId() == desc.groupId()) : desc;
        grpDesc.onCacheStopped(desc.cacheName(), desc.cacheId());
        if (!grpDesc.hasCaches()) {
            this.markedForDeletionCacheGrps.computeIfAbsent(topVer, map -> new ConcurrentHashMap()).put(grpDesc.groupId(), grpDesc);
            this.registeredCacheGrps.remove(grpDesc.groupId());
            this.ctx.discovery().removeCacheGroup(grpDesc);
            exchangeActions.addCacheGroupToStop(grpDesc, req.destroy());
            assert (exchangeActions.checkStopRequestConsistency(grpDesc.groupId()));
            if (req.destroy()) {
                for (ExchangeActions.CacheActionData action : exchangeActions.cacheStopRequests()) {
                    if (action.descriptor().groupId() != grpDesc.groupId()) continue;
                    action.request().destroy(false);
                }
            }
        }
        return true;
    }

    private void processTemplateAddRequest(boolean persistedCfgs, CacheChangeProcessResult res, DynamicCacheChangeRequest req) {
        CacheConfiguration ccfg = req.startCacheConfiguration();
        assert (ccfg != null) : req;
        DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredTemplates.get(req.cacheName());
        if (desc == null) {
            DynamicCacheDescriptor templateDesc = new DynamicCacheDescriptor(this.ctx, ccfg, req.cacheType(), null, true, req.initiatingNodeId(), false, false, req.deploymentId(), req.schema(), req.cacheConfigurationEnrichment());
            DynamicCacheDescriptor old = this.registeredTemplates().put(ccfg.getName(), templateDesc);
            assert (old == null);
            res.addedDescs.add(templateDesc);
        }
        if (!persistedCfgs) {
            this.ctx.cache().completeTemplateAddFuture(ccfg.getName(), req.deploymentId());
        }
    }

    private boolean processStartAlreadyStartedCacheRequest(AffinityTopologyVersion topVer, boolean persistedCfgs, DynamicCacheChangeRequest req, String cacheName, DynamicCacheDescriptor desc) {
        assert (!persistedCfgs);
        assert (req.initiatingNodeId() != null) : req;
        if (req.failIfExists()) {
            this.ctx.cache().completeCacheStartFuture(req, false, (Throwable)((Object)new CacheExistsException("Failed to start cache (a cache with the same name is already started): " + cacheName)));
        } else {
            boolean clientReq;
            ClusterNode node = this.ctx.discovery().node(req.initiatingNodeId());
            boolean bl = clientReq = node != null && !this.ctx.discovery().cacheAffinityNode(node, cacheName);
            if (clientReq) {
                this.ctx.discovery().addClientNode(cacheName, req.initiatingNodeId(), req.nearCacheConfiguration() != null);
                if (node.id().equals(req.initiatingNodeId())) {
                    desc.clientCacheStartVersion(topVer);
                    this.ctx.discovery().clientCacheStartEvent(req.requestId(), F.asMap(cacheName, req), null);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean processStartNewCacheRequest(ExchangeActions exchangeActions, AffinityTopologyVersion topVer, boolean persistedCfgs, CacheChangeProcessResult res, DynamicCacheChangeRequest req, String cacheName) {
        IgniteSnapshotManager snapshotMgr;
        String conflictErr;
        assert (exchangeActions != null);
        CacheConfiguration ccfg = req.startCacheConfiguration();
        IgniteCheckedException err = null;
        if (this.ctx.cache().context().readOnlyMode()) {
            err = new IgniteClusterReadOnlyException(String.format("Failed to perform %s operation (cluster is in read-only mode) [cacheGrp=%s, cache=%s]", "start cache", ccfg.getGroupName(), cacheName));
        }
        if (err == null && (conflictErr = this.checkCacheConflict(req.startCacheConfiguration())) != null) {
            U.warn(this.log, "Ignore cache start request. " + conflictErr);
            err = new IgniteCheckedException("Failed to start cache. " + conflictErr);
        }
        if (err == null) {
            err = QueryUtils.checkQueryEntityConflicts(req.startCacheConfiguration(), this.registeredCaches.values());
        }
        if (err == null) {
            GridEncryptionManager encMgr = this.ctx.encryption();
            if (ccfg.isEncryptionEnabled()) {
                if (encMgr.isMasterKeyChangeInProgress()) {
                    err = new IgniteCheckedException("Cache start failed. Master key change is in progress.");
                } else if (encMgr.masterKeyDigest() != null && !Arrays.equals(encMgr.masterKeyDigest(), req.masterKeyDigest())) {
                    err = new IgniteCheckedException("Cache start failed. The request was initiated before the master key change and can't be processed.");
                }
                if (err != null) {
                    U.warn(this.log, "Ignore cache start request during the master key change process.", err);
                }
            }
        }
        if (err == null && req.restartId() == null && (snapshotMgr = this.ctx.cache().context().snapshotMgr()).isRestoring(ccfg)) {
            err = new IgniteCheckedException("Cache start failed. A cache or group with the same name is currently being restored from a snapshot [cache=" + cacheName + (ccfg.getGroupName() == null ? "" : ", group=" + ccfg.getGroupName()) + ']');
        }
        if (err != null) {
            if (persistedCfgs) {
                res.errs.add(err);
            } else {
                this.ctx.cache().completeCacheStartFuture(req, false, err);
            }
            return false;
        }
        assert (req.cacheType() != null) : req;
        assert (F.eq(ccfg.getName(), cacheName)) : req;
        int cacheId = CU.cacheId(cacheName);
        CacheGroupDescriptor grpDesc = this.registerCacheGroup(exchangeActions, topVer, ccfg, cacheId, req.initiatingNodeId(), req.deploymentId(), req.encryptionKey(), req.encryptionKeyId(), req.cacheConfigurationEnrichment());
        DynamicCacheDescriptor startDesc = new DynamicCacheDescriptor(this.ctx, ccfg, req.cacheType(), grpDesc, false, req.initiatingNodeId(), false, req.sql(), req.deploymentId(), req.schema(), req.cacheConfigurationEnrichment());
        DynamicCacheDescriptor old = this.registeredCaches.put(ccfg.getName(), startDesc);
        this.registeredCachesById.put(startDesc.cacheId(), startDesc);
        this.restartingCaches.remove(ccfg.getName());
        assert (old == null);
        this.ctx.discovery().setCacheFilter(startDesc.cacheId(), grpDesc.groupId(), ccfg.getName(), ccfg.getNearConfiguration() != null);
        if (!persistedCfgs) {
            this.ctx.discovery().addClientNode(cacheName, req.initiatingNodeId(), req.nearCacheConfiguration() != null);
        }
        res.addedDescs.add(startDesc);
        exchangeActions.addCacheToStart(req, startDesc);
        return true;
    }

    void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        if (!this.ctx.isDaemon()) {
            dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.CACHE_PROC.ordinal(), this.joinDiscoveryData());
        }
    }

    boolean hasRestartingCaches() {
        return !F.isEmpty(this.restartingCaches);
    }

    Collection<String> restartingCaches() {
        return this.restartingCaches.keySet();
    }

    private Serializable joinDiscoveryData() {
        if (this.cachesOnDisconnect != null) {
            Object desc;
            HashMap<Integer, CacheClientReconnectDiscoveryData.CacheGroupInfo> cacheGrpsInfo = new HashMap<Integer, CacheClientReconnectDiscoveryData.CacheGroupInfo>();
            HashMap<String, CacheClientReconnectDiscoveryData.CacheInfo> cachesInfo = new HashMap<String, CacheClientReconnectDiscoveryData.CacheInfo>();
            Map<Integer, CacheGroupDescriptor> grps = this.cachesOnDisconnect.cacheGrps;
            Map<String, DynamicCacheDescriptor> caches = this.cachesOnDisconnect.caches;
            for (CacheGroupContext cacheGroupContext : this.ctx.cache().cacheGroups()) {
                desc = grps.get(cacheGroupContext.groupId());
                assert (desc != null) : cacheGroupContext.cacheOrGroupName();
                cacheGrpsInfo.put(cacheGroupContext.groupId(), new CacheClientReconnectDiscoveryData.CacheGroupInfo(((CacheGroupDescriptor)desc).config(), ((CacheGroupDescriptor)desc).deploymentId(), 0L));
            }
            for (IgniteInternalCache igniteInternalCache : this.ctx.cache().caches()) {
                desc = caches.get(igniteInternalCache.name());
                assert (desc != null) : igniteInternalCache.name();
                cachesInfo.put(igniteInternalCache.name(), new CacheClientReconnectDiscoveryData.CacheInfo(((DynamicCacheDescriptor)desc).cacheConfiguration(), ((DynamicCacheDescriptor)desc).cacheType(), ((DynamicCacheDescriptor)desc).deploymentId(), igniteInternalCache.context().isNear(), 0L));
            }
            return new CacheClientReconnectDiscoveryData(cacheGrpsInfo, cachesInfo);
        }
        assert (this.ctx.config().isDaemon() || this.joinDiscoData != null);
        return this.joinDiscoData;
    }

    @Nullable
    public LocalJoinCachesContext localJoinCachesContext() {
        if (this.ctx.isDaemon()) {
            return null;
        }
        LocalJoinCachesContext result = this.locJoinCachesCtx;
        this.locJoinCachesCtx = null;
        return result;
    }

    boolean hasCachesReceivedFromJoin(UUID joinedNodeId) {
        for (DynamicCacheDescriptor desc : this.registeredCaches.values()) {
            if (!desc.staticallyConfigured()) continue;
            assert (desc.receivedFrom() != null) : desc;
            if (!joinedNodeId.equals(desc.receivedFrom())) continue;
            return true;
        }
        return false;
    }

    List<DynamicCacheDescriptor> cachesReceivedFromJoin(UUID joinedNodeId) {
        assert (joinedNodeId != null);
        List<DynamicCacheDescriptor> started = null;
        if (!this.ctx.isDaemon()) {
            for (DynamicCacheDescriptor desc : this.orderedCaches(CacheComparators.DIRECT)) {
                if (!desc.staticallyConfigured()) continue;
                assert (desc.receivedFrom() != null) : desc;
                if (!joinedNodeId.equals(desc.receivedFrom())) continue;
                if (started == null) {
                    started = new ArrayList<DynamicCacheDescriptor>();
                }
                started.add(desc);
            }
        }
        return started != null ? started : Collections.emptyList();
    }

    public void onDiscoveryEvent(int type, ClusterNode node, AffinityTopologyVersion topVer) {
        if (type == 10 && !this.ctx.isDaemon()) {
            for (Object desc : this.registeredCacheGrps.values()) {
                if (!node.id().equals(((CacheGroupDescriptor)desc).receivedFrom())) continue;
                ((CacheGroupDescriptor)desc).receivedFromStartVersion(topVer);
            }
            for (Object desc : this.registeredCaches.values()) {
                if (!node.id().equals(((DynamicCacheDescriptor)desc).receivedFrom())) continue;
                ((DynamicCacheDescriptor)desc).receivedFromStartVersion(topVer);
            }
            for (Object desc : this.registeredTemplates.values()) {
                if (!node.id().equals(((DynamicCacheDescriptor)desc).receivedFrom())) continue;
                ((DynamicCacheDescriptor)desc).receivedFromStartVersion(topVer);
            }
            if (node.id().equals(this.ctx.discovery().localNode().id()) && this.gridData == null) {
                assert (this.joinDiscoData != null);
                this.initStartCachesForLocalJoin(true, false);
            }
        }
    }

    public void collectGridNodeData(DiscoveryDataBag dataBag, CacheConfigurationSplitter splitter) {
        if (this.ctx.isDaemon()) {
            return;
        }
        if (!dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.CACHE_PROC.ordinal())) {
            dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.CACHE_PROC.ordinal(), this.collectCommonDiscoveryData(splitter));
        }
    }

    private CacheNodeCommonDiscoveryData collectCommonDiscoveryData(CacheConfigurationSplitter cfgSplitter) {
        HashMap<Integer, CacheGroupData> cacheGrps = new HashMap<Integer, CacheGroupData>();
        for (Object grpDesc : this.registeredCacheGrps.values()) {
            T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = cfgSplitter.split((CacheGroupDescriptor)grpDesc);
            CacheGroupData grpData = new CacheGroupData((CacheConfiguration)((Object)splitCfg.get1()), ((CacheGroupDescriptor)grpDesc).groupName(), ((CacheGroupDescriptor)grpDesc).groupId(), ((CacheGroupDescriptor)grpDesc).receivedFrom(), ((CacheGroupDescriptor)grpDesc).startTopologyVersion(), ((CacheGroupDescriptor)grpDesc).deploymentId(), ((CacheGroupDescriptor)grpDesc).caches(), 0L, ((CacheGroupDescriptor)grpDesc).persistenceEnabled(), ((CacheGroupDescriptor)grpDesc).walEnabled(), ((CacheGroupDescriptor)grpDesc).walChangeRequests(), splitCfg.get2() != null ? ((CacheGroupDescriptor)grpDesc).cacheConfigurationEnrichment() : null);
            cacheGrps.put(((CacheGroupDescriptor)grpDesc).groupId(), grpData);
        }
        HashMap<String, CacheData> caches = new HashMap<String, CacheData>();
        for (Object desc : this.registeredCaches.values()) {
            T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = cfgSplitter.split((DynamicCacheDescriptor)desc);
            CacheData cacheData = new CacheData((CacheConfiguration)((Object)splitCfg.get1()), ((DynamicCacheDescriptor)desc).cacheId(), ((DynamicCacheDescriptor)desc).groupId(), ((DynamicCacheDescriptor)desc).cacheType(), ((DynamicCacheDescriptor)desc).deploymentId(), ((DynamicCacheDescriptor)desc).schema(), ((DynamicCacheDescriptor)desc).receivedFrom(), ((DynamicCacheDescriptor)desc).staticallyConfigured(), ((DynamicCacheDescriptor)desc).sql(), false, 0L, splitCfg.get2() != null ? ((DynamicCacheDescriptor)desc).cacheConfigurationEnrichment() : null);
            caches.put(((DynamicCacheDescriptor)desc).cacheName(), cacheData);
        }
        HashMap<String, CacheData> templates = new HashMap<String, CacheData>();
        for (DynamicCacheDescriptor desc : this.registeredTemplates.values()) {
            T2<CacheConfiguration, CacheConfigurationEnrichment> splitCfg = cfgSplitter.split(desc);
            CacheData cacheData = new CacheData((CacheConfiguration)((Object)splitCfg.get1()), 0, 0, desc.cacheType(), desc.deploymentId(), desc.schema(), desc.receivedFrom(), desc.staticallyConfigured(), false, true, 0L, splitCfg.get2() != null ? desc.cacheConfigurationEnrichment() : null);
            templates.put(desc.cacheName(), cacheData);
        }
        HashSet<String> restarting = new HashSet<String>(this.restartingCaches.keySet());
        return new CacheNodeCommonDiscoveryData(caches, templates, cacheGrps, this.ctx.discovery().clientNodesMap(), restarting);
    }

    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        if (this.ctx.isDaemon() || data.commonData() == null) {
            return;
        }
        assert (this.joinDiscoData != null || this.disconnectedState());
        assert (data.commonData() instanceof CacheNodeCommonDiscoveryData) : data;
        CacheNodeCommonDiscoveryData cachesData = (CacheNodeCommonDiscoveryData)data.commonData();
        this.validateNoNewCachesWithNewFormat(cachesData);
        HashMap<Integer, CacheGroupDescriptor> locCacheGrps = new HashMap<Integer, CacheGroupDescriptor>(this.registeredCacheGroups());
        this.cleanCachesAndGroups();
        this.registerReceivedCacheGroups(cachesData, locCacheGrps);
        this.registerReceivedCacheTemplates(cachesData);
        this.registerReceivedCaches(cachesData);
        this.addReceivedClientNodesToDiscovery(cachesData);
        String conflictErr = this.validateRegisteredCaches();
        this.gridData = new GridData(this.joinDiscoData, cachesData, conflictErr);
        if (this.cachesOnDisconnect == null || this.cachesOnDisconnect.clusterActive()) {
            this.initStartCachesForLocalJoin(false, this.disconnectedState());
        }
    }

    public void validateNoNewCachesWithNewFormat(CacheNodeCommonDiscoveryData clusterWideCacheData) {
        IgniteDiscoverySpi spi = (IgniteDiscoverySpi)this.ctx.discovery().getInjectedDiscoverySpi();
        boolean allowSplitCacheConfigurations = spi.allNodesSupport(IgniteFeatures.SPLITTED_CACHE_CONFIGURATIONS);
        if (!allowSplitCacheConfigurations) {
            ArrayList<String> cachesToDestroy = new ArrayList<String>();
            for (DynamicCacheDescriptor cacheDescriptor : this.registeredCaches().values()) {
                CacheData clusterCacheData = clusterWideCacheData.caches().get(cacheDescriptor.cacheName());
                if (!clusterCacheData.receivedFrom().equals(cacheDescriptor.receivedFrom())) continue;
                cachesToDestroy.add(cacheDescriptor.cacheName());
            }
            if (!cachesToDestroy.isEmpty()) {
                this.ctx.cache().dynamicDestroyCaches(cachesToDestroy, false);
                throw new IllegalStateException("Node can't join to cluster in compatibility mode with newly configured caches: " + cachesToDestroy);
            }
        }
    }

    @Nullable
    private String validateRegisteredCaches() {
        String conflictErr = null;
        if (this.joinDiscoData != null) {
            for (Map.Entry<String, CacheJoinNodeDiscoveryData.CacheInfo> e : this.joinDiscoData.caches().entrySet()) {
                if (this.registeredCaches.containsKey(e.getKey()) || (conflictErr = this.checkCacheConflict(e.getValue().cacheData().config())) == null) continue;
                conflictErr = "Failed to start configured cache due to conflict with started caches. " + conflictErr;
                break;
            }
        }
        return conflictErr;
    }

    private void addReceivedClientNodesToDiscovery(CacheNodeCommonDiscoveryData cachesData) {
        if (!F.isEmpty(cachesData.clientNodesMap())) {
            for (Map.Entry<String, Map<UUID, Boolean>> entry : cachesData.clientNodesMap().entrySet()) {
                String cacheName = entry.getKey();
                for (Map.Entry<UUID, Boolean> tup : entry.getValue().entrySet()) {
                    this.ctx.discovery().addClientNode(cacheName, tup.getKey(), tup.getValue());
                }
            }
        }
    }

    private void registerReceivedCaches(CacheNodeCommonDiscoveryData cachesData) {
        HashMap<DynamicCacheDescriptor, QuerySchemaPatch> patchesToApply = new HashMap<DynamicCacheDescriptor, QuerySchemaPatch>();
        HashSet<DynamicCacheDescriptor> cachesToSave = new HashSet<DynamicCacheDescriptor>();
        boolean hasSchemaPatchConflict = false;
        for (CacheData cacheData : cachesData.caches().values()) {
            Collection<QueryEntity> localQueryEntities;
            CacheGroupDescriptor grpDesc = (CacheGroupDescriptor)this.registeredCacheGrps.get(cacheData.groupId());
            assert (grpDesc != null) : cacheData.cacheConfiguration().getName();
            CacheConfiguration cfg = cacheData.cacheConfiguration();
            DynamicCacheDescriptor desc = new DynamicCacheDescriptor(this.ctx, cacheData.cacheConfiguration(), cacheData.cacheType(), grpDesc, false, cacheData.receivedFrom(), cacheData.staticallyConfigured(), cacheData.sql(), cacheData.deploymentId(), new QuerySchema(cacheData.schema().entities()), cacheData.cacheConfigurationEnrichment());
            QuerySchemaPatch schemaPatch = desc.makeSchemaPatch(localQueryEntities = this.getLocalQueryEntities(cfg.getName()));
            if (schemaPatch.hasConflicts()) {
                hasSchemaPatchConflict = true;
                this.log.warning("Skipping apply patch because conflicts : " + schemaPatch.getConflictsMessage());
            } else if (!schemaPatch.isEmpty()) {
                patchesToApply.put(desc, schemaPatch);
            } else if (!GridFunc.eqNotOrdered(desc.schema().entities(), localQueryEntities)) {
                cachesToSave.add(desc);
            }
            desc.receivedOnDiscovery(true);
            this.registeredCaches.put(cacheData.cacheConfiguration().getName(), desc);
            this.registeredCachesById.put(desc.cacheId(), desc);
            this.ctx.discovery().setCacheFilter(desc.cacheId(), grpDesc.groupId(), cfg.getName(), cfg.getNearConfiguration() != null);
        }
        this.updateRegisteredCachesIfNeeded(patchesToApply, cachesToSave, hasSchemaPatchConflict);
    }

    private void updateRegisteredCachesIfNeeded(Map<DynamicCacheDescriptor, QuerySchemaPatch> patchesToApply, Collection<DynamicCacheDescriptor> cachesToSave, boolean hasSchemaPatchConflict) {
        block3: {
            block4: {
                if (hasSchemaPatchConflict || !this.isMergeConfigSupports(this.ctx.discovery().localNode())) break block3;
                boolean isClusterActive = this.ctx.state().clusterState().active();
                if (isClusterActive || patchesToApply.isEmpty()) break block4;
                for (Map.Entry<DynamicCacheDescriptor, QuerySchemaPatch> entry : patchesToApply.entrySet()) {
                    if (!entry.getKey().applySchemaPatch(entry.getValue())) continue;
                    this.saveCacheConfiguration(entry.getKey());
                }
                for (DynamicCacheDescriptor descriptor : cachesToSave) {
                    this.saveCacheConfiguration(descriptor);
                }
                break block3;
            }
            if (!patchesToApply.isEmpty()) break block3;
            for (DynamicCacheDescriptor descriptor : cachesToSave) {
                this.saveCacheConfiguration(descriptor);
            }
        }
    }

    private void registerReceivedCacheTemplates(CacheNodeCommonDiscoveryData cachesData) {
        for (CacheData cacheData : cachesData.templates().values()) {
            DynamicCacheDescriptor desc = new DynamicCacheDescriptor(this.ctx, cacheData.cacheConfiguration(), cacheData.cacheType(), null, true, cacheData.receivedFrom(), cacheData.staticallyConfigured(), false, cacheData.deploymentId(), cacheData.schema(), cacheData.cacheConfigurationEnrichment());
            this.registeredTemplates.put(cacheData.cacheConfiguration().getName(), desc);
        }
    }

    private void registerReceivedCacheGroups(CacheNodeCommonDiscoveryData cachesData, Map<Integer, CacheGroupDescriptor> locCacheGrps) {
        for (CacheGroupData grpData : cachesData.cacheGroups().values()) {
            CacheGroupDescriptor grpDesc = new CacheGroupDescriptor(grpData.config(), grpData.groupName(), grpData.groupId(), grpData.receivedFrom(), grpData.startTopologyVersion(), grpData.deploymentId(), grpData.caches(), grpData.persistenceEnabled(), grpData.walEnabled(), grpData.walChangeRequests(), grpData.cacheConfigurationEnrichment());
            if (locCacheGrps.containsKey(grpDesc.groupId())) {
                CacheGroupDescriptor locGrpCfg = locCacheGrps.get(grpDesc.groupId());
                grpDesc.mergeWith(locGrpCfg);
            }
            CacheGroupDescriptor old = this.registeredCacheGrps.put(grpDesc.groupId(), grpDesc);
            assert (old == null) : old;
            this.ctx.discovery().addCacheGroup(grpDesc, grpData.config().getNodeFilter(), grpData.config().getCacheMode());
        }
    }

    private void cleanCachesAndGroups() {
        this.registeredCaches.clear();
        this.registeredCachesById.clear();
        this.registeredCacheGrps.clear();
        this.ctx.discovery().cleanCachesAndGroups();
    }

    public void cleanupRemovedCaches(AffinityTopologyVersion topVer) {
        this.markedForDeletionCacheGrps.headMap((Object)topVer, true).clear();
    }

    @Nullable
    public CacheGroupDescriptor markedForDeletionCacheGroupDesc(int grpId) {
        for (Map descriptors : this.markedForDeletionCacheGrps.values()) {
            CacheGroupDescriptor desc = (CacheGroupDescriptor)descriptors.get(grpId);
            if (desc == null) continue;
            return desc;
        }
        return null;
    }

    private void saveCacheConfiguration(DynamicCacheDescriptor desc) {
        try {
            this.ctx.cache().saveCacheConfiguration(desc);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Error while saving cache configuration to disk, cfg = " + (Object)((Object)desc.cacheConfiguration()), e);
        }
    }

    private Collection<QueryEntity> getLocalQueryEntities(String cacheName) {
        if (this.joinDiscoData == null) {
            return Collections.emptyList();
        }
        CacheJoinNodeDiscoveryData.CacheInfo cacheInfo = this.joinDiscoData.caches().get(cacheName);
        if (cacheInfo == null) {
            return Collections.emptyList();
        }
        return cacheInfo.cacheData().queryEntities();
    }

    private void initStartCachesForLocalJoin(boolean firstNode, boolean reconnect) {
        if (this.ctx.state().clusterState().transition()) {
            this.joinOnTransition = true;
            return;
        }
        if (this.joinDiscoData != null) {
            ArrayList<T2<DynamicCacheDescriptor, NearCacheConfiguration>> locJoinStartCaches = new ArrayList<T2<DynamicCacheDescriptor, NearCacheConfiguration>>();
            ArrayList<DynamicCacheDescriptor> locJoinInitCaches = new ArrayList<DynamicCacheDescriptor>();
            this.locCfgsForActivation = new HashMap<String, T2<CacheConfiguration, NearCacheConfiguration>>();
            boolean active = this.ctx.state().clusterState().active();
            for (DynamicCacheDescriptor desc : this.orderedCaches(CacheComparators.DIRECT)) {
                if (firstNode && !this.joinDiscoData.caches().containsKey(desc.cacheName())) continue;
                CacheConfiguration cfg = desc.cacheConfiguration();
                if (reconnect && this.surviveReconnect(cfg.getName()) && this.cachesOnDisconnect.state.active() && active) continue;
                CacheJoinNodeDiscoveryData.CacheInfo locCfg = this.joinDiscoData.caches().get(cfg.getName());
                NearCacheConfiguration<?, ?> nearCfg = null;
                if (locCfg != null) {
                    nearCfg = locCfg.cacheData().config().getNearConfiguration();
                    DynamicCacheDescriptor desc0 = new DynamicCacheDescriptor(this.ctx, locCfg.cacheData().config(), desc.cacheType(), desc.groupDescriptor(), desc.template(), desc.receivedFrom(), desc.staticallyConfigured(), desc.sql(), desc.deploymentId(), desc.schema().copy(), locCfg.cacheData().cacheConfigurationEnrichment());
                    desc0.startTopologyVersion(desc.startTopologyVersion());
                    desc0.receivedFromStartVersion(desc.receivedFromStartVersion());
                    desc0.clientCacheStartVersion(desc.clientCacheStartVersion());
                    desc0.cacheConfiguration().setStatisticsEnabled(cfg.isStatisticsEnabled());
                    desc = desc0;
                }
                if (locCfg != null || this.joinDiscoData.startCaches() || CU.affinityNode(this.ctx.discovery().localNode(), desc.groupDescriptor().config().getNodeFilter())) {
                    if (active) {
                        locJoinStartCaches.add(new T2(desc, nearCfg));
                        continue;
                    }
                    this.locCfgsForActivation.put(desc.cacheName(), new T2(desc.cacheConfiguration(), nearCfg));
                    continue;
                }
                locJoinInitCaches.add(desc);
            }
            this.locJoinCachesCtx = new LocalJoinCachesContext(locJoinStartCaches, locJoinInitCaches, new HashMap<Integer, CacheGroupDescriptor>(this.registeredCacheGrps), new HashMap<String, DynamicCacheDescriptor>(this.registeredCaches));
        }
    }

    public void onStateChangeFinish(ChangeGlobalStateFinishMessage msg) {
        if (this.joinOnTransition) {
            this.initStartCachesForLocalJoin(false, false);
            this.joinOnTransition = false;
        }
    }

    public ExchangeActions onStateChangeRequest(ChangeGlobalStateMessage msg, AffinityTopologyVersion topVer, DiscoveryDataClusterState curState) throws IgniteCheckedException {
        ExchangeActions exchangeActions = new ExchangeActions();
        if (msg.activate() == curState.active()) {
            return exchangeActions;
        }
        if (msg.activate()) {
            for (DynamicCacheDescriptor desc : this.orderedCaches(CacheComparators.DIRECT)) {
                desc.startTopologyVersion(topVer);
                DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(msg.requestId(), desc.cacheName(), msg.initiatorNodeId());
                req.startCacheConfiguration(desc.cacheConfiguration());
                req.cacheType(desc.cacheType());
                T2<CacheConfiguration, NearCacheConfiguration> locCfg = this.locCfgsForActivation.get(desc.cacheName());
                if (locCfg != null) {
                    if (locCfg.get1() != null) {
                        req.startCacheConfiguration((CacheConfiguration)((Object)locCfg.get1()));
                    }
                    req.nearCacheConfiguration((NearCacheConfiguration)locCfg.get2());
                    req.locallyConfigured(true);
                }
                exchangeActions.addCacheToStart(req, desc);
            }
            for (CacheGroupDescriptor grpDesc : this.registeredCacheGroups().values()) {
                exchangeActions.addCacheGroupToStart(grpDesc);
            }
            List<StoredCacheData> storedCfgs = msg.storedCacheConfigurations();
            if (storedCfgs != null) {
                ArrayList<DynamicCacheChangeRequest> reqs = new ArrayList<DynamicCacheChangeRequest>();
                IgniteUuid deploymentId = msg.id();
                for (StoredCacheData storedCfg : storedCfgs) {
                    CacheConfiguration<?, ?> ccfg = storedCfg.config();
                    if (this.registeredCaches.containsKey(ccfg.getName())) continue;
                    DynamicCacheChangeRequest req = new DynamicCacheChangeRequest(msg.requestId(), ccfg.getName(), msg.initiatorNodeId());
                    req.deploymentId(deploymentId);
                    req.startCacheConfiguration(ccfg);
                    req.cacheType(this.ctx.cache().cacheType(ccfg.getName()));
                    req.schema(new QuerySchema(storedCfg.queryEntities()));
                    req.sql(storedCfg.sql());
                    reqs.add(req);
                }
                CacheChangeProcessResult res = this.processCacheChangeRequests(exchangeActions, reqs, topVer, true);
                if (!res.errs.isEmpty()) {
                    IgniteCheckedException err = new IgniteCheckedException("Failed to activate cluster.");
                    for (IgniteCheckedException err0 : res.errs) {
                        err.addSuppressed(err0);
                    }
                    throw err;
                }
            }
        } else {
            this.locCfgsForActivation = new HashMap<String, T2<CacheConfiguration, NearCacheConfiguration>>();
            for (DynamicCacheDescriptor desc : this.orderedCaches(CacheComparators.REVERSE)) {
                DynamicCacheChangeRequest req = DynamicCacheChangeRequest.stopRequest(this.ctx, desc.cacheName(), desc.sql(), false);
                exchangeActions.addCacheToStop(req, desc);
                if (!this.ctx.discovery().cacheClientNode(this.ctx.discovery().localNode(), desc.cacheName())) continue;
                this.locCfgsForActivation.put(desc.cacheName(), new T2<CacheConfiguration, NearCacheConfiguration>(null, null));
            }
            for (CacheGroupDescriptor grpDesc : this.registeredCacheGroups().values()) {
                exchangeActions.addCacheGroupToStop(grpDesc, false);
            }
        }
        return exchangeActions;
    }

    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        if (data.hasJoiningNodeData()) {
            Serializable joiningNodeData = data.joiningNodeData();
            if (joiningNodeData instanceof CacheClientReconnectDiscoveryData) {
                if (this.disconnectedState()) {
                    if (this.clientReconnectReqs == null) {
                        this.clientReconnectReqs = new LinkedHashMap<UUID, CacheClientReconnectDiscoveryData>();
                    }
                    this.clientReconnectReqs.put(data.joiningNodeId(), (CacheClientReconnectDiscoveryData)joiningNodeData);
                } else {
                    this.processClientReconnectData((CacheClientReconnectDiscoveryData)joiningNodeData, data.joiningNodeId());
                }
            } else if (joiningNodeData instanceof CacheJoinNodeDiscoveryData) {
                this.processJoiningNode((CacheJoinNodeDiscoveryData)joiningNodeData, data.joiningNodeId(), false);
            }
        }
    }

    public String validateJoiningNodeData(DiscoveryDataBag.JoiningNodeDiscoveryData data, boolean joiningNodeClient) {
        Serializable joiningNodeData;
        if (data.hasJoiningNodeData() && (joiningNodeData = data.joiningNodeData()) instanceof CacheJoinNodeDiscoveryData) {
            CacheJoinNodeDiscoveryData joinData = (CacheJoinNodeDiscoveryData)joiningNodeData;
            HashSet<String> problemCaches = null;
            HashSet<String> encClientCaches = null;
            for (CacheJoinNodeDiscoveryData.CacheInfo cacheInfo : joinData.caches().values()) {
                CacheConfiguration<?, ?> cfg = cacheInfo.cacheData().config();
                if (this.registeredCaches.containsKey(cfg.getName())) continue;
                String conflictErr = this.checkCacheConflict(cfg);
                if (conflictErr != null) {
                    U.warn(this.log, "Ignore cache received from joining node. " + conflictErr);
                    continue;
                }
                long flags = cacheInfo.getFlags();
                if (flags == 1L) {
                    if (problemCaches == null) {
                        problemCaches = new HashSet<String>();
                    }
                    problemCaches.add(cfg.getName());
                    continue;
                }
                if (!joiningNodeClient || !cfg.isEncryptionEnabled()) continue;
                if (encClientCaches == null) {
                    encClientCaches = new HashSet<String>();
                }
                encClientCaches.add(cfg.getName());
            }
            if (!F.isEmpty(problemCaches)) {
                return problemCaches.stream().collect(Collectors.joining(", ", "Joining node has caches with data which are not presented on cluster, it could mean that they were already destroyed, to add the node to cluster - remove directories with the caches[", "]"));
            }
            if (!F.isEmpty(encClientCaches)) {
                return encClientCaches.stream().collect(Collectors.joining(", ", "Joining node has encrypted caches which are not presented on the cluster, encrypted caches configured on client node cannot be started when such node joins the cluster, these caches can be started manually (dynamically) after node joined[caches=", "]"));
            }
        }
        return null;
    }

    private void processClientReconnectData(CacheClientReconnectDiscoveryData clientData, UUID clientNodeId) {
        DiscoveryDataClusterState state = this.ctx.state().clusterState();
        if (state.active() && !state.transition()) {
            for (CacheClientReconnectDiscoveryData.CacheInfo cacheInfo : clientData.clientCaches().values()) {
                String cacheName = cacheInfo.config().getName();
                if (this.surviveReconnect(cacheName)) {
                    this.ctx.discovery().addClientNode(cacheName, clientNodeId, false);
                    continue;
                }
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(cacheName);
                if (desc == null || !desc.deploymentId().equals(cacheInfo.deploymentId())) continue;
                this.ctx.discovery().addClientNode(cacheName, clientNodeId, cacheInfo.nearCache());
            }
        }
    }

    private String checkCacheConflict(CacheConfiguration<?, ?> cfg) {
        Object desc3;
        Object desc2;
        int cacheId = CU.cacheId(cfg.getName());
        if (this.cacheGroupByName(cfg.getName()) != null) {
            return "Cache name conflict with existing cache group (change cache name) [cacheName=" + cfg.getName() + ']';
        }
        if (cfg.getGroupName() != null && (desc2 = (DynamicCacheDescriptor)this.registeredCaches.get(cfg.getGroupName())) != null) {
            return "Cache group name conflict with existing cache (change group name) [cacheName=" + cfg.getName() + ", conflictingCacheName=" + ((DynamicCacheDescriptor)desc2).cacheName() + ']';
        }
        for (Object desc3 : this.registeredCaches.values()) {
            if (((DynamicCacheDescriptor)desc3).cacheId() != cacheId) continue;
            return "Cache ID conflict (change cache name) [cacheName=" + cfg.getName() + ", conflictingCacheName=" + ((DynamicCacheDescriptor)desc3).cacheName() + ']';
        }
        int grpId = CU.cacheGroupId(cfg);
        if (cfg.getGroupName() != null) {
            if (this.cacheGroupByName(cfg.getGroupName()) == null && (desc3 = (CacheGroupDescriptor)this.registeredCacheGrps.get(grpId)) != null) {
                return "Cache group ID conflict (change cache group name) [cacheName=" + cfg.getName() + ", groupName=" + cfg.getGroupName() + (((CacheGroupDescriptor)desc3).sharedGroup() ? ", conflictingGroupName=" : ", conflictingCacheName=") + ((CacheGroupDescriptor)desc3).cacheOrGroupName() + ']';
            }
        } else {
            desc3 = (CacheGroupDescriptor)this.registeredCacheGrps.get(grpId);
            if (desc3 != null) {
                return "Cache group ID conflict (change cache name) [cacheName=" + cfg.getName() + (((CacheGroupDescriptor)desc3).sharedGroup() ? ", conflictingGroupName=" : ", conflictingCacheName=") + ((CacheGroupDescriptor)desc3).cacheOrGroupName() + ']';
            }
        }
        return null;
    }

    private String processJoiningNode(CacheJoinNodeDiscoveryData joinData, UUID nodeId, boolean locJoin) {
        this.registerNewCacheTemplates(joinData, nodeId);
        HashMap<DynamicCacheDescriptor, QuerySchemaPatch> patchesToApply = new HashMap<DynamicCacheDescriptor, QuerySchemaPatch>();
        boolean hasSchemaPatchConflict = false;
        boolean active = this.ctx.state().clusterState().active();
        boolean isMergeConfigSupport = this.isMergeConfigSupports(null);
        for (CacheJoinNodeDiscoveryData.CacheInfo cacheInfo : joinData.caches().values()) {
            CacheConfiguration<?, ?> cfg = cacheInfo.cacheData().config();
            if (!this.registeredCaches.containsKey(cfg.getName())) {
                String conflictErr = this.checkCacheConflict(cfg);
                if (conflictErr != null) {
                    if (locJoin) {
                        return conflictErr;
                    }
                    U.warn(this.log, "Ignore cache received from joining node. " + conflictErr);
                    continue;
                }
                this.registerNewCache(joinData, nodeId, cacheInfo);
            } else if (!active && isMergeConfigSupport) {
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)this.registeredCaches.get(cfg.getName());
                QuerySchemaPatch schemaPatch = desc.makeSchemaPatch(cacheInfo.cacheData());
                if (schemaPatch.hasConflicts()) {
                    hasSchemaPatchConflict = true;
                    this.log.error("Error during making schema patch : " + schemaPatch.getConflictsMessage());
                } else if (!schemaPatch.isEmpty() && !hasSchemaPatchConflict) {
                    patchesToApply.put(desc, schemaPatch);
                }
            }
            this.ctx.discovery().addClientNode(cfg.getName(), nodeId, cfg.getNearConfiguration() != null);
        }
        if (!hasSchemaPatchConflict && !patchesToApply.isEmpty()) {
            for (Map.Entry entry : patchesToApply.entrySet()) {
                if (!((DynamicCacheDescriptor)entry.getKey()).applySchemaPatch((QuerySchemaPatch)entry.getValue())) continue;
                this.saveCacheConfiguration((DynamicCacheDescriptor)entry.getKey());
            }
        }
        if (joinData.startCaches()) {
            for (DynamicCacheDescriptor dynamicCacheDescriptor : this.registeredCaches.values()) {
                this.ctx.discovery().addClientNode(dynamicCacheDescriptor.cacheName(), nodeId, dynamicCacheDescriptor.cacheConfiguration().getNearConfiguration() != null);
            }
        }
        return null;
    }

    private void registerNewCache(CacheJoinNodeDiscoveryData joinData, UUID nodeId, CacheJoinNodeDiscoveryData.CacheInfo cacheInfo) {
        CacheConfiguration<?, ?> cfg = cacheInfo.cacheData().config();
        int cacheId = CU.cacheId(cfg.getName());
        CacheGroupDescriptor grpDesc = this.registerCacheGroup(null, null, cfg, cacheId, nodeId, joinData.cacheDeploymentId(), null, null, cacheInfo.cacheData().cacheConfigurationEnrichment());
        this.ctx.discovery().setCacheFilter(cacheId, grpDesc.groupId(), cfg.getName(), cfg.getNearConfiguration() != null);
        DynamicCacheDescriptor desc = new DynamicCacheDescriptor(this.ctx, cfg, cacheInfo.cacheType(), grpDesc, false, nodeId, cacheInfo.isStaticallyConfigured(), cacheInfo.sql(), joinData.cacheDeploymentId(), new QuerySchema(cacheInfo.cacheData().queryEntities()), cacheInfo.cacheData().cacheConfigurationEnrichment());
        DynamicCacheDescriptor old = this.registeredCaches.put(cfg.getName(), desc);
        this.registeredCachesById.put(desc.cacheId(), desc);
        if (cacheInfo.cacheData().groupKeyEncrypted() != null) {
            int grpId = CU.cacheGroupId(cacheInfo.cacheData().config());
            assert (cacheInfo.cacheData().config().isEncryptionEnabled());
            GroupKeyEncrypted restoredKey = cacheInfo.cacheData().groupKeyEncrypted();
            GroupKey activeKey = this.ctx.encryption().getActiveKey(grpId);
            if (activeKey == null) {
                this.ctx.encryption().setInitialGroupKey(grpId, restoredKey.key(), restoredKey.id());
            } else assert (activeKey.equals(new GroupKey(restoredKey.id(), this.ctx.config().getEncryptionSpi().decryptKey(restoredKey.key()))));
        }
        assert (old == null) : old;
    }

    private void registerNewCacheTemplates(CacheJoinNodeDiscoveryData joinData, UUID nodeId) {
        for (CacheJoinNodeDiscoveryData.CacheInfo cacheInfo : joinData.templates().values()) {
            CacheConfiguration<?, ?> cfg = cacheInfo.cacheData().config();
            if (this.registeredTemplates.containsKey(cfg.getName())) continue;
            DynamicCacheDescriptor desc = new DynamicCacheDescriptor(this.ctx, cfg, cacheInfo.cacheType(), null, true, nodeId, true, false, joinData.cacheDeploymentId(), new QuerySchema(cacheInfo.cacheData().queryEntities()), cacheInfo.cacheData().cacheConfigurationEnrichment());
            DynamicCacheDescriptor old = this.registeredTemplates.put(cfg.getName(), desc);
            assert (old == null) : old;
        }
    }

    public boolean isMergeConfigSupports(ClusterNode joiningNode) {
        DiscoCache discoCache = this.ctx.discovery().discoCache();
        if (discoCache == null) {
            return true;
        }
        if (joiningNode != null && joiningNode.version().compareToIgnoreTimestamp(V_MERGE_CONFIG_SINCE) < 0) {
            return false;
        }
        List<ClusterNode> nodes = discoCache.allNodes();
        for (ClusterNode node : nodes) {
            IgniteProductVersion version = node.version();
            if (version.compareToIgnoreTimestamp(V_MERGE_CONFIG_SINCE) >= 0) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private CacheGroupDescriptor cacheGroupByName(String grpName) {
        assert (grpName != null);
        for (CacheGroupDescriptor grpDesc : this.registeredCacheGrps.values()) {
            if (!grpName.equals(grpDesc.groupName())) continue;
            return grpDesc;
        }
        return null;
    }

    @Nullable
    private CacheGroupDescriptor nonSharedCacheGroupByCacheName(String cacheName) {
        assert (cacheName != null);
        for (CacheGroupDescriptor grpDesc : this.registeredCacheGrps.values()) {
            if (grpDesc.sharedGroup() || !grpDesc.caches().containsKey(cacheName)) continue;
            return grpDesc;
        }
        return null;
    }

    private CacheGroupDescriptor registerCacheGroup(@Nullable ExchangeActions exchActions, @Nullable AffinityTopologyVersion curTopVer, CacheConfiguration<?, ?> startedCacheCfg, Integer cacheId, UUID rcvdFrom, IgniteUuid deploymentId, @Nullable byte[] encKey, @Nullable Integer encKeyId, CacheConfigurationEnrichment cacheCfgEnrichment) {
        DataRegionConfiguration drCfg;
        CacheGroupDescriptor desc;
        if (startedCacheCfg.getGroupName() != null && (desc = this.cacheGroupByName(startedCacheCfg.getGroupName())) != null) {
            desc.onCacheAdded(startedCacheCfg.getName(), cacheId);
            return desc;
        }
        int grpId = CU.cacheGroupId(startedCacheCfg);
        Map<String, Integer> caches = Collections.singletonMap(startedCacheCfg.getName(), cacheId);
        boolean persistent = this.resolvePersistentFlag(exchActions, startedCacheCfg);
        boolean walGloballyEnabled = this.ctx.clientNode() ? persistent : (persistent ? this.ctx.cache().context().database().walEnabled(grpId, false) : (drCfg = CU.findDataRegion(this.ctx.config().getDataStorageConfiguration(), startedCacheCfg.getDataRegionName())) != null && drCfg.isCdcEnabled());
        CacheGroupDescriptor grpDesc = new CacheGroupDescriptor(startedCacheCfg, startedCacheCfg.getGroupName(), grpId, rcvdFrom, curTopVer != null ? curTopVer.nextMinorVersion() : null, deploymentId, caches, persistent, walGloballyEnabled, null, cacheCfgEnrichment);
        if (startedCacheCfg.isEncryptionEnabled()) {
            this.ctx.encryption().setInitialGroupKey(grpId, encKey, encKeyId);
        }
        CacheGroupDescriptor old = this.registeredCacheGrps.put(grpId, grpDesc);
        assert (old == null) : old;
        this.ctx.discovery().addCacheGroup(grpDesc, grpDesc.config().getNodeFilter(), startedCacheCfg.getCacheMode());
        if (exchActions != null) {
            exchActions.addCacheGroupToStart(grpDesc);
        }
        return grpDesc;
    }

    private boolean resolvePersistentFlag(@Nullable ExchangeActions exchActions, CacheConfiguration<?, ?> startedCacheCfg) {
        if (!this.ctx.clientNode()) {
            return CU.isPersistentCache(startedCacheCfg, this.ctx.config().getDataStorageConfiguration());
        }
        if (exchActions == null) {
            return false;
        }
        Collection<ClusterNode> aliveSrvNodes = this.ctx.discovery().aliveServerNodes();
        assert (!aliveSrvNodes.isEmpty()) : "No alive server nodes";
        for (ClusterNode srvNode : aliveSrvNodes) {
            if (!CU.affinityNode(srvNode, startedCacheCfg.getNodeFilter())) continue;
            Object dsCfgBytes = srvNode.attribute("org.apache.ignite.data.storage.config");
            if (dsCfgBytes instanceof byte[]) {
                try {
                    DataStorageConfiguration crdDsCfg = (DataStorageConfiguration)new JdkMarshaller().unmarshal((byte[])dsCfgBytes, U.resolveClassLoader(this.ctx.config()));
                    return CU.isPersistentCache(startedCacheCfg, crdDsCfg);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to unmarshal remote data storage configuration [remoteNode=" + srvNode + ", cacheName=" + startedCacheCfg.getName() + "]", e);
                    continue;
                }
            }
            U.error(this.log, "Remote marshalled data storage configuration is absent [remoteNode=" + srvNode + ", cacheName=" + startedCacheCfg.getName() + ", dsCfg=" + dsCfgBytes + "]");
        }
        U.error(this.log, "Failed to find affinity server node with data storage configuration for starting cache [cacheName=" + startedCacheCfg.getName() + ", aliveSrvNodes=" + aliveSrvNodes + "]");
        return false;
    }

    void validateStartCacheConfiguration(CacheConfiguration ccfg) throws IgniteCheckedException {
        CacheGroupDescriptor grpDesc;
        if (ccfg.getGroupName() != null && (grpDesc = this.cacheGroupByName(ccfg.getGroupName())) != null) {
            assert (ccfg.getGroupName().equals(grpDesc.groupName()));
            this.validateCacheGroupConfiguration(grpDesc.config(), ccfg);
        }
    }

    private void validateCacheGroupConfiguration(CacheConfiguration cfg, CacheConfiguration startCfg) throws IgniteCheckedException {
        GridCacheAttributes attr1 = new GridCacheAttributes(cfg);
        GridCacheAttributes attr2 = new GridCacheAttributes(startCfg);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "cacheMode", "Cache mode", (Object)cfg.getCacheMode(), (Object)startCfg.getCacheMode(), true);
        if (cfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT || startCfg.getAtomicityMode() == CacheAtomicityMode.TRANSACTIONAL_SNAPSHOT) {
            CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "atomicityMode", "Atomicity mode", (Object)attr1.atomicityMode(), (Object)attr2.atomicityMode(), true);
        }
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "affinity", "Affinity function", attr1.cacheAffinityClassName(), attr2.cacheAffinityClassName(), true);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "affinityPartitionsCount", "Affinity partitions count", attr1.affinityPartitionsCount(), attr2.affinityPartitionsCount(), true);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "nodeFilter", "Node filter", attr1.nodeFilterClassName(), attr2.nodeFilterClassName(), true);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "dataRegionName", "Data region", cfg.getDataRegionName(), startCfg.getDataRegionName(), true);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "topologyValidator", "Topology validator", attr1.topologyValidatorClassName(), attr2.topologyValidatorClassName(), true);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "partitionLossPolicy", "Partition Loss Policy", (Object)cfg.getPartitionLossPolicy(), (Object)startCfg.getPartitionLossPolicy(), true);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "rebalanceMode", "Rebalance mode", (Object)cfg.getRebalanceMode(), (Object)startCfg.getRebalanceMode(), true);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "rebalanceDelay", "Rebalance delay", cfg.getRebalanceDelay(), startCfg.getRebalanceDelay(), false);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "rebalanceOrder", "Rebalance order", cfg.getRebalanceOrder(), startCfg.getRebalanceOrder(), false);
        if (cfg.getCacheMode() == CacheMode.PARTITIONED) {
            CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "backups", "Backups", cfg.getBackups(), startCfg.getBackups(), true);
        }
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "encryptionEnabled", "Encrypted", cfg.isEncryptionEnabled(), startCfg.isEncryptionEnabled(), true);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "diskPageCompression", "Disk page compression", (Object)cfg.getDiskPageCompression(), (Object)startCfg.getDiskPageCompression(), true);
        CU.validateCacheGroupsAttributesMismatch(this.log, cfg, startCfg, "diskPageCompressionLevel", "Disk page compression level", cfg.getDiskPageCompressionLevel(), startCfg.getDiskPageCompressionLevel(), true);
    }

    ConcurrentMap<String, DynamicCacheDescriptor> registeredCaches() {
        return this.registeredCaches;
    }

    ConcurrentMap<Integer, DynamicCacheDescriptor> registeredCachesById() {
        return this.registeredCachesById;
    }

    ConcurrentMap<String, DynamicCacheDescriptor> registeredTemplates() {
        return this.registeredTemplates;
    }

    ConcurrentMap<Integer, CacheGroupDescriptor> registeredCacheGroups() {
        return this.registeredCacheGrps;
    }

    private Collection<DynamicCacheDescriptor> orderedCaches(Comparator<DynamicCacheDescriptor> comparator) {
        ArrayList<DynamicCacheDescriptor> ordered = new ArrayList<DynamicCacheDescriptor>();
        ordered.addAll(this.registeredCaches.values());
        Collections.sort(ordered, comparator);
        return ordered;
    }

    public void onDisconnected() {
        this.cachesOnDisconnect = new CachesOnDisconnect(this.ctx.state().clusterState(), new HashMap<Integer, CacheGroupDescriptor>(this.registeredCacheGrps), new HashMap<String, DynamicCacheDescriptor>(this.registeredCaches));
        this.registeredCacheGrps.clear();
        this.registeredCaches.clear();
        this.registeredCachesById.clear();
        this.registeredTemplates.clear();
        this.clientReconnectReqs = null;
    }

    public ClusterCachesReconnectResult onReconnected(boolean active, boolean transition) {
        assert (this.disconnectedState());
        HashSet<String> stoppedCaches = new HashSet<String>();
        HashSet<Integer> stoppedCacheGrps = new HashSet<Integer>();
        HashSet<String> survivedCaches = new HashSet<String>();
        if (!active) {
            this.joinOnTransition = transition;
            if (F.isEmpty(this.locCfgsForActivation)) {
                this.locCfgsForActivation = new HashMap<String, T2<CacheConfiguration, NearCacheConfiguration>>();
                for (IgniteInternalCache igniteInternalCache : this.ctx.cache().caches()) {
                    this.locCfgsForActivation.put(igniteInternalCache.name(), new T2(null, igniteInternalCache.configuration().getNearConfiguration()));
                }
            }
            for (Map.Entry<Object, Object> entry : this.cachesOnDisconnect.cacheGrps.entrySet()) {
                stoppedCacheGrps.add(((CacheGroupDescriptor)entry.getValue()).groupId());
            }
            for (Map.Entry entry : this.cachesOnDisconnect.caches.entrySet()) {
                stoppedCaches.add((String)entry.getKey());
            }
        } else {
            boolean stopped;
            for (Map.Entry<Integer, CacheGroupDescriptor> entry : this.cachesOnDisconnect.cacheGrps.entrySet()) {
                CacheGroupDescriptor desc;
                CacheGroupDescriptor locDesc = entry.getValue();
                stopped = true;
                if (locDesc.sharedGroup()) {
                    desc = this.cacheGroupByName(locDesc.groupName());
                    if (desc != null && desc.deploymentId().equals(locDesc.deploymentId())) {
                        stopped = false;
                    }
                } else {
                    desc = this.nonSharedCacheGroupByCacheName(locDesc.config().getName());
                    if (desc != null && (this.surviveReconnect(locDesc.config().getName()) || desc.deploymentId().equals(locDesc.deploymentId()))) {
                        stopped = false;
                    }
                }
                if (stopped) {
                    stoppedCacheGrps.add(locDesc.groupId());
                    continue;
                }
                assert (locDesc.groupId() == desc.groupId());
            }
            for (Map.Entry entry : this.cachesOnDisconnect.caches.entrySet()) {
                DynamicCacheDescriptor newDesc;
                DynamicCacheDescriptor desc = (DynamicCacheDescriptor)entry.getValue();
                String cacheName = (String)entry.getKey();
                stopped = !this.surviveReconnect(cacheName) ? (newDesc = (DynamicCacheDescriptor)this.registeredCaches.get(cacheName)) == null || !desc.deploymentId().equals(newDesc.deploymentId()) : false;
                if (stopped) {
                    stoppedCaches.add(cacheName);
                    continue;
                }
                survivedCaches.add(cacheName);
            }
            if (this.locJoinCachesCtx != null) {
                this.locJoinCachesCtx.removeSurvivedCaches(survivedCaches);
                if (this.locJoinCachesCtx.isEmpty()) {
                    this.locJoinCachesCtx = null;
                }
            }
            if (!this.cachesOnDisconnect.clusterActive()) {
                this.initStartCachesForLocalJoin(false, true);
            }
        }
        if (this.clientReconnectReqs != null) {
            for (Map.Entry entry : this.clientReconnectReqs.entrySet()) {
                this.processClientReconnectData((CacheClientReconnectDiscoveryData)entry.getValue(), (UUID)entry.getKey());
            }
            this.clientReconnectReqs = null;
        }
        this.cachesOnDisconnect = null;
        return new ClusterCachesReconnectResult(stoppedCacheGrps, stoppedCaches);
    }

    private boolean disconnectedState() {
        return this.cachesOnDisconnect != null;
    }

    private boolean surviveReconnect(String cacheName) {
        return CU.isUtilityCache(cacheName);
    }

    public boolean isRestarting(String cacheName) {
        return this.restartingCaches.containsKey(cacheName);
    }

    public void removeRestartingCache(String cacheName) {
        this.restartingCaches.remove(cacheName);
    }

    public void removeRestartingCaches() {
        this.restartingCaches.clear();
    }

    private static class CacheChangeProcessResult {
        private boolean needExchange;
        private final List<DynamicCacheDescriptor> addedDescs = new ArrayList<DynamicCacheDescriptor>();
        private final List<IgniteCheckedException> errs = new ArrayList<IgniteCheckedException>();

        private CacheChangeProcessResult() {
        }
    }

    private static class CachesOnDisconnect {
        final DiscoveryDataClusterState state;
        final Map<Integer, CacheGroupDescriptor> cacheGrps;
        final Map<String, DynamicCacheDescriptor> caches;

        CachesOnDisconnect(DiscoveryDataClusterState state, Map<Integer, CacheGroupDescriptor> cacheGrps, Map<String, DynamicCacheDescriptor> caches) {
            this.state = state;
            this.cacheGrps = cacheGrps;
            this.caches = caches;
        }

        boolean clusterActive() {
            return this.state.active() && !this.state.transition();
        }
    }

    private static class GridData {
        private final CacheJoinNodeDiscoveryData joinDiscoData;
        private final CacheNodeCommonDiscoveryData gridData;
        private final String conflictErr;

        GridData(CacheJoinNodeDiscoveryData joinDiscoData, CacheNodeCommonDiscoveryData gridData, String conflictErr) {
            this.joinDiscoData = joinDiscoData;
            this.gridData = gridData;
            this.conflictErr = conflictErr;
        }
    }

    static class CacheComparators {
        static Comparator<DynamicCacheDescriptor> DIRECT = new Comparator<DynamicCacheDescriptor>(){

            @Override
            public int compare(DynamicCacheDescriptor o1, DynamicCacheDescriptor o2) {
                if (o1.cacheType().userCache() ^ o2.cacheType().userCache()) {
                    return o2.cacheType().userCache() ? -1 : 1;
                }
                return Integer.compare(o1.cacheId(), o2.cacheId());
            }
        };
        static Comparator<DynamicCacheDescriptor> REVERSE = new Comparator<DynamicCacheDescriptor>(){

            @Override
            public int compare(DynamicCacheDescriptor o1, DynamicCacheDescriptor o2) {
                return -DIRECT.compare(o1, o2);
            }
        };

        CacheComparators() {
        }
    }
}

