/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cdc;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cdc.CdcConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.cdc.CdcConsumerState;
import org.apache.ignite.internal.cdc.CdcFileLockHolder;
import org.apache.ignite.internal.cdc.WalRecordsConsumer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderResolver;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CdcMain
implements Runnable {
    public static final String ERR_MSG = "Persistence and CDC disabled. Capture Data Change can't run!";
    public static final String STATE_DIR = "state";
    public static final String CUR_SEG_IDX = "CurrentSegmentIndex";
    public static final String COMMITTED_SEG_IDX = "CommittedSegmentIndex";
    public static final String COMMITTED_SEG_OFFSET = "CommittedSegmentOffset";
    public static final String LAST_SEG_CONSUMPTION_TIME = "LastSegmentConsumptionTime";
    public static final String BINARY_META_DIR = "BinaryMetaDir";
    public static final String MARSHALLER_DIR = "MarshallerDir";
    public static final String CDC_DIR = "CdcDir";
    private final IgniteConfiguration igniteCfg;
    private final GridSpringResourceContext ctx;
    private MetricRegistry mreg;
    private AtomicLongMetric curSegmentIdx;
    private AtomicLongMetric committedSegmentIdx;
    private AtomicLongMetric committedSegmentOffset;
    private AtomicLongMetric lastSegmentConsumptionTs;
    protected final CdcConfiguration cdcCfg;
    private final IgniteWalIteratorFactory factory;
    private final WalRecordsConsumer<?, ?> consumer;
    private final IgniteLogger log;
    private Path cdcDir;
    private File binaryMeta;
    private File marshaller;
    private CdcConsumerState state;
    private T2<WALPointer, Integer> initState;
    private volatile boolean stopped;
    private final Set<Path> processedSegments = new HashSet<Path>();

    public CdcMain(IgniteConfiguration cfg, GridSpringResourceContext ctx, CdcConfiguration cdcCfg) {
        this.igniteCfg = new IgniteConfiguration(cfg);
        this.ctx = ctx;
        this.cdcCfg = cdcCfg;
        try {
            U.initWorkDir(this.igniteCfg);
            this.log = U.initLogger(this.igniteCfg, "ignite-cdc");
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        this.consumer = new WalRecordsConsumer(cdcCfg.getConsumer(), this.log);
        this.factory = new IgniteWalIteratorFactory(this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CdcMain cdcMain = this;
        synchronized (cdcMain) {
            if (this.stopped) {
                return;
            }
        }
        try {
            this.runX();
        }
        catch (Throwable e) {
            this.log.error("Cdc error", e);
            throw new IgniteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runX() throws Exception {
        this.ackAsciiLogo();
        if (!CU.isCdcEnabled(this.igniteCfg)) {
            this.log.error(ERR_MSG);
            throw new IllegalArgumentException(ERR_MSG);
        }
        try (CdcFileLockHolder lock = this.lockPds();){
            String consIdDir = this.cdcDir.getName(this.cdcDir.getNameCount() - 1).toString();
            Files.createDirectories(this.cdcDir.resolve(STATE_DIR), new FileAttribute[0]);
            this.binaryMeta = CacheObjectBinaryProcessorImpl.binaryWorkDir(this.igniteCfg.getWorkDirectory(), consIdDir);
            this.marshaller = MarshallerContextImpl.mappingFileStoreWorkDir(this.igniteCfg.getWorkDirectory());
            if (this.log.isInfoEnabled()) {
                this.log.info("Change Data Capture [dir=" + this.cdcDir + ']');
                this.log.info("Ignite node Binary meta [dir=" + this.binaryMeta + ']');
                this.log.info("Ignite node Marshaller [dir=" + this.marshaller + ']');
            }
            StandaloneGridKernalContext kctx = this.startStandaloneKernal();
            this.initMetrics();
            try {
                block23: {
                    kctx.resource().injectGeneric(this.consumer.consumer());
                    this.state = this.createState(this.cdcDir.resolve(STATE_DIR));
                    this.initState = this.state.load();
                    if (this.initState != null) {
                        this.committedSegmentIdx.value(((WALPointer)this.initState.get1()).index());
                        this.committedSegmentOffset.value(((WALPointer)this.initState.get1()).fileOffset());
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Initial state loaded [ptr=" + this.initState.get1() + ", idx=" + this.initState.get2() + ']');
                        }
                    }
                    this.consumer.start(this.mreg, kctx.metric().registry(MetricUtils.metricName("cdc", "consumer")));
                    try {
                        this.consumeWalSegmentsUntilStopped();
                        this.consumer.stop();
                        if (!this.log.isInfoEnabled()) break block23;
                        this.log.info("Ignite Change Data Capture Application stopped.");
                    }
                    catch (Throwable throwable) {
                        this.consumer.stop();
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Ignite Change Data Capture Application stopped.");
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                for (GridComponent comp : kctx) {
                    comp.stop(false);
                }
            }
        }
    }

    protected CdcConsumerState createState(Path stateDir) {
        return new CdcConsumerState(stateDir);
    }

    private StandaloneGridKernalContext startStandaloneKernal() throws IgniteCheckedException {
        StandaloneGridKernalContext kctx = new StandaloneGridKernalContext(this.log, this.binaryMeta, this.marshaller){

            @Override
            protected IgniteConfiguration prepareIgniteConfiguration() {
                IgniteConfiguration cfg = super.prepareIgniteConfiguration();
                cfg.setIgniteInstanceName(CdcMain.cdcInstanceName(CdcMain.this.igniteCfg.getIgniteInstanceName()));
                if (!F.isEmpty(CdcMain.this.cdcCfg.getMetricExporterSpi())) {
                    cfg.setMetricExporterSpi(CdcMain.this.cdcCfg.getMetricExporterSpi());
                }
                IgnitionEx.initializeDefaultMBeanServer(cfg);
                return cfg;
            }
        };
        kctx.resource().setSpringContext(this.ctx);
        for (GridComponent comp : kctx) {
            comp.start();
        }
        this.mreg = kctx.metric().registry("cdc");
        return kctx;
    }

    private void initMetrics() {
        this.mreg.objectMetric(BINARY_META_DIR, String.class, "Binary meta directory").value(this.binaryMeta.getAbsolutePath());
        this.mreg.objectMetric(MARSHALLER_DIR, String.class, "Marshaller directory").value(this.marshaller.getAbsolutePath());
        this.mreg.objectMetric(CDC_DIR, String.class, "CDC directory").value(this.cdcDir.toFile().getAbsolutePath());
        this.curSegmentIdx = this.mreg.longMetric(CUR_SEG_IDX, "Current segment index");
        this.committedSegmentIdx = this.mreg.longMetric(COMMITTED_SEG_IDX, "Committed segment index");
        this.committedSegmentOffset = this.mreg.longMetric(COMMITTED_SEG_OFFSET, "Committed segment offset");
        this.lastSegmentConsumptionTs = this.mreg.longMetric(LAST_SEG_CONSUMPTION_TIME, "Last time of consumption of WAL segment");
    }

    private CdcFileLockHolder lockPds() throws IgniteCheckedException {
        File consIdDir;
        PdsFolderSettings<CdcFileLockHolder> settings = new PdsFolderResolver<CdcFileLockHolder>(this.igniteCfg, this.log, this.igniteCfg.getConsistentId(), this::tryLock).resolve();
        if (settings == null) {
            throw new IgniteException("Can't find the folder to read WAL segments from! [workDir=" + this.igniteCfg.getWorkDirectory() + ", consistentId=" + this.igniteCfg.getConsistentId() + ']');
        }
        CdcFileLockHolder lock = settings.getLockedFileLockHolder();
        if (lock == null && (lock = this.tryLock(consIdDir = settings.persistentStoreNodePath())) == null) {
            throw new IgniteException("Can't acquire lock for Change Data Capture folder [dir=" + consIdDir.getAbsolutePath() + ']');
        }
        return lock;
    }

    public void consumeWalSegmentsUntilStopped() {
        try {
            HashSet<Path> seen = new HashSet<Path>();
            AtomicLong lastSgmnt = new AtomicLong(-1L);
            while (!this.stopped) {
                try (Stream<Path> cdcFiles = Files.walk(this.cdcDir, 1, new FileVisitOption[0]);){
                    HashSet exists = new HashSet();
                    cdcFiles.peek(exists::add).filter(p -> FileWriteAheadLogManager.WAL_SEGMENT_FILE_FILTER.accept(p.toFile()) && !seen.contains(p)).peek(seen::add).sorted(Comparator.comparingLong(this::segmentIndex)).peek(p -> {
                        long nextSgmnt = this.segmentIndex((Path)p);
                        assert (lastSgmnt.get() == -1L || nextSgmnt - lastSgmnt.get() == 1L);
                        lastSgmnt.set(nextSgmnt);
                    }).forEach(this::consumeSegment);
                    seen.removeIf(p -> !exists.contains(p));
                }
                if (this.stopped) continue;
                U.sleep(this.cdcCfg.getCheckFrequency());
            }
        }
        catch (IOException | IgniteInterruptedCheckedException e) {
            throw new IgniteException(e);
        }
    }

    private void consumeSegment(Path segment) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Processing WAL segment [segment=" + segment + ']');
        }
        this.lastSegmentConsumptionTs.value(System.currentTimeMillis());
        IgniteWalIteratorFactory.IteratorParametersBuilder builder = new IgniteWalIteratorFactory.IteratorParametersBuilder().log(this.log).binaryMetadataFileStoreDir(this.binaryMeta).marshallerMappingFileStoreDir(this.marshaller).keepBinary(this.cdcCfg.isKeepBinary()).filesOrDirs(segment.toFile()).addFilter((type, ptr) -> type == WALRecord.RecordType.DATA_RECORD_V2);
        if (this.igniteCfg.getDataStorageConfiguration().getPageSize() != 0) {
            builder.pageSize(this.igniteCfg.getDataStorageConfiguration().getPageSize());
        }
        long segmentIdx = this.segmentIndex(segment);
        this.curSegmentIdx.value(segmentIdx);
        if (this.initState != null) {
            if (segmentIdx > ((WALPointer)this.initState.get1()).index()) {
                throw new IgniteException("Found segment greater then saved state. Some events are missed. Exiting! [state=" + this.initState + ", segment=" + segmentIdx + ']');
            }
            if (segmentIdx < ((WALPointer)this.initState.get1()).index()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Already processed segment found. Skipping and deleting the file [segment=" + segmentIdx + ", state=" + ((WALPointer)this.initState.get1()).index() + ']');
                }
                try {
                    Files.delete(segment);
                    return;
                }
                catch (IOException e) {
                    throw new IgniteException(e);
                }
            }
            builder.from((WALPointer)this.initState.get1());
        }
        try (WalRecordsConsumer.DataEntryIterator iter = new WalRecordsConsumer.DataEntryIterator(this.factory.iterator(builder));){
            if (this.initState != null) {
                iter.init((Integer)this.initState.get2());
                this.initState = null;
            }
            boolean interrupted = Thread.interrupted();
            while (iter.hasNext() && !interrupted) {
                boolean commit = this.consumer.onRecords(iter);
                if (commit) {
                    T2<WALPointer, Integer> curState = iter.state();
                    assert (curState != null);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Saving state [curState=" + curState + ']');
                    }
                    this.state.save(curState);
                    this.committedSegmentIdx.value(((WALPointer)curState.get1()).index());
                    this.committedSegmentOffset.value(((WALPointer)curState.get1()).fileOffset());
                    if (!this.processedSegments.isEmpty()) {
                        for (Path processedSegment : this.processedSegments) {
                            if (processedSegment.equals(segment)) continue;
                            Files.delete(processedSegment);
                        }
                        this.processedSegments.clear();
                    }
                }
                interrupted = Thread.interrupted();
            }
            if (interrupted) {
                throw new IgniteException("Change Data Capture Application interrupted");
            }
            this.processedSegments.add(segment);
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    private CdcFileLockHolder tryLock(File dbStoreDirWithSubdirectory) {
        File cdcRoot = new File(this.igniteCfg.getDataStorageConfiguration().getCdcWalPath());
        if (!cdcRoot.isAbsolute()) {
            cdcRoot = new File(this.igniteCfg.getWorkDirectory(), this.igniteCfg.getDataStorageConfiguration().getCdcWalPath());
        }
        if (!cdcRoot.exists()) {
            this.log.warning("CDC root directory not exists. Should be created by Ignite Node. Is Change Data Capture enabled in IgniteConfiguration? [dir=" + cdcRoot + ']');
            return null;
        }
        Path cdcDir = Paths.get(cdcRoot.getAbsolutePath(), dbStoreDirWithSubdirectory.getName());
        if (!Files.exists(cdcDir, new LinkOption[0])) {
            this.log.warning("CDC directory not exists. Should be created by Ignite Node. Is Change Data Capture enabled in IgniteConfiguration? [dir=" + cdcDir + ']');
            return null;
        }
        this.cdcDir = cdcDir;
        CdcFileLockHolder lock = new CdcFileLockHolder(cdcDir.toString(), "cdc.lock", this.log);
        try {
            lock.tryLock(this.cdcCfg.getLockTimeout());
            return lock;
        }
        catch (IgniteCheckedException e) {
            U.closeQuiet(lock);
            if (this.log.isInfoEnabled()) {
                this.log.info("Unable to acquire lock to lock CDC folder [dir=" + cdcRoot + "]" + IgniteKernal.NL + "Reason: " + e.getMessage());
            }
            return null;
        }
    }

    public long segmentIndex(Path segment) {
        String fn = segment.getFileName().toString();
        return Long.parseLong(fn.substring(0, fn.indexOf(46)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CdcMain cdcMain = this;
        synchronized (cdcMain) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Stopping Change Data Capture service instance");
            }
            this.stopped = true;
        }
    }

    private void ackAsciiLogo() {
        String ver = "ver. " + IgniteVersionUtils.ACK_VER_STR;
        if (this.log.isInfoEnabled()) {
            this.log.info(IgniteKernal.NL + IgniteKernal.NL + ">>>    __________  ________________    ________  _____" + IgniteKernal.NL + ">>>   /  _/ ___/ |/ /  _/_  __/ __/   / ___/ _ \\/ ___/" + IgniteKernal.NL + ">>>  _/ // (7 7    // /  / / / _/    / /__/ // / /__  " + IgniteKernal.NL + ">>> /___/\\___/_/|_/___/ /_/ /___/    \\___/____/\\___/  " + IgniteKernal.NL + ">>> " + IgniteKernal.NL + ">>> " + ver + IgniteKernal.NL + ">>> " + IgniteVersionUtils.COPYRIGHT + IgniteKernal.NL + ">>> " + IgniteKernal.NL + ">>> Ignite documentation: http://" + "ignite.apache.org" + IgniteKernal.NL + ">>> Consumer: " + U.toStringSafe(this.consumer.consumer()) + IgniteKernal.NL + ">>> ConsistentId: " + this.igniteCfg.getConsistentId() + IgniteKernal.NL);
        }
        if (this.log.isQuiet()) {
            U.quiet(false, "   __________  ________________    ________  _____", "  /  _/ ___/ |/ /  _/_  __/ __/   / ___/ _ \\/ ___/", " _/ // (7 7    // /  / / / _/    / /__/ // / /__  ", "/___/\\___/_/|_/___/ /_/ /___/    \\___/____/\\___/  ", "", ver, IgniteVersionUtils.COPYRIGHT, "", "Ignite documentation: http://ignite.apache.org", "Consumer: " + U.toStringSafe(this.consumer.consumer()), "ConsistentId: " + this.igniteCfg.getConsistentId(), "", "Quiet mode.");
            String fileName = this.log.fileName();
            if (fileName != null) {
                U.quiet(false, "  ^-- Logging to file '" + fileName + '\'');
            }
            if (this.log instanceof GridLoggerProxy) {
                U.quiet(false, "  ^-- Logging by '" + ((GridLoggerProxy)this.log).getLoggerInfo() + '\'');
            }
            U.quiet(false, "  ^-- To see **FULL** console log here add -DIGNITE_QUIET=false or \"-v\" to ignite-cdc.{sh|bat}", "");
        }
    }

    public static String cdcInstanceName(String igniteInstanceName) {
        return "cdc-" + igniteInstanceName;
    }
}

