/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemView;
import org.h2.table.Column;
import org.h2.value.DataType;

public class SqlViewColumnView {
    private final SqlSystemView view;
    private final Column col;

    public SqlViewColumnView(SqlSystemView view, Column col) {
        this.view = view;
        this.col = col;
    }

    @Order
    public String columnName() {
        return this.col.getName();
    }

    @Order(value=2)
    public String schemaName() {
        return QueryUtils.SCHEMA_SYS;
    }

    @Order(value=1)
    public String viewName() {
        return this.view.getTableName();
    }

    public String type() {
        return DataType.getTypeClassName((int)this.col.getType());
    }

    public String defaultValue() {
        return String.valueOf(this.col.getDefaultExpression());
    }

    public long precision() {
        return this.col.getPrecision();
    }

    public int scale() {
        return this.col.getScale();
    }

    public boolean nullable() {
        return this.col.isNullable();
    }
}

