/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.messages;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.query.stat.StatisticsType;
import org.apache.ignite.internal.processors.query.stat.messages.StatisticsKeyMessage;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class StatisticsRequest
implements Message {
    private static final long serialVersionUID = 0L;
    public static final short TYPE_CODE = 186;
    private UUID reqId;
    private StatisticsKeyMessage key;
    private StatisticsType type;
    @GridDirectMap(keyType=String.class, valueType=Long.class)
    private Map<String, Long> versions;
    private AffinityTopologyVersion topVer;

    public StatisticsRequest() {
    }

    public StatisticsRequest(UUID reqId, StatisticsKeyMessage key, StatisticsType type, AffinityTopologyVersion topVer, Map<String, Long> versions) {
        this.reqId = reqId;
        this.key = key;
        this.type = type;
        this.topVer = topVer;
        this.versions = versions;
    }

    public UUID reqId() {
        return this.reqId;
    }

    public StatisticsType type() {
        return this.type;
    }

    public StatisticsKeyMessage key() {
        return this.key;
    }

    public AffinityTopologyVersion topVer() {
        return this.topVer;
    }

    public Map<String, Long> versions() {
        return this.versions;
    }

    public String toString() {
        return S.toString(StatisticsRequest.class, (Object)this);
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("key", (Message)this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeUuid("reqId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByte("type", this.type != null ? (byte)this.type.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMap("versions", this.versions, MessageCollectionItemType.STRING, MessageCollectionItemType.LONG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.key = (StatisticsKeyMessage)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.reqId = reader.readUuid("reqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                byte typeOrd = reader.readByte("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.type = StatisticsType.fromOrdinal(typeOrd);
                reader.incrementState();
            }
            case 4: {
                this.versions = reader.readMap("versions", MessageCollectionItemType.STRING, MessageCollectionItemType.LONG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(StatisticsRequest.class);
    }

    public short directType() {
        return 186;
    }

    public byte fieldsCount() {
        return 5;
    }

    public void onAckReceived() {
    }
}

