/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedEnumProperty;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.stat.BusyExecutor;
import org.apache.ignite.internal.processors.query.stat.IgniteGlobalStatisticsManager;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsConfigurationManager;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsDummyStoreImpl;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsHelper;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsInMemoryStoreImpl;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsManager;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsPersistenceStoreImpl;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsRepository;
import org.apache.ignite.internal.processors.query.stat.IgniteStatisticsStore;
import org.apache.ignite.internal.processors.query.stat.LocalStatisticsGatheringContext;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.ObjectPartitionStatisticsObsolescence;
import org.apache.ignite.internal.processors.query.stat.ObjectStatistics;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsEvent;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;
import org.apache.ignite.internal.processors.query.stat.StatisticsProcessor;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.StatisticsUsageState;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;

public class IgniteStatisticsManagerImpl
implements IgniteStatisticsManager {
    private static final int STATS_POOL_SIZE = 4;
    private static final StatisticsUsageState DEFAULT_STATISTICS_USAGE_STATE = StatisticsUsageState.ON;
    private static final int OBSOLESCENCE_INTERVAL = 60;
    private final IgniteLogger log;
    private final GridKernalContext ctx;
    private final SchemaManager schemaMgr;
    private final IgniteStatisticsRepository statsRepos;
    private final IgniteGlobalStatisticsManager globalStatsMgr;
    private final IgniteStatisticsHelper helper;
    private final StatisticsProcessor statProc;
    private final IgniteStatisticsConfigurationManager statCfgMgr;
    private final IgniteThreadPoolExecutor mgmtPool;
    private final BusyExecutor obsolescenceBusyExecutor;
    private final IgniteThreadPoolExecutor gatherPool;
    private final DistributedEnumProperty<StatisticsUsageState> usageState = new DistributedEnumProperty("statistics.usage.state", StatisticsUsageState::fromOrdinal, StatisticsUsageState::index, StatisticsUsageState.class);
    private volatile StatisticsUsageState lastUsageState = null;
    private boolean started = false;
    private GridTimeoutProcessor.CancelableTask obsolescenceSchedule;
    private final PartitionsExchangeAware exchAwareLsnr = new PartitionsExchangeAware(){

        public void onDoneAfterTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
            if (fut.exchangeType() != GridDhtPartitionsExchangeFuture.ExchangeType.ALL) {
                return;
            }
            ClusterState newState = IgniteStatisticsManagerImpl.this.ctx.state().clusterState().state();
            if (newState.active() && !IgniteStatisticsManagerImpl.this.started) {
                IgniteStatisticsManagerImpl.this.tryStart();
            }
            if (!newState.active() && IgniteStatisticsManagerImpl.this.started) {
                IgniteStatisticsManagerImpl.this.tryStop();
            }
            if (IgniteStatisticsManagerImpl.this.started) {
                IgniteStatisticsManagerImpl.this.statCfgMgr.afterTopologyUnlock(fut);
            }
        }
    };

    public IgniteStatisticsManagerImpl(GridKernalContext ctx, SchemaManager schemaMgr) {
        this.ctx = ctx;
        this.schemaMgr = schemaMgr;
        boolean serverNode = ctx.config().isClientMode() == false && !ctx.isDaemon();
        this.helper = new IgniteStatisticsHelper(ctx.localNodeId(), schemaMgr, arg_0 -> ((GridKernalContext)ctx).log(arg_0));
        this.log = ctx.log(IgniteStatisticsManagerImpl.class);
        IgniteCacheDatabaseSharedManager db = GridCacheUtils.isPersistenceEnabled((IgniteConfiguration)ctx.config()) ? ctx.cache().context().database() : null;
        this.gatherPool = serverNode ? new IgniteThreadPoolExecutor("stat-gather", ctx.igniteInstanceName(), 0, 4, 60000L, new LinkedBlockingQueue(), -1, ctx.uncaughtExceptionHandler()) : null;
        this.mgmtPool = new IgniteThreadPoolExecutor("stat-mgmt", ctx.igniteInstanceName(), 0, 1, 60000L, new LinkedBlockingQueue(), -1, ctx.uncaughtExceptionHandler());
        this.obsolescenceBusyExecutor = new BusyExecutor("obsolescence", this.mgmtPool, () -> ((GridKernalContext)ctx).isStopping(), arg_0 -> ((GridKernalContext)ctx).log(arg_0));
        IgniteStatisticsStore store = !serverNode ? new IgniteStatisticsDummyStoreImpl(arg_0 -> ((GridKernalContext)ctx).log(arg_0)) : (db == null ? new IgniteStatisticsInMemoryStoreImpl(arg_0 -> ((GridKernalContext)ctx).log(arg_0)) : new IgniteStatisticsPersistenceStoreImpl(ctx.internalSubscriptionProcessor(), db, arg_0 -> ((GridKernalContext)ctx).log(arg_0)));
        this.statsRepos = new IgniteStatisticsRepository(store, ctx.systemView(), this.helper, arg_0 -> ((GridKernalContext)ctx).log(arg_0));
        this.statProc = serverNode ? new StatisticsProcessor(this.statsRepos, this.gatherPool, () -> ((GridKernalContext)ctx).isStopping(), arg_0 -> ((GridKernalContext)ctx).log(arg_0)) : null;
        this.statCfgMgr = new IgniteStatisticsConfigurationManager(schemaMgr, ctx.internalSubscriptionProcessor(), ctx.systemView(), ctx.state(), this.statProc, db != null, this.mgmtPool, () -> ((GridKernalContext)ctx).isStopping(), arg_0 -> ((GridKernalContext)ctx).log(arg_0), serverNode);
        this.globalStatsMgr = new IgniteGlobalStatisticsManager(this, ctx.systemView(), this.mgmtPool, ctx.discovery(), ctx.state(), ctx.cache().context().exchange(), this.helper, ctx.io(), arg_0 -> ((GridKernalContext)ctx).log(arg_0));
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(dispatcher -> {
            this.usageState.addListener((name, oldVal, newVal) -> {
                if (this.log.isInfoEnabled()) {
                    this.log.info(String.format("Statistics usage state was changed from %s to %s", oldVal, newVal));
                }
                this.lastUsageState = newVal;
                if (oldVal == newVal) {
                    return;
                }
                if (newVal == StatisticsUsageState.ON || newVal == StatisticsUsageState.NO_UPDATE) {
                    this.tryStart();
                }
                if (newVal == StatisticsUsageState.OFF) {
                    this.tryStop();
                }
            });
            dispatcher.registerProperty(this.usageState);
        });
        this.tryStart();
        if (serverNode) {
            this.obsolescenceSchedule = ctx.timeout().schedule(() -> this.obsolescenceBusyExecutor.execute(() -> this.processObsolescence()), 60000L, 60000L);
        }
        ctx.cache().context().exchange().registerExchangeAwareComponent(this.exchAwareLsnr);
    }

    private synchronized void tryStop() {
        StatisticsUsageState statUsageState = this.usageState();
        if ((ClusterState.ACTIVE != this.ctx.state().clusterState().state() || this.ctx.isStopping() || statUsageState != StatisticsUsageState.ON && statUsageState != StatisticsUsageState.NO_UPDATE) && this.started) {
            this.stopX();
        }
    }

    private void stopX() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Stopping statistics subsystem");
        }
        this.globalStatsMgr.stop();
        this.statCfgMgr.stop();
        if (this.statProc != null) {
            this.statProc.stop();
        }
        this.statsRepos.stop();
        this.obsolescenceBusyExecutor.deactivate();
        this.started = false;
    }

    private synchronized void tryStart() {
        StatisticsUsageState statUsageState = this.usageState();
        if (!(ClusterState.ACTIVE != this.ctx.state().clusterState().state() || this.ctx.isStopping() || statUsageState != StatisticsUsageState.ON && statUsageState != StatisticsUsageState.NO_UPDATE || this.started)) {
            this.startX();
        }
    }

    private void startX() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting statistics subsystem...");
        }
        this.obsolescenceBusyExecutor.activate();
        this.statsRepos.start();
        if (this.statProc != null) {
            this.statProc.start();
        }
        this.statCfgMgr.start();
        this.globalStatsMgr.start();
        this.started = true;
    }

    public IgniteStatisticsRepository statisticsRepository() {
        return this.statsRepos;
    }

    public ObjectStatistics getLocalStatistics(StatisticsKey key) {
        StatisticsUsageState currState = this.usageState();
        return currState == StatisticsUsageState.ON || currState == StatisticsUsageState.NO_UPDATE ? this.statsRepos.getLocalStatistics(key, null) : null;
    }

    public ObjectStatisticsImpl getLocalStatistics(StatisticsKey key, AffinityTopologyVersion topVer) {
        return this.statsRepos.getLocalStatistics(key, topVer);
    }

    public ObjectStatistics getGlobalStatistics(StatisticsKey key) {
        StatisticsUsageState currState = this.usageState();
        return currState == StatisticsUsageState.ON || currState == StatisticsUsageState.NO_UPDATE ? this.globalStatsMgr.getGlobalStatistics(key) : null;
    }

    public void collectStatistics(StatisticsObjectConfiguration ... targets) throws IgniteCheckedException {
        this.ensureActive("collect statistics");
        if (this.usageState() == StatisticsUsageState.OFF) {
            throw new IgniteException("Can't gather statistics while statistics usage state is OFF.");
        }
        this.statCfgMgr.updateStatistics(targets);
    }

    public void dropStatistics(StatisticsTarget ... targets) throws IgniteCheckedException {
        this.ensureActive("drop statistics");
        if (this.usageState() == StatisticsUsageState.OFF) {
            throw new IgniteException("Can't drop statistics while statistics usage state is OFF.");
        }
        this.statCfgMgr.dropStatistics(Arrays.asList(targets), true);
    }

    public void refreshStatistics(StatisticsTarget ... targets) throws IgniteCheckedException {
        this.ensureActive("refresh statistics");
        if (this.usageState() == StatisticsUsageState.OFF) {
            throw new IgniteException("Can't refresh statistics while statistics usage state is OFF.");
        }
        this.statCfgMgr.refreshStatistics(Arrays.asList(targets));
    }

    public void dropAll() throws IgniteCheckedException {
        this.ensureActive("drop all statistics");
        this.statCfgMgr.dropAll();
    }

    public void stop() {
        List unfinishedTasks;
        this.stopX();
        if (this.obsolescenceSchedule != null) {
            this.obsolescenceSchedule.close();
        }
        if (this.gatherPool != null && !(unfinishedTasks = this.gatherPool.shutdownNow()).isEmpty()) {
            this.log.warning(String.format("%d statistics collection cancelled.", unfinishedTasks.size()));
        }
        if (this.mgmtPool != null && !(unfinishedTasks = this.mgmtPool.shutdownNow()).isEmpty()) {
            this.log.warning(String.format("%d statistics configuration change handler cancelled.", unfinishedTasks.size()));
        }
    }

    public IgniteStatisticsConfigurationManager statisticConfiguration() {
        return this.statCfgMgr;
    }

    public void usageState(StatisticsUsageState state) throws IgniteCheckedException {
        this.ensureActive("change usage state of statistics");
        try {
            this.usageState.propagate((Enum)state);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Unable to set usage state value due to " + e.getMessage(), (Throwable)e);
        }
    }

    public StatisticsUsageState usageState() {
        return this.lastUsageState == null ? DEFAULT_STATISTICS_USAGE_STATE : this.lastUsageState;
    }

    public void onRowUpdated(String schemaName, String objName, int partId, byte[] keyBytes) {
        ObjectPartitionStatisticsObsolescence statObs = this.statsRepos.getObsolescence(new StatisticsKey(schemaName, objName), partId);
        if (statObs != null) {
            statObs.onModified(keyBytes);
        }
    }

    public synchronized void processObsolescence() {
        List<StatisticsKey> keys;
        StatisticsUsageState usageState = this.usageState();
        if (usageState != StatisticsUsageState.ON || this.ctx.isStopping()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skipping obsolescence processing.");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Process statistics obsolescence started.");
        }
        if (F.isEmpty(keys = this.statsRepos.getObsolescenceKeys())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("No obsolescence info found. Finish obsolescence processing.");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format("Scheduling obsolescence savings for %d targets", keys.size()));
        }
        for (StatisticsKey key : keys) {
            StatisticsObjectConfiguration cfg = null;
            try {
                cfg = this.statCfgMgr.config(key);
            }
            catch (IgniteCheckedException igniteCheckedException) {
                // empty catch block
            }
            Set<Integer> tasksParts = this.calculateObsolescencedPartitions(cfg, this.statsRepos.getObsolescence(key));
            GridH2Table tbl = this.schemaMgr.dataTable(key.schema(), key.obj());
            if (tbl == null && this.log.isDebugEnabled()) {
                this.log.debug(String.format("Got obsolescence statistics for unknown table %s", key));
            }
            LocalStatisticsGatheringContext ctx = new LocalStatisticsGatheringContext(true, tbl, cfg, tasksParts, null);
            this.statProc.updateLocalStatistics(ctx);
        }
    }

    private Set<Integer> calculateObsolescencedPartitions(StatisticsObjectConfiguration cfg, IntMap<ObjectPartitionStatisticsObsolescence> parts) {
        HashSet<Integer> res = new HashSet<Integer>();
        parts.forEach((k, v) -> {
            ObjectPartitionStatisticsImpl partStat = this.statsRepos.getLocalPartitionStatistics(cfg.key(), k);
            if (partStat == null || partStat.rowCount() == 0L || (double)v.modified() * 100.0 / (double)partStat.rowCount() > (double)cfg.maxPartitionObsolescencePercent()) {
                res.add(k);
            }
        });
        return res;
    }

    public void subscribeToLocalStatistics(Consumer<ObjectStatisticsEvent> subscriber) {
        this.statsRepos.subscribeToLocalStatistics(subscriber);
    }

    public void subscribeToStatisticsConfig(Consumer<StatisticsObjectConfiguration> subscriber) {
        this.statCfgMgr.subscribe(subscriber);
    }

    public void ensureActive(String op) {
        if (this.ctx.state().clusterState().state() != ClusterState.ACTIVE) {
            throw new IgniteException(String.format("Unable to perform %s due to cluster state [state=%s]", op, this.ctx.state().clusterState().state()));
        }
    }
}

