/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.maintenance;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.IndexDefinition;
import org.apache.ignite.internal.cache.query.index.IndexFactory;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexFactory;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.cache.query.index.sorted.maintenance.MaintenanceRebuildIndexTarget;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.aware.IndexBuildStatusStorage;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.schema.IndexRebuildCancelToken;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorImpl;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.h2.engine.Session;
import org.jetbrains.annotations.Nullable;

public class RebuildIndexAction
implements MaintenanceAction<Boolean> {
    private final List<MaintenanceRebuildIndexTarget> indexesToRebuild;
    private final IgniteH2Indexing indexing;
    private final IgniteLogger log;

    public RebuildIndexAction(List<MaintenanceRebuildIndexTarget> indexesToRebuild, IgniteH2Indexing indexing, IgniteLogger log) {
        this.indexesToRebuild = indexesToRebuild;
        this.indexing = indexing;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean execute() {
        GridKernalContext kernalContext = this.indexing.kernalContext();
        GridCacheDatabaseSharedManager database = (GridCacheDatabaseSharedManager)kernalContext.cache().context().database();
        CheckpointManager manager = database.getCheckpointManager();
        IndexBuildStatusStorage storage = this.getIndexBuildStatusStorage(kernalContext);
        try {
            this.prepareForRebuild(database, manager, storage);
            for (MaintenanceRebuildIndexTarget params : this.indexesToRebuild) {
                int cacheId = params.cacheId();
                String idxName = params.idxName();
                try {
                    this.execute0(cacheId, idxName, kernalContext, storage, manager);
                }
                catch (Exception e) {
                    this.log.error("Rebuilding index " + idxName + " for cache " + cacheId + " failed", (Throwable)e);
                    Boolean bl = false;
                    this.cleanUpAfterRebuild(manager, storage);
                    return bl;
                }
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to prepare for the rebuild of indexes", (Throwable)e);
            Boolean bl = false;
            return bl;
        }
        finally {
            this.cleanUpAfterRebuild(manager, storage);
        }
        this.unregisterMaintenanceTask(kernalContext);
        return true;
    }

    private void execute0(int cacheId, String idxName, GridKernalContext kernalContext, IndexBuildStatusStorage storage, CheckpointManager manager) throws Exception {
        SchemaManager schemaManager;
        GridCacheContext context = kernalContext.cache().context().cacheContext(cacheId);
        String cacheName = context.name();
        H2TreeIndex targetIndex = this.findIndex(cacheName, idxName, schemaManager = this.indexing.schemaManager());
        if (targetIndex == null) {
            return;
        }
        GridH2Table targetTable = targetIndex.getTable();
        this.destroyOldIndex(targetIndex, targetTable);
        this.recreateIndex(targetIndex, context, cacheName, storage, schemaManager, targetTable);
        manager.forceCheckpoint("afterIndexRebuild", null).futureFor(CheckpointState.FINISHED).get();
    }

    private void recreateIndex(H2TreeIndex oldIndex, final GridCacheContext<?, ?> context, final String cacheName, final IndexBuildStatusStorage storage, SchemaManager schemaManager, GridH2Table targetTable) throws IgniteCheckedException {
        GridFutureAdapter createIdxFut = new GridFutureAdapter();
        IndexRebuildCancelToken token = new IndexRebuildCancelToken();
        SchemaIndexCacheVisitorImpl visitor = new SchemaIndexCacheVisitorImpl(context, token, createIdxFut){

            public void visit(SchemaIndexCacheVisitorClosure clo) {
                storage.onStartRebuildIndexes(context);
                try {
                    super.visit(clo);
                    this.buildIdxFut.get();
                }
                catch (Exception e) {
                    throw new IgniteException((Throwable)e);
                }
                finally {
                    storage.onFinishRebuildIndexes(cacheName);
                }
            }
        };
        IndexProcessor indexProcessor = context.kernalContext().indexProcessor();
        SortedIndexDefinition definition = oldIndex.index().indexDefinition();
        Index newIndex = indexProcessor.createIndexDynamically(targetTable.cacheContext(), (IndexFactory)InlineIndexFactory.INSTANCE, (IndexDefinition)definition, (SchemaIndexCacheVisitor)visitor);
        InlineIndexImpl queryIndex = (InlineIndexImpl)newIndex.unwrap(InlineIndexImpl.class);
        H2TreeIndex newIdx = oldIndex.createCopy(queryIndex, definition);
        schemaManager.createIndex(targetTable.getSchema().getName(), targetTable.getName(), newIdx, true);
        assert (createIdxFut.isDone());
    }

    private void destroyOldIndex(H2TreeIndex index, GridH2Table table) throws IgniteCheckedException {
        index.destroyImmediately();
        Session session = table.getDatabase().getSystemSession();
        table.removeIndex(session, (org.h2.index.Index)index);
    }

    @Nullable
    private H2TreeIndex findIndex(String cacheName, String idxName, SchemaManager schemaManager) {
        H2TreeIndex targetIndex = null;
        for (H2TableDescriptor tblDesc : schemaManager.tablesForCache(cacheName)) {
            GridH2Table tbl = tblDesc.table();
            assert (tbl != null);
            org.h2.index.Index index = tbl.getIndex(idxName);
            if (index == null) continue;
            assert (index instanceof H2TreeIndex);
            targetIndex = (H2TreeIndex)index;
            break;
        }
        return targetIndex;
    }

    private void prepareForRebuild(GridCacheDatabaseSharedManager database, CheckpointManager manager, IndexBuildStatusStorage storage) throws IgniteCheckedException {
        database.resumeWalLogging();
        database.onStateRestored(null);
        manager.addCheckpointListener((CheckpointListener)storage, null);
    }

    private void cleanUpAfterRebuild(CheckpointManager manager, IndexBuildStatusStorage storage) {
        manager.removeCheckpointListener((CheckpointListener)storage);
    }

    private void unregisterMaintenanceTask(GridKernalContext kernalContext) {
        kernalContext.maintenanceRegistry().unregisterMaintenanceTask("indexRebuildMaintenanceTask");
    }

    private IndexBuildStatusStorage getIndexBuildStatusStorage(GridKernalContext kernalContext) {
        GridQueryProcessor query = kernalContext.query();
        return query.getIdxBuildStatusStorage();
    }

    public String name() {
        return "rebuild";
    }

    @Nullable
    public String description() {
        return "Rebuilding indexes";
    }
}

