/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import java.lang.reflect.Array;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryArray;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.DmlStatementsProcessor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.dml.DmlBatchSender;
import org.apache.ignite.internal.processors.query.h2.dml.UpdatePlan;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.transactions.TransactionDuplicateKeyException;
import org.h2.util.DateTimeUtils;
import org.h2.util.LocalDateTimeUtils;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class DmlUtils {
    public static Object convert(Object val, GridH2RowDescriptor desc, Class<?> expCls, int type, String columnName) {
        if (val == null) {
            return null;
        }
        Class<?> currCls = val.getClass();
        try {
            if (val instanceof Date && currCls != Date.class && expCls == Date.class) {
                return new Date(((Date)val).getTime());
            }
            if (type == 20 && currCls == byte[].class) {
                return U.unmarshal((Marshaller)desc.context().marshaller(), (byte[])((byte[])val), (ClassLoader)U.resolveClassLoader((IgniteConfiguration)desc.context().gridConfig()));
            }
            if (val instanceof Timestamp && LocalDateTimeUtils.LOCAL_DATE_TIME == expCls) {
                return LocalDateTimeUtils.valueToLocalDateTime((Value)ValueTimestamp.get((Timestamp)((Timestamp)val)));
            }
            if (val instanceof Date && LocalDateTimeUtils.LOCAL_DATE == expCls) {
                return LocalDateTimeUtils.valueToLocalDate((Value)ValueDate.fromDateValue((long)DateTimeUtils.dateValueFromDate((long)((Date)val).getTime())));
            }
            if (val instanceof Time && LocalDateTimeUtils.LOCAL_TIME == expCls) {
                return LocalDateTimeUtils.valueToLocalTime((Value)ValueTime.get((Time)((Time)val)));
            }
            if (type == 17 && val instanceof BinaryArray) {
                return val;
            }
            if (type == 17 && currCls != expCls) {
                if (currCls != Object[].class) {
                    throw new IgniteCheckedException("Unexpected array type - only conversion from Object[] is assumed");
                }
                assert (expCls.isArray());
                Object[] curr = (Object[])val;
                Object newArr = Array.newInstance(expCls.getComponentType(), curr.length);
                System.arraycopy(curr, 0, newArr, 0, curr.length);
                return newArr;
            }
            Object res = H2Utils.convert(val, desc.indexing(), type);
            if (res instanceof Date && res.getClass() != Date.class && expCls == Date.class) {
                return new Date(((Date)res).getTime());
            }
            return res;
        }
        catch (Exception e) {
            throw new IgniteSQLException("Value conversion failed [column=" + columnName + ", from=" + currCls.getName() + ", to=" + expCls.getName() + ']', 3013, (Throwable)e);
        }
    }

    public static boolean isBatched(SqlFieldsQuery qry) {
        return qry instanceof SqlFieldsQueryEx && ((SqlFieldsQueryEx)qry).isBatched();
    }

    public static UpdateResult processSelectResult(UpdatePlan plan, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        switch (plan.mode()) {
            case MERGE: {
                return new UpdateResult(DmlUtils.doMerge(plan, cursor, pageSize), X.EMPTY_OBJECT_ARRAY);
            }
            case INSERT: {
                return new UpdateResult(DmlUtils.dmlDoInsert(plan, cursor, pageSize), X.EMPTY_OBJECT_ARRAY);
            }
            case UPDATE: {
                return DmlUtils.doUpdate(plan, cursor, pageSize);
            }
            case DELETE: {
                return DmlUtils.doDelete(plan.cacheContext(), cursor, pageSize);
            }
        }
        throw new IgniteSQLException("Unexpected DML operation [mode=" + (Object)((Object)plan.mode()) + ']', 2001);
    }

    private static long dmlDoInsert(UpdatePlan plan, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        GridCacheContext cctx = plan.cacheContext();
        if (plan.rowCount() == 1) {
            IgniteBiTuple<?, ?> t = plan.processRow(cursor.iterator().next());
            Throwable throwable = null;
            try (MTC.TraceSurroundings ignored = MTC.support((Span)cctx.kernalContext().tracing().create(SpanType.SQL_CACHE_UPDATE, MTC.span()).addTag("sql.cache.updates", () -> "1"));){
                if (cctx.cache().putIfAbsent(t.getKey(), t.getValue())) {
                    long l = 1L;
                    return l;
                }
                try {
                    throw new TransactionDuplicateKeyException("Duplicate key during INSERT [key=" + t.getKey() + ']');
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        DmlBatchSender sender = new DmlBatchSender(cctx, pageSize, 1);
        for (List<?> row : cursor) {
            IgniteBiTuple<?, ?> keyValPair = plan.processRow(row);
            sender.add(keyValPair.getKey(), new DmlStatementsProcessor.InsertEntryProcessor(keyValPair.getValue()), 0);
        }
        sender.flush();
        SQLException resEx = sender.error();
        if (!F.isEmpty(sender.failedKeys())) {
            String msg = "Failed to INSERT some keys because they are already in cache [keys=" + sender.failedKeys() + ']';
            SQLException dupEx = new SQLException(msg, "23000");
            if (resEx == null) {
                resEx = dupEx;
            } else {
                resEx.setNextException(dupEx);
            }
        }
        if (resEx != null) {
            throw new IgniteSQLException(resEx);
        }
        return sender.updateCount();
    }

    private static UpdateResult doUpdate(UpdatePlan plan, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        GridCacheContext cctx = plan.cacheContext();
        DmlBatchSender sender = new DmlBatchSender(cctx, pageSize, 1);
        for (List<?> row : cursor) {
            T3<Object, Object, Object> row0 = plan.processRowForUpdate(row);
            Object key = row0.get1();
            Object oldVal = row0.get2();
            Object newVal = row0.get3();
            sender.add(key, new DmlStatementsProcessor.ModifyingEntryProcessor(oldVal, new DmlStatementsProcessor.EntryValueUpdater(newVal)), 0);
        }
        sender.flush();
        SQLException resEx = sender.error();
        if (resEx != null) {
            if (!F.isEmpty(sender.failedKeys())) {
                String msg = "Failed to UPDATE some keys because they had been modified concurrently [keys=" + sender.failedKeys() + ']';
                SQLException dupEx = IgniteQueryErrorCode.createJdbcSqlException((String)msg, (int)4002);
                dupEx.setNextException(resEx);
                resEx = dupEx;
            }
            throw new IgniteSQLException(resEx);
        }
        return new UpdateResult(sender.updateCount(), sender.failedKeys().toArray(), cursor instanceof QueryCursorImpl ? ((QueryCursorImpl)cursor).partitionResult() : null);
    }

    private static long doMerge(UpdatePlan plan, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        GridCacheContext cctx = plan.cacheContext();
        if (plan.rowCount() == 1) {
            IgniteBiTuple<?, ?> t = plan.processRow(cursor.iterator().next());
            try (MTC.TraceSurroundings ignored = MTC.support((Span)cctx.kernalContext().tracing().create(SpanType.SQL_CACHE_UPDATE, MTC.span()).addTag("sql.cache.updates", () -> "1"));){
                cctx.cache().put(t.getKey(), t.getValue());
            }
            return 1L;
        }
        int resCnt = 0;
        LinkedHashMap<Object, Object> rows = new LinkedHashMap<Object, Object>();
        Iterator<List<?>> it = cursor.iterator();
        while (it.hasNext()) {
            List<?> row = it.next();
            IgniteBiTuple<?, ?> t = plan.processRow(row);
            rows.put(t.getKey(), t.getValue());
            if ((pageSize <= 0 || rows.size() != pageSize) && it.hasNext()) continue;
            MTC.TraceSurroundings ignored = MTC.support((Span)cctx.kernalContext().tracing().create(SpanType.SQL_CACHE_UPDATE, MTC.span()).addTag("sql.cache.updates", () -> Integer.toString(rows.size())));
            Throwable throwable = null;
            try {
                cctx.cache().putAll(rows);
                resCnt += rows.size();
                if (!it.hasNext()) continue;
                rows.clear();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        return resCnt;
    }

    private static UpdateResult doDelete(GridCacheContext cctx, Iterable<List<?>> cursor, int pageSize) throws IgniteCheckedException {
        DmlBatchSender sender = new DmlBatchSender(cctx, pageSize, 1);
        for (List<?> row : cursor) {
            if (row.size() != 2) continue;
            Object key = row.get(0);
            ClusterNode node = sender.primaryNodeByKey(key);
            IgniteInClosure<MutableEntry<Object, Object>> rmvC = DmlStatementsProcessor.getRemoveClosure(node, key);
            sender.add(key, new DmlStatementsProcessor.ModifyingEntryProcessor(row.get(1), rmvC), 0);
        }
        sender.flush();
        SQLException resEx = sender.error();
        if (resEx != null) {
            if (!F.isEmpty(sender.failedKeys())) {
                String msg = "Failed to DELETE some keys because they had been modified concurrently [keys=" + sender.failedKeys() + ']';
                SQLException conEx = IgniteQueryErrorCode.createJdbcSqlException((String)msg, (int)4002);
                conEx.setNextException(resEx);
                resEx = conEx;
            }
            throw new IgniteSQLException(resEx);
        }
        return new UpdateResult(sender.updateCount(), sender.failedKeys().toArray(), cursor instanceof QueryCursorImpl ? ((QueryCursorImpl)cursor).partitionResult() : null);
    }

    public static List<UpdateResult> processSelectResultBatched(UpdatePlan plan, List<List<List<?>>> rows, int pageSize) throws IgniteCheckedException {
        switch (plan.mode()) {
            case MERGE: {
                throw new IgniteCheckedException("Unsupported, fix");
            }
            case INSERT: {
                return DmlUtils.doInsertBatched(plan, rows, pageSize);
            }
        }
        throw new IgniteSQLException("Unexpected batched DML operation [mode=" + (Object)((Object)plan.mode()) + ']', 2001);
    }

    private static List<UpdateResult> doInsertBatched(UpdatePlan plan, List<List<List<?>>> cursor, int pageSize) throws IgniteCheckedException {
        SQLException e;
        GridCacheContext cctx = plan.cacheContext();
        DmlBatchSender snd = new DmlBatchSender(cctx, pageSize, cursor.size());
        int rowNum = 0;
        SQLException resEx = null;
        for (List<List<?>> qryRow : cursor) {
            for (List<?> row : qryRow) {
                try {
                    IgniteBiTuple<?, ?> keyValPair = plan.processRow(row);
                    snd.add(keyValPair.getKey(), new DmlStatementsProcessor.InsertEntryProcessor(keyValPair.getValue()), rowNum);
                }
                catch (Exception e2) {
                    int code;
                    String sqlState;
                    if (e2 instanceof IgniteSQLException) {
                        sqlState = ((IgniteSQLException)((Object)e2)).sqlState();
                        code = ((IgniteSQLException)((Object)e2)).statusCode();
                    } else {
                        sqlState = "50000";
                        code = 1;
                    }
                    resEx = DmlUtils.chainException(resEx, new SQLException(e2.getMessage(), sqlState, code, e2));
                    snd.setFailed(rowNum);
                }
            }
            ++rowNum;
        }
        try {
            snd.flush();
        }
        catch (Exception e3) {
            resEx = DmlUtils.chainException(resEx, new SQLException(e3.getMessage(), "50000", 1, e3));
        }
        resEx = DmlUtils.chainException(resEx, snd.error());
        if (!F.isEmpty(snd.failedKeys())) {
            e = new SQLException("Failed to INSERT some keys because they are already in cache [keys=" + snd.failedKeys() + ']', "23000", 4001);
            resEx = DmlUtils.chainException(resEx, e);
        }
        if (resEx != null) {
            e = new BatchUpdateException(resEx.getMessage(), resEx.getSQLState(), resEx.getErrorCode(), snd.perRowCounterAsArray(), (Throwable)resEx);
            throw new IgniteCheckedException((Throwable)e);
        }
        int[] cntPerRow = snd.perRowCounterAsArray();
        ArrayList<UpdateResult> res = new ArrayList<UpdateResult>(cntPerRow.length);
        for (int i = 0; i < cntPerRow.length; ++i) {
            int cnt = cntPerRow[i];
            res.add(new UpdateResult(cnt, X.EMPTY_OBJECT_ARRAY));
        }
        return res;
    }

    public static SQLException chainException(SQLException main, SQLException add) {
        if (main == null) {
            if (add != null) {
                main = add;
                return main;
            }
            return null;
        }
        main.setNextException(add);
        return main;
    }

    public static CacheOperationContext setKeepBinaryContext(GridCacheContext<?, ?> cctx) {
        CacheOperationContext opCtx = cctx.operationContextPerCall();
        if (cctx.binaryMarshaller()) {
            CacheOperationContext newOpCtx = null;
            if (opCtx == null) {
                newOpCtx = new CacheOperationContext(false, true, null, false, null, false, null, true);
            } else if (!opCtx.isKeepBinary()) {
                newOpCtx = opCtx.keepBinary();
            }
            if (newOpCtx != null) {
                cctx.operationContextPerCall(newOpCtx);
            }
        }
        return opCtx;
    }

    public static void restoreKeepBinaryContext(GridCacheContext<?, ?> cctx, CacheOperationContext oldOpCtx) {
        cctx.operationContextPerCall(oldOpCtx);
    }

    private DmlUtils() {
    }
}

