/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.RunningQueryManager;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.TraceableIterator;
import org.apache.ignite.internal.processors.tracing.Tracing;

public class RegisteredQueryCursor<T>
extends QueryCursorImpl<T> {
    private final AtomicBoolean unregistered = new AtomicBoolean(false);
    private RunningQueryManager runningQryMgr;
    private long qryId;
    private Exception failReason;
    private final Tracing tracing;
    private final Span qrySpan;

    public RegisteredQueryCursor(Iterable<T> iterExec, GridQueryCancel cancel, RunningQueryManager runningQryMgr, boolean lazy, long qryId, Tracing tracing) {
        super(iterExec, cancel, true, lazy);
        assert (runningQryMgr != null);
        assert (qryId != 0L);
        this.runningQryMgr = runningQryMgr;
        this.qryId = qryId;
        this.tracing = tracing;
        GridRunningQueryInfo qryInfo = runningQryMgr.runningQueryInfo(qryId);
        this.qrySpan = qryInfo == null ? NoopSpan.INSTANCE : qryInfo.span();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Iterator<T> iter() {
        try (MTC.TraceSurroundings ignored = MTC.supportContinual((Span)this.qrySpan);){
            Iterator iter = this.lazy() ? new RegisteredIterator(super.iter()) : super.iter();
            Iterator iterator = this.qrySpan != NoopSpan.INSTANCE ? new TraceableIterator(iter) : iter;
            return iterator;
        }
        catch (Exception e) {
            this.failReason = e;
            this.qrySpan.addTag("error", e::getMessage);
            if (!QueryUtils.wasCancelled((Throwable)this.failReason)) throw e;
            this.unregisterQuery();
            throw e;
        }
    }

    public void close() {
        Span span = MTC.span();
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.tracing.create(SpanType.SQL_CURSOR_CLOSE, span != NoopSpan.INSTANCE ? span : this.qrySpan));){
            super.close();
            this.unregisterQuery();
        }
        catch (Throwable th) {
            this.qrySpan.addTag("error", th::getMessage);
            throw th;
        }
    }

    public void cancel() {
        try (MTC.TraceSurroundings ignored = MTC.support((Span)this.tracing.create(SpanType.SQL_CURSOR_CANCEL, this.qrySpan));){
            if (this.failReason == null) {
                this.failReason = new QueryCancelledException();
            }
            this.qrySpan.addTag("error", this.failReason::getMessage);
            this.close();
        }
    }

    private void unregisterQuery() {
        if (this.unregistered.compareAndSet(false, true)) {
            this.runningQryMgr.unregister(this.qryId, (Throwable)this.failReason);
        }
    }

    private class RegisteredIterator
    implements Iterator<T> {
        final Iterator<T> delegateIt;

        private RegisteredIterator(Iterator<T> it) {
            this.delegateIt = it;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegateIt.hasNext();
            }
            catch (Exception e) {
                RegisteredQueryCursor.this.failReason = e;
                if (QueryUtils.wasCancelled((Throwable)RegisteredQueryCursor.this.failReason)) {
                    RegisteredQueryCursor.this.unregisterQuery();
                }
                throw e;
            }
        }

        @Override
        public T next() {
            try {
                return this.delegateIt.next();
            }
            catch (Exception e) {
                RegisteredQueryCursor.this.failReason = e;
                if (QueryUtils.wasCancelled((Throwable)RegisteredQueryCursor.this.failReason)) {
                    RegisteredQueryCursor.this.unregisterQuery();
                }
                throw e;
            }
        }
    }
}

