/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.snapshot;

import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.snapshot.SnapshotCreateCommandOption;
import org.apache.ignite.internal.commandline.snapshot.SnapshotSubcommand;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCreateTask;
import org.apache.ignite.internal.visor.snapshot.VisorSnapshotCreateTaskArg;

public class SnapshotCreateCommand
extends SnapshotSubcommand {
    protected SnapshotCreateCommand() {
        super("create", VisorSnapshotCreateTask.class);
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String snpName = argIter.nextArg("Expected snapshot name.");
        boolean sync = false;
        while (argIter.hasNextSubArg()) {
            String arg = argIter.nextArg(null);
            SnapshotCreateCommandOption option = CommandArgUtils.of(arg, SnapshotCreateCommandOption.class);
            if (option == null) {
                throw new IllegalArgumentException("Invalid argument: " + arg + ". Possible options: " + F.concat((Iterable)F.asList((Object[])SnapshotCreateCommandOption.values()), (String)", ") + '.');
            }
            assert (option == SnapshotCreateCommandOption.SYNC);
            sync = true;
        }
        this.cmdArg = new VisorSnapshotCreateTaskArg(snpName, sync);
    }

    @Override
    public void printUsage(Logger log) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.generalUsageOptions());
        params.put(SnapshotCreateCommandOption.SYNC.optionName(), SnapshotCreateCommandOption.SYNC.description());
        this.usage(log, "Create cluster snapshot:", CommandList.SNAPSHOT, params, this.name(), "snapshot_name", CommandLogger.optional(SnapshotCreateCommandOption.SYNC.argName()));
    }
}

