/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.meta.subcommands;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.meta.MetadataCommand;
import org.apache.ignite.internal.commandline.meta.MetadataSubCommandsList;
import org.apache.ignite.internal.commandline.meta.subcommands.MetadataAbstractSubCommand;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataMarshalled;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataRemoveTask;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataTypeArgs;

public class MetadataRemoveCommand
extends MetadataAbstractSubCommand<MetadataTypeArgs, MetadataMarshalled> {
    public static final String OUT_FILE_NAME = "--out";
    private Path outFile;

    @Override
    protected String taskName() {
        return MetadataRemoveTask.class.getName();
    }

    @Override
    public String confirmationPrompt() {
        return "Warning: the command will remove the binary metadata for a type \"" + ((MetadataTypeArgs)this.arg()).toString() + "\" from cluster.";
    }

    @Override
    public MetadataTypeArgs parseArguments0(CommandArgIterator argIter) {
        this.outFile = null;
        MetadataTypeArgs argType = MetadataCommand.parseArgs(argIter);
        while (argIter.hasNextSubArg() && this.outFile == null) {
            String opt = argIter.nextArg("");
            if (!OUT_FILE_NAME.equalsIgnoreCase(opt)) continue;
            String fileName = argIter.nextArg("output file name");
            this.outFile = FS.getPath(fileName, new String[0]);
        }
        if (this.outFile != null) {
            try (OutputStream os = Files.newOutputStream(this.outFile, new OpenOption[0]);){
                os.close();
                Files.delete(this.outFile);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot write to output file " + this.outFile + ". Error: " + e.toString(), e);
            }
        }
        return argType;
    }

    @Override
    protected void printResult(MetadataMarshalled res, Logger log) {
        if (res.metadata() == null) {
            throw new IllegalArgumentException("Failed to remove binary type, type not found: " + this.arg());
        }
        BinaryMetadata m = res.metadata();
        if (this.outFile == null) {
            this.outFile = FS.getPath(m.typeId() + ".bin", new String[0]);
        }
        try (OutputStream os = Files.newOutputStream(this.outFile, new OpenOption[0]);){
            os.write(res.metadataMarshalled());
        }
        catch (IOException e) {
            log.severe("Cannot store removed type '" + m.typeName() + "' to: " + this.outFile);
            log.severe(CommandLogger.errorMessage(e));
            return;
        }
        log.info("Type '" + m.typeName() + "' is removed. Metadata is stored at: " + this.outFile);
    }

    @Override
    public String name() {
        return MetadataSubCommandsList.REMOVE.text();
    }
}

