/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.baseline;

import org.apache.ignite.internal.visor.baseline.VisorBaselineOperation;
import org.jetbrains.annotations.Nullable;

public enum BaselineSubcommands {
    ADD("add", VisorBaselineOperation.ADD),
    REMOVE("remove", VisorBaselineOperation.REMOVE),
    COLLECT("collect", VisorBaselineOperation.COLLECT),
    SET("set", VisorBaselineOperation.SET),
    VERSION("version", VisorBaselineOperation.VERSION),
    AUTO_ADJUST("auto_adjust", VisorBaselineOperation.AUTOADJUST);

    private static final BaselineSubcommands[] VALS;
    private final String name;
    private final VisorBaselineOperation visorBaselineOperation;

    private BaselineSubcommands(String name, VisorBaselineOperation operation) {
        this.name = name;
        this.visorBaselineOperation = operation;
    }

    public static BaselineSubcommands of(String text) {
        for (BaselineSubcommands cmd : BaselineSubcommands.values()) {
            if (!cmd.text().equalsIgnoreCase(text)) continue;
            return cmd;
        }
        return null;
    }

    public String text() {
        return this.name;
    }

    public VisorBaselineOperation visorBaselineOperation() {
        return this.visorBaselineOperation;
    }

    @Nullable
    public static BaselineSubcommands fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALS = BaselineSubcommands.values();
    }
}

