/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.persistence.CleanAndBackupSubcommandArg;
import org.apache.ignite.internal.commandline.persistence.PersistenceArguments;
import org.apache.ignite.internal.commandline.persistence.PersistenceSubcommands;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.persistence.PersistenceCleanAndBackupSettings;
import org.apache.ignite.internal.visor.persistence.PersistenceCleanAndBackupType;
import org.apache.ignite.internal.visor.persistence.PersistenceTask;
import org.apache.ignite.internal.visor.persistence.PersistenceTaskArg;
import org.apache.ignite.internal.visor.persistence.PersistenceTaskResult;
import org.apache.ignite.lang.IgniteBiTuple;

public class PersistenceCommand
implements Command<PersistenceArguments> {
    private PersistenceArguments cleaningArgs;

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Optional firstNodeOpt = client.compute().nodes().stream().findFirst();
            if (firstNodeOpt.isPresent()) {
                UUID uuid = ((GridClientNode)firstNodeOpt.get()).nodeId();
                PersistenceTaskResult res = (PersistenceTaskResult)TaskExecutor.executeTaskByNameOnNode(client, PersistenceTask.class.getName(), this.convertArguments(this.cleaningArgs), uuid, clientCfg);
                this.printResult(res, logger);
            } else {
                logger.warning("No nodes found in topology, command won't be executed.");
            }
        }
        catch (Throwable t) {
            logger.severe("Failed to execute persistence command='" + this.cleaningArgs.subcommand().text() + "'");
            logger.severe(CommandLogger.errorMessage(t));
            throw t;
        }
        return null;
    }

    private void printResult(PersistenceTaskResult res, Logger logger) {
        if (!res.inMaintenanceMode()) {
            logger.warning("Persistence command can be sent only to node in Maintenance Mode.");
            return;
        }
        if (res.cachesInfo() != null) {
            logger.info("Persistent caches found on node:");
            res.cachesInfo().entrySet().stream().sorted((ci0, ci1) -> {
                boolean corrupted1;
                IgniteBiTuple t0 = (IgniteBiTuple)ci0.getValue();
                IgniteBiTuple t1 = (IgniteBiTuple)ci1.getValue();
                boolean corrupted0 = (Boolean)t0.get1() != false || (Boolean)t0.get2() != false;
                boolean bl = corrupted1 = (Boolean)t1.get1() != false || (Boolean)t1.get2() != false;
                if (corrupted0 && corrupted1) {
                    return 0;
                }
                if (!corrupted0 && !corrupted1) {
                    return 0;
                }
                if (corrupted0 && !corrupted1) {
                    return -1;
                }
                return 1;
            }).forEach(e -> {
                IgniteBiTuple t = (IgniteBiTuple)e.getValue();
                String status = (Boolean)t.get1() == false ? "corrupted - WAL disabled globally." : ((Boolean)t.get1() == false ? "corrupted - WAL disabled locally." : "no corruption.");
                logger.info("  cache name: " + (String)e.getKey() + ". Status: " + status);
            });
        } else if (this.cleaningArgs != null && this.cleaningArgs.subcommand() == PersistenceSubcommands.CLEAN) {
            List failedToHandleCaches;
            logger.info("Maintenance task is " + (!res.maintenanceTaskCompleted() ? "not " : "") + "fixed.");
            List cleanedCaches = res.handledCaches();
            if (cleanedCaches != null && !cleanedCaches.isEmpty()) {
                String cacheDirNames = String.join((CharSequence)", ", cleanedCaches);
                logger.info("Cache directories were cleaned: [" + cacheDirNames + ']');
            }
            if ((failedToHandleCaches = res.failedCaches()) != null && !failedToHandleCaches.isEmpty()) {
                String failedToHandleCachesStr = String.join((CharSequence)", ", failedToHandleCaches);
                logger.info("Failed to clean following directories: [" + failedToHandleCachesStr + ']');
            }
        } else {
            List backupFailedCaches;
            List backupCompletedCaches = res.handledCaches();
            if (backupCompletedCaches != null && !backupCompletedCaches.isEmpty()) {
                String cacheDirNames = String.join((CharSequence)", ", backupCompletedCaches);
                logger.info("Cache data files was backed up to the following directories in node's work directory: [" + cacheDirNames + ']');
            }
            if ((backupFailedCaches = res.failedCaches()) != null && !backupFailedCaches.isEmpty()) {
                String backupFailedCachesStr = String.join((CharSequence)", ", backupFailedCaches);
                logger.info("Failed to backup the following directories in node's work directory: [" + backupFailedCachesStr + ']');
            }
        }
    }

    @Override
    public PersistenceArguments arg() {
        return this.cleaningArgs;
    }

    @Override
    public void printUsage(Logger logger) {
        String cacheNames = "cache1,cache2,cache3";
        this.usage(logger, "Print information about potentially corrupted caches on local node:", CommandList.PERSISTENCE, new String[0]);
        this.usage(logger, "The same information is printed when info subcommand is passed:", CommandList.PERSISTENCE, PersistenceSubcommands.INFO.text());
        this.usage(logger, "Clean directories of caches with corrupted data files:", CommandList.PERSISTENCE, PersistenceSubcommands.CLEAN.text(), CleanAndBackupSubcommandArg.CORRUPTED.argName());
        this.usage(logger, "Clean directories of all caches:", CommandList.PERSISTENCE, PersistenceSubcommands.CLEAN.text(), CleanAndBackupSubcommandArg.ALL.argName());
        this.usage(logger, "Clean directories of only given caches:", CommandList.PERSISTENCE, PersistenceSubcommands.CLEAN.text(), CleanAndBackupSubcommandArg.CACHES.argName(), "cache1,cache2,cache3");
        this.usage(logger, "Backup data files of corrupted caches only:", CommandList.PERSISTENCE, PersistenceSubcommands.BACKUP.text(), CleanAndBackupSubcommandArg.CORRUPTED.argName());
        this.usage(logger, "Backup data files of all caches:", CommandList.PERSISTENCE, PersistenceSubcommands.BACKUP.text(), CleanAndBackupSubcommandArg.ALL.argName());
        this.usage(logger, "Backup data files of only given caches:", CommandList.PERSISTENCE, PersistenceSubcommands.BACKUP.text(), CleanAndBackupSubcommandArg.CACHES.argName(), "cache1,cache2,cache3");
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        if (!argIter.hasNextSubArg()) {
            this.cleaningArgs = new PersistenceArguments.Builder(PersistenceSubcommands.INFO).build();
            return;
        }
        PersistenceSubcommands cmd = PersistenceSubcommands.of(argIter.nextArg("Expected persistence maintenance action"));
        if (cmd == null) {
            throw new IllegalArgumentException("Expected correct persistence maintenance action");
        }
        PersistenceArguments.Builder bldr = new PersistenceArguments.Builder(cmd);
        switch (cmd) {
            case BACKUP: 
            case CLEAN: {
                CleanAndBackupSubcommandArg cleanAndBackupSubcommandArg = CommandArgUtils.of(argIter.nextArg("Expected one of subcommand arguments"), CleanAndBackupSubcommandArg.class);
                if (cleanAndBackupSubcommandArg == null) {
                    throw new IllegalArgumentException("Expected one of subcommand arguments");
                }
                bldr.withCleanAndBackupSubcommandArg(cleanAndBackupSubcommandArg);
                if (cleanAndBackupSubcommandArg == CleanAndBackupSubcommandArg.ALL || cleanAndBackupSubcommandArg == CleanAndBackupSubcommandArg.CORRUPTED || cleanAndBackupSubcommandArg != CleanAndBackupSubcommandArg.CACHES) break;
                Set<String> caches = argIter.nextStringSet("list of cache names");
                if (F.isEmpty(caches)) {
                    throw new IllegalArgumentException("Empty list of cache names");
                }
                bldr.withCacheNames(new ArrayList<String>(caches));
            }
        }
        this.cleaningArgs = bldr.build();
    }

    @Override
    public String name() {
        return CommandList.PERSISTENCE.toCommandName();
    }

    private PersistenceTaskArg convertArguments(PersistenceArguments args) {
        PersistenceCleanAndBackupSettings cleanSettings = this.convertCleanAndBackupSettings(args);
        PersistenceTaskArg taskArgs = new PersistenceTaskArg(args.subcommand().operation(), cleanSettings);
        return taskArgs;
    }

    private PersistenceCleanAndBackupSettings convertCleanAndBackupSettings(PersistenceArguments args) {
        PersistenceCleanAndBackupType type;
        if (args.subcommand() == PersistenceSubcommands.INFO) {
            return null;
        }
        switch (args.cleanArg()) {
            case ALL: {
                type = PersistenceCleanAndBackupType.ALL;
                break;
            }
            case CORRUPTED: {
                type = PersistenceCleanAndBackupType.CORRUPTED;
                break;
            }
            default: {
                type = PersistenceCleanAndBackupType.CACHES;
            }
        }
        return new PersistenceCleanAndBackupSettings(type, args.cachesList());
    }
}

