/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.io.File;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.UUID;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.client.GridClientAuthenticationException;
import org.apache.ignite.internal.client.GridClientClosedException;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientHandshakeException;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.ssl.GridSslBasicContextFactory;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.CommonArgParser;
import org.apache.ignite.internal.commandline.ConnectionAndSslParameters;
import org.apache.ignite.internal.commandline.GridConsole;
import org.apache.ignite.internal.commandline.GridConsoleAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.logger.java.JavaLoggerFileHandler;
import org.apache.ignite.logger.java.JavaLoggerFormatter;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityCredentialsBasicProvider;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.apache.ignite.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandHandler {
    static final String CMD_HELP = "--help";
    public static final String CONFIRM_MSG = "y";
    static final String DELIM = "--------------------------------------------------------------------------------";
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_INVALID_ARGUMENTS = 1;
    public static final int EXIT_CODE_CONNECTION_FAILED = 2;
    public static final int ERR_AUTHENTICATION_FAILED = 3;
    public static final int EXIT_CODE_UNEXPECTED_ERROR = 4;
    private static final long DFLT_PING_INTERVAL = 5000L;
    private static final long DFLT_PING_TIMEOUT = 30000L;
    private final Scanner in = new Scanner(System.in);
    public static final String UTILITY_NAME = "control.(sh|bat)";
    public static final String NULL = "null";
    private final Logger logger;
    protected final String ses = U.id8((UUID)UUID.randomUUID());
    public GridConsole console = GridConsoleAdapter.getInstance();
    private Object lastOperationRes;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public static void main(String[] args) {
        CommandHandler hnd = new CommandHandler();
        System.exit(hnd.execute(Arrays.asList(args)));
    }

    private Logger setupJavaLogger() {
        Logger result = CommandHandler.initLogger(CommandHandler.class.getName() + "Log");
        try {
            String absPathPattern = new File(JavaLoggerFileHandler.logDirectory((String)U.defaultWorkDirectory()), "control-utility-%g.log").getAbsolutePath();
            FileHandler fileHandler = new FileHandler(absPathPattern, 0x500000, 5);
            fileHandler.setFormatter((Formatter)new JavaLoggerFormatter());
            result.addHandler(fileHandler);
        }
        catch (Exception e) {
            System.out.println("Failed to configure logging to file");
        }
        result.addHandler(CommandHandler.setupStreamHandler());
        return result;
    }

    public static StreamHandler setupStreamHandler() {
        return new StreamHandler(System.out, new Formatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + "\n";
            }
        });
    }

    public static Logger initLogger(@Nullable String loggerName) {
        Logger result = loggerName == null ? Logger.getAnonymousLogger() : Logger.getLogger(loggerName);
        result.setLevel(Level.INFO);
        result.setUseParentHandlers(false);
        return result;
    }

    public CommandHandler() {
        this.logger = this.setupJavaLogger();
    }

    public CommandHandler(Logger logger) {
        this.logger = logger;
    }

    /*
     * Exception decompiling
     */
    public int execute(List<String> rawArgs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isHelp(List<String> rawArgs) {
        if (F.isEmpty(rawArgs)) {
            return true;
        }
        if (rawArgs.size() > 2) {
            return false;
        }
        boolean help = false;
        boolean experimental = false;
        for (String arg : rawArgs) {
            if (CMD_HELP.equalsIgnoreCase(arg)) {
                help = true;
                continue;
            }
            if ("--enable-experimental".equalsIgnoreCase(arg)) {
                experimental = true;
                continue;
            }
            return false;
        }
        return help || experimental;
    }

    private boolean isSSLMisconfigurationError(Throwable e) {
        return e != null && e.getMessage() != null && e.getMessage().contains("SSL");
    }

    private boolean isConnectionClosedSilentlyException(Throwable e) {
        if (!(e instanceof GridClientDisconnectedException)) {
            return false;
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return false;
        }
        return (cause = cause.getCause()) instanceof GridClientConnectionResetException && cause.getMessage() != null && cause.getMessage().contains("Failed to perform handshake");
    }

    protected boolean isSensitiveArgument(String arg) {
        return CommonArgParser.isSensitiveArgument(arg);
    }

    private String argumentsToString(List<String> rawArgs) {
        boolean hide = false;
        SB sb = new SB();
        for (int i = 0; i < rawArgs.size(); ++i) {
            if (hide) {
                sb.a("***** ");
                hide = false;
                continue;
            }
            String arg = rawArgs.get(i);
            sb.a(arg).a(' ');
            hide = this.isSensitiveArgument(arg);
        }
        return sb.toString();
    }

    private String retrieveUserName(ConnectionAndSslParameters args, GridClientConfiguration clientCfg) throws IgniteCheckedException {
        if (!F.isEmpty((String)args.userName())) {
            return args.userName();
        }
        if (clientCfg.getSecurityCredentialsProvider() == null) {
            return this.requestDataFromConsole("user: ");
        }
        return (String)clientCfg.getSecurityCredentialsProvider().credentials().getLogin();
    }

    @NotNull
    private GridClientConfiguration getClientConfiguration(ConnectionAndSslParameters args) throws IgniteCheckedException {
        return this.getClientConfiguration(args.userName(), args.password(), args);
    }

    @NotNull
    private GridClientConfiguration getClientConfiguration(String userName, String password, ConnectionAndSslParameters args) throws IgniteCheckedException {
        GridClientConfiguration clientCfg = new GridClientConfiguration();
        clientCfg.setPingInterval(args.pingInterval());
        clientCfg.setPingTimeout(args.pingTimeout());
        clientCfg.setServers(Collections.singletonList(args.host() + ":" + args.port()));
        if (!F.isEmpty((String)userName)) {
            clientCfg.setSecurityCredentialsProvider(this.getSecurityCredentialsProvider(userName, password, clientCfg));
        }
        if (!F.isEmpty((String)args.sslKeyStorePath())) {
            clientCfg.setSslContextFactory((GridSslContextFactory)this.createSslSupportFactory(args));
        }
        return clientCfg;
    }

    @NotNull
    private SecurityCredentialsProvider getSecurityCredentialsProvider(String userName, String password, GridClientConfiguration clientCfg) throws IgniteCheckedException {
        SecurityCredentialsProvider securityCredential = clientCfg.getSecurityCredentialsProvider();
        if (securityCredential == null) {
            return new SecurityCredentialsBasicProvider(new SecurityCredentials(userName, password));
        }
        SecurityCredentials credential = securityCredential.credentials();
        credential.setLogin((Object)userName);
        credential.setPassword((Object)password);
        return securityCredential;
    }

    @NotNull
    private GridSslBasicContextFactory createSslSupportFactory(ConnectionAndSslParameters args) {
        GridSslBasicContextFactory factory = new GridSslBasicContextFactory();
        List<String> sslProtocols = CommandHandler.split(args.sslProtocol(), ",");
        String sslProtocol = F.isEmpty(sslProtocols) ? "TLS" : sslProtocols.get(0);
        factory.setProtocol(sslProtocol);
        factory.setKeyAlgorithm(args.sslKeyAlgorithm());
        if (sslProtocols.size() > 1) {
            factory.setProtocols(sslProtocols);
        }
        factory.setCipherSuites(CommandHandler.split(args.getSslCipherSuites(), ","));
        factory.setKeyStoreFilePath(args.sslKeyStorePath());
        if (args.sslKeyStorePassword() != null) {
            factory.setKeyStorePassword(args.sslKeyStorePassword());
        } else {
            char[] keyStorePwd = this.requestPasswordFromConsole("SSL keystore password: ");
            args.sslKeyStorePassword(keyStorePwd);
            factory.setKeyStorePassword(keyStorePwd);
        }
        factory.setKeyStoreType(args.sslKeyStoreType());
        if (F.isEmpty((String)args.sslTrustStorePath())) {
            factory.setTrustManagers(new TrustManager[]{GridSslBasicContextFactory.getDisabledTrustManager()});
        } else {
            factory.setTrustStoreFilePath(args.sslTrustStorePath());
            if (args.sslTrustStorePassword() != null) {
                factory.setTrustStorePassword(args.sslTrustStorePassword());
            } else {
                char[] trustStorePwd = this.requestPasswordFromConsole("SSL truststore password: ");
                args.sslTrustStorePassword(trustStorePwd);
                factory.setTrustStorePassword(trustStorePwd);
            }
            factory.setTrustStoreType(args.sslTrustStoreType());
        }
        return factory;
    }

    public <T> T getLastOperationResult() {
        return (T)this.lastOperationRes;
    }

    private String readLine(String prompt) {
        System.out.print(prompt);
        return this.in.nextLine();
    }

    private boolean confirm(String str) {
        if (str == null) {
            return true;
        }
        String prompt = str + System.lineSeparator() + "Press '" + CONFIRM_MSG + "' to continue . . . ";
        return CONFIRM_MSG.equalsIgnoreCase(this.readLine(prompt));
    }

    public static boolean isAuthError(Throwable e) {
        return X.hasCause((Throwable)e, (Class[])new Class[]{GridClientAuthenticationException.class});
    }

    private static boolean isConnectionError(Throwable e) {
        return e instanceof GridClientClosedException || e instanceof GridClientConnectionResetException || e instanceof GridClientDisconnectedException || e instanceof GridClientHandshakeException || e instanceof GridServerUnreachableException;
    }

    private char[] requestPasswordFromConsole(String msg) {
        if (this.console == null) {
            throw new UnsupportedOperationException("Failed to securely read password (console is unavailable): " + msg);
        }
        return this.console.readPassword(msg, new Object[0]);
    }

    private String requestDataFromConsole(String msg) {
        if (this.console != null) {
            return this.console.readLine(msg, new Object[0]);
        }
        Scanner scanner = new Scanner(System.in);
        this.logger.info(msg);
        return scanner.nextLine();
    }

    private static List<String> split(String s, String delim) {
        if (F.isEmpty((String)s)) {
            return Collections.emptyList();
        }
        return Arrays.stream(s.split(delim)).map(String::trim).filter(item -> !item.isEmpty()).collect(Collectors.toList());
    }

    private void printHelp(List<String> rawArgs) {
        boolean experimentalEnabled = rawArgs.stream().anyMatch("--enable-experimental"::equalsIgnoreCase) || IgniteSystemProperties.getBoolean((String)"IGNITE_ENABLE_EXPERIMENTAL_COMMAND");
        this.logger.info("Control utility script is used to execute admin commands on cluster or get common cluster info. The command has the following syntax:");
        this.logger.info("");
        this.logger.info("  " + CommandLogger.join(" ", CommandLogger.join(" ", UTILITY_NAME, CommandLogger.join(" ", CommonArgParser.getCommonOptions())), CommandLogger.optional("command"), "<command_parameters>"));
        this.logger.info("");
        this.logger.info("");
        this.logger.info("This utility can do the following commands:");
        Arrays.stream(CommandList.values()).filter(c -> experimentalEnabled || !c.command().experimental()).forEach(c -> c.command().printUsage(this.logger));
        this.logger.info("");
        this.logger.info("By default commands affecting the cluster require interactive confirmation.");
        this.logger.info("Use --yes option to disable it.");
        this.logger.info("");
        this.logger.info("Default values:");
        this.logger.info("    HOST_OR_IP=127.0.0.1");
        this.logger.info("    PORT=11211");
        this.logger.info("    PING_INTERVAL=5000");
        this.logger.info("    PING_TIMEOUT=30000");
        this.logger.info("    SSL_PROTOCOL=TLS");
        this.logger.info("    SSL_KEY_ALGORITHM=" + SslContextFactory.DFLT_KEY_ALGORITHM);
        this.logger.info("    KEYSTORE_TYPE=" + SslContextFactory.DFLT_STORE_TYPE);
        this.logger.info("    TRUSTSTORE_TYPE=" + SslContextFactory.DFLT_STORE_TYPE);
        this.logger.info("");
        this.logger.info("Exit codes:");
        this.logger.info("    0 - successful execution.");
        this.logger.info("    1 - invalid arguments.");
        this.logger.info("    2 - connection failed.");
        this.logger.info("    3 - authentication failed.");
        this.logger.info("    4 - unexpected error.");
    }

    private static /* synthetic */ boolean lambda$execute$0(Handler handler) {
        return handler instanceof FileHandler;
    }
}

