/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule.logical;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.processors.query.calcite.rule.logical.ImmutableExposeIndexRule;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.util.typedef.F;
import org.immutables.value.Value;

@Value.Enclosing
public class ExposeIndexRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    public ExposeIndexRule(Config config) {
        super((RelRule.Config)config);
    }

    private static boolean preMatch(IgniteLogicalTableScan scan) {
        return !((IgniteTable)scan.getTable().unwrap(IgniteTable.class)).indexes().isEmpty();
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)call.rel(0);
        RelOptCluster cluster = scan.getCluster();
        RelOptTable optTable = scan.getTable();
        IgniteTable igniteTable = (IgniteTable)optTable.unwrap(IgniteTable.class);
        List<RexNode> proj = scan.projects();
        RexNode condition = scan.condition();
        ImmutableBitSet requiredCols = scan.requiredColumns();
        if (igniteTable.isIndexRebuildInProgress()) {
            return;
        }
        List indexes = igniteTable.indexes().values().stream().map(idx -> idx.toRel(cluster, optTable, proj, condition, requiredCols)).collect(Collectors.toList());
        assert (!indexes.isEmpty());
        HashMap equivMap = new HashMap(indexes.size());
        for (int i = 1; i < indexes.size(); ++i) {
            equivMap.put(indexes.get(i), scan);
        }
        call.transformTo((RelNode)F.first(indexes), equivMap);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableExposeIndexRule.Config.of().withOperandSupplier(b -> b.operand(IgniteLogicalTableScan.class).predicate(x$0 -> ExposeIndexRule.preMatch(x$0)).anyInputs());

        default public ExposeIndexRule toRule() {
            return new ExposeIndexRule(this);
        }
    }
}

