/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.processors.query.calcite.util.IndexConditions;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIndexScan
extends ProjectableFilterableTableScan {
    protected final String idxName;
    protected final IndexConditions idxCond;

    protected AbstractIndexScan(RelInput input) {
        super(input);
        this.idxName = input.getString("index");
        this.idxCond = new IndexConditions(input);
    }

    protected AbstractIndexScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, String idxName, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable IndexConditions idxCond, @Nullable ImmutableBitSet reqColumns) {
        super(cluster, traitSet, hints, table, proj, cond, reqColumns);
        this.idxName = idxName;
        this.idxCond = idxCond;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        pw = pw.item("index", (Object)this.idxName);
        pw = super.explainTerms0(pw);
        return this.idxCond.explainTerms(pw);
    }

    public String indexName() {
        return this.idxName;
    }

    public List<RexNode> lowerCondition() {
        return this.idxCond == null ? null : this.idxCond.lowerCondition();
    }

    public List<RexNode> lowerBound() {
        return this.idxCond == null ? null : this.idxCond.lowerBound();
    }

    public List<RexNode> upperCondition() {
        return this.idxCond == null ? null : this.idxCond.upperCondition();
    }

    public List<RexNode> upperBound() {
        return this.idxCond == null ? null : this.idxCond.upperBound();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double cost;
        double rows = this.table.getRowCount();
        if (this.condition == null) {
            cost = rows * 1.0;
        } else {
            double selectivity0;
            RexBuilder builder = this.getCluster().getRexBuilder();
            double selectivity = 1.0;
            cost = 0.0;
            if (this.lowerCondition() != null) {
                selectivity0 = mq.getSelectivity((RelNode)this, RexUtil.composeConjunction((RexBuilder)builder, this.lowerCondition()));
                selectivity -= 1.0 - selectivity0;
                cost += Math.log(rows) * 3.0;
            }
            if (!(this.upperCondition() == null || this.lowerCondition() != null && this.lowerCondition().equals(this.upperCondition()))) {
                selectivity0 = mq.getSelectivity((RelNode)this, RexUtil.composeConjunction((RexBuilder)builder, this.upperCondition()));
                selectivity -= 1.0 - selectivity0;
            }
            if ((rows *= selectivity) <= 0.0) {
                rows = 1.0;
            }
            cost += rows * 4.0;
        }
        return planner.getCostFactory().makeCost(rows, cost, 0.0).plus(planner.getCostFactory().makeTinyCost());
    }

    public IndexConditions indexConditions() {
        return this.idxCond;
    }
}

