/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.prepare.IdGenerator;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteExchange;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteReceiver;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSender;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTrimExchange;

public class Splitter
extends IgniteRelShuttle {
    private final Deque<FragmentProto> stack = new LinkedList<FragmentProto>();
    private FragmentProto curr;

    public List<Fragment> go(IgniteRel root) {
        ArrayList<Fragment> res = new ArrayList<Fragment>();
        this.stack.push(new FragmentProto(IdGenerator.nextId(), root));
        while (!this.stack.isEmpty()) {
            this.curr = this.stack.pop();
            this.curr.root = this.visit(this.curr.root);
            res.add(this.curr.build());
            this.curr = null;
        }
        return res;
    }

    @Override
    public IgniteRel visit(IgniteReceiver rel) {
        throw new AssertionError();
    }

    @Override
    public IgniteRel visit(IgniteExchange rel) {
        long sourceFragmentId;
        RelOptCluster cluster = rel.getCluster();
        long targetFragmentId = this.curr.id;
        long exchangeId = sourceFragmentId = IdGenerator.nextId();
        IgniteReceiver receiver = new IgniteReceiver(cluster, rel.getTraitSet(), rel.getRowType(), exchangeId, sourceFragmentId);
        IgniteSender sender = new IgniteSender(cluster, rel.getTraitSet(), rel.getInput(), exchangeId, targetFragmentId, rel.distribution());
        this.curr.remotes.add((Object)receiver);
        this.stack.push(new FragmentProto(sourceFragmentId, sender));
        return receiver;
    }

    @Override
    public IgniteRel visit(IgniteTrimExchange rel) {
        return ((IgniteTrimExchange)this.processNode(rel)).clone(IdGenerator.nextId());
    }

    @Override
    public IgniteRel visit(IgniteIndexScan rel) {
        return rel.clone(IdGenerator.nextId());
    }

    @Override
    public IgniteRel visit(IgniteTableScan rel) {
        return rel.clone(IdGenerator.nextId());
    }

    private static class FragmentProto {
        private final long id;
        private IgniteRel root;
        private final ImmutableList.Builder<IgniteReceiver> remotes = ImmutableList.builder();

        private FragmentProto(long id, IgniteRel root) {
            this.id = id;
            this.root = root;
        }

        Fragment build() {
            return new Fragment(this.id, this.root, (List<IgniteReceiver>)this.remotes.build());
        }
    }
}

