/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMappingException;
import org.apache.ignite.internal.processors.query.calcite.metadata.MappingService;
import org.apache.ignite.internal.processors.query.calcite.prepare.ExecutionPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.prepare.FragmentSplitter;
import org.apache.ignite.internal.processors.query.calcite.prepare.MappingQueryContext;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteReceiver;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSender;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.NotNull;

public class QueryTemplate {
    private final ImmutableList<Fragment> fragments;
    private final AtomicReference<ExecutionPlan> executionPlan = new AtomicReference();

    public QueryTemplate(List<Fragment> fragments) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (Fragment fragment : fragments) {
            b.add((Object)fragment.attach(Commons.emptyCluster()));
        }
        this.fragments = b.build();
    }

    public ExecutionPlan map(MappingService mappingService, MappingQueryContext ctx) {
        ExecutionPlan executionPlan = this.executionPlan.get();
        if (executionPlan != null && Objects.equals(executionPlan.topologyVersion(), ctx.topologyVersion())) {
            return executionPlan;
        }
        List<Fragment> fragments = Commons.transform(this.fragments, f -> f.attach(ctx.cluster()));
        FragmentMappingException ex = null;
        RelMetadataQuery mq = ((Fragment)F.first(fragments)).root().getCluster().getMetadataQuery();
        for (int i = 0; i < 3; ++i) {
            try {
                ExecutionPlan executionPlan0 = new ExecutionPlan(ctx.topologyVersion(), this.map(mappingService, fragments, ctx, mq));
                if (executionPlan == null || executionPlan.topologyVersion().before(executionPlan0.topologyVersion())) {
                    this.executionPlan.compareAndSet(executionPlan, executionPlan0);
                }
                return executionPlan0;
            }
            catch (FragmentMappingException e) {
                if (ex == null) {
                    ex = e;
                } else {
                    ex.addSuppressed(e);
                }
                fragments = this.replace(fragments, e.fragment(), new FragmentSplitter(e.node()).go(e.fragment()));
                continue;
            }
        }
        throw new IgniteSQLException("Failed to map query.", ex);
    }

    @NotNull
    private List<Fragment> map(MappingService mappingService, List<Fragment> fragments, MappingQueryContext ctx, RelMetadataQuery mq) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (Fragment fragment : fragments) {
            b.add((Object)fragment.map(mappingService, ctx, mq).attach(Commons.emptyCluster()));
        }
        return b.build();
    }

    private List<Fragment> replace(List<Fragment> fragments, Fragment fragment, List<Fragment> replacement) {
        assert (!F.isEmpty(replacement));
        HashMap<Long, Long> newTargets = new HashMap<Long, Long>();
        for (Fragment fragment0 : replacement) {
            for (IgniteReceiver remote : fragment0.remotes()) {
                newTargets.put(remote.exchangeId(), fragment0.fragmentId());
            }
        }
        ArrayList<Fragment> fragments0 = new ArrayList<Fragment>(fragments.size() + replacement.size() - 1);
        for (Fragment fragment0 : fragments) {
            IgniteSender sender;
            Long newTargetId;
            if (fragment0 == fragment) {
                fragment0 = (Fragment)F.first(replacement);
            } else if (!fragment0.rootFragment() && (newTargetId = (Long)newTargets.get((sender = (IgniteSender)fragment0.root()).exchangeId())) != null) {
                sender = new IgniteSender(sender.getCluster(), sender.getTraitSet(), sender.getInput(), sender.exchangeId(), newTargetId, sender.distribution());
                fragment0 = new Fragment(fragment0.fragmentId(), sender, fragment0.remotes());
            }
            fragments0.add(fragment0);
        }
        fragments0.addAll(replacement.subList(1, replacement.size()));
        return fragments0;
    }
}

