/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.ValidationException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.prepare.DdlPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.ExplainPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.FieldsMetadata;
import org.apache.ignite.internal.processors.query.calcite.prepare.FieldsMetadataImpl;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgnitePlanner;
import org.apache.ignite.internal.processors.query.calcite.prepare.MultiStepDmlPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.MultiStepQueryPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlannerHelper;
import org.apache.ignite.internal.processors.query.calcite.prepare.PlanningContext;
import org.apache.ignite.internal.processors.query.calcite.prepare.PrepareService;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryPlan;
import org.apache.ignite.internal.processors.query.calcite.prepare.QueryTemplate;
import org.apache.ignite.internal.processors.query.calcite.prepare.Splitter;
import org.apache.ignite.internal.processors.query.calcite.prepare.ValidationResult;
import org.apache.ignite.internal.processors.query.calcite.prepare.ddl.DdlSqlToCommandConverter;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.typedef.T2;
import org.jetbrains.annotations.Nullable;

public class PrepareServiceImpl
extends AbstractService
implements PrepareService {
    private final DdlSqlToCommandConverter ddlConverter = new DdlSqlToCommandConverter();

    public PrepareServiceImpl(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void onStart(GridKernalContext ctx) {
        super.onStart(ctx);
    }

    @Override
    public QueryPlan prepareSingle(SqlNode sqlNode, PlanningContext ctx) {
        try {
            assert (this.single(sqlNode));
            ctx.planner().reset();
            if (SqlKind.DDL.contains(sqlNode.getKind())) {
                return this.prepareDdl(sqlNode, ctx);
            }
            switch (sqlNode.getKind()) {
                case SELECT: 
                case ORDER_BY: 
                case WITH: 
                case VALUES: 
                case UNION: 
                case EXCEPT: 
                case INTERSECT: {
                    return this.prepareQuery(sqlNode, ctx);
                }
                case INSERT: 
                case DELETE: 
                case UPDATE: 
                case MERGE: {
                    return this.prepareDml(sqlNode, ctx);
                }
                case EXPLAIN: {
                    return this.prepareExplain(sqlNode, ctx);
                }
            }
            throw new IgniteSQLException("Unsupported operation [sqlNodeKind=" + sqlNode.getKind() + "; querySql=\"" + ctx.query() + "\"]", 1002);
        }
        catch (CalciteContextException | ValidationException e) {
            throw new IgniteSQLException("Failed to validate query. " + e.getMessage(), 1001, e);
        }
    }

    private QueryPlan prepareDdl(SqlNode sqlNode, PlanningContext ctx) {
        assert (sqlNode instanceof SqlDdl) : sqlNode == null ? "null" : sqlNode.getClass().getName();
        return new DdlPlan(this.ddlConverter.convert((SqlDdl)sqlNode, ctx));
    }

    private QueryPlan prepareExplain(SqlNode explain, PlanningContext ctx) throws ValidationException {
        IgnitePlanner planner = ctx.planner();
        SqlNode sql = ((SqlExplain)explain).getExplicandum();
        sql = planner.validate(sql);
        IgniteRel igniteRel = PlannerHelper.optimize(sql, planner, this.log);
        String plan = RelOptUtil.toString((RelNode)igniteRel, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES);
        return new ExplainPlan(plan, this.explainFieldsMetadata(ctx));
    }

    private boolean single(SqlNode sqlNode) {
        return !(sqlNode instanceof SqlNodeList);
    }

    private QueryPlan prepareQuery(SqlNode sqlNode, PlanningContext ctx) {
        IgnitePlanner planner = ctx.planner();
        ValidationResult validated = planner.validateAndGetTypeMetadata(sqlNode);
        sqlNode = validated.sqlNode();
        IgniteRel igniteRel = PlannerHelper.optimize(sqlNode, planner, this.log);
        List<Fragment> fragments = new Splitter().go(igniteRel);
        QueryTemplate template = new QueryTemplate(fragments);
        return new MultiStepQueryPlan(template, this.queryFieldsMetadata(ctx, validated.dataType(), validated.origins()));
    }

    private QueryPlan prepareDml(SqlNode sqlNode, PlanningContext ctx) throws ValidationException {
        IgnitePlanner planner = ctx.planner();
        sqlNode = planner.validate(sqlNode);
        IgniteRel igniteRel = PlannerHelper.optimize(sqlNode, planner, this.log);
        List<Fragment> fragments = new Splitter().go(igniteRel);
        QueryTemplate template = new QueryTemplate(fragments);
        return new MultiStepDmlPlan(template, this.queryFieldsMetadata(ctx, igniteRel.getRowType(), null));
    }

    private FieldsMetadata queryFieldsMetadata(PlanningContext ctx, RelDataType sqlType, @Nullable List<List<String>> origins) {
        RelDataType resultType = TypeUtils.getResultType(ctx.typeFactory(), (RelOptSchema)ctx.catalogReader(), sqlType, origins);
        return new FieldsMetadataImpl(resultType, origins);
    }

    private FieldsMetadata explainFieldsMetadata(PlanningContext ctx) {
        IgniteTypeFactory factory = ctx.typeFactory();
        RelDataType planStrDataType = factory.createSqlType(SqlTypeName.VARCHAR, -1);
        T2 planField = new T2((Object)"PLAN", (Object)planStrDataType);
        RelDataType planDataType = factory.createStructType(Collections.singletonList(planField));
        return this.queryFieldsMetadata(ctx, planDataType, null);
    }
}

