/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercionImpl;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteCustomType;
import org.apache.ignite.internal.processors.query.calcite.type.OtherType;
import org.apache.ignite.internal.processors.query.calcite.type.UuidType;

public class IgniteTypeCoercion
extends TypeCoercionImpl {
    public IgniteTypeCoercion(RelDataTypeFactory typeFactory, SqlValidator validator) {
        super(typeFactory, validator);
    }

    protected boolean coerceOperandType(SqlValidatorScope scope, SqlCall call, int idx, RelDataType targetType) {
        if (targetType instanceof IgniteCustomType) {
            SqlNode operand = (SqlNode)call.getOperandList().get(idx);
            if (operand instanceof SqlDynamicParam) {
                return false;
            }
            RelDataType fromType = this.validator.deriveType(scope, operand);
            if (fromType == null) {
                return false;
            }
            if (SqlTypeUtil.inCharFamily((RelDataType)fromType) || targetType instanceof OtherType) {
                targetType = this.factory.createTypeWithNullability(targetType, fromType.isNullable());
                SqlCall desired = SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{operand, new SqlDataTypeSpec((SqlTypeNameSpec)new SqlUserDefinedTypeNameSpec(targetType.toString(), SqlParserPos.ZERO), SqlParserPos.ZERO).withNullable(Boolean.valueOf(targetType.isNullable()))});
                call.setOperand(idx, (SqlNode)desired);
                this.updateInferredType((SqlNode)desired, targetType);
                return true;
            }
            return false;
        }
        return super.coerceOperandType(scope, call, idx, targetType);
    }

    public RelDataType commonTypeForBinaryComparison(RelDataType type1, RelDataType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        if (type1 instanceof UuidType && SqlTypeUtil.isCharacter((RelDataType)type2)) {
            return type1;
        }
        if (type2 instanceof UuidType && SqlTypeUtil.isCharacter((RelDataType)type1)) {
            return type2;
        }
        return super.commonTypeForBinaryComparison(type1, type2);
    }

    protected boolean needToCast(SqlValidatorScope scope, SqlNode node, RelDataType toType) {
        if (SqlTypeUtil.isInterval((RelDataType)toType)) {
            RelDataType fromType = this.validator.deriveType(scope, node);
            if (SqlTypeUtil.isInterval((RelDataType)fromType)) {
                return fromType.getSqlTypeName().getFamily() != toType.getSqlTypeName().getFamily();
            }
        } else if (SqlTypeUtil.isIntType((RelDataType)toType)) {
            RelDataType fromType = this.validator.deriveType(scope, node);
            if (fromType == null) {
                return false;
            }
            if (SqlTypeUtil.isIntType((RelDataType)fromType) && fromType.getSqlTypeName() != toType.getSqlTypeName()) {
                return true;
            }
        }
        return super.needToCast(scope, node, toType);
    }
}

