/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMdSelectivity;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteExchange;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableSpool;
import org.apache.ignite.internal.processors.query.calcite.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteStatisticsImpl;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.apache.ignite.internal.processors.query.stat.ColumnStatistics;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class IgniteMdSelectivity
extends RelMdSelectivity {
    private static final double IS_NULL_SELECTIVITY = 0.1;
    private static final double IS_NOT_NULL_SELECTIVITY = 0.9;
    private static final double EQUALS_SELECTIVITY = 0.15;
    private static final double COMPARISON_SELECTIVITY = 0.5;
    private static final double OTHER_SELECTIVITY = 0.25;
    private final MathContext MATH_CONTEXT = MathContext.DECIMAL64;
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.SELECTIVITY.method, (MetadataHandler)new IgniteMdSelectivity());

    public Double getSelectivity(ProjectableFilterableTableScan rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate == null) {
            return this.getTablePredicateBasedSelectivity(rel, mq, rel.condition());
        }
        RexNode condition = rel.pushUpPredicate();
        if (condition == null) {
            return this.getTablePredicateBasedSelectivity(rel, mq, predicate);
        }
        RexNode diff = RelMdUtil.minusPreds((RexBuilder)RexUtils.builder((RelNode)rel), (RexNode)predicate, (RexNode)condition);
        return this.getTablePredicateBasedSelectivity(rel, mq, diff);
    }

    public Double getSelectivity(IgniteSortedIndexSpool rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds((RexBuilder)rel.getCluster().getRexBuilder(), (RexNode)predicate, (RexNode)rel.condition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.condition());
    }

    public Double getSelectivity(RelSubset rel, RelMetadataQuery mq, RexNode predicate) {
        RelNode best = rel.getBest();
        if (best == null) {
            return super.getSelectivity((RelNode)rel, mq, predicate);
        }
        return this.getSelectivity(best, mq, predicate);
    }

    private BigDecimal toComparableValue(RexLiteral val) {
        RelDataType type = val.getType();
        if (type instanceof BasicSqlType) {
            BasicSqlType bType = (BasicSqlType)type;
            switch ((SqlTypeFamily)bType.getFamily()) {
                case NULL: {
                    return null;
                }
                case NUMERIC: {
                    return (BigDecimal)val.getValueAs(BigDecimal.class);
                }
                case DATE: {
                    return new BigDecimal(((DateString)val.getValueAs(DateString.class)).getMillisSinceEpoch());
                }
                case TIME: {
                    return new BigDecimal(((TimeString)val.getValueAs(TimeString.class)).getMillisOfDay());
                }
                case TIMESTAMP: {
                    return new BigDecimal(((TimestampString)val.getValueAs(TimestampString.class)).getMillisSinceEpoch());
                }
                case BOOLEAN: {
                    return (Boolean)val.getValueAs(Boolean.class) != false ? BigDecimal.ONE : BigDecimal.ZERO;
                }
            }
            return null;
        }
        return null;
    }

    private BigDecimal toComparableValue(Value val) {
        if (val == null) {
            return null;
        }
        switch (val.getType()) {
            case 0: {
                throw new IllegalArgumentException("Can't compare null values");
            }
            case 1: {
                return val.getBoolean() ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case 2: {
                return new BigDecimal(val.getByte());
            }
            case 3: {
                return new BigDecimal(val.getShort());
            }
            case 4: {
                return new BigDecimal(val.getInt());
            }
            case 5: {
                return new BigDecimal(val.getLong());
            }
            case 6: {
                return val.getBigDecimal();
            }
            case 7: {
                return BigDecimal.valueOf(val.getDouble());
            }
            case 8: {
                return BigDecimal.valueOf(val.getFloat());
            }
            case 10: {
                return BigDecimal.valueOf(val.getDate().getTime());
            }
            case 9: {
                return BigDecimal.valueOf(val.getTime().getTime());
            }
            case 11: {
                return BigDecimal.valueOf(val.getTimestamp().getTime());
            }
            case 12: {
                BigInteger bigInteger = new BigInteger(1, val.getBytes());
                return new BigDecimal(bigInteger);
            }
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                return null;
            }
            case 20: {
                BigInteger bigInt = new BigInteger(1, val.getBytes());
                return new BigDecimal(bigInt);
            }
        }
        throw new IllegalStateException("Unsupported H2 type: " + val.getType());
    }

    private double getTablePredicateBasedSelectivity(ProjectableFilterableTableScan rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate == null || predicate.isAlwaysTrue()) {
            return 1.0;
        }
        if (predicate.isAlwaysFalse()) {
            return 0.0;
        }
        double sel = 1.0;
        HashMap<RexSlot, Boolean> addNotNull = new HashMap<RexSlot, Boolean>();
        for (RexNode rexNode : RelOptUtil.conjunctions((RexNode)predicate)) {
            SqlKind predKind = rexNode.getKind();
            if (predKind == SqlKind.OR) {
                double orSelTotal = 1.0;
                for (RexNode orPred : RelOptUtil.disjunctions((RexNode)rexNode)) {
                    orSelTotal *= 1.0 - this.getTablePredicateBasedSelectivity(rel, mq, orPred);
                }
                sel *= 1.0 - orSelTotal;
                continue;
            }
            if (predKind == SqlKind.NOT) {
                assert (rexNode instanceof RexCall);
                sel *= 1.0 - this.getTablePredicateBasedSelectivity(rel, mq, (RexNode)((RexCall)rexNode).getOperands().get(0));
                continue;
            }
            RexSlot op = null;
            if (rexNode instanceof RexCall) {
                op = this.getOperand((RexCall)rexNode);
            } else if (rexNode instanceof RexSlot) {
                op = (RexSlot)rexNode;
            }
            ColumnStatistics colStat = this.getColumnStatistics(mq, rel, op);
            if (colStat == null) {
                sel *= this.guessSelectivity(rexNode);
                continue;
            }
            if (predKind == SqlKind.LOCAL_REF) {
                if (op != null) {
                    addNotNull.put(op, Boolean.TRUE);
                }
                sel *= this.estimateRefSelectivity(rel, mq, (RexLocalRef)rexNode);
                continue;
            }
            if (predKind == SqlKind.IS_NULL) {
                if (op != null) {
                    addNotNull.put(op, Boolean.FALSE);
                }
                sel *= this.estimateIsNullSelectivity(colStat);
                continue;
            }
            if (predKind == SqlKind.IS_NOT_NULL) {
                if (op != null) {
                    addNotNull.put(op, Boolean.FALSE);
                }
                sel *= this.estimateIsNotNullSelectivity(colStat);
                continue;
            }
            if (predKind == SqlKind.EQUALS) {
                if (op != null) {
                    addNotNull.put(op, Boolean.TRUE);
                }
                assert (rexNode instanceof RexCall);
                sel *= this.estimateEqualsSelectivity(colStat, (RexCall)rexNode);
                continue;
            }
            if (predKind.belongsTo((Collection)SqlKind.COMPARISON)) {
                if (op != null) {
                    addNotNull.put(op, Boolean.TRUE);
                }
                assert (rexNode instanceof RexCall);
                sel *= this.estimateRangeSelectivity(colStat, (RexCall)rexNode);
                continue;
            }
            sel *= 0.25;
        }
        for (Map.Entry entry : addNotNull.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            ColumnStatistics colStat = this.getColumnStatistics(mq, rel, (RexSlot)entry.getKey());
            sel *= colStat == null ? 0.9 : this.estimateIsNotNullSelectivity(colStat);
        }
        return sel;
    }

    @Nullable
    private ColumnStatistics getColumnStatistics(RelMetadataQuery mq, ProjectableFilterableTableScan rel, RexSlot op) {
        Statistic stat;
        RelColumnOrigin origin;
        if (op instanceof RexLocalRef) {
            origin = rel.columnOriginsByRelLocalRef(op.getIndex());
        } else if (op instanceof RexInputRef) {
            origin = mq.getColumnOrigin((RelNode)rel, op.getIndex());
        } else {
            return null;
        }
        String colName = IgniteMdSelectivity.extactFieldName(origin);
        IgniteTable tbl = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (tbl != null);
        if (tbl instanceof IgniteCacheTable && "_KEY".equals(colName)) {
            colName = ((IgniteCacheTable)tbl).descriptor().typeDescription().keyFieldName();
        }
        if (!((stat = tbl.getStatistic()) instanceof IgniteStatisticsImpl)) {
            return null;
        }
        return ((IgniteStatisticsImpl)stat).getColumnStatistics(colName);
    }

    private static String extactFieldName(RelColumnOrigin origin) {
        return (String)origin.getOriginTable().getRowType().getFieldNames().get(origin.getOriginColumnOrdinal());
    }

    private double estimateRefSelectivity(ProjectableFilterableTableScan rel, RelMetadataQuery mq, RexLocalRef ref) {
        ColumnStatistics colStat = this.getColumnStatistics(mq, rel, (RexSlot)ref);
        double res = 0.33;
        if (colStat == null) {
            return res;
        }
        if (colStat.max() == null || colStat.max().getType() != 1) {
            return res;
        }
        Boolean min = colStat.min().getBoolean();
        Boolean max = colStat.max().getBoolean();
        if (!max.booleanValue()) {
            return 0.0;
        }
        double notNullSel = this.estimateIsNotNullSelectivity(colStat);
        return max != false && min != false ? notNullSel : notNullSel / 2.0;
    }

    private double estimateRangeSelectivity(ColumnStatistics colStat, RexCall pred) {
        RexLiteral literal = null;
        if (pred.getOperands().get(1) instanceof RexLiteral) {
            literal = (RexLiteral)pred.getOperands().get(1);
        }
        if (literal == null) {
            return this.guessSelectivity((RexNode)pred);
        }
        BigDecimal val = this.toComparableValue(literal);
        return this.estimateSelectivity(colStat, val, (RexNode)pred);
    }

    private double estimateSelectivity(ColumnStatistics colStat, BigDecimal val, RexNode pred) {
        BigDecimal total;
        if (val == null) {
            return this.guessSelectivity(pred);
        }
        SqlOperator op = ((RexCall)pred).op;
        BigDecimal min = this.toComparableValue(colStat.min());
        BigDecimal max = this.toComparableValue(colStat.max());
        BigDecimal bigDecimal = total = min == null || max == null ? null : max.subtract(min).abs();
        if (total == null) {
            return this.guessSelectivity(pred);
        }
        if (total.signum() == 0) {
            BigDecimal diff = val.subtract(min);
            int diffSign = diff.signum();
            switch (op.getKind()) {
                case GREATER_THAN: {
                    return diffSign < 0 ? 1.0 : 0.0;
                }
                case LESS_THAN: {
                    return diffSign > 0 ? 1.0 : 0.0;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return diffSign <= 0 ? 1.0 : 0.0;
                }
                case LESS_THAN_OR_EQUAL: {
                    return diffSign >= 0 ? 1.0 : 0.0;
                }
            }
            return this.guessSelectivity(pred);
        }
        BigDecimal actual = BigDecimal.ZERO;
        switch (op.getKind()) {
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                actual = max.subtract(val);
                if (actual.signum() >= 0) break;
                return 0.0;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                actual = val.subtract(min);
                if (actual.signum() >= 0) break;
                return 0.0;
            }
            default: {
                return this.guessSelectivity(pred);
            }
        }
        return actual.compareTo(total) > 0 ? 1.0 : actual.divide(total, this.MATH_CONTEXT).doubleValue();
    }

    private double estimateEqualsSelectivity(ColumnStatistics colStat, RexCall pred) {
        BigDecimal maxComparable;
        BigDecimal minComparable;
        if (colStat.total() == 0L) {
            return 1.0;
        }
        if (colStat.total() - colStat.nulls() == 0L) {
            return 0.0;
        }
        RexLiteral literal = null;
        if (pred.getOperands().get(1) instanceof RexLiteral) {
            literal = (RexLiteral)pred.getOperands().get(1);
        }
        if (literal == null) {
            return this.guessSelectivity((RexNode)pred);
        }
        BigDecimal comparableVal = this.toComparableValue(literal);
        if (comparableVal == null) {
            return this.guessSelectivity((RexNode)pred);
        }
        if (colStat.min() != null && (minComparable = this.toComparableValue(colStat.min())) != null && minComparable.compareTo(comparableVal) > 0) {
            return 0.0;
        }
        if (colStat.max() != null && (maxComparable = this.toComparableValue(colStat.max())) != null && maxComparable.compareTo(comparableVal) < 0) {
            return 0.0;
        }
        double expectedRows = (double)(colStat.total() - colStat.nulls()) / (double)colStat.distinct();
        return expectedRows / (double)colStat.total();
    }

    private double estimateIsNotNullSelectivity(ColumnStatistics colStat) {
        if (colStat.total() == 0L) {
            return 0.9;
        }
        return (double)(colStat.total() - colStat.nulls()) / (double)colStat.total();
    }

    private double estimateIsNullSelectivity(ColumnStatistics colStat) {
        if (colStat.total() == 0L) {
            return 0.1;
        }
        return (double)colStat.nulls() / (double)colStat.total();
    }

    private RexSlot getOperand(RexCall pred) {
        List operands = pred.getOperands();
        if (operands.isEmpty() || operands.size() > 2) {
            return null;
        }
        RexNode op = (RexNode)operands.get(0);
        if (op instanceof RexCall && op.isA(SqlKind.CAST)) {
            op = (RexNode)((RexCall)op).operands.get(0);
        }
        return op instanceof RexSlot ? (RexSlot)op : null;
    }

    private double guessSelectivity(RexNode pred) {
        if (pred.getKind() == SqlKind.IS_NULL) {
            return 0.1;
        }
        if (pred.getKind() == SqlKind.IS_NOT_NULL) {
            return 0.9;
        }
        if (pred.isA(SqlKind.EQUALS)) {
            return 0.15;
        }
        if (pred.isA((Collection)SqlKind.COMPARISON)) {
            return 0.5;
        }
        return 0.25;
    }

    public Double getSelectivity(IgniteExchange exch, RelMetadataQuery mq, RexNode predicate) {
        RelNode input = exch.getInput();
        if (input == null) {
            return null;
        }
        return this.getSelectivity(input, mq, predicate);
    }

    public Double getSelectivity(IgniteTableSpool tspool, RelMetadataQuery mq, RexNode predicate) {
        RelNode input = tspool.getInput();
        if (input == null) {
            return null;
        }
        return this.getSelectivity(input, mq, predicate);
    }

    public Double getSelectivity(IgniteHashIndexSpool rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds((RexBuilder)rel.getCluster().getRexBuilder(), (RexNode)predicate, (RexNode)rel.condition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.condition());
    }
}

