/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class ScanNode<Row>
extends AbstractNode<Row>
implements SingleNode<Row> {
    private final Iterable<Row> src;
    private Iterator<Row> it;
    private int requested;
    private boolean inLoop;
    private boolean firstReq = true;

    public ScanNode(ExecutionContext<Row> ctx, RelDataType rowType, Iterable<Row> src) {
        super(ctx, rowType);
        this.src = src;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (rowsCnt > 0 && this.requested == 0) : "rowsCnt=" + rowsCnt + ", requested=" + this.requested;
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            if (this.firstReq) {
                try {
                    this.push();
                }
                catch (Throwable e) {
                    this.onError(e);
                }
                this.firstReq = false;
            } else {
                this.context().execute(this::push, this::onError);
            }
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        Commons.closeQuiet(this.it);
        this.it = null;
        Commons.closeQuiet(this.src);
    }

    @Override
    protected void rewindInternal() {
        Commons.closeQuiet(this.it);
        this.it = null;
    }

    @Override
    public void register(List<Node<Row>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    private void push() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.checkState();
        this.inLoop = true;
        try {
            if (this.it == null) {
                this.it = this.src.iterator();
            }
            int processed = 0;
            while (this.requested > 0 && this.it.hasNext()) {
                this.checkState();
                --this.requested;
                this.downstream().push(this.it.next());
                if (++processed != IN_BUFFER_SIZE || this.requested <= 0) continue;
                this.context().execute(this::push, this::onError);
                return;
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.requested > 0 && !this.it.hasNext()) {
            Commons.closeQuiet(this.it);
            this.it = null;
            this.requested = 0;
            this.downstream().end();
        }
    }
}

