/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.calcite.exec.ExchangeService;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.MailboxRegistry;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Mailbox;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;
import org.apache.ignite.internal.processors.query.calcite.trait.Destination;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;

public class Outbox<Row>
extends AbstractNode<Row>
implements Mailbox<Row>,
SingleNode<Row>,
Downstream<Row> {
    private final ExchangeService exchange;
    private final MailboxRegistry registry;
    private final long exchangeId;
    private final long targetFragmentId;
    private final Destination<Row> dest;
    private final Deque<Row> inBuf = new ArrayDeque<Row>(IN_BUFFER_SIZE);
    private final Map<UUID, Buffer> nodeBuffers = new HashMap<UUID, Buffer>();
    private int waiting;
    private boolean exchangeFinished;

    public Outbox(ExecutionContext<Row> ctx, RelDataType rowType, ExchangeService exchange, MailboxRegistry registry, long exchangeId, long targetFragmentId, Destination<Row> dest) {
        super(ctx, rowType);
        this.exchange = exchange;
        this.registry = registry;
        this.targetFragmentId = targetFragmentId;
        this.exchangeId = exchangeId;
        this.dest = dest;
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    public void onAcknowledge(UUID nodeId, int batchId) throws Exception {
        assert (this.nodeBuffers.containsKey(nodeId));
        this.checkState();
        this.nodeBuffers.get(nodeId).acknowledge(batchId);
    }

    public void init() {
        try {
            this.checkState();
            this.flush();
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    @Override
    public void request(int rowCnt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void push(Row row) throws Exception {
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        this.inBuf.add(row);
        this.flush();
    }

    @Override
    public void end() throws Exception {
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.flush();
    }

    @Override
    public void onError(Throwable e) {
        this.onErrorInternal(e);
    }

    @Override
    protected void onErrorInternal(Throwable e) {
        try {
            this.sendError(e);
        }
        catch (IgniteCheckedException ex) {
            U.error((IgniteLogger)this.context().logger(), (Object)("Error occurred during send error message: " + X.getFullStackTrace((Throwable)e)));
        }
        finally {
            U.closeQuiet((AutoCloseable)this);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        this.registry.unregister(this);
        for (UUID node : this.dest.targets()) {
            this.getOrCreateBuffer(node).close();
        }
    }

    @Override
    public void onRegister(Downstream<Row> downstream) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rewindInternal() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private void sendBatch(UUID nodeId, int batchId, boolean last, List<Row> rows) throws IgniteCheckedException {
        this.exchange.sendBatch(nodeId, this.queryId(), this.targetFragmentId, this.exchangeId, batchId, last, rows);
    }

    private void sendError(Throwable err) throws IgniteCheckedException {
        this.exchange.sendError(this.context().originatingNodeId(), this.queryId(), this.fragmentId(), err);
    }

    private void sendInboxClose(UUID nodeId) {
        try {
            this.exchange.closeInbox(nodeId, this.queryId(), this.targetFragmentId, this.exchangeId);
        }
        catch (IgniteCheckedException e) {
            U.warn((IgniteLogger)this.context().logger(), (Object)"Failed to send cancel message.", (Throwable)e);
        }
    }

    private Buffer getOrCreateBuffer(UUID nodeId) {
        return this.nodeBuffers.computeIfAbsent(nodeId, this::createBuffer);
    }

    private Buffer createBuffer(UUID nodeId) {
        return new Buffer(nodeId);
    }

    private void flush() throws Exception {
        while (!this.inBuf.isEmpty()) {
            this.checkState();
            Collection buffers = this.dest.targets(this.inBuf.peek()).stream().map(this::getOrCreateBuffer).collect(Collectors.toList());
            assert (!F.isEmpty((Collection)buffers));
            if (!buffers.stream().allMatch(rec$ -> ((Buffer)rec$).ready())) {
                return;
            }
            Row row = this.inBuf.remove();
            for (Buffer dest : buffers) {
                dest.add(row);
            }
        }
        assert (this.inBuf.isEmpty());
        if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.source().request(this.waiting);
        } else if (this.waiting == -1) {
            for (UUID node : this.dest.targets()) {
                this.getOrCreateBuffer(node).end();
            }
            if (!this.exchangeFinished) {
                this.exchange.onOutboundExchangeFinished(this.queryId(), this.exchangeId);
                this.exchangeFinished = true;
            }
        }
    }

    public void onNodeLeft(UUID nodeId) {
        if (nodeId.equals(this.context().originatingNodeId())) {
            this.context().execute(this::close, this::onError);
        }
    }

    private final class Buffer {
        private final UUID nodeId;
        private int hwm = -1;
        private int lwm = -1;
        private List<Row> curr;

        private Buffer(UUID nodeId) {
            this.nodeId = nodeId;
            this.curr = new ArrayList(AbstractNode.IO_BATCH_SIZE);
        }

        private boolean ready() {
            if (this.hwm == Integer.MAX_VALUE) {
                return false;
            }
            return this.curr.size() < AbstractNode.IO_BATCH_SIZE || this.hwm - this.lwm < AbstractNode.IO_BATCH_CNT;
        }

        public void add(Row row) throws IgniteCheckedException {
            assert (this.ready());
            if (this.curr.size() == AbstractNode.IO_BATCH_SIZE) {
                Outbox.this.sendBatch(this.nodeId, ++this.hwm, false, this.curr);
                this.curr = new ArrayList(AbstractNode.IO_BATCH_SIZE);
            }
            this.curr.add(row);
        }

        public void end() throws IgniteCheckedException {
            if (this.hwm == Integer.MAX_VALUE) {
                return;
            }
            int batchId = this.hwm + 1;
            this.hwm = Integer.MAX_VALUE;
            List tmp = this.curr;
            this.curr = null;
            Outbox.this.sendBatch(this.nodeId, batchId, true, tmp);
        }

        private void acknowledge(int id) throws Exception {
            if (this.lwm > id) {
                return;
            }
            boolean readyBefore = this.ready();
            this.lwm = id;
            if (!readyBefore && this.ready()) {
                Outbox.this.flush();
            }
        }

        public void close() {
            int currBatchId = this.hwm;
            if (this.hwm == Integer.MAX_VALUE) {
                return;
            }
            this.hwm = Integer.MAX_VALUE;
            this.curr = null;
            if (currBatchId >= 0) {
                Outbox.this.sendInboxClose(this.nodeId);
            }
        }
    }
}

