/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractSetOpNode;

public class IntersectNode<Row>
extends AbstractSetOpNode<Row> {
    public IntersectNode(ExecutionContext<Row> ctx, RelDataType rowType, AggregateType type, boolean all, RowHandler.RowFactory<Row> rowFactory, int inputsCnt) {
        super(ctx, rowType, type, all, rowFactory, new IntersectGrouping(ctx, rowFactory, type, all, inputsCnt));
    }

    private static class IntersectGrouping<Row>
    extends AbstractSetOpNode.Grouping<Row> {
        private final int inputsCnt;

        private IntersectGrouping(ExecutionContext<Row> ctx, RowHandler.RowFactory<Row> rowFactory, AggregateType type, boolean all, int inputsCnt) {
            super(ctx, rowFactory, type, all);
            this.inputsCnt = inputsCnt;
        }

        @Override
        protected void endOfSet(int setIdx) {
            if (this.type == AggregateType.SINGLE && this.rowsCnt == 0) {
                this.groups.clear();
            }
            super.endOfSet(setIdx);
        }

        @Override
        protected void addOnSingle(Row row, int setIdx) {
            GroupKey key = this.key(row);
            if (setIdx == 0) {
                int[] cntrs = this.groups.computeIfAbsent(key, k -> new int[this.inputsCnt]);
                cntrs[0] = cntrs[0] + 1;
            } else {
                int[] cntrs = (int[])this.groups.get(key);
                if (cntrs != null) {
                    if (cntrs[setIdx - 1] == 0) {
                        this.groups.remove(key);
                    } else {
                        int n = setIdx;
                        cntrs[n] = cntrs[n] + 1;
                    }
                }
            }
        }

        @Override
        protected void addOnMapper(Row row, int setIdx) {
            int[] cntrs = this.groups.computeIfAbsent(this.key(row), k -> new int[this.inputsCnt]);
            int n = setIdx;
            cntrs[n] = cntrs[n] + 1;
        }

        @Override
        protected boolean affectResult(int[] cntrs) {
            return true;
        }

        @Override
        protected int availableRows(int[] cntrs) {
            int cnt = cntrs[0];
            for (int i = 1; i < cntrs.length; ++i) {
                if (cntrs[i] >= cnt) continue;
                cnt = cntrs[i];
            }
            if (this.all) {
                cntrs[0] = cnt;
                return cnt;
            }
            return cnt == 0 ? 0 : 1;
        }

        @Override
        protected void decrementAvailableRows(int[] cntrs, int amount) {
            assert (amount > 0);
            assert (this.all);
            cntrs[0] = cntrs[0] - amount;
        }
    }
}

