/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Pair;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.query.calcite.exec.ExchangeService;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.MailboxRegistry;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Mailbox;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Inbox<Row>
extends AbstractNode<Row>
implements Mailbox<Row>,
SingleNode<Row> {
    private final ExchangeService exchange;
    private final MailboxRegistry registry;
    private final long exchangeId;
    private final long srcFragmentId;
    private final Map<UUID, Buffer> perNodeBuffers;
    private volatile Collection<UUID> srcNodeIds;
    private Comparator<Row> comp;
    private List<Buffer> buffers;
    private int requested;
    private boolean inLoop;
    private static final Batch<?> WAITING = new Batch(0, false, null);
    private static final Batch<?> END = new Batch(0, false, null);

    public Inbox(ExecutionContext<Row> ctx, ExchangeService exchange, MailboxRegistry registry, long exchangeId, long srcFragmentId) {
        super(ctx, ctx.getTypeFactory().createUnknownType());
        this.exchange = exchange;
        this.registry = registry;
        this.srcFragmentId = srcFragmentId;
        this.exchangeId = exchangeId;
        this.perNodeBuffers = new HashMap<UUID, Buffer>();
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    public void init(ExecutionContext<Row> ctx, RelDataType rowType, Collection<UUID> srcNodeIds, @Nullable Comparator<Row> comp) {
        assert (this.context().fragmentId() == ctx.fragmentId()) : "different fragments unsupported: previous=" + this.context().fragmentId() + " current=" + ctx.fragmentId();
        this.context(ctx);
        this.rowType(rowType);
        this.comp = comp;
        this.srcNodeIds = new HashSet<UUID>(srcNodeIds);
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (this.srcNodeIds != null);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.context().execute(this::doPush, this::onError);
        }
    }

    @Override
    public void closeInternal() {
        super.closeInternal();
        this.registry.unregister(this);
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void register(List<Node<Row>> sources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void rewindInternal() {
        throw new UnsupportedOperationException();
    }

    public void onBatchReceived(UUID src, int batchId, boolean last, List<Row> rows) throws Exception {
        Buffer buf = this.getOrCreateBuffer(src);
        boolean waitingBefore = buf.check() == State.WAITING;
        buf.offer(batchId, last, rows);
        if (this.requested > 0 && waitingBefore && buf.check() != State.WAITING) {
            this.push();
        }
    }

    private void doPush() throws Exception {
        this.checkState();
        this.push();
    }

    private void push() throws Exception {
        if (this.buffers == null) {
            for (UUID node : this.srcNodeIds) {
                this.checkNode(node);
            }
            this.buffers = this.srcNodeIds.stream().map(this::getOrCreateBuffer).collect(Collectors.toList());
            assert (this.buffers.size() == this.perNodeBuffers.size());
        }
        if (this.comp != null) {
            this.pushOrdered();
        } else {
            this.pushUnordered();
        }
    }

    private boolean checkAllBuffsReady(Iterator<Buffer> it) {
        while (it.hasNext()) {
            Buffer buf = it.next();
            switch (buf.check()) {
                case READY: {
                    break;
                }
                case END: {
                    it.remove();
                    this.exchange.onInboundExchangeFinished(buf.nodeId, this.queryId(), this.exchangeId);
                    break;
                }
                case WAITING: {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushOrdered() throws Exception {
        if (!this.checkAllBuffsReady(this.buffers.iterator())) {
            return;
        }
        PriorityQueue heap = new PriorityQueue(Math.max(this.buffers.size(), 1), Map.Entry.comparingByKey(this.comp));
        for (Buffer buf : this.buffers) {
            State state = buf.check();
            if (state == State.READY) {
                heap.offer(Pair.of((Object)buf.peek(), (Object)buf));
                continue;
            }
            throw new AssertionError((Object)("Unexpected buffer state: " + (Object)((Object)state)));
        }
        this.inLoop = true;
        try {
            while (this.requested > 0 && !heap.isEmpty()) {
                this.checkState();
                Buffer buf = (Buffer)((Pair)heap.poll()).right;
                --this.requested;
                this.downstream().push(buf.remove());
                switch (buf.check()) {
                    case END: {
                        this.buffers.remove(buf);
                        this.exchange.onInboundExchangeFinished(buf.nodeId, this.queryId(), this.exchangeId);
                        break;
                    }
                    case READY: {
                        heap.offer(Pair.of((Object)buf.peek(), (Object)buf));
                        break;
                    }
                    case WAITING: {
                        return;
                    }
                }
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.requested > 0 && heap.isEmpty()) {
            assert (this.buffers.isEmpty());
            this.requested = 0;
            this.downstream().end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushUnordered() throws Exception {
        int idx = 0;
        int noProgress = 0;
        this.inLoop = true;
        try {
            while (this.requested > 0 && !this.buffers.isEmpty()) {
                this.checkState();
                Buffer buf = this.buffers.get(idx);
                switch (buf.check()) {
                    case END: {
                        this.buffers.remove(idx--);
                        this.exchange.onInboundExchangeFinished(buf.nodeId, this.queryId(), this.exchangeId);
                        break;
                    }
                    case READY: {
                        noProgress = 0;
                        --this.requested;
                        this.downstream().push(buf.remove());
                        break;
                    }
                    case WAITING: {
                        if (++noProgress < this.buffers.size()) break;
                        return;
                    }
                }
                if (++idx != this.buffers.size()) continue;
                idx = 0;
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.requested > 0 && this.buffers.isEmpty()) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    private void acknowledge(UUID nodeId, int batchId) throws IgniteCheckedException {
        this.exchange.acknowledge(nodeId, this.queryId(), this.srcFragmentId, this.exchangeId, batchId);
    }

    private Buffer getOrCreateBuffer(UUID nodeId) {
        return this.perNodeBuffers.computeIfAbsent(nodeId, this::createBuffer);
    }

    private Buffer createBuffer(UUID nodeId) {
        return new Buffer(nodeId);
    }

    public void onNodeLeft(UUID nodeId) {
        if (this.context().originatingNodeId().equals(nodeId) && this.srcNodeIds == null) {
            this.context().execute(this::close, this::onError);
        } else if (this.srcNodeIds != null && this.srcNodeIds.contains(nodeId)) {
            this.context().execute(() -> this.onNodeLeft0(nodeId), this::onError);
        }
    }

    private void onNodeLeft0(UUID nodeId) throws Exception {
        this.checkState();
        if (this.getOrCreateBuffer(nodeId).check() != State.END) {
            throw new ClusterTopologyCheckedException("Failed to execute query, node left [nodeId=" + nodeId + ']');
        }
    }

    private void checkNode(UUID nodeId) throws ClusterTopologyCheckedException {
        if (!this.exchange.alive(nodeId)) {
            throw new ClusterTopologyCheckedException("Failed to execute query, node left [nodeId=" + nodeId + ']');
        }
    }

    private final class Buffer {
        private final UUID nodeId;
        private int lastEnqueued = -1;
        private final PriorityQueue<Batch<Row>> batches = new PriorityQueue(AbstractNode.IO_BATCH_CNT);
        private Batch<Row> curr = this.waitingMark();

        private Buffer(UUID nodeId) {
            this.nodeId = nodeId;
        }

        private void offer(int id, boolean last, List<Row> rows) {
            this.batches.offer(new Batch(id, last, rows));
        }

        private Batch<Row> pollBatch() {
            if (this.batches.isEmpty() || this.batches.peek().batchId != this.lastEnqueued + 1) {
                return this.waitingMark();
            }
            Batch batch = this.batches.poll();
            assert (batch != null && batch.batchId == this.lastEnqueued + 1);
            this.lastEnqueued = batch.batchId;
            return batch;
        }

        private State check() {
            if (this.finished()) {
                return State.END;
            }
            if (this.waiting()) {
                return State.WAITING;
            }
            if (this.isEnd()) {
                this.curr = this.finishedMark();
                return State.END;
            }
            return State.READY;
        }

        private Row peek() {
            assert (this.curr != null);
            assert (this.curr != WAITING);
            assert (this.curr != END);
            assert (!this.isEnd());
            return this.curr.rows.get(this.curr.idx);
        }

        private Row remove() throws IgniteCheckedException {
            assert (this.curr != null);
            assert (this.curr != WAITING);
            assert (this.curr != END);
            assert (!this.isEnd());
            Object row = this.curr.rows.set(this.curr.idx++, null);
            if (this.curr.idx == this.curr.rows.size() && !this.curr.last) {
                Inbox.this.acknowledge(this.nodeId, this.curr.batchId);
                this.curr = this.pollBatch();
            }
            return row;
        }

        private boolean finished() {
            return this.curr == END;
        }

        private boolean waiting() {
            return this.curr == WAITING && (this.curr = this.pollBatch()) == WAITING;
        }

        private boolean isEnd() {
            return this.curr.last && this.curr.idx == this.curr.rows.size();
        }

        private Batch<Row> finishedMark() {
            return END;
        }

        private Batch<Row> waitingMark() {
            return WAITING;
        }
    }

    private static enum State {
        END,
        READY,
        WAITING;

    }

    private static final class Batch<Row>
    implements Comparable<Batch<Row>> {
        private final int batchId;
        private final boolean last;
        private final List<Row> rows;
        private int idx;

        private Batch(int batchId, boolean last, List<Row> rows) {
            this.batchId = batchId;
            this.last = last;
            this.rows = rows;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Batch batch = (Batch)o;
            return this.batchId == batch.batchId;
        }

        public int hashCode() {
            return this.batchId;
        }

        @Override
        public int compareTo(@NotNull Batch<Row> o) {
            return Integer.compare(this.batchId, o.batchId);
        }
    }
}

