/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.exp;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.ConstantUntypedNull;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.IgniteSqlFunctions;

public class ConverterUtils {
    private ConverterUtils() {
    }

    static Expression toInternal(Expression operand, Type targetType) {
        return ConverterUtils.toInternal(operand, operand.getType(), targetType);
    }

    private static Expression toInternal(Expression operand, Type fromType, Type targetType) {
        if (fromType == Date.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call((Method)BuiltInMethod.DATE_TO_INT.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Integer.class) {
                return Expressions.call((Method)BuiltInMethod.DATE_TO_INT_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        } else if (fromType == Time.class) {
            if (targetType == Integer.TYPE) {
                return Expressions.call((Method)BuiltInMethod.TIME_TO_INT.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Integer.class) {
                return Expressions.call((Method)BuiltInMethod.TIME_TO_INT_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        } else if (fromType == Timestamp.class) {
            if (targetType == Long.TYPE) {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG.method, (Expression[])new Expression[]{operand});
            }
            if (targetType == Long.class) {
                return Expressions.call((Method)BuiltInMethod.TIMESTAMP_TO_LONG_OPTIONAL.method, (Expression[])new Expression[]{operand});
            }
        }
        return operand;
    }

    private static Expression fromInternal(Expression operand, Type targetType) {
        return ConverterUtils.fromInternal(operand, operand.getType(), targetType);
    }

    private static Expression fromInternal(Expression operand, Type fromType, Type targetType) {
        if (operand == ConstantUntypedNull.INSTANCE) {
            return operand;
        }
        if (!(operand.getType() instanceof Class)) {
            return operand;
        }
        if (Types.isAssignableFrom((Type)targetType, (Type)fromType)) {
            return operand;
        }
        if (targetType == Date.class) {
            if (ConverterUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_DATE.method, (Expression[])new Expression[]{operand});
            }
        } else if (targetType == Time.class) {
            if (ConverterUtils.isA(fromType, Primitive.INT)) {
                return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIME.method, (Expression[])new Expression[]{operand});
            }
        } else if (targetType == Timestamp.class && ConverterUtils.isA(fromType, Primitive.LONG)) {
            return Expressions.call((Method)BuiltInMethod.INTERNAL_TO_TIMESTAMP.method, (Expression[])new Expression[]{operand});
        }
        if (Primitive.is((Type)operand.type) && Primitive.isBox((Type)targetType)) {
            return Expressions.convert_((Expression)operand, (Type)Primitive.ofBox((Type)targetType).primitiveClass);
        }
        return operand;
    }

    static List<Expression> fromInternal(Class<?>[] targetTypes, List<Expression> expressions) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == expressions.size()) {
            for (int i = 0; i < expressions.size(); ++i) {
                list.add(ConverterUtils.fromInternal(expressions.get(i), targetTypes[i]));
            }
        } else {
            int j = 0;
            for (int i = 0; i < expressions.size(); ++i) {
                Class<?> type;
                if (!targetTypes[j].isArray()) {
                    type = targetTypes[j];
                    ++j;
                } else {
                    type = targetTypes[j].getComponentType();
                }
                list.add(ConverterUtils.fromInternal(expressions.get(i), type));
            }
        }
        return list;
    }

    private static Type toInternal(RelDataType type) {
        return ConverterUtils.toInternal(type, false);
    }

    static Type toInternal(RelDataType type, boolean forceNotNull) {
        switch (type.getSqlTypeName()) {
            case DATE: 
            case TIME: {
                return type.isNullable() && !forceNotNull ? Integer.class : Integer.TYPE;
            }
            case TIMESTAMP: {
                return type.isNullable() && !forceNotNull ? Long.class : Long.TYPE;
            }
        }
        return null;
    }

    static List<Type> internalTypes(List<? extends RexNode> operandList) {
        return Util.transform(operandList, node -> ConverterUtils.toInternal(node.getType()));
    }

    public static Expression convert(Expression operand, Type toType) {
        Type fromType = operand.getType();
        return ConverterUtils.convert(operand, fromType, toType);
    }

    public static Expression convertToDecimal(Expression operand, RelDataType targetType) {
        assert (targetType.getSqlTypeName() == SqlTypeName.DECIMAL);
        return Expressions.call(IgniteSqlFunctions.class, (String)"toBigDecimal", (Expression[])new Expression[]{operand, Expressions.constant((Object)targetType.getPrecision()), Expressions.constant((Object)targetType.getScale())});
    }

    public static Expression convert(Expression operand, Type fromType, Type toType) {
        Expression internalTypedOperand;
        boolean fromNumber;
        if (!Types.needTypeCast((Type)fromType, (Type)toType)) {
            return operand;
        }
        if (toType == Void.class) {
            return RexImpTable.NULL_EXPR;
        }
        if (toType == BigDecimal.class) {
            throw new AssertionError((Object)"For conversion to decimal, ConverterUtils#convertToDecimal method should be used instead.");
        }
        Primitive toPrimitive = Primitive.of((Type)toType);
        Primitive toBox = Primitive.ofBox((Type)toType);
        Primitive fromBox = Primitive.ofBox((Type)fromType);
        Primitive fromPrimitive = Primitive.of((Type)fromType);
        boolean bl = fromNumber = fromType instanceof Class && Number.class.isAssignableFrom((Class)fromType);
        if (fromType == String.class) {
            if (toPrimitive != null) {
                switch (toPrimitive) {
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap((String)toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toPrimitive.boxClass, (String)("parse" + SqlFunctions.initcap((String)toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
            }
            if (toBox != null) {
                switch (toBox) {
                    case CHAR: {
                        return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap((String)toBox.primitiveName) + "Boxed"), (Expression[])new Expression[]{operand});
                    }
                }
                return Expressions.call((Type)toBox.boxClass, (String)"valueOf", (Expression[])new Expression[]{operand});
            }
        }
        if (toPrimitive != null) {
            if (fromPrimitive != null) {
                return Expressions.convert_((Expression)operand, (Type)toPrimitive.primitiveClass);
            }
            if (fromNumber || fromBox == Primitive.CHAR) {
                return Expressions.unbox((Expression)operand, (Primitive)toPrimitive);
            }
            return Expressions.call(SqlFunctions.class, (String)("to" + SqlFunctions.initcap((String)toPrimitive.primitiveName)), (Expression[])new Expression[]{operand});
        }
        if (fromNumber && toBox != null) {
            return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.box((Expression)Expressions.unbox((Expression)operand, (Primitive)toBox), (Primitive)toBox));
        }
        if (fromPrimitive != null && toBox != null) {
            if (operand instanceof UnaryExpression) {
                Primitive origin;
                UnaryExpression una = (UnaryExpression)operand;
                if (una.nodeType == ExpressionType.Convert && Primitive.of((Type)una.getType()) == toBox && (origin = Primitive.of((Type)una.expression.type)) != null && toBox.assignableFrom(origin)) {
                    return Expressions.box((Expression)una.expression, (Primitive)toBox);
                }
            }
            if (fromType == toBox.primitiveClass) {
                return Expressions.box((Expression)operand, (Primitive)toBox);
            }
            return Expressions.box((Expression)Expressions.convert_((Expression)operand, (Type)toBox.primitiveClass), (Primitive)toBox);
        }
        if (ConverterUtils.representAsInternalType(fromType) && operand != (internalTypedOperand = ConverterUtils.toInternal(operand, fromType, toType))) {
            return internalTypedOperand;
        }
        if (ConverterUtils.representAsInternalType(toType)) {
            Expression originTypedOperand = ConverterUtils.fromInternal(operand, fromType, toType);
            if (operand != originTypedOperand) {
                return originTypedOperand;
            }
        } else {
            if (toType == String.class) {
                Expression result;
                if (fromPrimitive != null) {
                    switch (fromPrimitive) {
                        case FLOAT: 
                        case DOUBLE: {
                            return Expressions.call(SqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand});
                        }
                    }
                    return Expressions.call((Type)fromPrimitive.boxClass, (String)"toString", (Expression[])new Expression[]{operand});
                }
                if (fromType == BigDecimal.class) {
                    return Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call(IgniteSqlFunctions.class, (String)"toString", (Expression[])new Expression[]{operand}));
                }
                try {
                    if (operand instanceof ConstantExpression) {
                        ConstantExpression ce = (ConstantExpression)operand;
                        if (ce.value == null) {
                            return Expressions.convert_((Expression)operand, (Type)toType);
                        }
                    }
                    result = Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)RexImpTable.NULL_EXPR), (Expression)RexImpTable.NULL_EXPR, (Expression)Expressions.call((Expression)operand, (String)"toString", (Expression[])new Expression[0]));
                }
                catch (RuntimeException e) {
                    return Expressions.convert_((Expression)operand, (Type)toType);
                }
                return result;
            }
            if (toType == UUID.class && fromType == String.class) {
                return Expressions.call(UUID.class, (String)"fromString", (Expression[])new Expression[]{operand});
            }
        }
        return Expressions.convert_((Expression)operand, (Type)toType);
    }

    private static boolean isA(Type fromType, Primitive primitive) {
        return Primitive.of((Type)fromType) == primitive || Primitive.ofBox((Type)fromType) == primitive;
    }

    private static boolean representAsInternalType(Type type) {
        return type == Date.class || type == Time.class || type == Timestamp.class;
    }

    static List<Expression> convertAssignableTypes(Class<?>[] targetTypes, List<Expression> arguments) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        if (targetTypes.length == arguments.size()) {
            for (int i = 0; i < arguments.size(); ++i) {
                list.add(ConverterUtils.convertAssignableType(arguments.get(i), targetTypes[i]));
            }
        } else {
            int j = 0;
            for (Expression argument : arguments) {
                Class<?> type;
                if (!targetTypes[j].isArray()) {
                    type = targetTypes[j];
                    ++j;
                } else {
                    type = targetTypes[j].getComponentType();
                }
                list.add(ConverterUtils.convertAssignableType(argument, type));
            }
        }
        return list;
    }

    private static Expression convertAssignableType(Expression argument, Type targetType) {
        if (targetType != BigDecimal.class) {
            return argument;
        }
        return ConverterUtils.convert(argument, targetType);
    }
}

