/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.ddl;

import java.util.function.Supplier;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQuerySchemaManager;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteCacheTable;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;

class SchemaManager
implements GridQuerySchemaManager {
    private final Supplier<SchemaPlus> schemaSupp;

    SchemaManager(Supplier<SchemaPlus> schemaSupp) {
        this.schemaSupp = schemaSupp;
    }

    public GridQueryTypeDescriptor typeDescriptorForTable(String schemaName, String tableName) {
        SchemaPlus schema = this.schemaSupp.get().getSubSchema(schemaName);
        if (schema == null) {
            return null;
        }
        IgniteCacheTable tbl = (IgniteCacheTable)schema.getTable(tableName);
        return tbl == null ? null : tbl.descriptor().typeDescription();
    }

    public GridQueryTypeDescriptor typeDescriptorForIndex(String schemaName, String idxName) {
        SchemaPlus schema = this.schemaSupp.get().getSubSchema(schemaName);
        if (schema == null) {
            return null;
        }
        for (String tableName : schema.getTableNames()) {
            Table tbl = schema.getTable(tableName);
            if (!(tbl instanceof IgniteCacheTable) || ((IgniteTable)tbl).getIndex(idxName) == null) continue;
            return ((IgniteCacheTable)tbl).descriptor().typeDescription();
        }
        return null;
    }

    public <K, V> GridCacheContextInfo<K, V> cacheInfoForTable(String schemaName, String tableName) {
        SchemaPlus schema = this.schemaSupp.get().getSubSchema(schemaName);
        if (schema == null) {
            return null;
        }
        Table tbl = schema.getTable(tableName);
        IgniteCacheTable cachetbl = tbl instanceof IgniteCacheTable ? (IgniteCacheTable)tbl : null;
        return cachetbl == null ? null : cachetbl.descriptor().cacheInfo();
    }
}

